/*
 * Copyright (c) 2017-2023. AxonIQ B.V.
 */
package io.axoniq.dataprotection.cryptoengine;

import org.junit.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.lang.invoke.MethodHandles;

/*
 * To make this test work on any given machine, install SoftHSM (https://www.opendnssec.org/softhsm/),
 * initialize a token, and adjust the configuration below accordingly.
 *
 * The test will be ignored if the native lib can't be found.
 */
public class PKCS11Test extends AbstractEngineTestSet {

    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SOFTHSM_CONFIG_FILE = "/usr/local/etc/softhsm/softhsm2_stef.conf";
    private static final String TOKEN_PIN = "1234";
    private static final CryptoEngine cryptoEngine;

    static {
        if (new File(SOFTHSM_CONFIG_FILE).exists()) {
            cryptoEngine = new PKCS11CryptoEngine(SOFTHSM_CONFIG_FILE, TOKEN_PIN.toCharArray());
        } else {
            logger.warn("SoftHSM native lib not found - all PKCS#11 test will be skipped");
            cryptoEngine = null;
        }
    }

    @Before
    public void beforeMethod() {
        Assume.assumeTrue(cryptoEngine != null);
    }

    protected CryptoEngine getCryptoEngine() {
        return cryptoEngine;
    }
}
