package io.axoniq.dataprotection.cryptoengine.vault;

import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;

import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import org.jetbrains.annotations.Nullable;

import com.bettercloud.vault.SslConfig;
import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.api.Auth;
import com.bettercloud.vault.response.AuthResponse;

import okhttp3.OkHttpClient;

/**
 * Utility class that has a methode to create the VaultCryptoEngine and it
 * has a factory method to produce an OkHttpClient that accepts
 * untrusted SSL certificates. This is useful to run tests against Vault with SSL
 * (which is important to test, among other things because of performance).
 *
 * Code has been copied from StackOverflow, answer by user sonxurxo:
 * https://stackoverflow.com/a/25992879/8254465
 */
public abstract class Utils {

    /* Change this as appropriate. */
    private static final String VAULT_ADDRESS = "http://localhost:8200";
    private static final String ROOT_TOKEN = "s.zOSdEBtdCFEcQJ0t9jB4bepJ";

    /* We need a policy with create, read and delete rights, but _without_ update rights, in order
     * to properly do a getOrCreate. */
    private static final String POLICY_ID = "axoniq_data_protection";
    private static final String POLICY_HCL = "path \"secret/*\" { " +
            "capabilities = [\"create\", \"read\", \"delete\"] }";

    /* Create the VaultCryptoEngine. */
    public static VaultCryptoEngine initVaultCryptoEngine(@Nullable Integer engineVersion) throws VaultException {
        /* Set up a BetterCloud Vault client. */
        VaultConfig rootVaultConfig = new VaultConfig()
                .engineVersion(engineVersion)
                .sslConfig(new SslConfig().verify(false).build())
                .address(VAULT_ADDRESS)
                .token(ROOT_TOKEN)
                .build();
        Vault rootVault = new Vault(rootVaultConfig);

        /* Store our create/read/delete policy. */
        rootVault.logical().write("sys/policy/" + POLICY_ID,
                                  Collections.singletonMap("policy", POLICY_HCL));

        /* Obtain a token mapped to this policy. */
        AuthResponse authResponse = rootVault.auth().createToken(
                new Auth.TokenRequest().polices(Collections.singletonList(POLICY_ID)));
        String token = authResponse.getAuthClientToken();

        /* Create the OkHttpClient. */
        OkHttpClient okHttpClient = Utils.getUnsafeOkHttpClient();
        return new VaultCryptoEngine(okHttpClient, VAULT_ADDRESS, token,"secret/data/");
    }

    public static SecretKeySpec generateKey() {
        byte[] keyBytes = new byte[32];
        ThreadLocalRandom.current().nextBytes(keyBytes);
        return new SecretKeySpec(keyBytes, "AES");
    }

    private Utils() {
        throw new Error("non-instantiable class");
    }

    private static OkHttpClient getUnsafeOkHttpClient() {
        try {
            // Create a trust manager that does not validate certificate chains
            final TrustManager[] trustAllCerts = new TrustManager[] {
                    new X509TrustManager() {
                        @Override
                        public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        @Override
                        public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                            return new java.security.cert.X509Certificate[]{};
                        }
                    }
            };

            // Install the all-trusting trust manager
            final SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new java.security.SecureRandom());
            // Create an ssl socket factory with our all-trusting manager
            final SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();

            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            builder.hostnameVerifier(new HostnameVerifier() {
                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });

            OkHttpClient okHttpClient = builder.build();
            return okHttpClient;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

}
