/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin.application.requestprocessor;

import io.axoniq.axonserver.access.application.AdminApplicationController;
import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.admin.application.api.ApplicationAdminService;
import io.axoniq.axonserver.admin.application.api.ApplicationContextRoleRequest;
import io.axoniq.axonserver.admin.application.api.ApplicationOverview;
import io.axoniq.axonserver.admin.application.api.ApplicationRequest;
import io.axoniq.axonserver.admin.application.api.ConnectedApplicationOverview;
import io.axoniq.axonserver.admin.application.requestprocessor.ContextStateProvider;
import io.axoniq.axonserver.admin.application.requestprocessor.i;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.common.Role;
import io.axoniq.axonserver.enterprise.cluster.ClusterEvent;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ApplicationProtoConverter;
import io.axoniq.axonserver.grpc.internal.Application;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.command.CommandMetricsWebSocket;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ApplicationAdminRequestProcessor
implements ApplicationAdminService {
    private static final Logger G = AuditLog.getLogger();
    private static final String B = "/\\%;";
    private final RoleController A;
    private final Logger E;
    private final RaftConfigServiceFactory C;
    private final ContextStateProvider c;
    private final AdminApplicationController e;

    private /* synthetic */ void M(List<ApplicationContextRoleRequest> a2) {
        ApplicationAdminRequestProcessor a3;
        Set set = a3.A.listRoles().stream().map(Role::getRole).collect(Collectors.toSet());
        for (String string : a2.stream().map(ApplicationContextRoleRequest::roles).flatMap(Collection::stream).distinct().collect(Collectors.toList())) {
            if (set.contains(string)) continue;
            throw new MessagingPlatformException(ErrorCode.UNKNOWN_ROLE, string + ": Role unknown");
        }
    }

    private /* synthetic */ void M(Throwable a2, String a3, Object ... a4) {
        ApplicationAdminRequestProcessor a5;
        if (MessagingPlatformException.isClientException((Throwable)a2)) {
            a5.E.info(a3, (Object)a4, (Object)a2);
            return;
        }
        a5.E.warn(a3, (Object)a4, (Object)a2);
    }

    @Nonnull
    public Flux<ApplicationOverview> getApplications(@Nonnull Authentication a3) {
        return Flux.fromStream((Stream)this.e.getApplications()).map(a2 -> {
            ApplicationAdminRequestProcessor a3;
            return new i(a3, a2);
        }).doFirst(() -> {
            if (G.isInfoEnabled()) {
                G.info(ClusterEvent.M((Object)"\u000e\u0011(7u80\u001b \u000f&\u001eu\u001e:J9\u0003&\u001eu\u000b%\u001a9\u00036\u000b!\u0003:\u0004&J4\u00041J!\u00020\u0003'J'\u00059\u000f&D"), (Object)AuditLog.username((String)a3.username()));
            }
        }).doOnSubscribe(a2 -> {
            ApplicationAdminRequestProcessor a3;
            a3.E.info(ClusterEvent.M((Object)"-0\u001eu\u000b%\u001a9\u00036\u000b!\u0003:\u0004&J'\u000f$\u001f0\u0019!J'\u000f6\u000f<\u001c0\u000eu\f:\u0018u\u000b%\u001a9\u00036\u000b!\u0003:\u0004"));
        }).doOnError(a2 -> {
            ApplicationAdminRequestProcessor a3;
            a3.M(a2, ClusterEvent.M((Object)"\u0010\u0018'\u0005'J9\u0003&\u001e<\u00042J4\u001a%\u0006<\t4\u001e<\u0005;\u0019"), new Object[0]);
        });
    }

    @Nonnull
    public Mono<String> createOrUpdateApplication(@Nonnull ApplicationRequest application, @Nonnull Authentication a2) {
        return Mono.fromCallable(() -> {
            ApplicationAdminRequestProcessor a3;
            return a3.C.getRaftConfigService().updateApplication(ApplicationProtoConverter.createApplication((ApplicationRequest)application)).getToken();
        }).doFirst(() -> {
            if (G.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = application.name();
                objectArray[2] = application.rolesPerContext();
                G.info(ClusterEvent.M((Object)"\u000e\u0011(7u80\u001b \u000f&\u001eu\u001e:J6\u00180\u000b!\u000fu\u000b%\u001a9\u00036\u000b!\u0003:\u0004uH.\u0017wJ\"\u0003!\u0002u\u0018:\u00060\u0019u\u0011(D"), objectArray);
            }
        }).doFirst(() -> {
            ApplicationAdminRequestProcessor a3;
            ApplicationAdminRequestProcessor applicationAdminRequestProcessor = a3;
            applicationAdminRequestProcessor.M(application.name());
            applicationAdminRequestProcessor.M(application.rolesPerContext());
        }).doOnSubscribe(a3 -> {
            ApplicationAdminRequestProcessor a4;
            a4.E.info(CommandMetricsWebSocket.M((Object)"qqWbFf\u0012bBs^jQbFj]m\u0012qWrGfAw\u0012qW`WjDfV#Tl@#SsBo[`Sw[l\\9\u0012xO"), (Object)application.name());
        }).doOnError(a3 -> {
            ApplicationAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = application.name();
            a4.M(a3, CommandMetricsWebSocket.M((Object)"I~\b#wq@l@#QqWbFj\\d\u001dvBgSw[mU#SsBo[`Sw[l\\"), objectArray);
        });
    }

    private /* synthetic */ void M(String a2) {
        int n;
        char[] cArray = a2.toCharArray();
        int n2 = cArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            char c2 = cArray[n];
            if (B.indexOf(c2) >= 0) {
                Object[] objectArray = new Object[2];
                objectArray[0] = a2;
                objectArray[1] = Character.valueOf(c2);
                throw new MessagingPlatformException(ErrorCode.INVALID_NAME, String.format(ClusterEvent.M((Object)"p\u0019oJ<\u0004#\u000b9\u00031J6\u00024\u00184\t!\u000f'J}O&Cu\u0003;J;\u000b8\u000f"), objectArray));
            }
            n3 = ++n;
        }
    }

    public ApplicationAdminRequestProcessor(RaftConfigServiceFactory a2, AdminApplicationController a3, RoleController a4, ContextStateProvider a5) {
        ApplicationAdminRequestProcessor a6;
        ApplicationAdminRequestProcessor applicationAdminRequestProcessor = a6;
        ApplicationAdminRequestProcessor applicationAdminRequestProcessor2 = a6;
        a6.E = LoggerFactory.getLogger(ApplicationAdminRequestProcessor.class);
        applicationAdminRequestProcessor2.C = a2;
        applicationAdminRequestProcessor2.e = a3;
        applicationAdminRequestProcessor.A = a4;
        applicationAdminRequestProcessor.c = a5;
    }

    @Nonnull
    public Mono<ConnectedApplicationOverview> getConnectedApplicationsByContext(@Nonnull String contextName, @Nonnull Authentication a2) {
        return Mono.fromCallable(() -> {
            ApplicationAdminRequestProcessor a3;
            return a3.c.getCurrentState(contextName);
        }).doFirst(() -> {
            if (G.isInfoEnabled()) {
                G.info(CommandMetricsWebSocket.M((Object)"XI~o#`fCvWpF#Fl\u0012dWw\u0012`]m\\fQwWg\u0012bBs^jQbFj]mA#I~\u001c"), (Object)AuditLog.username((String)a2.username()), (Object)contextName);
            }
        }).doOnSubscribe(a3 -> {
            ApplicationAdminRequestProcessor a4;
            a4.E.info(CommandMetricsWebSocket.M((Object)"DWw\u0012`]m\\fQwWg\u0012bBs^jQbFj]m\u0012qWrGfAw\u0012qW`WjDfV#Tl@#Ql\\wW{F9\u0012xO"), (Object)contextName);
        }).doOnError(a3 -> {
            ApplicationAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = contextName;
            a4.M(a3, ClusterEvent.M((Object)"\u0011(Pu/'\u0018:\u0018u\r0\u001e!\u0003;\ru\t:\u0004;\u000f6\u001e0\u000eu\u000b%\u001a9\u00036\u000b!\u0003:\u0004"), objectArray);
        });
    }

    @Nonnull
    public Mono<String> refreshToken(@Nonnull String applicationName, @Nonnull Authentication a2) {
        return Mono.fromCallable(() -> {
            ApplicationAdminRequestProcessor a3;
            return a3.C.getRaftConfigService().refreshToken(Application.newBuilder().setName(applicationName).build()).getToken();
        }).doFirst(() -> {
            if (G.isInfoEnabled()) {
                G.info(ClusterEvent.M((Object)"1.\u0017\bJ\u0007\u000f$\u001f0\u0019!J!\u0005u\u00180\u00040\u001du\u001e:\u00010\u0004u\f:\u0018u\u000b%\u001a9\u00036\u000b!\u0003:\u0004u\u0011(D"), (Object)AuditLog.username((String)a2.username()), (Object)applicationName);
            }
        }).doOnSubscribe(a3 -> {
            ApplicationAdminRequestProcessor a4;
            a4.E.info(ClusterEvent.M((Object)".0\u00060\u001e0J4\u001a%\u0006<\t4\u001e<\u0005;J'\u000f$\u001f0\u0019!J'\u000f6\u000f<\u001c0\u000eu\f:\u0018u\u000b%\u001a9\u00036\u000b!\u0003:\u0004oJ.\u0017"), (Object)applicationName);
        }).doOnError(a3 -> {
            ApplicationAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = applicationName;
            a4.M(a3, CommandMetricsWebSocket.M((Object)"xO9\u0012F@q]q\u0012qWe@fAk[mU#FlYf\\"), objectArray);
        });
    }

    @Nonnull
    public Mono<Void> deleteApplication(@Nonnull String applicationName, @Nonnull Authentication a2) {
        return Mono.fromRunnable(() -> {
            ApplicationAdminRequestProcessor a3;
            a3.C.getRaftConfigService().deleteApplication(Application.newBuilder().setName(applicationName).build());
        }).doFirst(() -> {
            if (G.isInfoEnabled()) {
                G.info(ClusterEvent.M((Object)"\u000e\u0011(7u80\u001b \u000f&\u001eu\u001e:J1\u000f9\u000f!\u000fu\u000b%\u001a9\u00036\u000b!\u0003:\u0004u\u0011(D"), (Object)AuditLog.username((String)a2.username()), (Object)applicationName);
            }
        }).doOnSubscribe(a3 -> {
            ApplicationAdminRequestProcessor a4;
            a4.E.info(CommandMetricsWebSocket.M((Object)"vf^fFf\u0012bBs^jQbFj]m\u0012qWrGfAw\u0012qW`WjDfV#Tl@#SsBo[`Sw[l\\9\u0012xO"), (Object)applicationName);
        }).doOnError(a3 -> {
            ApplicationAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = applicationName;
            a4.M(a3, CommandMetricsWebSocket.M((Object)"xO9\u0012F@q]q\u0012gWoWw[mU#SsBo[`Sw[l\\"), objectArray);
        });
    }

    @Nonnull
    public Mono<ApplicationOverview> getApplication(@Nonnull String applicationName, @Nonnull Authentication a2) {
        return Mono.fromCallable(() -> {
            ApplicationAdminRequestProcessor a3;
            ApplicationAdminRequestProcessor applicationAdminRequestProcessor = a3;
            return applicationAdminRequestProcessor.M(applicationAdminRequestProcessor.e.get(applicationName));
        }).doFirst(() -> {
            if (G.isInfoEnabled()) {
                G.info(CommandMetricsWebSocket.M((Object)"ixO^\u0012QWrGfAw\u0012w]#UfF#SsBo[`Sw[l\\#I~\u0012b\\g\u0012jFp\u0012q]oWp\u001c"), (Object)AuditLog.username((String)a2.username()), (Object)applicationName);
            }
        }).doOnSubscribe(a3 -> {
            ApplicationAdminRequestProcessor a4;
            a4.E.info(CommandMetricsWebSocket.M((Object)"DWw\u0012bBs^jQbFj]m\u0012qWrGfAw\u0012qW`WjDfV#Tl@#SsBo[`Sw[l\\9\u0012xO"), (Object)applicationName);
        }).doOnError(a3 -> {
            ApplicationAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = applicationName;
            a4.M(a3, CommandMetricsWebSocket.M((Object)"I~\b#wq@l@#UfFw[mU#SsBo[`Sw[l\\"), objectArray);
        });
    }
}

