/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin.context.requestprocessor;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.admin.context.api.ContextAdminService;
import io.axoniq.axonserver.admin.context.api.ContextOverview;
import io.axoniq.axonserver.admin.context.api.ContextPropertiesUpdate;
import io.axoniq.axonserver.admin.context.api.ContextUpdate;
import io.axoniq.axonserver.admin.context.api.ContextUpdateState;
import io.axoniq.axonserver.admin.context.api.RemoveContext;
import io.axoniq.axonserver.admin.context.api.ReplicationGroupContext;
import io.axoniq.axonserver.admin.context.requestprocessor.ContextFilter;
import io.axoniq.axonserver.admin.context.requestprocessor.TierConfiguration;
import io.axoniq.axonserver.admin.context.requestprocessor.VisibleContextCache;
import io.axoniq.axonserver.admin.context.requestprocessor.b;
import io.axoniq.axonserver.admin.context.requestprocessor.i;
import io.axoniq.axonserver.admin.tier.api.LocalTierInfo;
import io.axoniq.axonserver.admin.tier.requestprocessor.LocalTierAdminRequestProcessor;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.configuration.admin.AdminContext;
import io.axoniq.axonserver.configuration.admin.AdminContexts;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.localstorage.ContextPropertyDefinition;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.file.EmbeddedDBPropertiesProvider;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.transport.rest.LoadBalancingManagementRestController;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.retry.Retry;

@Service
public class ContextAdminRequestProcessor
implements ContextAdminService {
    private final Logger d;
    private final VisibleContextCache a;
    private final ContextFilter j;
    private static final Logger h = AuditLog.getLogger();
    private final Sinks.Many<ContextUpdate> l;
    private final AdminContexts G;
    private final Limits B;
    private final ClusterController A;
    private final LocalTierAdminRequestProcessor E;
    private final RaftConfigServiceFactory C;
    private final Predicate<String> c;
    private final EmbeddedDBPropertiesProvider e;

    private /* synthetic */ boolean h(TierConfiguration a2) {
        block2: {
            block3: {
                ContextAdminRequestProcessor a3;
                if (a3.B.multitier()) break block2;
                if (a2.h().size() > 1) break block3;
                if (a2.M().size() <= 1) break block2;
            }
            return true;
        }
        return false;
    }

    @EventListener
    public void on(ContextEvents.ContextUpdatedInAdmin a4) {
        ContextAdminRequestProcessor a5;
        a5.l.emitNext((Object)new b(a4.M(), ContextUpdateState.A), (a2, a3) -> {
            if (a3 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    @Nonnull
    public Flux<String> getVisibleContexts(boolean includeAdmin, @Nonnull Authentication a2) {
        return Flux.fromIterable((Iterable)this.a.apply(a2)).filter(a3 -> {
            if (includeAdmin || !RaftAdminGroup.M((String)a3)) {
                return true;
            }
            return false;
        });
    }

    @NotNull
    public Mono<Void> updateContext(@NotNull ContextPropertiesUpdate request, @Nonnull Authentication a2) {
        return Mono.fromFuture(() -> {
            ContextAdminRequestProcessor a3;
            ContextAdminRequestProcessor contextAdminRequestProcessor = a3;
            contextAdminRequestProcessor.d.info(SerializedEvent.M((Object)"\u001a\"+3;7o1 <;77&o *#:7<&o *1*;97+r)==r,=!&**;ho)2"), (Object)request.contextName());
            return contextAdminRequestProcessor.C.getRaftConfigService().updateContext(request.contextName(), request.metaDataMap());
        }).doFirst(() -> {
            ContextAdminRequestProcessor a4;
            h.info(LoadBalancingManagementRestController.M((Object)"m}K[\u0016TSwCcEr\u0016rY&CvRgBc\u0016eYhBcNr\u0016}K("), (Object)AuditLog.username((String)a2.username()), (Object)request.contextName());
            ContextAdminRequestProcessor contextAdminRequestProcessor = a4;
            contextAdminRequestProcessor.M(request.metaDataMap());
            contextAdminRequestProcessor.M(request.contextName(), request.metaDataMap(), a2);
        }).doOnError(a3 -> {
            ContextAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = request.contextName();
            a4.M(a3, SerializedEvent.M((Object)")2ho771*\";; <o%';#7o'?6.&&<(r,=!&**;"), objectArray);
        });
    }

    @Nonnull
    public Flux<ContextUpdate> subscribeContextUpdates(@Nonnull Authentication a4) {
        return this.l.asFlux().publish().autoConnect().filter(a3 -> {
            ContextAdminRequestProcessor a4;
            return a4.j.hasAccess(a3.name(), a4);
        }).doOnCancel(() -> {
            ContextAdminRequestProcessor a2;
            a2.d.info(SerializedEvent.M((Object)"\u001c'-!, &0*6o!;=?r=7,7&$&<(r,=!&**;r:\"+3;7<"));
        }).doOnError(a2 -> {
            ContextAdminRequestProcessor a3;
            a3.M(a2, LoadBalancingManagementRestController.M((Object)"S~UcFr_iX&An_jS&ZoErSh_hQ&Bi\u0016eYhBcNr\u0016sFbWrSu"), new Object[0]);
        }).doFirst(() -> {
            ContextAdminRequestProcessor a3;
            if (!a3.A.isAdminNode()) {
                throw new MessagingPlatformException(ErrorCode.UNSUPPORTED_INSTRUCTION, LoadBalancingManagementRestController.M((Object)"xiRc\u0016oE&XiB&Wh\u0016YWb[oX&XiRc"));
            }
            h.info(SerializedEvent.M((Object)"\u0014)2\u000fo\u0001:0<1=;-7+r;=o1 <;77&o'?6.&*!a"), (Object)AuditLog.username((String)a4.username()));
            a3.d.info(LoadBalancingManagementRestController.M((Object)"HSq\u0016uCdEeDoTcD&Bi\u0016eYhBcNr\u0016sFbWrSu"));
        });
    }

    @EventListener
    public void on(ContextEvents.ContextRegisteredInAdmin a4) {
        ContextAdminRequestProcessor a5;
        a5.l.emitNext((Object)new b(a4.context(), ContextUpdateState.E), (a2, a3) -> {
            if (a3 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    @Nonnull
    public Flux<ContextOverview> getContexts(@Nonnull Authentication a4) {
        return Flux.defer(() -> {
            ContextAdminRequestProcessor a2;
            if (!a2.A.isAdminNode()) {
                throw new MessagingPlatformException(ErrorCode.UNSUPPORTED_INSTRUCTION, LoadBalancingManagementRestController.M((Object)"xiRc\u0016oE&XiB&Wh\u0016YWb[oX&XiRc"));
            }
            return Flux.fromIterable((Iterable)a2.G.findAll());
        }).filter(a3 -> {
            ContextAdminRequestProcessor a4;
            return a4.j.hasAccess(a3.getName(), a4);
        }).map(a2 -> {
            ContextAdminRequestProcessor a3;
            return new i(a3, a2);
        }).doFirst(() -> h.info(LoadBalancingManagementRestController.M((Object)"m}K[\u0016TSwCcEr\u0016rY&ZoEr\u0016eYhBcNrE("), (Object)AuditLog.username((String)a4.username()))).doOnError(a2 -> {
            ContextAdminRequestProcessor a3;
            a3.M(a2, LoadBalancingManagementRestController.M((Object)"cNeSvBoYh\u0016q^oZc\u0016tSrDoSp_hQ&UiXrS~Bu"), new Object[0]);
        });
    }

    @Nonnull
    public Mono<Void> deleteContext(@Nonnull RemoveContext request, @Nonnull Authentication a2) {
        return Mono.fromRunnable(() -> {
            ContextAdminRequestProcessor a3;
            RemoveContext removeContext = request;
            a3.d.info(SerializedEvent.M((Object)"\u000b7#7;7o1 <;77&o *#:7<&o *1*;97+r)==r,=!&**;ho)2"), (Object)removeContext.name());
            if (removeContext.name().startsWith(LoadBalancingManagementRestController.M((Object)"Y"))) {
                Object[] objectArray = new Object[1];
                objectArray[0] = request.name();
                throw new MessagingPlatformException(ErrorCode.CANNOT_DELETE_INTERNAL_CONTEXT, String.format(SerializedEvent.M((Object)"\f3!< &o6*>*&*r&<;7=<.>o1 <;77&ow<"), objectArray));
            }
            a3.C.getRaftConfigService().deleteContext(request.name(), request.preserveEventStore());
        }).doFirst(() -> {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((String)a2.username());
            objectArray[1] = request.name();
            objectArray[2] = request.preserveEventStore();
            h.info(SerializedEvent.M((Object)"\t4/\u0012r\u001d7>'*!;r;=o6*>*&*r,=!&**;r4/o\"=7<7=$*r*$*<;r<&  *r4/a"), objectArray);
        }).doOnError(a3 -> {
            ContextAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = request.name();
            a4.M(a3, SerializedEvent.M((Object)")2ho771*\";; <o%';#7o6*>*&&<(r,=!&**;"), objectArray);
        });
    }

    @Nonnull
    public Mono<ContextOverview> getContext(@Nonnull String contextName, @Nonnull Authentication a4) {
        return Mono.fromCallable(() -> {
            ContextAdminRequestProcessor a3;
            if (!a3.A.isAdminNode()) {
                throw new MessagingPlatformException(ErrorCode.UNSUPPORTED_INSTRUCTION, SerializedEvent.M((Object)"\u001c 6*r&!o< &o3!r\u00103+?&<o< 6*"));
            }
            return a3.G.findById(contextName);
        }).map(a2 -> (AdminContext)a2.orElseThrow(() -> new MessagingPlatformException(ErrorCode.CONTEXT_NOT_FOUND, LoadBalancingManagementRestController.M((Object)"EYhBcNr\u0016hYr\u0016`YsXb")))).filter(a3 -> {
            ContextAdminRequestProcessor a4;
            return a4.j.hasAccess(a3.getName(), a4);
        }).switchIfEmpty(Mono.error(() -> new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, LoadBalancingManagementRestController.M((Object)"OXpWj_b\u0016rYmSh")))).retryWhen((Retry)Retry.backoff((long)2L, (Duration)Duration.ofSeconds(1L)).onRetryExhaustedThrow((a2, a3) -> a3.failure())).map(a2 -> {
            ContextAdminRequestProcessor a3;
            return new i(a3, a2);
        }).doOnError(a3 -> {
            ContextAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = contextName;
            a4.M(a3, LoadBalancingManagementRestController.M((Object)"M{\f&S~UcFr_iX&An_jS&DcBt_c@oXa\u0016eYhBcNr"), objectArray);
        });
    }

    @Nonnull
    public Mono<Void> initCluster(@Nonnull List<String> contexts, @Nonnull Authentication a3) {
        return Mono.fromRunnable(() -> {
            ContextAdminRequestProcessor a3;
            a3.C.getLocalRaftConfigService().init(contexts);
        }).doFirst(() -> h.info(SerializedEvent.M((Object)"\t4/\u0012r\u001d7>'*!;r;=o;!;;;.>&(*r,>:!;7=r4/a"), (Object)AuditLog.username((String)a3.username()), (Object)contexts)).doOnError(a2 -> {
            ContextAdminRequestProcessor a3;
            a3.M(a2, LoadBalancingManagementRestController.M((Object)"cNeSvBoYh\u0016oX&_h_r\u0016eZsErSt"), new Object[0]);
        });
    }

    private /* synthetic */ void M(String a4, Map<String, String> a5, Authentication a6) {
        ContextAdminRequestProcessor a7;
        TierConfiguration tierConfiguration = new TierConfiguration(a5);
        a6 = a7.E.getLocalTiers(a6).stream().map(LocalTierInfo::id).collect(Collectors.toList());
        if (a7.h(tierConfiguration) && !a7.M(tierConfiguration)) {
            throw new IllegalArgumentException(SerializedEvent.M((Object)"\u0002'#&&\u007f;;* o!;==3(7o;<r <#+o3#> %*6o%&&'r.r93#;+r#;,7!!*"));
        }
        tierConfiguration.M((List)a6);
        a5.entrySet().stream().filter(a2 -> ((String)a2.getKey()).startsWith("event.storage")).map(Map.Entry::getValue).forEach(a3 -> {
            ContextAdminRequestProcessor a4;
            a4.e.getEventProperties(a4).getStorage(a3);
        });
        a5.entrySet().stream().filter(a2 -> ((String)a2.getKey()).startsWith("snapshot.storage")).map(Map.Entry::getValue).forEach(a3 -> {
            ContextAdminRequestProcessor a4;
            a4.e.getSnapshotProperties(a4).getStorage(a3);
        });
    }

    private /* synthetic */ void M(String a2) {
        ContextAdminRequestProcessor a3;
        if (!a3.c.test(a2)) {
            throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, SerializedEvent.M((Object)"\u001b!$.>&6o1 <;77&o<.?*"));
        }
    }

    private /* synthetic */ void M(@NotNull Map<String, String> a2) {
        for (Map.Entry entry : a2.entrySet()) {
            try {
                ContextPropertyDefinition contextPropertyDefinition = ContextPropertyDefinition.M((String)((String)entry.getKey()));
                if (contextPropertyDefinition == null) continue;
                contextPropertyDefinition.M((String)entry.getValue());
            }
            catch (Exception exception) {
                throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, exception.getMessage());
            }
        }
    }

    private /* synthetic */ boolean M(TierConfiguration a2) {
        block4: {
            block3: {
                block2: {
                    if (a2.h().size() <= 1) break block2;
                    if (((TierConfiguration.Tier)a2.h().get(1)).M(LoadBalancingManagementRestController.M((Object)"TjWe]Y^iZc"))) break block3;
                }
                if (a2.M().size() <= 1) break block4;
                if (!((TierConfiguration.Tier)a2.M().get(1)).M(SerializedEvent.M((Object)"0#3,9\u0010: >*"))) break block4;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public Mono<Void> createContext(@Nonnull ReplicationGroupContext request, @Nonnull Authentication a2) {
        return Mono.fromFuture(() -> {
            ContextAdminRequestProcessor a3;
            ContextAdminRequestProcessor contextAdminRequestProcessor = a3;
            contextAdminRequestProcessor.d.info(LoadBalancingManagementRestController.M((Object)"EDcWrS&UiXrS~B&DcGsSuB&DcUc_pSb\u0016`Yt\u0016eYhBcNr\f&M{"), (Object)request.contextName());
            return contextAdminRequestProcessor.C.getRaftConfigService().addContext(request.replicationGroupName(), request.contextName(), request.metaDataMap());
        }).doFirst(() -> {
            ContextAdminRequestProcessor a4;
            h.info(SerializedEvent.M((Object)"\u0014)2\u000fo\u0000*#:7<&o& r.6+r,=!&**;r4/a"), (Object)AuditLog.username((String)a2.username()), (Object)request.contextName());
            ContextAdminRequestProcessor contextAdminRequestProcessor = a4;
            ReplicationGroupContext replicationGroupContext = request;
            a4.M(replicationGroupContext.contextName());
            contextAdminRequestProcessor.M(replicationGroupContext.metaDataMap());
            contextAdminRequestProcessor.M(request.contextName(), request.metaDataMap(), a2);
        }).doOnError(a3 -> {
            ContextAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = request.contextName();
            a4.M(a3, LoadBalancingManagementRestController.M((Object)"M{\f&S~UcFr_iX&An_jS&UtSgBoXa\u0016eYhBcNr"), objectArray);
        });
    }

    @EventListener
    public void on(ContextEvents.ContextUnregisteredInAdmin a4) {
        ContextAdminRequestProcessor a5;
        a5.l.emitNext((Object)new b(a4.context(), ContextUpdateState.c), (a2, a3) -> {
            if (a3 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    public ContextAdminRequestProcessor(RaftConfigServiceFactory a2, ClusterController a3, AdminContexts a4, ContextFilter a5, Limits a6, VisibleContextCache a7, LocalTierAdminRequestProcessor a8, EmbeddedDBPropertiesProvider a9) {
        ContextAdminRequestProcessor a10;
        ContextAdminRequestProcessor contextAdminRequestProcessor = a10;
        ContextAdminRequestProcessor contextAdminRequestProcessor2 = a10;
        ContextAdminRequestProcessor contextAdminRequestProcessor3 = a10;
        ContextAdminRequestProcessor contextAdminRequestProcessor4 = a10;
        a10.d = LoggerFactory.getLogger(ContextAdminRequestProcessor.class);
        ContextAdminRequestProcessor contextAdminRequestProcessor5 = a10;
        a10.c = new ContextNameValidation();
        contextAdminRequestProcessor5.l = Sinks.many().multicast().onBackpressureBuffer();
        contextAdminRequestProcessor4.C = a2;
        contextAdminRequestProcessor4.A = a3;
        contextAdminRequestProcessor3.G = a4;
        contextAdminRequestProcessor3.j = a5;
        contextAdminRequestProcessor2.B = a6;
        contextAdminRequestProcessor2.a = a7;
        contextAdminRequestProcessor.E = a8;
        contextAdminRequestProcessor.e = a9;
    }

    private /* synthetic */ void M(Throwable a2, String a3, Object ... a4) {
        ContextAdminRequestProcessor a5;
        if (MessagingPlatformException.isClientException((Throwable)a2)) {
            a5.d.info(a3, (Object)a4, (Object)a2);
            return;
        }
        a5.d.warn(a3, (Object)a4, (Object)a2);
    }
}

