/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin.eventprocessor.requestprocessor;

import io.axoniq.axonserver.admin.Instruction;
import io.axoniq.axonserver.admin.InstructionCache;
import io.axoniq.axonserver.admin.context.requestprocessor.VisibleContextCache;
import io.axoniq.axonserver.admin.eventprocessor.api.EventProcessor;
import io.axoniq.axonserver.admin.eventprocessor.api.EventProcessorAdminService;
import io.axoniq.axonserver.admin.eventprocessor.api.EventProcessorId;
import io.axoniq.axonserver.admin.eventprocessor.api.Result;
import io.axoniq.axonserver.admin.eventprocessor.requestprocessor.DistributedEventProcessor;
import io.axoniq.axonserver.admin.eventprocessor.requestprocessor.InstructionInformation;
import io.axoniq.axonserver.admin.eventprocessor.requestprocessor.L;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.component.processor.EventProcessorIdentifier;
import io.axoniq.axonserver.component.processor.ProcessorEventPublisher;
import io.axoniq.axonserver.component.processor.balancing.LoadBalancingStrategy;
import io.axoniq.axonserver.component.processor.balancing.strategy.LoadBalanceStrategyRepository;
import io.axoniq.axonserver.component.processor.listener.ClientProcessor;
import io.axoniq.axonserver.component.processor.listener.ClientProcessors;
import io.axoniq.axonserver.configuration.common.CommonConfigurationFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.StringUtils;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class LocalEventProcessorsAdminService
implements EventProcessorAdminService {
    protected final LoadBalanceStrategyRepository G;
    private final CommonConfigurationFactory B;
    protected static final Logger A = AuditLog.getLogger();
    private final ProcessorEventPublisher E;
    private final Logger C;
    private final ConstraintCache<String, Instruction> c;
    protected final Flux<ClientProcessor> e;

    private /* synthetic */ int M(L a22) {
        L l2 = a22;
        int a22 = l2.e >>> 1;
        return l2.C ^ a22;
    }

    private /* synthetic */ boolean h(EventProcessorIdentifier a2, ClientProcessor a3) {
        LocalEventProcessorsAdminService a4;
        return a4.M(a3, (EventProcessorId)a2);
    }

    @Autowired
    public LocalEventProcessorsAdminService(ProcessorEventPublisher a2, ClientProcessors a3, InstructionCache a4, LoadBalanceStrategyRepository a5, CommonConfigurationFactory a6) {
        a7(a2, Flux.fromIterable((Iterable)a3), (ConstraintCache)a4, a5, a6);
        LocalEventProcessorsAdminService a7;
    }

    @Nonnull
    public Mono<Result> pause(@Nonnull EventProcessorId identifier, @Nonnull Authentication a2) {
        String string = identifier.name();
        String string2 = "Pause " + string;
        return this.e.doFirst(() -> {
            if (A.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = StringUtils.sanitize((String)string);
                objectArray[2] = StringUtils.sanitize((String)identifier.tokenStoreIdentifier());
                A.info(VisibleContextCache.M((Object)"\u0017v1Pl_)|9h?yly#-<l9~)-\t{)c8-<\u007f#n)~?b>-nv1M7pn#"), objectArray);
            }
        }).filter(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.M(a3, identifier);
        }).collectList().flatMap(a4 -> {
            LocalEventProcessorsAdminService a5;
            return Mono.create(a6 -> {
                LocalEventProcessorsAdminService a7;
                if (a4.isEmpty()) {
                    a6.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_NOT_FOUND, QueryHandler.M((Object)"\u000b\u007f+g:)>{!j+z=f<) f:)(f;g*")));
                    return;
                }
                String string = UUID.randomUUID().toString();
                Set set = a4.stream().map(ClientProcessor::clientId).collect(Collectors.toSet());
                LocalEventProcessorsAdminService localEventProcessorsAdminService = a7;
                localEventProcessorsAdminService.c.put((Object)string, (Object)new InstructionInformation(a6, string, string2, set));
                a4.forEach(a4 -> {
                    LocalEventProcessorsAdminService a5;
                    a5.E.pauseProcessorRequest(a4.context(), a4.clientId(), string, string);
                });
            });
        }).doOnError(a3 -> {
            LocalEventProcessorsAdminService a4;
            a4.M(string2, a3);
        });
    }

    @Nonnull
    public Mono<Result> start(@Nonnull EventProcessorId identifier, @Nonnull Authentication a2) {
        String string = identifier.name();
        String string2 = "Start " + string;
        return this.e.doFirst(() -> {
            if (A.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = StringUtils.sanitize((String)string);
                objectArray[2] = StringUtils.sanitize((String)identifier.tokenStoreIdentifier());
                A.info(QueryHandler.M((Object)"R5t\u0013)\u001cl?|+z:):fnz:h<}nL8l }ny<f-l=z!{n+5t\u000er3+`"), objectArray);
            }
        }).filter(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.M(a3, identifier);
        }).collectList().flatMap(a4 -> {
            LocalEventProcessorsAdminService a5;
            return Mono.create(a6 -> {
                LocalEventProcessorsAdminService a7;
                if (a4.isEmpty()) {
                    a6.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_NOT_FOUND, VisibleContextCache.M((Object)"H:h\"yl}>b/h?~#\u007flc#ylk#x\"i")));
                    return;
                }
                String string = UUID.randomUUID().toString();
                Set set = a4.stream().map(ClientProcessor::clientId).collect(Collectors.toSet());
                LocalEventProcessorsAdminService localEventProcessorsAdminService = a7;
                localEventProcessorsAdminService.c.put((Object)string, (Object)new InstructionInformation(a6, string, string2, set));
                a4.forEach(a4 -> {
                    LocalEventProcessorsAdminService a5;
                    a5.E.startProcessorRequest(a4.context(), a4.clientId(), string, string);
                });
            });
        }).doOnError(a3 -> {
            LocalEventProcessorsAdminService a4;
            a4.M(string2, a3);
        });
    }

    @Nonnull
    public Mono<Result> move(@Nonnull EventProcessorId identifier, int segment, @Nonnull String target, @Nonnull Authentication a2) {
        EventProcessorId eventProcessorId = identifier;
        String string = eventProcessorId.name();
        String string2 = eventProcessorId.tokenStoreIdentifier();
        String string3 = "Move " + string;
        string2 = new EventProcessorIdentifier(string, identifier.context(), string2);
        return this.e.doFirst(() -> {
            if (A.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = StringUtils.sanitize((String)string);
                objectArray[2] = StringUtils.sanitize((String)identifier.tokenStoreIdentifier());
                A.info(VisibleContextCache.M((Object)"\u0017v1Pl_)|9h?yly#-?y-\u007f8-\t{)c8-<\u007f#n)~?b>-nv1M7pn#"), objectArray);
            }
        }).filter(arg_0 -> this.h((EventProcessorIdentifier)string2, arg_0)).collectList().flatMap(a6 -> {
            LocalEventProcessorsAdminService a7;
            return Mono.create(a8 -> {
                LocalEventProcessorsAdminService a9;
                Object object = a6.stream().filter(a3 -> target.equals(a3.clientId())).findFirst();
                if (!((Optional)object).isPresent()) {
                    a8.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_MOVE_UNKNOWN_TARGET, VisibleContextCache.M((Object)"Y-\u007f+h8-*b>-!b:hlc#ylk#x\"i")));
                    return;
                }
                Object object2 = ((Optional)object).get().eventProcessorInfo().getSegmentStatusList();
                if (object2.stream().anyMatch(a3 -> {
                    if (a3.getSegmentId() == segment) {
                        return true;
                    }
                    return false;
                })) {
                    a8.success();
                    return;
                }
                if (((Optional)object).get().eventProcessorInfo().getAvailableThreads() < 1) {
                    a8.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_MOVE_NO_AVAILBLE_THREADS, QueryHandler.M((Object)"G!)/\u007f/`\"h,e+):a<l/m=)!gn}/{)l:")));
                    return;
                }
                object2 = UUID.randomUUID().toString();
                object = a6.stream().map(ClientProcessor::clientId).filter(a3 -> {
                    if (!target.equals(a3)) {
                        return true;
                    }
                    return false;
                }).collect(Collectors.toSet());
                if (object.isEmpty()) {
                    a8.error((Throwable)new MessagingPlatformException(ErrorCode.OTHER, VisibleContextCache.M((Object)"C#-#y$h>-/a%h\"yle-~ln l%`)ily$hl~)j!h\"y")));
                    return;
                }
                a9.c.put(object2, (Object)new InstructionInformation(a8, (String)object2, string3, (Set)object));
                a6.stream().filter(a3 -> {
                    if (!target.equals(a3.clientId())) {
                        return true;
                    }
                    return false;
                }).forEach(arg_0 -> a9.M(string, segment, (String)object2, arg_0));
            });
        }).doOnError(a3 -> {
            LocalEventProcessorsAdminService a4;
            a4.M(string3, a3);
        });
    }

    @Nonnull
    public Mono<Void> loadBalance(@Nonnull EventProcessorId processor, @Nonnull String strategy, @Nonnull Authentication a2) {
        return this.e.filter(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.M(a3, processor);
        }).map(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.B.trackingEventProcessor(processor.name(), a3.context(), processor.tokenStoreIdentifier());
        }).flatMap(a3 -> {
            LocalEventProcessorsAdminService a4;
            return Mono.fromRunnable(() -> {
                LocalEventProcessorsAdminService a4;
                a4.G.findByName(strategy).balance(a3).perform();
            }).subscribeOn(Schedulers.boundedElastic());
        }).then().doFirst(() -> {
            if (A.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = processor;
                objectArray[2] = strategy;
                A.info(QueryHandler.M((Object)"\u0015r3Tn[+x;l=}n}!)=l:)\"f/mck/e/g-` nnz:{/}+n7)(f<)>{!j+z=f<)lr3+n}!)lr3+`"), objectArray);
            }
        });
    }

    @Nonnull
    public Flux<String> clientsBy(@Nonnull EventProcessorId identifier, @Nonnull Authentication a2) {
        EventProcessorId eventProcessorId = identifier;
        String string = eventProcessorId.name();
        String string2 = eventProcessorId.tokenStoreIdentifier();
        if (A.isInfoEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((String)a2.username());
            objectArray[1] = StringUtils.sanitize((String)string);
            objectArray[2] = StringUtils.sanitize((String)string2);
            A.info(QueryHandler.M((Object)"R5t\u0013)\u001cl?|+z:)(f<)/)\"`=}nf()-e'l }=):a/}nj!g:h'g=):a+)>{!j+z=f<)lr3+nIn+5tl"), objectArray);
        }
        identifier = new EventProcessorIdentifier(string, identifier.context(), string2);
        return this.e.filter(arg_0 -> this.M((EventProcessorIdentifier)identifier, arg_0)).map(ClientProcessor::clientId).distinct();
    }

    public LocalEventProcessorsAdminService(ProcessorEventPublisher a2, Flux<ClientProcessor> a3, ConstraintCache<String, Instruction> a4, LoadBalanceStrategyRepository a5, CommonConfigurationFactory a6) {
        LocalEventProcessorsAdminService a7;
        LocalEventProcessorsAdminService localEventProcessorsAdminService = a7;
        LocalEventProcessorsAdminService localEventProcessorsAdminService2 = a7;
        LocalEventProcessorsAdminService localEventProcessorsAdminService3 = a7;
        localEventProcessorsAdminService3.C = LoggerFactory.getLogger(LocalEventProcessorsAdminService.class);
        localEventProcessorsAdminService3.E = a2;
        localEventProcessorsAdminService2.e = a3;
        localEventProcessorsAdminService2.c = a4;
        localEventProcessorsAdminService.G = a5;
        localEventProcessorsAdminService.B = a6;
    }

    @Nonnull
    public Mono<Result> split(@Nonnull EventProcessorId identifier, @Nonnull Authentication a5) {
        String string = identifier.name();
        String string2 = "Split " + string;
        String string3 = identifier.tokenStoreIdentifier();
        return this.e.doFirst(() -> {
            if (A.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a5.username());
                objectArray[1] = StringUtils.sanitize((String)string);
                objectArray[2] = StringUtils.sanitize((String)string3);
                A.info(VisibleContextCache.M((Object)"V7p\u0011-\u001eh=x)~8-8bl~<a%ylll~)j!h\"ylb*-\t{)c8-<\u007f#n)~?b>-nv1M7pn#"), objectArray);
            }
        }).filter(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.M(a3, identifier);
        }).flatMap(a2 -> Flux.fromIterable((Iterable)a2.eventProcessorInfo().getSegmentStatusList()).map(a3 -> new L(a2.clientId(), a2.context(), a3.getSegmentId(), a3.getOnePartOf()))).reduce((a2, a3) -> {
            if (a2.e < a3.e) {
                return a2;
            }
            return a3;
        }).switchIfEmpty(Mono.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_NOT_FOUND, VisibleContextCache.M((Object)"H:h\"yl}>b/h?~#\u007flc#ylk#x\"i")))).flatMap(a4 -> {
            LocalEventProcessorsAdminService a6;
            return Mono.create(a5 -> {
                LocalEventProcessorsAdminService a6;
                String string = UUID.randomUUID().toString();
                a6.c.put((Object)string, (Object)new InstructionInformation(a5, string, string2, Collections.singleton(a3.E)));
                L l2 = a4;
                a6.E.splitSegment(l2.c, l2.E, string, a3.C, string);
            });
        }).doOnError(a3 -> {
            LocalEventProcessorsAdminService a4;
            a4.M(string2, a3);
        });
    }

    @Nonnull
    public Iterable<LoadBalancingStrategy> getBalancingStrategies(@Nonnull Authentication a2) {
        A.debug(QueryHandler.M((Object)"\u0015r3Tn[+x;l=}n}!)\"`=}ne!h*$,h\"h j'g))=}<h:l)`+z`"), (Object)AuditLog.username((String)a2.username()));
        return this.G.findAll();
    }

    @Nonnull
    public Flux<EventProcessor> eventProcessorsByComponent(@Nonnull String component, @Nonnull Authentication a3) {
        if (A.isInfoEnabled()) {
            A.debug(VisibleContextCache.M((Object)"\u0017v1Pl_)|9h?yly#- d?ylH:h\"yl}>b/h?~#\u007f?-%cln#`<b\"h\"yl/7pn#"), (Object)AuditLog.username((String)a3.username()), (Object)StringUtils.sanitize((String)component));
        }
        return this.e.filterWhen(a4 -> {
            LocalEventProcessorsAdminService a5;
            return a5.e.filter(a3 -> a3.belongsToComponent(component)).map(EventProcessorIdentifier::new).map(a3 -> a3.M((EventProcessorId)new EventProcessorIdentifier(a4))).reduce(Boolean::logicalOr);
        }).transform(a2 -> a2.groupBy(EventProcessorIdentifier::new).flatMap(a4 -> a4.timeout(Duration.ofMillis(100L)).onErrorResume(a2 -> Flux.empty()).collectList().map(a3 -> new DistributedEventProcessor((EventProcessorId)a4.key(), a3))));
    }

    @Nonnull
    public Mono<Void> setAutoLoadBalanceStrategy(@Nonnull EventProcessorId processor, @Nonnull String strategy, @Nonnull Authentication a2) {
        return Mono.error((Throwable)new UnsupportedOperationException(QueryHandler.M((Object)"H;}!)\"f/mnk/e/g-` nn`=) f:)=|>y!{:l*")));
    }

    @Nonnull
    public Flux<EventProcessor> eventProcessors(@Nonnull Authentication a3) {
        return this.e.transform(a2 -> a2.groupBy(EventProcessorIdentifier::new).flatMap(a4 -> a4.timeout(Duration.ofMillis(100L)).onErrorResume(a2 -> Flux.empty()).collectList().map(a3 -> new DistributedEventProcessor((EventProcessorId)a4.key(), a3))));
    }

    private /* synthetic */ void M(String a2, Throwable a3) {
        LocalEventProcessorsAdminService a4;
        if (ErrorCode.fromException((Throwable)a3).isClientException()) {
            a4.C.info(QueryHandler.M((Object)"5tno/`\"l*"), (Object)a2, (Object)a3);
            return;
        }
        a4.C.warn(VisibleContextCache.M((Object)"v1-*l%a)i"), (Object)a2, (Object)a3);
    }

    private /* synthetic */ boolean M(EventProcessorIdentifier a2, ClientProcessor a3) {
        LocalEventProcessorsAdminService a4;
        return a4.M(a3, (EventProcessorId)a2);
    }

    @Nonnull
    public Mono<Result> merge(@Nonnull EventProcessorId identifier, @Nonnull Authentication a5) {
        String string = identifier.name();
        String string2 = "Merge " + string;
        String string3 = identifier.tokenStoreIdentifier();
        return this.e.doFirst(() -> {
            if (A.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a5.username());
                objectArray[1] = StringUtils.sanitize((String)string);
                objectArray[2] = StringUtils.sanitize((String)string3);
                A.info(QueryHandler.M((Object)"\u0015r3Tn[+x;l=}n}!)#l<n+)/)=l)d+g:)!onL8l }ny<f-l=z!{n+5t\u000er3+`"), objectArray);
            }
        }).filter(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.M(a3, identifier);
        }).flatMap(a2 -> Flux.fromIterable((Iterable)a2.eventProcessorInfo().getSegmentStatusList()).map(a3 -> new L(a2.clientId(), a2.context(), a3.getSegmentId(), a3.getOnePartOf()))).collectList().flatMap(a4 -> {
            LocalEventProcessorsAdminService a5;
            return Mono.create(a8 -> {
                LocalEventProcessorsAdminService a9;
                String string = UUID.randomUUID().toString();
                L l2 = (L)a4.stream().reduce((a2, a3) -> {
                    if (a2.e > a3.e) {
                        return a2;
                    }
                    return a3;
                }).orElseThrow(() -> new IllegalArgumentException("No segments found for processor name [" + string + "]"));
                int a42 = a9.M(l2);
                a4.stream().map(a2 -> {
                    L l2 = a2;
                    return new ClientContext(l2.E, l2.c);
                }).distinct().filter(a3 -> {
                    if (!a2.E.equals(a3.clientId())) {
                        return true;
                    }
                    return false;
                }).forEach(a5 -> {
                    LocalEventProcessorsAdminService a6;
                    a6.E.releaseSegment(a5.context(), a5.clientId(), string, a42, string);
                });
                a9.c.put((Object)string, (Object)new InstructionInformation(a8, string, string2, Collections.singleton(l2.E)));
                L l3 = l2;
                a9.E.mergeSegment(l3.c, l3.E, string, l2.C, string);
            });
        }).doOnError(a3 -> {
            LocalEventProcessorsAdminService a4;
            a4.M(string2, a3);
        });
    }

    private /* synthetic */ boolean M(ClientProcessor a2, EventProcessorId a3) {
        if (a2.eventProcessorInfo().getProcessorName().equals(a3.name()) && a2.eventProcessorInfo().getTokenStoreIdentifier().equals(a3.tokenStoreIdentifier()) && a2.context().equals(a3.context())) {
            return true;
        }
        return false;
    }

    private /* synthetic */ void M(String a2, int a3, String a4, ClientProcessor a5) {
        LocalEventProcessorsAdminService a6;
        a6.E.releaseSegment(a5.context(), a5.clientId(), a2, a3, a4);
    }
}

