/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin.replicationgroup.requestprocessor;

import io.axoniq.axonserver.access.application.AdminApplicationController;
import io.axoniq.axonserver.admin.replicationgroup.api.JoinReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.LeaveReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.NodeOverviewInfo;
import io.axoniq.axonserver.admin.replicationgroup.api.RemoveReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupAdminService;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupMember;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupOverview;
import io.axoniq.axonserver.admin.replicationgroup.api.Role;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.UpdateReplicationGroupPayload;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.UpdateReplicationGroupTask;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.e;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.i;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroups;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.AdminReplicationGroupController;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ReplicationGroupMemberConverter;
import io.axoniq.axonserver.localstorage.transaction.PreparedTransaction;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.taskscheduler.task.AddNodeToExistingReplicationGroupTask;
import io.axoniq.axonserver.taskscheduler.task.PrepareDeleteNodeFromContextTask;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ReplicationGroupAdminRequestProcessor
implements ReplicationGroupAdminService {
    private final ClusterController j;
    private final Logger h;
    private final TaskPublisher l;
    private final RaftConfigServiceFactory G;
    private final AddNodeToExistingReplicationGroupTask B;
    private final PrepareDeleteNodeFromContextTask A;
    private final Predicate<String> E;
    private final AdminReplicationGroupController C;
    private static final Logger c = AuditLog.getLogger();
    private final AdminReplicationGroups e;

    private /* synthetic */ void M(Throwable a2, String a3, Object ... a4) {
        ReplicationGroupAdminRequestProcessor a5;
        if (MessagingPlatformException.isClientException((Throwable)a2)) {
            a5.h.info(a3, (Object)a4, (Object)a2);
            return;
        }
        a5.h.warn(a3, (Object)a4, (Object)a2);
    }

    @NotNull
    public Mono<String> updateReplicationGroup(@NotNull ReplicationGroup updated, boolean preserve, @NotNull Authentication a4) {
        Object object = (AdminReplicationGroup)this.C.findByName(updated.name()).orElseThrow(() -> new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, updated.name() + ": not found"));
        HashMap<String, Role> hashMap = new HashMap<String, Role>();
        object.getMembers().forEach(a3 -> {
            ReplicationGroupAdminRequestProcessor a4;
            hashMap.put(a3.getClusterNode().getName(), a4.M(a3.getRole()));
        });
        object = new ArrayList();
        ArrayList arrayList = new ArrayList();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        if (updated.members().stream().noneMatch(a2 -> a2.role().equals((Object)Role.G))) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, PreparedTransaction.M((Object)"\rAc@,J&]cY*Z+\u000e3\\*C\"\\:\u000e1A/Kc]3K G%G&J"));
        }
        updated.members().forEach(arg_0 -> ReplicationGroupAdminRequestProcessor.M(hashMap, (List)object, arrayList, hashMap2, hashMap3, arg_0));
        hashMap.forEach((a5, a6) -> {
            if (a6.equals((Object)Role.G)) {
                hashMap2.put(a5, preserve);
                return;
            }
            hashMap3.put(a5, preserve);
        });
        UpdateReplicationGroupPayload updateReplicationGroupPayload = preserve = new UpdateReplicationGroupPayload();
        preserve.setReplicationGroup(updated.name());
        updateReplicationGroupPayload.setAddPrimaryNodes((List)object);
        updateReplicationGroupPayload.setDeleteNodes(hashMap3.entrySet().stream().map(a2 -> new UpdateReplicationGroupPayload.DeleteNode((String)a2.getKey(), ((Boolean)a2.getValue()).booleanValue())).collect(Collectors.toList()));
        preserve.setDeletePrimaryNodes(hashMap2.entrySet().stream().map(a2 -> new UpdateReplicationGroupPayload.DeleteNode((String)a2.getKey(), ((Boolean)a2.getValue()).booleanValue())).collect(Collectors.toList()));
        UpdateReplicationGroupPayload updateReplicationGroupPayload2 = preserve;
        updateReplicationGroupPayload2.setAddNodes(arrayList);
        updateReplicationGroupPayload2.setPrincipal(a4.username());
        return Mono.fromFuture(() -> {
            ReplicationGroupAdminRequestProcessor a3;
            return a3.l.publishScheduledTask(AdminUtils.getAdmin(), UpdateReplicationGroupTask.class.getName(), (Object)updateReplicationGroupPayload2, Duration.ZERO);
        });
    }

    @Nonnull
    public Mono<ReplicationGroupOverview> getReplicationGroup(@Nonnull String replicationGroupName, @Nonnull Authentication a2) {
        return Mono.fromCallable(() -> {
            ReplicationGroupAdminRequestProcessor a5;
            if (c.isInfoEnabled()) {
                c.info(PreparedTransaction.M((Object)"\u0018U>sc|&_6K0ZcZ,\u000e/G0Zc\\&^/G O7G,@cI1A6^0\u0000"), (Object)AuditLog.username((String)a2.username()));
            }
            return a5.e.findByName(replicationGroupName).map(a2 -> ReplicationGroupAdminRequestProcessor.M((AdminReplicationGroup)a2)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, AdminApplicationController.M((Object)"g7E>\\1T&\\=[rR Z'Er[=ArS=@<Q")));
        });
    }

    private /* synthetic */ Role M(io.axoniq.axonserver.grpc.cluster.Role a2) {
        return Role.valueOf((String)a2.name());
    }

    private static /* synthetic */ void M(Map a2, List a3, List a4, Map a5, Map a6, ReplicationGroupMember a7) {
        Role role = a7.role();
        Role role2 = (Role)a2.remove(a7.nodeName());
        if (role2 == null) {
            if (role.equals((Object)Role.G)) {
                a3.add(a7.nodeName());
                return;
            }
            a4.add(new UpdateReplicationGroupPayload.AddNode(a7));
            return;
        }
        if (!role2.equals((Object)role)) {
            if (role2.equals((Object)Role.G)) {
                a5.put(a7.nodeName(), true);
                a4.add(new UpdateReplicationGroupPayload.AddNode(a7));
                return;
            }
            a6.put(a7.nodeName(), true);
            if (role.equals((Object)Role.G)) {
                a3.add(a7.nodeName());
                return;
            }
            a4.add(new UpdateReplicationGroupPayload.AddNode(a7));
        }
    }

    public ReplicationGroupAdminRequestProcessor(RaftConfigServiceFactory a2, ClusterController a3, PrepareDeleteNodeFromContextTask a4, AdminReplicationGroups a5, AdminReplicationGroupController a6, AddNodeToExistingReplicationGroupTask a7, TaskPublisher a8) {
        ReplicationGroupAdminRequestProcessor a9;
        ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor = a9;
        ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor2 = a9;
        ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor3 = a9;
        ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor4 = a9;
        replicationGroupAdminRequestProcessor4.h = LoggerFactory.getLogger(ReplicationGroupAdminRequestProcessor.class);
        ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor5 = a9;
        replicationGroupAdminRequestProcessor4.E = new ContextNameValidation();
        replicationGroupAdminRequestProcessor4.G = a2;
        replicationGroupAdminRequestProcessor3.j = a3;
        replicationGroupAdminRequestProcessor3.A = a4;
        replicationGroupAdminRequestProcessor2.e = a5;
        replicationGroupAdminRequestProcessor2.C = a6;
        replicationGroupAdminRequestProcessor.B = a7;
        replicationGroupAdminRequestProcessor.l = a8;
    }

    @Nonnull
    public Flux<NodeOverviewInfo> getNodes(@Nonnull Authentication a3) {
        return Flux.fromStream((Stream)this.j.nodes()).doFirst(() -> {
            if (c.isInfoEnabled()) {
                c.info(PreparedTransaction.M((Object)"u8S\u001e\u000e\u0011K2[&]7\u000e7AcB*]7\u000e\"B/\u000e-A'K0\u000e*@%A1C\"Z*A-\u0000"), (Object)AuditLog.username((String)a3.username()));
            }
        }).map(a2 -> {
            ReplicationGroupAdminRequestProcessor a3;
            return new i(a3, a2);
        });
    }

    @Nonnull
    public Flux<ReplicationGroupOverview> getReplicationGroups(@Nonnull Authentication a2) {
        return Flux.defer(() -> {
            ReplicationGroupAdminRequestProcessor a3;
            return Flux.fromStream((Stream)a3.e.findAll()).map(a2 -> new e(a2)).onErrorMap(a2 -> MessagingPlatformException.create((Throwable)a2));
        }).doFirst(() -> c.info(AdminApplicationController.M((Object)"\tN/hrg7D'P!A7QrA=\u0015>\\!ArT>YrG7E>\\1T&\\=[rR Z'E!\u001b"), (Object)AuditLog.username((String)a2.username())));
    }

    @Nonnull
    public Mono<Void> removeNodeFromReplicationGroup(@Nonnull LeaveReplicationGroup request, @Nonnull Authentication a4) {
        return Mono.defer(() -> {
            ReplicationGroupAdminRequestProcessor a4;
            if (c.isInfoEnabled()) {
                Object[] objectArray = new Object[4];
                objectArray[0] = AuditLog.username((String)a4.username());
                objectArray[1] = request.node();
                objectArray[2] = request.replicationGroup();
                objectArray[3] = request.preserveEventStore();
                c.info(PreparedTransaction.M((Object)"\u0018U>sc|&_6K0ZcZ,\u000e'K/K7Kc@,J&\u000e8ScH1A.\u000e1K3B*M\"Z*A-\u000e$\\,[3\u000e8Sc^1K0K1X&\u000e&X&@7]c]7A1K0\u000ecU>\u0000"), objectArray);
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = request.node();
            objectArray[1] = request.replicationGroup();
            objectArray[2] = request.preserveEventStore() ? PreparedTransaction.M((Object)"\u0003ce&K3G-IcK5K-Zc]7A1K") : "";
            a4.h.info(AdminApplicationController.M((Object)"\u0016P>P&Pr[=Q7\u0015 P#@7F&\u0015 P1P;C7QrS=Gr[=Q7\u000frN/\u0015\u007f\u00153[6\u0015 P\"Y;V3A;Z<\u00155G=@\"\u000frN/\u0015)H"), objectArray);
            return Mono.fromCompletionStage((CompletionStage)a4.A.prepareDeleteNodeFromContext(request.replicationGroup(), request.node(), request.preserveEventStore()));
        }).then().doOnError(a3 -> {
            ReplicationGroupAdminRequestProcessor a4;
            Object[] objectArray = new Object[2];
            objectArray[0] = request.replicationGroup();
            objectArray[1] = request.node();
            a4.M(a3, PreparedTransaction.M((Object)"U>\u0014cK1\\,\\cY+G/Kc\\&C,X*@$\u000e8S"), objectArray);
        }).onErrorMap(a2 -> MessagingPlatformException.create((Throwable)a2));
    }

    private static /* synthetic */ void M(Map a2, ClusterNode a3) {
        a2.put(a3.getName(), a3);
    }

    @Nonnull
    public Mono<Void> deleteReplicationGroup(@Nonnull RemoveReplicationGroup request, @Nonnull Authentication a4) {
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((String)a4.username());
        objectArray[1] = request.name();
        objectArray[2] = request.preserveEventStore();
        c.info(AdminApplicationController.M((Object)"n)H\u000f\u0015\u0000P#@7F&\u0015&ZrQ7Y7A7\u0015 P\"Y;V3A;Z<\u00155G=@\"\u0015)HrE P!P C7\u00157C7[&\u0015!A=G7FrN/\u001b"), objectArray);
        return Mono.fromRunnable(() -> {
            ReplicationGroupAdminRequestProcessor a3;
            a3.G.getRaftConfigService().deleteReplicationGroup(request.name(), request.preserveEventStore());
        }).doFirst(() -> {
            if (request.name().startsWith(PreparedTransaction.M((Object)"q"))) {
                Object[] objectArray = new Object[1];
                objectArray[0] = request.name();
                throw new MessagingPlatformException(ErrorCode.CANNOT_DELETE_INTERNAL_CONTEXT, String.format(AdminApplicationController.M((Object)"v3[<Z&\u00156P>P&Pr\\<A7G<T>\u00151Z<A7M&\u0015wF"), objectArray));
            }
        }).doFirst(() -> {
            ReplicationGroupAdminRequestProcessor a3;
            a3.h.info(AdminApplicationController.M((Object)"q7Y7A7\u0015 P#@7F&\u0015 P1P;C7QrS=GrG7E>\\1T&\\=[rR Z'Eh\u0015)H"), (Object)request.name());
        }).doOnError(a3 -> {
            ReplicationGroupAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = request.name();
            a4.M(a3, PreparedTransaction.M((Object)"8Sy\u000e&\\1A1\u000e4F*B&\u000e'K/K7G-Ic\\&^/G O7G,@cI1A6^"), objectArray);
        }).onErrorMap(a2 -> MessagingPlatformException.create((Throwable)a2));
    }

    @Nonnull
    public Mono<Void> addNodeToReplicationGroup(@Nonnull JoinReplicationGroup request, @Nonnull Authentication a4) {
        return Mono.defer(() -> {
            ReplicationGroupAdminRequestProcessor a4;
            if (c.isInfoEnabled()) {
                Object[] objectArray = new Object[4];
                objectArray[0] = AuditLog.username((String)a4.username());
                objectArray[1] = request.node();
                objectArray[2] = request.replicationGroup();
                objectArray[3] = request.role();
                c.info(AdminApplicationController.M((Object)"n)H\u000f\u0015\u0000P#@7F&\u0015&ZrT6Qr[=Q7\u0015)HrA=\u0015 P\"Y;V3A;Z<\u00155G=@\"\u0015)HrB;A:\u0015 Z>PrN/\u001b"), objectArray);
            }
            JoinReplicationGroup joinReplicationGroup = request;
            a4 = joinReplicationGroup.node();
            String string = joinReplicationGroup.replicationGroup();
            Object[] objectArray = new Object[3];
            objectArray[0] = a4;
            objectArray[1] = string;
            objectArray[2] = request.role();
            a4.h.info(PreparedTransaction.M((Object)"o'Jc@,J&\u000e1K2[&]7\u000e1K K*X&JcH,\\c@,J&\u0014cU>\u000en\u000e\"@'\u000e1K3B*M\"Z*A-\u000e$\\,[3\u0014cU>\u000en\u000e4G7Fc\\,B&\u0014cU>\u0000"), objectArray);
            if (!a4.C.findByName(string).isPresent()) {
                String string2 = "[" + ErrorCode.REPLICATION_GROUP_NOT_FOUND + "] Replication group " + string + " not found";
                return Mono.error((Throwable)new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, string2));
            }
            ClusterNode clusterNode = a4.j.getNode((String)a4);
            if (clusterNode == null) {
                String string3 = "[" + ErrorCode.NO_SUCH_NODE + "] Node " + (String)a4 + " not found";
                return Mono.error((Throwable)new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, string3));
            }
            if (clusterNode.getReplicatorGroupNames().contains(string)) {
                String string4 = "Replication group " + string + " already contains node " + (String)a4;
                return Mono.error((Throwable)new IllegalStateException(string4));
            }
            io.axoniq.axonserver.grpc.cluster.Role role = request.role() == null ? io.axoniq.axonserver.grpc.cluster.Role.PRIMARY : io.axoniq.axonserver.grpc.cluster.Role.valueOf((String)Objects.requireNonNull(request.role()).name());
            return Mono.fromCompletionStage((CompletionStage)a4.B.addNode((String)a4, string, role));
        }).then().doOnError(a3 -> {
            ReplicationGroupAdminRequestProcessor a4;
            Object[] objectArray = new Object[2];
            objectArray[0] = request.replicationGroup();
            objectArray[1] = request.node();
            a4.M(a3, AdminApplicationController.M((Object)"N/\u000frP G=GrB:\\>PrT6Q;[5\u0015)H"), objectArray);
        }).onErrorMap(a2 -> MessagingPlatformException.create((Throwable)a2));
    }

    private static /* synthetic */ boolean M(Map a2, String a3) {
        if (!a2.containsKey(a3)) {
            return true;
        }
        return false;
    }

    @Nonnull
    public Mono<Void> createReplicationGroup(@Nonnull ReplicationGroup request, @Nonnull Authentication a2) {
        return Mono.fromRunnable(() -> {
            ReplicationGroupAdminRequestProcessor a4;
            if (c.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = request.name();
                objectArray[2] = request.members();
                c.info(PreparedTransaction.M((Object)"\u0018U>sc|&_6K0ZcZ,\u000e \\&O7Kc\\&^/G O7G,@cI1A6^cU>\u000e4G7Fc@,J&]cU>\u0000"), objectArray);
            }
            ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor = a4;
            replicationGroupAdminRequestProcessor.h.info(AdminApplicationController.M((Object)"v P3A7\u0015 P#@7F&\u0015 P1P;C7QrS=GrG7E>\\1T&\\=[rR Z'Eh\u0015)H"), (Object)request.name());
            if (!replicationGroupAdminRequestProcessor.E.test(request.name())) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, PreparedTransaction.M((Object)"\n@5O/G'\u000e1K3B*M\"Z*A-\u000e$\\,[3\u000e-O.K"));
            }
            if (!request.members().isEmpty()) {
                a2 = new HashMap();
                a4.j.activeNodes().forEach(arg_0 -> ReplicationGroupAdminRequestProcessor.M((Map)a2, arg_0));
                a2 = request.members().stream().map(ReplicationGroupMember::nodeName).filter(arg_0 -> ReplicationGroupAdminRequestProcessor.M((Map)a2, arg_0)).collect(Collectors.toSet());
                if (!a2.isEmpty()) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, "Node is not active: " + (Set)a2);
                }
            } else {
                throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, AdminApplicationController.M((Object)"t6QrT&\u0015>P3F&\u0015=[7\u0015<Z6PrS=GrA:PrT\"E>\\1T&\\=[rR Z'E"));
            }
            a4.G.getRaftConfigService().createReplicationGroup(request.name(), (Collection)request.members().stream().map(ReplicationGroupMemberConverter::asReplicationGroupMember).collect(Collectors.toList()));
        }).doOnError(a3 -> {
            ReplicationGroupAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = request.name();
            a4.M(a3, AdminApplicationController.M((Object)")Hh\u0015\u0017G Z \u0015%];Y7\u00151G7T&\\<RrG7E>\\1T&\\=[rR Z'E"), objectArray);
        });
    }
}

