/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin.user.requestprocessor;

import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.admin.user.api.UserAdminService;
import io.axoniq.axonserver.admin.user.api.UserRole;
import io.axoniq.axonserver.admin.user.requestprocessor.UserController;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.admin.AdminUser;
import io.axoniq.axonserver.configuration.common.Role;
import io.axoniq.axonserver.enterprise.cluster.ClusterEvent;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.User;
import io.axoniq.axonserver.grpc.internal.UserContextRole;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.query.subscription.metric.GlobalSubscriptionMetricRegistry;
import io.axoniq.axonserver.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.springframework.security.crypto.password.PasswordEncoder;

public class RaftUserAdminService
implements UserAdminService {
    private final RoleController B;
    private final UserController A;
    private static final Logger E = AuditLog.getLogger();
    private static final String C = "/\\%;";
    private final RaftConfigServiceFactory c;
    private final PasswordEncoder e;

    public void deleteUser(@Nonnull String name, @Nonnull Authentication a2) {
        E.info(GlobalSubscriptionMetricRegistry.M((Object)"Q#w\u0005*\no)\u007f=y,*,exn=f=~=*-y=xx(#wz$"), (Object)AuditLog.username((String)a2.username()), (Object)name);
        this.c.getRaftConfigService().deleteUser(User.newBuilder().setName(name).build());
    }

    private /* synthetic */ void M(Set<? extends UserRole> a2) {
        RaftUserAdminService a3;
        Set set = a3.B.listRoles().stream().map(Role::getRole).collect(Collectors.toSet());
        for (String string : a2.stream().map(UserRole::role).distinct().collect(Collectors.toList())) {
            if (set.contains(string)) continue;
            throw new MessagingPlatformException(ErrorCode.UNKNOWN_ROLE, string + ": Role unknown");
        }
    }

    @Nonnull
    public List<AdminUser> users(@Nonnull Authentication a2) {
        E.info(ClusterEvent.M((Object)"1.\u0017\bJ\u0007\u000f$\u001f0\u0019!J!\u0005u\u0006<\u0019!J \u00190\u0018&J4\u00041J!\u00020\u0003'J'\u00059\u000f&D"), (Object)AuditLog.username((String)a2.username()));
        return this.A.getUsers();
    }

    public void createOrUpdateUser(@Nonnull String userName, @Nonnull String password, @Nonnull Set<? extends UserRole> roles, @Nonnull Authentication a3) {
        if (E.isInfoEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((String)a3.username());
            objectArray[1] = StringUtils.sanitize((String)userName);
            objectArray[2] = roles.stream().map(a2 -> a2.role() + "@" + a2.context()).map(StringUtils::sanitize).collect(Collectors.toSet());
            E.info(GlobalSubscriptionMetricRegistry.M((Object)"Q#w\u0005*\no)\u007f=y,*,exi*o9~=*-y=xx(#wz*/c,bxx7f=yxq%$"), objectArray);
        }
        this.M(userName);
        this.M(roles);
        if (!StringUtils.isEmpty((String)password)) {
            password = this.e.encode((CharSequence)password);
        }
        this.c.getRaftConfigService().updateUser(User.newBuilder().setName(userName).setPassword(StringUtils.getOrDefault((String)password, (String)"")).addAllRoles(this.M(roles)).build());
    }

    private /* synthetic */ void M(String a2) {
        int n;
        char[] cArray = a2.toCharArray();
        int n2 = cArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            char c2 = cArray[n];
            if (C.indexOf(c2) >= 0) {
                Object[] objectArray = new Object[2];
                objectArray[0] = a2;
                objectArray[1] = Character.valueOf(c2);
                throw new MessagingPlatformException(ErrorCode.INVALID_NAME, String.format(ClusterEvent.M((Object)"p\u0019oJ<\u0004#\u000b9\u00031J6\u00024\u00184\t!\u000f'J}O&Cu\u0003;J;\u000b8\u000f"), objectArray));
            }
            n3 = ++n;
        }
    }

    private /* synthetic */ Iterable<? extends UserContextRole> M(Set<? extends UserRole> a2) {
        ArrayList arrayList = new ArrayList();
        a2.forEach(a3 -> arrayList.add(UserContextRole.newBuilder().setContext(a3.context()).setRole(a3.role()).build()));
        return arrayList;
    }

    public RaftUserAdminService(UserController a2, PasswordEncoder a3, RaftConfigServiceFactory a4, RoleController a5) {
        RaftUserAdminService a6;
        RaftUserAdminService raftUserAdminService = a6;
        RaftUserAdminService raftUserAdminService2 = a6;
        raftUserAdminService2.A = a2;
        raftUserAdminService2.e = a3;
        raftUserAdminService.c = a4;
        raftUserAdminService.B = a5;
    }
}

