/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.config.AxonServerStandardConfiguration;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.HealthStatus;
import io.axoniq.axonserver.transport.rest.EventStoreTransformationRestController;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.DiskSpaceMetrics;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.system.DiskSpaceHealthIndicatorProperties;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.system.DiskSpaceHealthIndicator;
import org.springframework.context.annotation.Configuration;

@Configuration(value="diskSpace")
public class FileSystemMonitor
extends DiskSpaceHealthIndicator {
    public static final String A = "ROOT";
    private final Map<String, Path> E;
    private final MeterRegistry C;
    private final DiskSpaceHealthIndicatorProperties c;
    private final Logger e = LoggerFactory.getLogger(FileSystemMonitor.class);

    public Map<String, Path> getRegisteredPaths() {
        FileSystemMonitor a2;
        return a2.E;
    }

    public void registerPath(String a2, Path a3) {
        FileSystemMonitor a4;
        FileSystemMonitor fileSystemMonitor = a4;
        fileSystemMonitor.e.info(EventStoreTransformationRestController.M((Object)"-\u0006\u000e\u0000\u0014\u0006\u0012\u0000\u000e\u000e@\u000f\t\u0005\u0005I\u0013\u001d\u000f\u001b\u0005IG\u0012\u001dN@\b\u0014I\u0010\b\u0014\u0001@N\u001b\u0014G"), (Object)a2, (Object)a3);
        fileSystemMonitor.E.put(a2, a3);
        a4.M(a3);
    }

    public FileSystemMonitor(DiskSpaceHealthIndicatorProperties a2, MeterRegistry a3) {
        super(null, null);
        FileSystemMonitor a4;
        FileSystemMonitor fileSystemMonitor = a4;
        a4.E = new ConcurrentHashMap();
        a4.c = a2;
        a4.C = a3;
        a4.E.put(A, Paths.get("", new String[0]));
    }

    private /* synthetic */ Path M(Path a2) throws IOException {
        Path path;
        Path path2;
        Path path3 = a2;
        a2 = Files.getFileStore(path3);
        Path path4 = path2 = (path = path3.toAbsolutePath());
        while ((path = path4.getParent()) != null && a2.equals(Files.getFileStore(path))) {
            path4 = path;
        }
        return path2.normalize();
    }

    public List<Details> paths() {
        FileSystemMonitor a3;
        return a3.E.entrySet().stream().map(a2 -> {
            try {
                FileSystemMonitor a3;
                FileStore fileStore = Files.getFileStore((Path)a2.getValue());
                return new Details((String)a2.getKey(), a3.M((Path)a2.getValue()).toString(), fileStore.getUsableSpace(), fileStore.getTotalSpace());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }).collect(Collectors.toList());
    }

    protected void doHealthCheck(Health.Builder a2) {
        FileSystemMonitor a5;
        a2.up();
        a5.E.forEach((a3, a4) -> {
            FileSystemMonitor a5;
            try {
                if (!A.equals(a3)) {
                    FileStore fileStore;
                    FileStore fileStore2 = fileStore = Files.getFileStore(a4);
                    long l2 = fileStore2.getUsableSpace();
                    long l3 = a5.c.getThreshold().toBytes();
                    if (fileStore2.getUsableSpace() < l3) {
                        Object[] objectArray = new Object[3];
                        objectArray[0] = a4.toString();
                        objectArray[1] = l2;
                        objectArray[2] = l3;
                        a5.e.warn(String.format(EventStoreTransformationRestController.M((Object)"/\u0012\f\u0005I\u0004\u0000\u0013\u0002@\u001a\u0010\b\u0003\f@\b\u0014I\u0010\b\u0014\u0001@NE\u001aGI\t\u001a@\u000b\u0005\u0005\u000f\u001e@\u001d\b\u001b\u0005\u001a\b\u0006\f\rNI!\u001f\u0001\u0000\f\b\u0002\u0005\u0005S@L\u0004I\u0002\u0010\u0014\f\u0013IH\u001d\b\u001b\u0005\u001a\b\u0006\f\rZIE\u001aI"), objectArray));
                        a2.status(HealthStatus.e);
                    }
                    String string = a3;
                    String string2 = a3;
                    a2.withDetail(string2, (Object)new Details(string2, a5.M(a4).toString(), fileStore.getUsableSpace(), fileStore.getTotalSpace()));
                    a2.withDetail(AxonServerStandardConfiguration.M((Object)"0\u00106\u001d7\u0010+\u0014 "), (Object)l3);
                    return;
                }
            }
            catch (Exception exception) {
                a5.e.error(EventStoreTransformationRestController.M((Object)"/\u0001\u0000\f\f\u0004I\u0014\u0006@\u001b\u0005\u001d\u0012\u0000\u0005\u001f\u0005I\u0006\u0000\f\f@\u001a\u0014\u0006\u0012\f@\u000f\u000f\u001b@\u0012\u001d"), a4, (Object)exception);
                a2.down();
                a2.withDetail(AxonServerStandardConfiguration.M((Object)"\b%\f,"), (Object)a4.toString());
            }
        });
    }

    private /* synthetic */ void M(Path a22) {
        FileSystemMonitor a3;
        try {
            a22 = a3.M(a22);
            File file = new File(a22.toString());
            new DiskSpaceMetrics(file).bindTo(a3.C);
            return;
        }
        catch (Exception a22) {
            a3.e.error(AxonServerStandardConfiguration.M((Object)">%\u0011(\u001d X0\u0017d\u001a-\u0016 X \u00117\u0013d\u0015!\f6\u0011'\u000be"), (Throwable)a22);
            return;
        }
    }

    public void unregisterPath(String a2) {
        FileSystemMonitor a3;
        FileSystemMonitor fileSystemMonitor = a3;
        fileSystemMonitor.e.info(EventStoreTransformationRestController.M((Object)":\u0014\u0006\u0010\u0019\u0005\r@\u0004\u000f\u0007\t\u001d\u000f\u001b\t\u0007\u0007I\u0006\u0000\f\f@\u001a\u0014\u0006\u0012\f@N\u001b\u0014G"), (Object)a2);
        fileSystemMonitor.E.remove(a2);
    }
}

