/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.EventTransformationConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.file.multitier.LowerTierEventStoreFactory;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.replication.ServerProperties;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.axoniq.axonserver.util.StringUtils;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

@Configuration
@ConfigurationProperties(prefix="axoniq.axonserver")
public class MessagingPlatformConfiguration
implements ServerProperties {
    private int eventStoreProcessorsThreadCount;
    private int metricsSynchronizationRate;
    private final SystemInfoProvider systemInfoProvider;
    private String hostname;
    private int internalPort;
    private String internalDomain;
    public static final int DEFAULT_INTERNAL_GRPC_PORT = 8224;
    private boolean forceConnectionToPrimaryOrMessagingNode;
    private int executorThreadCount;
    private String name;
    private Duration metricsInterval;
    private int port;
    private Duration minKeepAliveTime;
    private String controldbBackupLocation;
    private String domain;
    private int clusterExecutorThreadCount;
    private boolean pluginsEnabled;
    private Duration keepAliveTimeout;
    private Duration keepAliveTime;
    private int maxMessageSize;
    private static final Logger auditLog;
    private String pluginCleanPolicy;
    private int httpPort;
    private int grpcBufferedMessages;
    private String pidFileLocation;
    @Value(value="${spring.datasource.url:#{null}}")
    private String datasourceUrl;
    private String pluginCacheDirectory;
    private static final int RESERVED = 10000;
    @NestedConfigurationProperty
    private AccessControlConfiguration accesscontrol;
    private boolean setWebSocketAllowedOrigins;
    @NestedConfigurationProperty
    private EventTransformationConfiguration eventTransformation;
    private final Map<String, Boolean> preview;
    private String pluginPackageDirectory;
    @NestedConfigurationProperty
    private SslConfiguration ssl;
    private String webSocketAllowedOrigins;
    private String internalHostname;
    private static final Logger logger;
    private static final int DEFAULT_MAX_TRANSACTION_SIZE = 4184304;
    private int eventStoreBackgroundThreadCount;

    public String getName() {
        MessagingPlatformConfiguration a2;
        if (a2.name == null) {
            a2.name = a2.getHostname();
        }
        return a2.name;
    }

    public SslConfiguration getSsl() {
        MessagingPlatformConfiguration a2;
        return a2.ssl;
    }

    public int getHttpPort() {
        MessagingPlatformConfiguration a2;
        if (a2.httpPort == 0) {
            a2.httpPort = a2.systemInfoProvider.getPort();
        }
        return a2.httpPort;
    }

    public void setGrpcBufferedMessages(int a2) {
        a.grpcBufferedMessages = a2;
    }

    public void setSsl(SslConfiguration a2) {
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.ssl == null) break block1;
                    auditLog.info(LowerTierEventStoreFactory.M((Object)"^6AEn\nc\u0003d\u0002x\u0017l\u0011d\ncE_ @*[ IK"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.ssl == null || a2.isEnabled() != a3.ssl.isEnabled()) {
                    auditLog.info(TransientException.M((Object)".91J\u0014\u0019]\u0004\u0012\u001d]\u0011\u0000D"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.ssl = a2;
    }

    public void setInternalHostname(String a2) {
        a.internalHostname = a2;
    }

    public void setHostname(String a2) {
        a.hostname = a2;
    }

    public void setMetricsInterval(Duration a2) {
        a.metricsInterval = a2;
    }

    public MessagingPlatformConfiguration(SystemInfoProvider a2) {
        MessagingPlatformConfiguration a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration3 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration4 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration5 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration6 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration7 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration8 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration9 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration10 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration11 = a3;
        a3.port = 8124;
        messagingPlatformConfiguration11.internalPort = 8224;
        messagingPlatformConfiguration11.keepAliveTimeout = Duration.ofMillis(5000L);
        messagingPlatformConfiguration10.keepAliveTime = Duration.ofMillis(2500L);
        messagingPlatformConfiguration10.minKeepAliveTime = Duration.ofMillis(1000L);
        messagingPlatformConfiguration9.setWebSocketAllowedOrigins = false;
        messagingPlatformConfiguration9.webSocketAllowedOrigins = "*";
        MessagingPlatformConfiguration messagingPlatformConfiguration12 = a3;
        messagingPlatformConfiguration9.ssl = new SslConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration13 = a3;
        messagingPlatformConfiguration8.accesscontrol = new AccessControlConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration14 = a3;
        messagingPlatformConfiguration8.eventTransformation = new EventTransformationConfiguration();
        messagingPlatformConfiguration8.forceConnectionToPrimaryOrMessagingNode = true;
        messagingPlatformConfiguration7.metricsInterval = Duration.ofMinutes(15L);
        messagingPlatformConfiguration7.controldbBackupLocation = ".";
        messagingPlatformConfiguration6.maxMessageSize = 0x400000;
        messagingPlatformConfiguration6.pidFileLocation = ".";
        messagingPlatformConfiguration5.grpcBufferedMessages = 500;
        messagingPlatformConfiguration5.executorThreadCount = 4;
        messagingPlatformConfiguration4.clusterExecutorThreadCount = 4;
        messagingPlatformConfiguration4.eventStoreBackgroundThreadCount = 8;
        messagingPlatformConfiguration3.eventStoreProcessorsThreadCount = 8;
        messagingPlatformConfiguration3.pluginsEnabled = true;
        messagingPlatformConfiguration2.pluginCacheDirectory = "plugins/cache";
        messagingPlatformConfiguration2.pluginPackageDirectory = "plugins/bundles";
        messagingPlatformConfiguration.pluginCleanPolicy = "onFirstInit";
        MessagingPlatformConfiguration messagingPlatformConfiguration15 = a3;
        messagingPlatformConfiguration.preview = new HashMap();
        messagingPlatformConfiguration.systemInfoProvider = a2;
    }

    public void setEventTransformation(EventTransformationConfiguration a2) {
        a.eventTransformation = a2;
    }

    private /* synthetic */ void M(String a2, String a3, boolean a4, BiConsumer<String, String> a5) {
        String string = a4 = a4 ? LowerTierEventStoreFactory.M((Object)"\fc\u0011h\u0017c\u0004aE") : "";
        if (StringUtils.isEmpty((String)a2)) {
            logger.error(TransientException.M((Object)")\u0012\u001f\u0011\u000e]\u0004\u0012\u001e]\u000e\u0018\u001e\u0018\u0018\u0010\u0003\u0013\u000f]\u000b]\u001c\u001c\u0006\u0014\u000e]\u0011\u0000\u0002\u0012\u0019\t\u0004\u001c\u0007\u0018D"), (Object)a4);
            throw new MessagingPlatformException(ErrorCode.VALIDATION_FAILED, "No " + a4 + "hostname set and system could not provide one.");
        }
        if (Character.isDigit(a2.charAt(0))) {
            logger.warn(LowerTierEventStoreFactory.M((Object)"Y\rhEv\u0018e\n~\u0011c\u0004`\u0000-\rl\u0016-\u0007h\u0000cE~\u0000yEl\u0016-\u0004cED5-\u0004i\u0001\u007f\u0000~\u0016#EY\rd\u0016-\bl\u001c-\u0015\u007f\ni\u0010n\u0000-\u0010c\u0012l\u000by\u0000iE\u007f\u0000~\u0010a\u0011~K"), (Object)a4);
            return;
        }
        int n = a2.indexOf(46);
        if (n != -1) {
            String string2 = a2;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (StringUtils.isEmpty((String)a3)) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a4;
                objectArray[1] = string3;
                objectArray[2] = string4;
                logger.info(TransientException.M((Object)")\u0012\u0004\u001b\u0003\u001a\u001f\u000f\u0003\u0013\r]\u000e\u0012\u0007\u001c\u0003\u0013J\u001b\u0018\u0012\u0007]\u0011\u0000\u0002\u0012\u0019\t\u0004\u001c\u0007\u0018J\r\u0018\u0012\u001a\u0018\u0018\t\u0013GJ\u0015\u0005\u000e\u001e\u0013\u000b\u0010\u000f@\u0011\u0000F]\u000e\u0012\u0007\u001c\u0003\u0013W\u0006\u0017"), objectArray);
                a5.accept(string3, string4);
                return;
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = a4;
            objectArray[1] = a2;
            objectArray[2] = string3;
            objectArray[3] = a3;
            logger.warn(LowerTierEventStoreFactory.M((Object)",j\u000bb\u0017d\u000bjEi\n`\u0004d\u000b-\u0015l\u0017yEb\u0003-\u0011e\u0000-\u001ep\rb\u0016y\u000bl\bhE*\u001epB7Ee\n~\u0011c\u0004`\u00000\u001epI-\u0001b\bl\fcXv\u0018"), objectArray);
            a5.accept(string3, a3);
        }
    }

    public String getInternalDomain() {
        MessagingPlatformConfiguration a2;
        if (a2.internalDomain == null) {
            a2.internalDomain = a2.getDomain();
        }
        return a2.internalDomain;
    }

    public String getPluginCleanPolicy() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCleanPolicy;
    }

    public String getHostname() {
        MessagingPlatformConfiguration a2;
        if (StringUtils.isEmpty((String)a2.hostname)) {
            try {
                MessagingPlatformConfiguration messagingPlatformConfiguration = a2;
                messagingPlatformConfiguration.hostname = messagingPlatformConfiguration.systemInfoProvider.getHostName();
                if (!StringUtils.isEmpty((String)messagingPlatformConfiguration.domain)) {
                    MessagingPlatformConfiguration messagingPlatformConfiguration2 = a2;
                    if (messagingPlatformConfiguration2.hostname.endsWith("." + messagingPlatformConfiguration2.domain)) {
                        a2.hostname = a2.hostname.substring(0, a2.hostname.length() - a2.domain.length() - 1);
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                logger.warn(TransientException.M((Object)">\u0005\b\u0006\u0019J\u0013\u0005\tJ\u0019\u000f\t\u000f\u000f\u0007\u0014\u0004\u0018J\u0015\u0005\u000e\u001e\u0013\u000b\u0010\u000f]\f\u000f\u0005\u0010J\u0014\u0004\u0018\u001e]\u000b\u0019\u000e\u000f\u000f\u000e\u0019GJ\u0006\u0017"), (Object)unknownHostException.getMessage());
            }
        }
        return a2.hostname;
    }

    public long getKeepAliveTimeout() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTimeout.toMillis();
    }

    public EventTransformationConfiguration getEventTransformation() {
        MessagingPlatformConfiguration a2;
        return a2.eventTransformation;
    }

    public void setKeepAliveTimeout(Duration a2) {
        a.keepAliveTimeout = a2;
    }

    public int getGrpcBufferedMessages() {
        MessagingPlatformConfiguration a2;
        return a2.grpcBufferedMessages;
    }

    public void setForceConnectionToPrimaryOrMessagingNode(boolean a2) {
        a.forceConnectionToPrimaryOrMessagingNode = a2;
    }

    public void setExecutorThreadCount(int a2) {
        a.executorThreadCount = a2;
    }

    public Map<String, Boolean> getPreview() {
        MessagingPlatformConfiguration a2;
        return a2.preview;
    }

    public void setKeepAliveTime(Duration a2) {
        a.keepAliveTime = a2;
    }

    public int getPort() {
        MessagingPlatformConfiguration a2;
        return a2.port;
    }

    public Duration getMetricsInterval() {
        MessagingPlatformConfiguration a2;
        return a2.metricsInterval;
    }

    public int getEventStoreBackgroundThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreBackgroundThreadCount;
    }

    public String getControldbBackupLocation() {
        MessagingPlatformConfiguration a2;
        return a2.controldbBackupLocation;
    }

    static {
        logger = LoggerFactory.getLogger(MessagingPlatformConfiguration.class);
        auditLog = AuditLog.getLogger();
    }

    public void setMinKeepAliveTime(Duration a2) {
        a.minKeepAliveTime = a2;
    }

    public void setName(String a2) {
        a.name = a2;
    }

    public void setEventStoreBackgroundThreadCount(int a2) {
        a.eventStoreBackgroundThreadCount = a2;
    }

    public boolean isForceConnectionToPrimaryOrMessagingNode() {
        MessagingPlatformConfiguration a2;
        return a2.forceConnectionToPrimaryOrMessagingNode;
    }

    public int getMaxMessageSize() {
        MessagingPlatformConfiguration a2;
        return a2.maxMessageSize;
    }

    public void setAccesscontrol(AccessControlConfiguration a2) {
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.accesscontrol == null) break block1;
                    auditLog.info(LowerTierEventStoreFactory.M((Object)"$n\u0006h\u0016~En\nc\u0011\u007f\naEn\nc\u0003d\u0002x\u0017l\u0011d\ncE_ @*[ IK"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.accesscontrol == null || a2.isEnabled() != a3.accesscontrol.isEnabled()) {
                    auditLog.info(TransientException.M((Object)"+\u001e\t\u0018\u0019\u000eJ\u001e\u0005\u0013\u001e\u000f\u0005\u0011J\u0014\u0019]\u0004\u0012\u001d]\u0011\u0000D"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.accesscontrol = a2;
    }

    public String getDomain() {
        MessagingPlatformConfiguration a2;
        if (a2.domain == null) {
            block4: {
                String string = a2.systemInfoProvider.getHostName();
                int n = string.indexOf(46);
                if (n == -1) break block4;
                a2.domain = string.substring(n + 1);
            }
            try {
                a2.domain = "";
            }
            catch (UnknownHostException unknownHostException) {
                logger.warn(LowerTierEventStoreFactory.M((Object)"N\nx\tiEc\nyEi\u0000y\u0000\u007f\bd\u000bhEe\n~\u0011c\u0004`\u0000-\u0003\u007f\n`Ed\u000bh\u0011-\u0004i\u0001\u007f\u0000~\u00167Ev\u0018"), (Object)unknownHostException.getMessage());
            }
        }
        return a2.domain;
    }

    public String getPluginPackageDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginPackageDirectory;
    }

    public void setPluginCleanPolicy(String a2) {
        a.pluginCleanPolicy = a2;
    }

    public void setMetricsSynchronizationRate(int a2) {
        a.metricsSynchronizationRate = a2;
    }

    public String getInternalHostname() {
        MessagingPlatformConfiguration a2;
        if (StringUtils.isEmpty((String)a2.internalHostname)) {
            a2.internalHostname = a2.getHostname();
        }
        return a2.internalHostname;
    }

    public AccessControlConfiguration getAccesscontrol() {
        MessagingPlatformConfiguration a2;
        return a2.accesscontrol;
    }

    public String getPidFileLocation() {
        MessagingPlatformConfiguration a2;
        return a2.pidFileLocation;
    }

    public boolean isPluginsEnabled() {
        MessagingPlatformConfiguration a2;
        return a2.pluginsEnabled;
    }

    public void setWebSocketAllowedOrigins(String a2) {
        a.webSocketAllowedOrigins = a2;
    }

    public int getExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.executorThreadCount;
    }

    public void setPort(int a2) {
        a.port = a2;
    }

    public void setEventStoreProcessorsThreadCount(int a2) {
        a.eventStoreProcessorsThreadCount = a2;
    }

    public void setClusterExecutorThreadCount(int a2) {
        a.clusterExecutorThreadCount = a2;
    }

    public long getKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTime.toMillis();
    }

    public void setMaxMessageSize(DataSize a2) {
        Assert.isTrue((a2.toBytes() >= 0L ? 1 : 0) != 0, (String)TransientException.M((Object)"'\u001c\u0012]\u0007\u0018\u0019\u000e\u000b\u001a\u000f]\u0019\u0014\u0010\u0018J\u0010\u001f\u000e\u001e]\b\u0018J\u001a\u0018\u0018\u000b\t\u000f\u000fJ\t\u0002\u001c\u0004]Z"));
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)LowerTierEventStoreFactory.M((Object)"(l\u001d-\bh\u0016~\u0004j\u0000-\u0016d\u001fhE`\u0010~\u0011-\u0007hEa\u0000~\u0016-\u0011e\u0004cE?T9R9]>S9R"));
        a.maxMessageSize = (int)a2.toBytes();
    }

    public void setSetWebSocketAllowedOrigins(boolean a2) {
        a.setWebSocketAllowedOrigins = a2;
    }

    public void setInternalDomain(String a2) {
        a.internalDomain = a2;
    }

    public void setPluginCacheDirectory(String a2) {
        a.pluginCacheDirectory = a2;
    }

    public void setInternalPort(int a2) {
        a.internalPort = a2;
    }

    public int getClusterExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.clusterExecutorThreadCount;
    }

    public int getMaxTransactionSize() {
        MessagingPlatformConfiguration a2;
        if (a2.maxMessageSize == 0) {
            return 4184304;
        }
        return a2.maxMessageSize - 10000;
    }

    public void setDomain(String a2) {
        a.domain = a2;
    }

    public boolean isExperimentalFeatureEnabled(String a2) {
        MessagingPlatformConfiguration a3;
        return a3.preview.getOrDefault(a2, false);
    }

    public void setPidFileLocation(String a2) {
        a.pidFileLocation = a2;
    }

    public boolean isSetWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.setWebSocketAllowedOrigins;
    }

    public int getInternalPort() {
        MessagingPlatformConfiguration a2;
        return a2.internalPort;
    }

    public String getPluginCacheDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCacheDirectory;
    }

    public String getFullyQualifiedInternalHostname() {
        MessagingPlatformConfiguration a2;
        String string = a2.getInternalDomain();
        if (!StringUtils.isEmpty((String)string)) {
            return a2.getInternalHostname() + "." + string;
        }
        return a2.getInternalHostname();
    }

    @PostConstruct
    public void postConstruct() {
        MessagingPlatformConfiguration a4;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a4;
        messagingPlatformConfiguration.M(a4.getHostname(), messagingPlatformConfiguration.getDomain(), false, (a2, a3) -> {
            MessagingPlatformConfiguration a4;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a4;
            messagingPlatformConfiguration.setHostname(a2);
            messagingPlatformConfiguration.setDomain(a3);
        });
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a4;
        messagingPlatformConfiguration2.M(a4.getInternalHostname(), messagingPlatformConfiguration2.getInternalDomain(), true, (a2, a3) -> {
            MessagingPlatformConfiguration a4;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a4;
            messagingPlatformConfiguration.setInternalHostname(a2);
            messagingPlatformConfiguration.setInternalDomain(a3);
        });
        if (a4.datasourceUrl != null && !a4.datasourceUrl.contains(LowerTierEventStoreFactory.M((Object)"_`\u0000`_")) && !a4.datasourceUrl.contains(TransientException.M((Object)"\u000b\u0005\u0005\u0013\u0019\u0018\u0018\u000b\u000f\u000fG\u001e\u0005\u0013\f\u0014\r\u0019\b"))) {
            throw new FailedToStartException(LowerTierEventStoreFactory.M((Object)"1e\u0000-\u0001l\u0011l\u0007l\u0016hEc\u0004`\u0000-\u0003b\u0017-$u\ncE^\u0000\u007f\u0013h\u0017-\bx\u0016yEo\u0000-Bl\u001db\u000b~\u0000\u007f\u0013h\u0017 \u0006b\u000bk\fj\u0001oB#ED\u0003-\u001cb\u0010-\u0004\u007f\u0000-\bd\u0002\u007f\u0004y\fc\u0002-\u0003\u007f\n`El\u000b-\na\u0001h\u0017-\u0013h\u0017~\fb\u000b-\u0000c\u0016x\u0017hEy\rl\u0011-\u0011e\u0000-&b\u000by\u0017b\t-!OEd\u0016-\fcE*\u0004u\nc\u0016h\u0017{\u0000\u007fHn\nc\u0011\u007f\na\u0001oB-\u0004c\u0001-\u0010}\u0001l\u0011hEy\rhE~\u0015\u007f\fc\u0002#\u0001l\u0011l\u0016b\u0010\u007f\u0006hKx\u0017aE}\u0017b\u0015h\u0017y\u001c-\u0011bEx\u0016hEi\u0004y\u0004o\u0004~\u0000-\u000bl\bhE*\u0004u\nc\u0016h\u0017{\u0000\u007fHn\nc\u0003d\u0002i\u0007*K"));
        }
        if (auditLog.isInfoEnabled()) {
            auditLog.info(TransientException.M((Object)">\u0005\u0013\f\u0014\r\b\u0018\u001c\u001e\u0014\u0005\u0013J\u0014\u0004\u0014\u001e\u0014\u000b\u0011\u0003\u0007\u000f\u0019J\n\u0003\t\u0002]9.&]\u0011\u0000J\u001c\u0004\u0019J\u001c\t\u001e\u000f\u000e\u0019]\t\u0012\u0004\t\u0018\u0012\u0006]\u0011\u0000D"), (Object)AuditLog.enablement((boolean)a4.ssl.isEnabled()), (Object)AuditLog.enablement((boolean)a4.accesscontrol.isEnabled()));
        }
    }

    public void setPluginPackageDirectory(String a2) {
        a.pluginPackageDirectory = a2;
    }

    @PostConstruct
    public void init() {
        if (auditLog.isInfoEnabled()) {
            MessagingPlatformConfiguration a4;
            a4.preview.forEach((a2, a3) -> {
                if (Boolean.TRUE.equals(a3)) {
                    auditLog.info(TransientException.M((Object)"-\u0018\u0018\u001c\u0014\u000f\nJ\u0012\f]\f\u0018\u000b\t\u001f\u000f\u000f]\u0011\u0000J\u0018\u0004\u001c\b\u0011\u000f\u0019D"), a2);
                }
            });
        }
    }

    public long getMinKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.minKeepAliveTime.toMillis();
    }

    public void setPluginsEnabled(boolean a2) {
        a.pluginsEnabled = a2;
    }

    public String getWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.webSocketAllowedOrigins;
    }

    public int getEventStoreProcessorsThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreProcessorsThreadCount;
    }

    public void setControldbBackupLocation(String a2) {
        a.controldbBackupLocation = a2;
    }

    public String getFullyQualifiedHostname() {
        MessagingPlatformConfiguration a2;
        String string = a2.getDomain();
        if (!StringUtils.isEmpty((String)string)) {
            return a2.getHostname() + "." + string;
        }
        return a2.getHostname();
    }
}

