/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.cluster.replication.file.StorageProperties;
import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.diagnostics.DiagnosticsOptions;
import io.axoniq.axonserver.util.ObjectUtils;
import java.time.Duration;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="axoniq.axonserver.replication")
@Configuration
public class RaftProperties
extends StorageProperties {
    private int maxEntriesPerBatch;
    private int heartbeatTimeout;
    private int logRetentionHours;
    private int snapshotFlowBuffer;
    private int waitForLeaderTimeout;
    private boolean forceSnapshotOnJoin;
    private int maxSnapshotChunksPerBatch;
    private int flowBuffer;
    private int maxReplicationRound;
    private int maxElectionTimeout;
    private boolean logCompactionEnabled;
    private int initialElectionTimeout;
    private int minElectionTimeout;
    private final SystemInfoProvider systemInfoProvider;

    public void setHeartbeatTimeout(Duration a2) {
        a.heartbeatTimeout = (int)a2.toMillis();
    }

    public void setMaxElectionTimeout(Duration a2) {
        a.maxElectionTimeout = (int)a2.toMillis();
    }

    public int getLogRetentionHours() {
        RaftProperties a2;
        return a2.logRetentionHours;
    }

    public void setLogCompactionEnabled(boolean a2) {
        a.logCompactionEnabled = a2;
    }

    public void setMaxEntriesPerBatch(int a2) {
        a.maxEntriesPerBatch = a2;
    }

    public int getMaxElectionTimeout() {
        RaftProperties a2;
        return a2.maxElectionTimeout;
    }

    public int getFlowBuffer() {
        RaftProperties a2;
        return a2.flowBuffer;
    }

    public void setLogRetentionHours(int a2) {
        a.logRetentionHours = Math.max(a2, 1);
    }

    public int getHeartbeatTimeout() {
        RaftProperties a2;
        return a2.heartbeatTimeout;
    }

    public void setWaitForLeaderTimeout(int a2) {
        a.waitForLeaderTimeout = a2;
    }

    public int getMaxReplicationRound() {
        RaftProperties a2;
        return a2.maxReplicationRound;
    }

    public int getMinElectionTimeout() {
        RaftProperties a2;
        return a2.minElectionTimeout;
    }

    public int getInitialElectionTimeout() {
        RaftProperties a2;
        return a2.initialElectionTimeout;
    }

    public boolean isUseMmapIndex() {
        RaftProperties a2;
        return (Boolean)ObjectUtils.M((Object)a2.useMmapIndex, (Object)true);
    }

    public void setInitialElectionTimeout(Duration a2) {
        a.initialElectionTimeout = (int)a2.toMillis();
    }

    public void setMaxReplicationRound(int a2) {
        a.maxReplicationRound = a2;
    }

    public void setSnapshotFlowBuffer(int a2) {
        a.snapshotFlowBuffer = a2;
    }

    public int getSnapshotFlowBuffer() {
        RaftProperties a2;
        return a2.snapshotFlowBuffer;
    }

    public int getWaitForLeaderTimeout() {
        RaftProperties a2;
        if (a2.waitForLeaderTimeout == -1) {
            a2.waitForLeaderTimeout = a2.maxElectionTimeout;
        }
        return a2.waitForLeaderTimeout;
    }

    public void setMaxSnapshotChunksPerBatch(int a2) {
        a.maxSnapshotChunksPerBatch = a2;
    }

    public void setMinElectionTimeout(Duration a2) {
        a.minElectionTimeout = (int)a2.toMillis();
    }

    public int getMaxEntriesPerBatch() {
        RaftProperties a2;
        return a2.maxEntriesPerBatch;
    }

    public boolean isForceCleanMmapIndex() {
        RaftProperties a2;
        if (a2.forceCleanMmapIndex != null) {
            return a2.forceCleanMmapIndex;
        }
        return a2.systemInfoProvider.javaOnWindows();
    }

    public int getMaxSnapshotChunksPerBatch() {
        RaftProperties a2;
        return a2.maxSnapshotChunksPerBatch;
    }

    public void setForceSnapshotOnJoin(boolean a2) {
        a.forceSnapshotOnJoin = a2;
    }

    public boolean isLogCompactionEnabled() {
        RaftProperties a2;
        return a2.logCompactionEnabled;
    }

    public RaftProperties(SystemInfoProvider a2) {
        RaftProperties a3;
        RaftProperties raftProperties = a3;
        RaftProperties raftProperties2 = a3;
        RaftProperties raftProperties3 = a3;
        RaftProperties raftProperties4 = a3;
        RaftProperties raftProperties5 = a3;
        RaftProperties raftProperties6 = a3;
        RaftProperties raftProperties7 = a3;
        raftProperties7.initialElectionTimeout = 0;
        raftProperties7.minElectionTimeout = 1000;
        raftProperties6.maxElectionTimeout = 2500;
        raftProperties6.heartbeatTimeout = 300;
        raftProperties5.maxEntriesPerBatch = 10;
        raftProperties5.flowBuffer = 1000;
        raftProperties4.snapshotFlowBuffer = 50;
        raftProperties4.maxSnapshotChunksPerBatch = 1000;
        raftProperties3.maxReplicationRound = 10;
        raftProperties3.logCompactionEnabled = true;
        raftProperties2.logRetentionHours = 1;
        raftProperties2.forceSnapshotOnJoin = true;
        raftProperties.waitForLeaderTimeout = -1;
        raftProperties.systemInfoProvider = a2;
    }

    public void setFlowBuffer(int a2) {
        a.flowBuffer = a2;
    }

    public boolean isForceSnapshotOnJoin() {
        RaftProperties a2;
        return a2.forceSnapshotOnJoin;
    }

    @PostConstruct
    public void validate() {
        RaftProperties a2;
        RaftProperties raftProperties = a2;
        Assert.isTrue((raftProperties.maxElectionTimeout > raftProperties.minElectionTimeout ? 1 : 0) != 0, (String)DiagnosticsOptions.M((Object)"iA\\\u0000ALACPIKN\u0004TMMAOQT\u0004MQSP\u0000FE\u0004GVEETAR\u0004TLAJ\u0000IIJ\u0000ALACPIKN\u0004TMMAOQT"));
    }
}

