/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.configuration.admin.jpa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.configuration.admin.AdminContext;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.jpa.AdminReplicationGroupJpa;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity(name="Context")
@Table(name="adm_context")
class AdminContextJpa
implements Serializable,
AdminContext {
    @Column(name="META_DATA")
    @Lob
    private String metaData;
    @Id
    private String name;
    @Column(name="CHANGE_PENDING")
    private Boolean changePending;
    @Column(name="PENDING_SINCE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date pendingSince;
    @ManyToOne
    @JoinColumn(name="replication_group_id")
    private AdminReplicationGroupJpa replicationGroup;

    public Map<String, String> getMetaDataMap() {
        AdminContextJpa a2;
        if (a2.metaData == null) {
            return Collections.emptyMap();
        }
        try {
            return (Map)new ObjectMapper().readValue(a2.metaData, Map.class);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return Collections.emptyMap();
        }
    }

    public boolean equals(Object a2) {
        AdminContextJpa a3;
        if (a3 == a2) {
            return true;
        }
        if (a2 == null || a3.getClass() != a2.getClass()) {
            return false;
        }
        a2 = (AdminContextJpa)a2;
        return Objects.equals(a3.name, ((AdminContextJpa)a2).name);
    }

    protected AdminContextJpa() {
        AdminContextJpa a2;
    }

    public void setReplicationGroup(AdminReplicationGroup a2) {
        a.replicationGroup = (AdminReplicationGroupJpa)a2;
    }

    public void setMetaDataMap(Map<String, String> a22) {
        a.metaData = null;
        try {
            a.metaData = new ObjectMapper().writeValueAsString(a22);
            return;
        }
        catch (JsonProcessingException a22) {
            a22.printStackTrace();
            return;
        }
    }

    public void changePending(Boolean a2) {
        AdminContextJpa a3;
        a3.changePending = a2;
        if (a3.changePending != null && a2.booleanValue()) {
            AdminContextJpa adminContextJpa = a3;
            adminContextJpa.pendingSince = new Date();
            return;
        }
        a3.pendingSince = null;
    }

    public boolean isChangePending() {
        AdminContextJpa a2;
        if (a2.changePending != null && a2.changePending.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setMetaData(String a2) {
        a.metaData = a2;
    }

    public int hashCode() {
        AdminContextJpa a2;
        Object[] objectArray = new Object[1];
        objectArray[0] = a2.name;
        return Objects.hash(objectArray);
    }

    public String getMetaData() {
        AdminContextJpa a2;
        return a2.metaData;
    }

    public Date getPendingSince() {
        AdminContextJpa a2;
        return a2.pendingSince;
    }

    public String getName() {
        AdminContextJpa a2;
        return a2.name;
    }

    public AdminReplicationGroup getReplicationGroup() {
        AdminContextJpa a2;
        return a2.replicationGroup;
    }

    public void setName(String a2) {
        a.name = a2;
    }

    AdminContextJpa(String a2) {
        AdminContextJpa a3;
        a3.name = a2;
    }

    public String toString() {
        AdminContextJpa a2;
        return "Context{name='" + a2.name + "'}";
    }
}

