/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.configuration.admin.jpa;

import io.axoniq.axonserver.configuration.admin.AdminContext;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.configuration.admin.jpa.AdminContextJpa;
import io.axoniq.axonserver.configuration.admin.jpa.AdminReplicationGroupMemberJpa;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="adm_replication_group", uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
public class AdminReplicationGroupJpa
implements AdminReplicationGroup {
    @Column(name="PENDING_SINCE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date pendingSince;
    private String name;
    @Column(name="CHANGE_PENDING")
    private Boolean changePending;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="replicationGroup", fetch=FetchType.EAGER)
    private Set<AdminReplicationGroupMemberJpa> members;
    @Id
    private String replicationGroupId;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="replicationGroup", fetch=FetchType.EAGER)
    private Set<AdminContextJpa> contexts;

    public void setChangePending(boolean a2) {
        boolean bl = a2;
        a3.changePending = bl;
        if (bl) {
            AdminReplicationGroupJpa a3;
            AdminReplicationGroupJpa adminReplicationGroupJpa = a3;
            adminReplicationGroupJpa.pendingSince = new Date();
            return;
        }
        a3.pendingSince = null;
    }

    public int hashCode() {
        AdminReplicationGroupJpa a2;
        Object[] objectArray = new Object[1];
        objectArray[0] = a2.name;
        return Objects.hash(objectArray);
    }

    public void setPendingSince(Date a2) {
        a.pendingSince = a2;
    }

    @PrePersist
    public void prePersist() {
        AdminReplicationGroupJpa a2;
        if (a2.replicationGroupId == null) {
            a2.replicationGroupId = UUID.randomUUID().toString();
        }
    }

    public void clearContexts() {
        AdminReplicationGroupJpa a2;
        a2.contexts.clear();
    }

    public void addMember(AdminReplicationGroupMember a2) {
        AdminReplicationGroupJpa a3;
        a2 = a3.M(a2);
        AdminReplicationGroupJpa adminReplicationGroupJpa = a3;
        a2.setReplicationGroup((AdminReplicationGroup)adminReplicationGroupJpa);
        adminReplicationGroupJpa.members.add(a2);
    }

    public Date getPendingSince() {
        AdminReplicationGroupJpa a2;
        return a2.pendingSince;
    }

    public void setMembers(Set<AdminReplicationGroupMember> a3) {
        if (a3 != null) {
            AdminReplicationGroupJpa a4;
            a4.members = a3.stream().map(a2 -> {
                if (a2 instanceof AdminReplicationGroupMemberJpa) {
                    return (AdminReplicationGroupMemberJpa)a2;
                }
                throw new IllegalArgumentException("Expecting AdminReplicationGroupMemberJpa, got: " + a2.getClass());
            }).collect(Collectors.toSet());
            return;
        }
        a4.members = null;
    }

    public void setReplicationGroupId(String a2) {
        a.replicationGroupId = a2;
    }

    AdminReplicationGroupJpa(String a2) {
        AdminReplicationGroupJpa a3;
        AdminReplicationGroupJpa adminReplicationGroupJpa = a3;
        AdminReplicationGroupJpa adminReplicationGroupJpa2 = a3;
        adminReplicationGroupJpa.members = new HashSet();
        AdminReplicationGroupJpa adminReplicationGroupJpa3 = a3;
        adminReplicationGroupJpa.contexts = new HashSet();
        adminReplicationGroupJpa.name = a2;
    }

    public void removeMember(AdminReplicationGroupMember a4) {
        AdminReplicationGroupJpa a5;
        a5.members.stream().filter(a3 -> a3.getClusterNode().getName().equals(a4.getClusterNode().getName())).findFirst().ifPresent(a2 -> {
            AdminReplicationGroupJpa a3;
            a2.setReplicationGroup(null);
            a3.members.remove(a2);
        });
    }

    @PreRemove
    public void preRemove() {
        AdminReplicationGroupJpa a3;
        new HashSet(a3.members).forEach(a2 -> {
            AdminReplicationGroupJpa a3;
            a2.getClusterNode().removeReplicationGroup((AdminReplicationGroup)a3);
        });
        a3.members.clear();
    }

    public boolean isChangePending() {
        AdminReplicationGroupJpa a2;
        if (a2.changePending != null && a2.changePending.booleanValue()) {
            return true;
        }
        return false;
    }

    protected AdminReplicationGroupJpa() {
        AdminReplicationGroupJpa a2;
        AdminReplicationGroupJpa adminReplicationGroupJpa = a2;
        a2.members = new HashSet();
        AdminReplicationGroupJpa adminReplicationGroupJpa2 = a2;
        adminReplicationGroupJpa.contexts = new HashSet();
    }

    public void addContext(AdminContext a2) {
        AdminReplicationGroupJpa a3;
        AdminReplicationGroupJpa adminReplicationGroupJpa = a3;
        a2.setReplicationGroup((AdminReplicationGroup)adminReplicationGroupJpa);
        adminReplicationGroupJpa.contexts.add((AdminContextJpa)a2);
    }

    public Set<AdminReplicationGroupMember> getMembers() {
        AdminReplicationGroupJpa a2;
        return new HashSet<AdminReplicationGroupMember>(a2.members);
    }

    public void removeContext(AdminContext a2) {
        AdminReplicationGroupJpa a3;
        a2.setReplicationGroup(null);
        a3.contexts.remove(a2);
    }

    public String getName() {
        AdminReplicationGroupJpa a2;
        return a2.name;
    }

    public boolean equals(Object a2) {
        AdminReplicationGroupJpa a3;
        if (a3 == a2) {
            return true;
        }
        if (a2 == null || a3.getClass() != a2.getClass()) {
            return false;
        }
        a2 = (AdminReplicationGroupJpa)a2;
        return Objects.equals(a3.name, ((AdminReplicationGroupJpa)a2).name);
    }

    public Set<? extends AdminContext> getContexts() {
        AdminReplicationGroupJpa a2;
        return a2.contexts;
    }

    public void setContexts(Set<AdminContext> a3) {
        AdminReplicationGroupJpa a4;
        a4.contexts = a3.stream().map(a2 -> {
            if (a2 instanceof AdminContextJpa) {
                return (AdminContextJpa)a2;
            }
            return new AdminContextJpa(a2.getName());
        }).collect(Collectors.toSet());
    }

    public void setName(String a2) {
        a.name = a2;
    }

    public String getReplicationGroupId() {
        AdminReplicationGroupJpa a2;
        return a2.replicationGroupId;
    }

    public AdminContext addContext(String a2) {
        AdminReplicationGroupJpa a3;
        a2 = new AdminContextJpa(a2);
        AdminReplicationGroupJpa adminReplicationGroupJpa = a3;
        a2.setReplicationGroup((AdminReplicationGroup)adminReplicationGroupJpa);
        String string = a2;
        adminReplicationGroupJpa.contexts.add(string);
        return string;
    }
}

