/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.tags.ClientTagsCache;
import io.axoniq.axonserver.enterprise.cluster.NodeSelector;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.ReadyForConnections;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.rest.json.CommandRequestJson;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AutoRebalancing {
    private final boolean B;
    private final NavigableSet<PlatformService.ClientComponent> A;
    private final PlatformService E;
    private final Logger C;
    private final ClientTagsCache c;
    private final NodeSelector e;

    public AutoRebalancing(PlatformService platformService, ClientTagsCache clientsTags, NodeSelector nodeSelector, @Value(value="${axoniq.axonserver.cluster.auto-balancing:true}") boolean a2) {
        AutoRebalancing autoRebalancing = this;
        AutoRebalancing autoRebalancing2 = this;
        this.C = LoggerFactory.getLogger(AutoRebalancing.class);
        AutoRebalancing autoRebalancing3 = this;
        this.A = new ConcurrentSkipListSet();
        autoRebalancing2.E = platformService;
        autoRebalancing2.c = clientsTags;
        autoRebalancing.e = nodeSelector;
        autoRebalancing.B = a2;
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected a2) {
        AutoRebalancing a3;
        AutoRebalancing autoRebalancing = a3;
        autoRebalancing.C.debug(EventTypeContext.M((Object)":T\u000bH\u0012G\u001aP\u0012K\u0015\u0004?M\bG\u0014J\u0015A\u0018P\u001e@A\u0004\u0000Y"), (Object)a2.B());
        a2 = new PlatformService.ClientComponent(a2.B(), a2.h(), a2.E(), a2.l());
        autoRebalancing.A.remove(a2);
        a3.C.debug(CommandRequestJson.M((Object)"+\u0005\u0015\u0019\u0019\u0001\u0015\u001e\bW\\\u0016\u0001"), (Object)a3.A);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeHealthChanged a2) {
        AutoRebalancing a3;
        AutoRebalancing autoRebalancing = a3;
        autoRebalancing.C.debug(EventTypeContext.M((Object)")A\u0018A\u0012R\u001e@[L\u001eE\u0017P\u0013\u0004\u0018L\u001aJ\u001cA\u001f\u0004\u001dK\t\u0004\u0000Y"), (Object)a2.getNode());
        autoRebalancing.A.clear();
        autoRebalancing.A.addAll(a3.E.getConnectedClients());
    }

    @Scheduled(fixedRateString="${axoniq.axonserver.cluster.balancing-rate:15000}")
    protected void M() {
        boolean bl;
        AutoRebalancing a2;
        if (!a2.B) {
            return;
        }
        a2.C.debug(CommandRequestJson.M((Object)".\b\u001e\f\u0010\f\u0012\u000e\u0019W\\\u0016\u0001"), (Object)a2.A);
        boolean bl2 = false;
        do {
            PlatformService.ClientComponent clientComponent;
            if ((clientComponent = (PlatformService.ClientComponent)a2.A.pollFirst()) != null && a2.e.canRebalance(clientComponent.getClientId(), clientComponent.getComponent(), clientComponent.getContext(), a2.M(clientComponent.getContext(), clientComponent.getClientStreamId()))) {
                bl = bl2;
                a2.M(clientComponent);
                continue;
            }
            bl = bl2 = clientComponent != null;
        } while (bl);
    }

    private /* synthetic */ Map<String, String> M(String a2, String a3) {
        AutoRebalancing a4;
        return a4.c.apply(new ClientStreamIdentification(a2, a3));
    }

    @EventListener
    public void on(ReadyForConnections a2) {
        if (a2.ready()) {
            AutoRebalancing a3;
            AutoRebalancing autoRebalancing = a3;
            autoRebalancing.A.clear();
            autoRebalancing.A.addAll(a3.E.getConnectedClients());
        }
    }

    private /* synthetic */ void M(PlatformService.ClientComponent a2) {
        AutoRebalancing a3;
        AutoRebalancing autoRebalancing = a3;
        autoRebalancing.C.info(EventTypeContext.M((Object)"v\u001eU\u000eA\bP\u0012J\u001c\u0004\tA\u0018K\u0015J\u001eG\u000f\u0004\u001dK\t\u0004\u0000Y"), (Object)a2.getClientStreamId());
        autoRebalancing.E.requestReconnect(a2, CommandRequestJson.M((Object)"\u000e\b\u001f\u0002\u0012\u0003\u0019\u000e\bM\u000e\b\r\u0018\u0019\u001e\b\b\u0018M\u001e\u0014\\\f\t\u0019\u0013M\u001e\f\u0010\f\u0012\u000e\u0015\u0003\u001b"));
    }
}

