/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.cluster.util.AxonThreadFactory;
import io.axoniq.axonserver.config.ClusterConfiguration;
import io.axoniq.axonserver.config.FlowControl;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterEvent;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.events.serializer.XStreamEventSerializer;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.StubFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ChannelExceptionHandler;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.internal.DeleteNode;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.message.query.QueryDispatcher;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.taskscheduler.TransientException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller(value="ClusterController")
public class ClusterController
implements SmartLifecycle,
ApplicationContextAware {
    private final StubFactory D;
    private final AdminNodes F;
    private final AtomicBoolean k;
    private volatile boolean f;
    private final QueryDispatcher I;
    private final ConcurrentMap<String, ClusterNode> H;
    private final ConcurrentMap<String, RemoteConnection> g;
    private ApplicationContext m;
    private final AdminConfigurationFactory K;
    private final MessagingPlatformConfiguration M;
    private final ClusterConfiguration d;
    private final ChannelExceptionHandler a;
    private final ApplicationEventPublisher j;
    private final List<Consumer<ClusterEvent>> h;
    private final ScheduledExecutorService l;
    private final XStreamEventSerializer G;
    private final AtomicBoolean B;
    private final ClusterTagsCache A;
    private final Limits E;
    private final CommandDispatcher C;
    private final ClientIdRegistry c;
    private final Logger e;

    private /* synthetic */ void h() {
        ClusterController a2;
        ClusterController clusterController = a2;
        Object object = clusterController.F.findById(clusterController.M.getName());
        if (!((Optional)object).isPresent()) {
            if (a2.F.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = a2.M.getName();
                String string = String.format(TransientException.M((Object)">\u001f\u000f\u0018\u0018\u0004\tJ\u0013\u0005\u0019\u000f]\u0004\u001c\u0007\u0018J\u0015\u000b\u000eJ\u001e\u0002\u001c\u0004\u001a\u000f\u0019F]\u0004\u0018\u001d]\u0004\u001c\u0007\u0018JX\u0019SJ.\u001e\u001c\u0018\tJ<\u0012\u0012\u0004.\u000f\u000f\u001c\u0018\u0018]\u001d\u0014\u001e\u0015J\u000f\u000f\u001e\u0005\u000b\u000f\u000f\u0013]\f\u0014\u0006\u0018D"), objectArray);
                throw new FailedToStartException(string);
            }
            ClusterController clusterController2 = a2;
            ClusterNode clusterNode = clusterController2.K.clusterNode(clusterController2.M.getName(), a2.M.getFullyQualifiedHostname(), a2.M.getFullyQualifiedInternalHostname(), a2.M.getPort(), a2.M.getInternalPort(), a2.M.getHttpPort());
            clusterController2.F.save(clusterNode);
            return;
        }
        ClusterNode clusterNode = (ClusterNode)((Optional)object).get();
        if (!clusterNode.getInternalHostName().equals(a2.M.getFullyQualifiedInternalHostname()) || !clusterNode.getGrpcInternalPort().equals(a2.M.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = clusterNode.getInternalHostName();
            objectArray[1] = clusterNode.getGrpcInternalPort();
            objectArray[2] = a2.M.getFullyQualifiedInternalHostname();
            objectArray[3] = a2.M.getInternalPort();
            object = String.format(QueryHandler.M((Object)"J;{<l }ng!m+.=)'g:l<g/ena!z:g/d+&>f<}n!kzt,* na/znj&h n+mb)ng+~n\u007f/e;l=)kzt,*'nZ:h<}nH6f Z+{8l<)9`:an{+j!\u007f+{7)(`\"l`"), objectArray);
            throw new FailedToStartException((String)object);
        }
        a2.B.set(clusterNode.isAdmin());
    }

    @EventListener
    @Transactional
    public void on(DeleteNode a2) {
        ClusterController a3;
        a3.deleteNode(a2.getNodeName());
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.g.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void M(ClusterNode a2, boolean a3) {
        ClusterController a4;
        if (a2.getName().equals(a4.M.getName())) {
            return;
        }
        ConcurrentMap concurrentMap = a4.g;
        synchronized (concurrentMap) {
            if (!a4.g.containsKey(a2.getName())) {
                ClusterController clusterController = a4;
                ClusterController clusterController2 = a4;
                ClusterController clusterController3 = a4;
                RemoteConnection remoteConnection = new RemoteConnection(clusterController, a2, a4.D, clusterController.I, clusterController2.C, clusterController2.c, clusterController3.a, clusterController3.G, a4.k.get());
                a4.g.put(a2.getName(), remoteConnection);
                if (a3) {
                    remoteConnection.M();
                }
            }
            return;
        }
    }

    public void stop() {
        ClusterController a4;
        ClusterController clusterController = a4;
        clusterController.l.shutdown();
        clusterController.g.forEach((a2, a3) -> a3.B());
        a4.f = false;
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.f;
    }

    public String getName() {
        ClusterController a2;
        return a2.M.getName();
    }

    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, ClusterConfiguration clusterConfiguration, AdminNodes clusterNodeRepository, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, StubFactory stubFactory, QueryDispatcher queryDispatcher, CommandDispatcher commandDispatcher, ClientIdRegistry clientIdRegistry, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, ChannelExceptionHandler channelExceptionHandler, XStreamEventSerializer a2) {
        ClusterController clusterController = this;
        ClusterController clusterController2 = this;
        ClusterController clusterController3 = this;
        ClusterController clusterController4 = this;
        ClusterController clusterController5 = this;
        ClusterController clusterController6 = this;
        ClusterController clusterController7 = this;
        ClusterController clusterController8 = this;
        this.e = LoggerFactory.getLogger(ClusterController.class);
        ClusterController clusterController9 = this;
        clusterController8.l = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new AxonThreadFactory(TransientException.M((Object)"\t\u0011\u001f\u000e\u001e\u0018\u0018P\u0018\u0018\t\u0012\u0004\u0013\u000f\u001e\u001e")));
        ClusterController clusterController10 = this;
        clusterController9.h = new CopyOnWriteArrayList();
        ClusterController clusterController11 = this;
        clusterController8.g = new ConcurrentHashMap();
        ClusterController clusterController12 = this;
        clusterController8.H = new ConcurrentHashMap();
        ClusterController clusterController13 = this;
        clusterController7.k = new AtomicBoolean();
        ClusterController clusterController14 = this;
        clusterController7.B = new AtomicBoolean();
        clusterController7.M = messagingPlatformConfiguration;
        clusterController6.d = clusterConfiguration;
        clusterController6.F = clusterNodeRepository;
        clusterController5.K = adminConfigurationFactory;
        clusterController5.A = clusterTagsCache;
        clusterController4.D = stubFactory;
        clusterController4.I = queryDispatcher;
        clusterController3.C = commandDispatcher;
        clusterController3.c = clientIdRegistry;
        clusterController2.j = applicationEventPublisher;
        clusterController2.E = limits;
        clusterController.a = channelExceptionHandler;
        clusterController.G = a2;
    }

    public Optional<RemoteConnection> getRemoteConnection(String a2) {
        ClusterController a3;
        return Optional.ofNullable((RemoteConnection)a3.g.get(a2));
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.g.values();
    }

    public ClusterNode getNode(String a3) {
        ClusterController a4;
        if ((a3 = a4.H.computeIfAbsent(a3, a2 -> {
            ClusterController a3;
            return a3.F.findById(a2).orElse(null);
        })) == null) {
            return null;
        }
        return a4.M((ClusterNode)a3);
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a3;
        return a3.F.findAll().peek(a2 -> {
            ClusterController a3;
            ClusterNode clusterNode = a2;
            clusterNode.setTags(a3.A.getClusterTags().getOrDefault(clusterNode.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    private /* synthetic */ void M(String a2) {
        ClusterController a4;
        if (a4.g.containsKey(a2) || a4.M.getName().equals(a2)) {
            return;
        }
        a4.E.getMaxClusterSize().ifPresent(a3 -> {
            ClusterController a4;
            if (a4.g.size() + 1 >= a3) {
                throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + a2);
            }
        });
    }

    public FlowControl getCommandFlowControl() {
        ClusterController a2;
        return a2.d.getCommandFlowControl();
    }

    public int getPhase() {
        return 50;
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupDeleted a2) {
        ClusterController a3;
        a3.H.clear();
        if (RaftAdminGroup.M((String)a2.replicationGroup())) {
            a3.B.set(false);
        }
    }

    public void setReadyForConnections(boolean a2) {
        ClusterController a5;
        ClusterController clusterController = a5;
        clusterController.k.set(a2);
        clusterController.g.forEach((a3, a4) -> a4.M(a2));
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a3;
        return a3.nodes().filter(a2 -> {
            ClusterController a3;
            return a3.isActive(a2.getName());
        });
    }

    public boolean isActive(String a2) {
        ClusterController a3;
        if (a2.equals(a3.M.getName()) || a3.g.get(a2) != null && ((RemoteConnection)a3.g.get(a2)).M()) {
            return true;
        }
        return false;
    }

    public void setApplicationContext(@Nonnull ApplicationContext a2) {
        this.m = a2;
    }

    @Transactional
    public synchronized void handleRemoteConnection(NodeInfo a2) {
        Object object;
        ClusterController a3;
        Object object2 = a2.getNodeName();
        ClusterNode clusterNode = a3.getNode((String)object2);
        if (clusterNode == null) {
            ClusterController clusterController = a3;
            clusterNode = clusterController.addConnection(a2);
            object = (RemoteConnection)clusterController.g.remove(object2);
            if (object != null) {
                object.B();
            }
        }
        if (!a3.g.containsKey(object2)) {
            ClusterController clusterController = a3;
            clusterController.M(clusterNode, false);
            object = clusterController.h.iterator();
            Iterator iterator = object;
            while (iterator.hasNext()) {
                object2 = (Consumer)object.next();
                iterator = object;
                object2.accept(new ClusterEvent(ClusterEvent.EventType.e, clusterNode));
            }
        }
        a3.j.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected(a2));
    }

    public void addNodeListener(Consumer<ClusterEvent> a2) {
        ClusterController a3;
        a3.h.add(a2);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated a2) {
        ClusterController a3;
        a3.H.clear();
        if (RaftAdminGroup.M((String)a2.replicationGroup())) {
            a3.B.set(a3.getMe().isAdmin());
        }
    }

    private static /* synthetic */ void M(ClusterNode a2, Consumer a3) {
        a3.accept(new ClusterEvent(ClusterEvent.EventType.e, a2));
    }

    public void connect(Node a2) {
        ClusterController a3;
        if (!a3.F.findById(a2.getNodeName()).isPresent()) {
            ClusterController clusterController = a3;
            clusterController.M(clusterController.K.clusterNode(a2), true);
        }
    }

    public long getConnectionWaitTime() {
        ClusterController a2;
        return a2.d.getConnectionWaitTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public synchronized void deleteNode(String a4) {
        ClusterController a5;
        ClusterController clusterController = a5;
        clusterController.e.info(TransientException.M((Object)".\u0018\u0006\u0018\u001e\u0018J\u0013\u0005\u0019\u000fGJ\u0006\u0017"), (Object)a4);
        clusterController.j.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested(a4));
        ConcurrentMap concurrentMap = clusterController.g;
        synchronized (concurrentMap) {
            RemoteConnection remoteConnection;
            if (a5.M.getName().equals(a4)) {
                a5.g.forEach((a2, a3) -> a3.B());
                ClusterController clusterController2 = a5;
                clusterController2.g.clear();
                clusterController2.F.deleteAllByNameNot(a4);
            }
            if ((remoteConnection = (RemoteConnection)a5.g.remove(a4)) != null) {
                a5.F.findById(a4).ifPresent(a3 -> {
                    ClusterController a4;
                    a4.F.deleteById(a4);
                });
                remoteConnection.B();
                a5.h.forEach(a3 -> a3.accept(new ClusterEvent(ClusterEvent.EventType.c, remoteConnection.M())));
                a5.H.remove(a4);
            }
        }
        a5.j.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted(a4));
    }

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo a2) {
        ClusterController a3;
        NodeInfo nodeInfo = a2;
        a3.M(nodeInfo.getNodeName());
        if (nodeInfo.getNodeName().equals(a3.M.getName())) {
            ClusterController clusterController = a3;
            clusterController.e.info(QueryHandler.M((Object)"\u001a{7` nn}!)$f'gn~'}&)-|<{+g:) f*lng/d+3nr3"), (Object)a2.getNodeName());
            return clusterController.getMe();
        }
        if (a2.getInternalHostName().equals(a3.M.getInternalHostname()) && a2.getGrpcInternalPort() == a3.M.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, TransientException.M((Object)">\u000b\u0013\u0004\u0012\u001e]\u0000\u0012\u0003\u0013J\u001e\u0006\b\u0019\t\u000f\u000fJ\n\u0003\t\u0002]\u0019\u001c\u0007\u0018J\u0015\u0005\u000e\u001e\u0013\u000b\u0010\u000f]\u000b\u0013\u000e]\u0003\u0013\u001e\u0018\u0018\u0013\u000b\u0011J\r\u0005\u000f\u001e"));
        }
        ClusterController clusterController = a3;
        if (!clusterController.g.containsKey((a2 = clusterController.M(a2)).getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.M((ClusterNode)a2, false);
            clusterController2.h.forEach(arg_0 -> ClusterController.M((ClusterNode)a2, arg_0));
        }
        return a2;
    }

    public ClusterNode getMe() {
        ClusterController a3;
        ClusterController clusterController = a3;
        return clusterController.F.findById(clusterController.M.getName()).map(a2 -> {
            ClusterController a3;
            ClusterNode clusterNode = a2;
            clusterNode.setTags(a3.A.getClusterTags().getOrDefault(clusterNode.getName(), Collections.emptyMap()));
            return a2;
        }).orElseThrow(() -> new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, QueryHandler.M((Object)"J;{<l }ng!m+) f:)(f;g*")));
    }

    @Transactional
    public void sendDeleteNode(String a2) {
        ClusterController a3;
        a3.deleteNode(a2);
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.B.get();
    }

    public void requestDelete(String a2) {
        ClusterController a3;
        a3.j.publishEvent((Object)DeleteNode.newBuilder().setNodeName(a2).build());
    }

    @Transactional
    public void start() {
        ClusterController a3;
        ClusterController clusterController = a3;
        clusterController.h();
        clusterController.e.debug(QueryHandler.M((Object)"Z:h<}nj\"|=}+{nj!g:{!e\"l<"));
        clusterController.nodes().forEach(a2 -> {
            ClusterController a3;
            a3.M(a2, true);
        });
        a3.l.scheduleWithFixedDelay(() -> {
            ClusterController a2;
            a2.g.values().forEach(RemoteConnection::E);
        }, a3.d.getConnectionCheckDelay(), a3.d.getConnectionCheckInterval(), TimeUnit.MILLISECONDS);
        a3.f = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ ClusterNode M(NodeInfo a2) {
        ClusterController a3;
        AdminNodes adminNodes = a3.F;
        synchronized (adminNodes) {
            ClusterNode clusterNode;
            ClusterController clusterController;
            Optional optional = a3.F.findById(a2.getNodeName());
            if (!optional.isPresent()) {
                optional = a3.F.findFirstByInternalHostNameAndGrpcInternalPort(a2.getInternalHostName(), a2.getGrpcInternalPort());
                if (optional.isPresent()) {
                    a3.F.delete((ClusterNode)optional.get());
                    RemoteConnection remoteConnection = (RemoteConnection)a3.g.remove(((ClusterNode)optional.get()).getName());
                    if (remoteConnection != null) {
                        remoteConnection.B();
                    }
                }
                ClusterController clusterController2 = a3;
                clusterController = clusterController2;
                clusterNode = clusterController2.K.clusterNode(a2);
            } else {
                clusterNode = (ClusterNode)optional.get();
                clusterController = a3;
                ClusterNode clusterNode2 = clusterNode;
                NodeInfo nodeInfo = a2;
                ClusterNode clusterNode3 = clusterNode;
                clusterNode3.setGrpcInternalPort(Integer.valueOf(a2.getGrpcInternalPort()));
                clusterNode3.setGrpcPort(Integer.valueOf(a2.getGrpcPort()));
                clusterNode.setHostName(nodeInfo.getHostName());
                clusterNode2.setHttpPort(Integer.valueOf(nodeInfo.getHttpPort()));
                clusterNode2.setInternalHostName(a2.getInternalHostName());
            }
            return clusterController.F.save(clusterNode);
        }
    }

    public FlowControl getQueryFlowControl() {
        ClusterController a2;
        return a2.d.getQueryFlowControl();
    }

    public void closeConnection(String a2) {
        ClusterController a3;
        if (a3.g.containsKey(a2)) {
            ((RemoteConnection)a3.g.get(a2)).l();
        }
    }

    public void publishEvent(Object a2) {
        ClusterController a3;
        a3.j.publishEvent(a2);
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.g.values().stream().filter(RemoteConnection::M);
    }
}

