/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.access.application.AdminApplicationController;
import io.axoniq.axonserver.cluster.grpc.LeaderElectionService;
import io.axoniq.axonserver.cluster.grpc.LogReplicationService;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalAuthenticationInterceptor;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AxonServerInternalService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component(value="MessagingClusterServer")
public class MessagingClusterServer
implements SmartLifecycle {
    private AdvancedTlsX509KeyManager.Closeable a;
    private final MessagingPlatformConfiguration j;
    private boolean h;
    private final ExecutorService l;
    private final List<AxonServerInternalService> G;
    private final Supplier<ScheduledExecutorService> B;
    private final LogReplicationService A;
    private Server E;
    private final Logger C;
    private final ApplicationEventPublisher c;
    private final LeaderElectionService e;

    public MessagingClusterServer(MessagingPlatformConfiguration a2, LogReplicationService a3, LeaderElectionService a4, List<AxonServerInternalService> a5, Supplier<ScheduledExecutorService> a6, ApplicationEventPublisher a7) {
        MessagingClusterServer a8;
        MessagingClusterServer messagingClusterServer = a8;
        MessagingClusterServer messagingClusterServer2 = a8;
        MessagingClusterServer messagingClusterServer3 = a8;
        MessagingClusterServer messagingClusterServer4 = a8;
        messagingClusterServer4.C = LoggerFactory.getLogger(MessagingClusterServer.class);
        messagingClusterServer4.j = a2;
        messagingClusterServer3.A = a3;
        messagingClusterServer3.e = a4;
        messagingClusterServer2.G = a5;
        messagingClusterServer2.B = a6;
        messagingClusterServer.c = a7;
        messagingClusterServer.l = Executors.newFixedThreadPool(a2.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(AdminApplicationController.M((Object)"V>@!A7G\u007fP*P1@&Z \u0018")));
    }

    public int getPhase() {
        return 50;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public boolean isRunning() {
        MessagingClusterServer a2;
        return a2.h;
    }

    public void stop() {
        MessagingClusterServer a2;
        if (a2.a != null) {
            a2.a.close();
        }
        a2.l.shutdown();
        try {
            if (!a2.E.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                MessagingClusterServer messagingClusterServer = a2;
                messagingClusterServer.C.debug(QueryHandler.M((Object)"O!{-l(|\"e7)=}!y>` nnJ\"|=}+{nZ+{8l<"));
                messagingClusterServer.E.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            a2.C.debug(AdminApplicationController.M((Object)"\u001b[&P G'E&P6\u00156@ \\<RrF:@&Q=B<\u0015=Sr\\<A7G<T>\u0015\u0013M=[\u0001P C7G"), (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        a2.h = false;
        a2.C.info(QueryHandler.M((Object)"H6f )\u001dl<\u007f+{nJ\"|=}+{nZ+{8l<)=}!y>l*"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        try {
            MessagingClusterServer messagingClusterServer;
            NettyServerBuilder nettyServerBuilder;
            NettyServerBuilder nettyServerBuilder2;
            MessagingClusterServer a2;
            String string = AdminApplicationController.M((Object)"<Zrf\u0001y");
            if (a2.j.getSsl() != null && a2.j.getSsl().isEnabled()) {
                Object object = a2.j.getSsl().getInternalCertChainFile();
                if (object == null) {
                    throw new RuntimeException(QueryHandler.M((Object)"/q!g'x`h6f z+{8l<'=z\"'-l<}cj&h'gco'e+) f:)=l:"));
                }
                Object object2 = a2.j.getSsl().getInternalPrivateKeyFile();
                if (object2 == null) {
                    throw new RuntimeException(AdminApplicationController.M((Object)"3M=[;D|T*Z<F7G$P \u001b!F>\u001b\"G;C3A7\u00189P+\u00184\\>Pr[=ArF7A"));
                }
                object2 = new File((String)object2);
                object = new File((String)object);
                if (!((File)object2).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object2).getCanonicalPath());
                }
                if (!((File)object).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object).getCanonicalPath());
                }
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                a2.a = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile((File)object2, (File)object, 1L, TimeUnit.MINUTES, (ScheduledExecutorService)a2.B.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                object = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                nettyServerBuilder2 = NettyServerBuilder.forPort((int)a2.j.getInternalPort(), (ServerCredentials)object);
                string = QueryHandler.M((Object)"\u001dZ\u0002)+g/k\"l*");
                nettyServerBuilder = nettyServerBuilder2;
            } else {
                nettyServerBuilder = nettyServerBuilder2 = NettyServerBuilder.forPort((int)a2.j.getInternalPort());
            }
            nettyServerBuilder.permitKeepAliveTime(a2.j.getMinKeepAliveTime(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(true);
            if (a2.j.getMaxMessageSize() > 0) {
                nettyServerBuilder2.maxInboundMessageSize(a2.j.getMaxMessageSize());
            }
            nettyServerBuilder2.intercept((ServerInterceptor)new InternalAuthenticationInterceptor(a2.j));
            a2.G.forEach(a3 -> {
                LinkedList<ContextInterceptor> linkedList = new LinkedList<ContextInterceptor>(a3.interceptors());
                if (a3.requiresContextInterceptor()) {
                    linkedList.add(new ContextInterceptor());
                }
                nettyServerBuilder2.addService(ServerInterceptors.intercept((BindableService)a3, linkedList));
            });
            MessagingClusterServer messagingClusterServer2 = a2;
            nettyServerBuilder2.addService((BindableService)a2.e);
            nettyServerBuilder2.addService((BindableService)messagingClusterServer2.A);
            if (messagingClusterServer2.j.getKeepAliveTime() > 0L) {
                nettyServerBuilder2.keepAliveTime(a2.j.getKeepAliveTime(), TimeUnit.MILLISECONDS);
                nettyServerBuilder2.keepAliveTimeout(a2.j.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            nettyServerBuilder2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(a2.j.getGrpcBufferedMessages()));
            nettyServerBuilder2.executor((Executor)a2.l);
            if (Epoll.isAvailable()) {
                messagingClusterServer = a2;
                nettyServerBuilder2.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(AdminApplicationController.M((Object)"V>@!A7G\u007fW=F!\u0018"))));
                nettyServerBuilder2.workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(QueryHandler.M((Object)"-e;z:l<$9f<b+{c"))));
                nettyServerBuilder2.channelType(EpollServerSocketChannel.class);
            } else {
                nettyServerBuilder2.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(AdminApplicationController.M((Object)"V>@!A7G\u007fW=F!\u0018"))));
                nettyServerBuilder2.workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(QueryHandler.M((Object)"-e;z:l<$9f<b+{c"))));
                nettyServerBuilder2.channelType(NioServerSocketChannel.class);
                messagingClusterServer = a2;
            }
            messagingClusterServer.E = nettyServerBuilder2.build();
            a2.E.start();
            a2.C.info(AdminApplicationController.M((Object)"t*Z<\u0015\u0001P C7Grv>@!A7Grf7G$P \u0015!A3G&P6\u0015=[rE=G&\u000frN/\u0015\u007f\u0015)H"), (Object)a2.j.getInternalPort(), (Object)string);
            a2.c.publishEvent((Object)new ReplicationServerStarted());
            a2.h = true;
            return;
        }
        catch (Exception exception) {
            throw new FailedToStartException(QueryHandler.M((Object)"\u001d}/{:` nnH6f )\u001dl<\u007f+{nJ\"|=}+{nZ+{8l<)(h'e+mn"), (Throwable)exception);
        }
    }
}

