/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.LifecycleController;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.StateChanged;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.RaftProperties;
import io.axoniq.axonserver.enterprise.cluster.GrpcRaftGroupFactory;
import io.axoniq.axonserver.enterprise.cluster.MetricsEvents;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftGroup;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.enterprise.replication.group.ReplicationGroupController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.message.query.subscription.metric.GlobalSubscriptionMetricRegistry;
import io.axoniq.axonserver.util.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;

@Controller
public class GrpcRaftController
implements SmartLifecycle,
RaftGroupManager {
    private final RaftGroupRepositoryManager K;
    private final Map<String, Long> M;
    public static final String d = "replication-logs";
    private final FileSystemMonitor a;
    private final LifecycleController j;
    private final Logger h;
    private final MessagingPlatformConfiguration l;
    private volatile boolean G;
    private final AtomicBoolean B;
    private final ApplicationEventPublisher A;
    private final Map<String, RaftGroup> E;
    private final RaftProperties C;
    private final GrpcRaftGroupFactory c;
    private final ReplicationGroupController e;

    public boolean isHealthy(String a2) {
        GrpcRaftController a3;
        return a3.getRaftNodeForContext(a2).E();
    }

    public void stop() {
        GrpcRaftController a4;
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.a.unregisterPath(d);
        grpcRaftController.E.forEach((a2, a3) -> a3.stop());
        a4.G = false;
    }

    public RaftNode waitForLeader(RaftGroup a2) {
        RaftGroup raftGroup = a2;
        while (!raftGroup.localNode().l() || a2.logEntryProcessor().M() == 0L) {
            try {
                Thread.sleep(100L);
                raftGroup = a2;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(GlobalSubscriptionMetricRegistry.M((Object)"\u0011d,o*x-z,*/b1f=*/k1~1d?*,exh=i7g=*4o9n=x"));
            }
        }
        return a2.localNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftNode getOrCreateRaftNode(String a2, String a3) {
        GrpcRaftController a4;
        if (!a4.G) {
            throw new IllegalStateException(MetricsEvents.M((Object)"kAJR]V\u0018WLEJPMT\u0017WPQL@WSV\u0004QJ\u0018TJK_V]WK"));
        }
        RaftGroup raftGroup = (RaftGroup)a4.E.get(a2);
        if (raftGroup != null) {
            return raftGroup.localNode();
        }
        Map map = a4.E;
        synchronized (map) {
            raftGroup = (RaftGroup)a4.E.get(a2);
            if (raftGroup == null) {
                if (a4.M(a2)) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, GlobalSubscriptionMetricRegistry.M((Object)"\no(f1i9~1e6*?x7\u007f(*<o4o,c7dxc6*(x7m*o+y"));
                }
                raftGroup = a4.M(a2, a3);
                raftGroup.startAndWait(null);
            }
        }
        return raftGroup.localNode();
    }

    public int electionTimeout() {
        GrpcRaftController a2;
        return a2.C.getMaxElectionTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ RaftGroup M(String a2, String a3) {
        GrpcRaftController a4;
        Map map = a4.E;
        synchronized (map) {
            block4: {
                GrpcRaftController grpcRaftController = a4;
                grpcRaftController.h.info(MetricsEvents.M((Object)"_E\u001e\u0018MVML\u0004JAHHQGYPQKV\u0004_VWQH"), (Object)a2);
                RaftGroup raftGroup = (RaftGroup)grpcRaftController.E.get(a2);
                if (raftGroup == null) break block4;
                return raftGroup;
            }
            a3 = a4.c.create(a2, a3);
            a3.localNode().h(arg_0 -> a4.M((RaftGroup)a3, arg_0));
            a4.E.put(a2, a3);
            return a3;
        }
    }

    public String getMyLabel(List<Node> a2) {
        a2 = a2.iterator();
        while (a2.hasNext()) {
            GrpcRaftController a3;
            Node node = (Node)a2.next();
            if (!node.getNodeName().equals(a3.l.getName())) continue;
            return node.getNodeId();
        }
        throw new RuntimeException(GlobalSubscriptionMetricRegistry.M((Object)"\u001be-f<*6e,*>c6nxi-x*o6~xd7n=*1dxd7n=y"));
    }

    public RaftNode getRaftNodeForContext(String a2) {
        GrpcRaftController a3;
        return a3.e.findReplicationGroupByContext(a2).map(arg_0 -> a3.getRaftNode(arg_0)).orElseThrow(() -> {
            GrpcRaftController a3;
            return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.l.getName() + ": Not a member of " + a2);
        });
    }

    public void start() {
        GrpcRaftController a4;
        Object object = new File(a4.C.getLogStorageFolder());
        GrpcRaftController grpcRaftController = a4;
        FileUtils.M((File)object);
        grpcRaftController.a.registerPath(d, ((File)object).toPath());
        object = grpcRaftController.K.getMyReplicationGroups();
        object.forEach(a2 -> {
            GrpcRaftController a3;
            a3.M(a2.groupId(), a2.nodeId());
        });
        a4.G = true;
        AtomicInteger atomicInteger = new AtomicInteger(object.size());
        object.forEach(a3 -> {
            GrpcRaftController a6;
            try {
                GrpcRaftController grpcRaftController = a6;
                grpcRaftController.h.info(GlobalSubscriptionMetricRegistry.M((Object)"#wb*\no(f1i9~1e6*?x7\u007f(*+~9x,c6m"), (Object)a3.groupId());
                ((RaftGroup)grpcRaftController.E.get(a3.groupId())).start(a3.role()).whenComplete((a4, a5) -> {
                    GrpcRaftController a6;
                    if (a5 == null) {
                        a6.h.info(GlobalSubscriptionMetricRegistry.M((Object)"q%0xX=z4c;k,c7dxm*e-zxy,k*~=n"), (Object)a3.groupId());
                        if (atomicInteger.decrementAndGet() == 0) {
                            GrpcRaftController grpcRaftController = a6;
                            grpcRaftController.j.setCleanShutdown();
                            grpcRaftController.B.set(true);
                            return;
                        }
                    } else {
                        a6.h.warn(MetricsEvents.M((Object)"_E\u001e\u0018v]TTM[ELMWJ\u0018CJKMT\u0018WLEJP\u0018BYMTA\\"), (Object)a3.groupId(), a5);
                    }
                });
                return;
            }
            catch (Exception a22) {
                a6.h.warn(MetricsEvents.M((Object)"CY\u0002\u0004~EQH]@\u0018PW\u0004QJQPQETMBA\u0018V]TTM[ELMWJ\u007fVWQH"), (Object)a3.groupId(), (Object)a22);
                return;
            }
        });
        a4.h.info(MetricsEvents.M((Object)"v]TTM[ELMWJ\u0018CJKMT\u0018GWJLVWHTAJ\u0004JQVJQJ_"));
        if (object.isEmpty()) {
            a4.B.set(true);
        }
    }

    public Set<String> raftGroups() {
        GrpcRaftController a2;
        return a2.E.keySet();
    }

    private /* synthetic */ void M(RaftNode a2, StateChanged a3) {
        GrpcRaftController a4;
        StateChanged stateChanged = a3;
        String string = stateChanged.h();
        long l2 = a2.h();
        if (stateChanged.E() && !a3.A()) {
            a4.A.publishEvent((Object)new ClusterEvents.LeaderStepDown(string, l2));
            return;
        }
        if (a3.A() && !a3.E()) {
            a4.A.publishEvent((Object)new ClusterEvents.BecomeLeader(string, () -> ((RaftNode)a2).M(), l2));
            return;
        }
        if (a3.M()) {
            a4.A.publishEvent((Object)new ClusterEvents.LeaderConfirmation(string, null, l2));
            return;
        }
        if (!StringUtils.isEmpty((String)a2.M())) {
            a4.A.publishEvent((Object)new ClusterEvents.LeaderConfirmation(string, a2.M(), l2));
        }
    }

    @Scheduled(fixedDelay=1000L)
    public void syncStore() {
        GrpcRaftController a4;
        if (a4.G) {
            a4.E.forEach((a2, a3) -> ((GrpcRaftGroup)a3).M());
        }
    }

    public void delete(String a2, boolean a3) {
        GrpcRaftController a4;
        if (!a3) {
            a4.M(a2);
        }
        a4.E.remove(a2);
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.e.deleteReplicationGroup(a2, a3);
        grpcRaftController.A.publishEvent((Object)new ClusterEvents.ReplicationGroupDeleted(a2, a3));
    }

    public String getMyName() {
        GrpcRaftController a2;
        return a2.l.getName();
    }

    public GrpcRaftController(MessagingPlatformConfiguration a2, RaftProperties a3, RaftGroupRepositoryManager a4, ApplicationEventPublisher a5, ReplicationGroupController a6, GrpcRaftGroupFactory a7, FileSystemMonitor a8, LifecycleController a9) {
        GrpcRaftController a10;
        GrpcRaftController grpcRaftController = a10;
        GrpcRaftController grpcRaftController2 = a10;
        GrpcRaftController grpcRaftController3 = a10;
        GrpcRaftController grpcRaftController4 = a10;
        GrpcRaftController grpcRaftController5 = a10;
        a10.h = LoggerFactory.getLogger(GrpcRaftController.class);
        GrpcRaftController grpcRaftController6 = a10;
        grpcRaftController5.E = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController7 = a10;
        grpcRaftController6.M = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController8 = a10;
        grpcRaftController5.B = new AtomicBoolean();
        grpcRaftController4.l = a2;
        grpcRaftController4.K = a4;
        grpcRaftController3.e = a6;
        grpcRaftController3.C = a3;
        grpcRaftController2.A = a5;
        grpcRaftController2.c = a7;
        grpcRaftController.a = a8;
        grpcRaftController.j = a9;
    }

    public int getPhase() {
        return 100;
    }

    public Collection<String> getRaftGroups() {
        GrpcRaftController a2;
        return a2.E.keySet();
    }

    public boolean isRunning() {
        GrpcRaftController a2;
        return a2.G;
    }

    public Optional<RaftNode> raftNode(String a2) {
        GrpcRaftController a3;
        if ((a2 = (RaftGroup)a3.E.get(a2)) != null) {
            return Optional.of(a2.localNode());
        }
        return Optional.empty();
    }

    public boolean ready() {
        GrpcRaftController a2;
        return a2.B.get();
    }

    private /* synthetic */ void M(RaftGroup a2, StateChanged a3) {
        GrpcRaftController a4;
        a4.M(a2.localNode(), a3);
    }

    public RaftNode getRaftNode(String a2) {
        GrpcRaftController a3;
        if (!a3.G) {
            throw new IllegalStateException(GlobalSubscriptionMetricRegistry.M((Object)"\u0011d1~1k4c\"k,c7dxe**+b-~<e/dxc6*(x7m*o+y"));
        }
        if (!a3.E.containsKey(a2)) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.l.getName() + ": Not a member of " + a2);
        }
        return ((RaftGroup)a3.E.get(a2)).localNode();
    }

    public RaftGroup initRaftGroup(String a2, String a3, String a4) {
        GrpcRaftController a5;
        a4 = Node.newBuilder().setNodeId(a3).setHost(a5.l.getFullyQualifiedInternalHostname()).setPort(a5.l.getInternalPort()).setNodeName(a4).setRole(Role.PRIMARY).build();
        GrpcRaftController grpcRaftController = a5;
        a3 = grpcRaftController.M(a2, a3);
        a3.raftConfiguration().update(Collections.singletonList(a4));
        grpcRaftController.h.debug(MetricsEvents.M((Object)"kPYVL\u0004^VWI\u0018MVMLvYBLcJKMT\u0018_E"), (Object)a2);
        String string = a3;
        string.startAndWait(Role.PRIMARY);
        return string;
    }

    public void prepareDeleteNodeFromReplicationGroup(String a2, String a3) {
        GrpcRaftController a4;
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.K.prepareDeleteNodeFromReplicationGroup(a2, a3);
        grpcRaftController.A.publishEvent((Object)new ClusterEvents.DeleteNodeFromReplicationGroupRequested(a2, a3));
    }

    private /* synthetic */ void M(String a2) {
        GrpcRaftController a3;
        a3.M.put(a2, System.currentTimeMillis() + 2L * (long)a3.C.getMaxElectionTimeout());
    }

    public Iterable<String> getAllNonAdminContexts() {
        GrpcRaftController a2;
        return a2.K.contexts();
    }

    private /* synthetic */ boolean M(String a2) {
        GrpcRaftController a3;
        if (a3.M.getOrDefault(a2, 0L) > System.currentTimeMillis()) {
            return true;
        }
        return false;
    }

    public RaftGroup getRaftGroup(String a2) {
        GrpcRaftController a3;
        return (RaftGroup)a3.E.get(a2);
    }
}

