/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.cluster.replication.EntryIterator;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.L;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.enterprise.replication.admin.AdminReplicationGroupController;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.replication.ReplicationLeaderProvider;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
public class RaftLeaderProviderImpl
implements ReplicationLeaderProvider {
    private final Map<String, String> l;
    private final ApplicationEventPublisher G;
    private final Set<Consumer<String>> B;
    private final Function<String, Set<String>> A;
    private static final EntryIterator E = new L();
    private final Logger C;
    private final RaftGroupManager c;
    private final String e;

    @Autowired
    public RaftLeaderProviderImpl(MessagingPlatformConfiguration a2, RaftGroupRepositoryManager a3, AdminReplicationGroupController a5, ApplicationEventPublisher a6, RaftGroupManager a7) {
        a8(a2.getName(), a4 -> {
            Set set = a3.contextsPerReplicationGroup(a4);
            if (set.isEmpty()) {
                set = a5.contextsPerReplicationGroup(a4);
            }
            return set;
        }, a6, a7);
        RaftLeaderProviderImpl a8;
    }

    public Set<String> leaderFor() {
        RaftLeaderProviderImpl a2;
        return a2.l.keySet().stream().filter(arg_0 -> a2.isLeader(arg_0)).collect(Collectors.toSet());
    }

    public String getLeader(String a2) {
        RaftLeaderProviderImpl a3;
        return (String)a3.l.get(a2);
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation a2) {
        RaftLeaderProviderImpl raftLeaderProviderImpl;
        RaftLeaderProviderImpl a3;
        long l2 = a3.c.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l2) {
            return;
        }
        if (a2.node() == null) {
            RaftLeaderProviderImpl raftLeaderProviderImpl2 = a3;
            raftLeaderProviderImpl = raftLeaderProviderImpl2;
            raftLeaderProviderImpl2.l.remove(a2.replicationGroup());
        } else {
            RaftLeaderProviderImpl raftLeaderProviderImpl3 = a3;
            raftLeaderProviderImpl = raftLeaderProviderImpl3;
            raftLeaderProviderImpl3.l.put(a2.replicationGroup(), a2.node());
        }
        ((Set)raftLeaderProviderImpl.A.apply(a2.replicationGroup())).forEach(a4 -> {
            RaftLeaderProviderImpl a5;
            a5.G.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a4, a2.replicationGroup(), a2.node(), l2));
        });
    }

    public void registerLeaderChangeListener(Consumer<String> a2) {
        RaftLeaderProviderImpl a3;
        a3.B.add(a2);
    }

    @EventListener
    public void on(ClusterEvents.LeaderStepDown a2) {
        RaftLeaderProviderImpl a3;
        long l2 = a3.c.currentTerm(a2.replicationGroup()).orElse(-1L);
        RaftLeaderProviderImpl raftLeaderProviderImpl = a3;
        raftLeaderProviderImpl.l.remove(a2.replicationGroup());
        ((Set)raftLeaderProviderImpl.A.apply(a2.replicationGroup())).forEach(a4 -> {
            RaftLeaderProviderImpl a5;
            a5.G.publishEvent((Object)new ClusterEvents.ContextLeaderStepDown(a4, a2.replicationGroup(), l2));
        });
        a3.M(a2.replicationGroup());
    }

    @EventListener
    public void on(ContextEvents.ContextDeleted a2) {
        RaftLeaderProviderImpl a5;
        long l2 = a5.c.currentTerm(a2.replicationGroup()).orElse(-1L);
        ((Set)a5.A.apply(a2.replicationGroup())).stream().filter(a3 -> a3.equals(a2.context())).forEach(a4 -> {
            RaftLeaderProviderImpl a5;
            a5.G.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a4, a2.replicationGroup(), (String)a5.l.get(a2.replicationGroup()), l2));
        });
    }

    RaftLeaderProviderImpl(String a2, Function<String, Set<String>> a3, ApplicationEventPublisher a4, RaftGroupManager a5) {
        RaftLeaderProviderImpl a6;
        RaftLeaderProviderImpl raftLeaderProviderImpl = a6;
        RaftLeaderProviderImpl raftLeaderProviderImpl2 = a6;
        a6.C = LoggerFactory.getLogger(RaftLeaderProviderImpl.class);
        RaftLeaderProviderImpl raftLeaderProviderImpl3 = a6;
        a6.l = new ConcurrentHashMap();
        RaftLeaderProviderImpl raftLeaderProviderImpl4 = a6;
        raftLeaderProviderImpl3.B = new CopyOnWriteArraySet();
        raftLeaderProviderImpl2.e = a2;
        raftLeaderProviderImpl2.A = a3;
        raftLeaderProviderImpl.G = a4;
        raftLeaderProviderImpl.c = a5;
    }

    @EventListener
    public void on(ClusterEvents.LeaderNotification a2) {
        RaftLeaderProviderImpl a3;
        long l2 = a3.c.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l2) {
            return;
        }
        if (!a2.node().equals(a3.l.get(a2.replicationGroup()))) {
            RaftLeaderProviderImpl raftLeaderProviderImpl = a3;
            raftLeaderProviderImpl.l.put(a2.replicationGroup(), a2.node());
            ((Set)raftLeaderProviderImpl.A.apply(a2.replicationGroup())).forEach(a4 -> {
                RaftLeaderProviderImpl a5;
                a5.G.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a4, a2.replicationGroup(), a2.node(), l2));
            });
            a3.M(a2.replicationGroup());
        }
    }

    public boolean isLeader(String a2) {
        RaftLeaderProviderImpl a3;
        String string = (String)a3.l.get(a2);
        a3.C.debug(QueryHandler.M((Object)"r33nj&l-b'g))\"l/m+{nr3"), (Object)a2, (Object)string);
        if (string != null && string.equals(a3.e)) {
            return true;
        }
        return false;
    }

    private /* synthetic */ void M(String a2) {
        RaftLeaderProviderImpl a4;
        a4.B.forEach(a3 -> a3.accept(a2));
    }

    @EventListener
    @Order(value=100)
    public void on(ContextEvents.ContextCreated a2) {
        RaftLeaderProviderImpl a3;
        String string = (String)a3.l.get(a2.replicationGroup());
        Optional optional = a3.c.currentTerm(a2.replicationGroup());
        if (!optional.isPresent()) {
            return;
        }
        if (a3.e.equals(string)) {
            a3.G.publishEvent((Object)new ClusterEvents.BecomeContextLeader(a2.context(), a2.replicationGroup(), () -> E, ((Long)optional.get()).longValue()));
            return;
        }
        a3.G.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a2.context(), a2.replicationGroup(), string, ((Long)optional.get()).longValue()));
    }

    @EventListener
    @Order(value=10)
    public void on(ClusterEvents.BecomeLeader a2) {
        RaftLeaderProviderImpl a3;
        long l2 = a3.c.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l2) {
            return;
        }
        RaftLeaderProviderImpl raftLeaderProviderImpl = a3;
        raftLeaderProviderImpl.l.put(a2.replicationGroup(), a3.e);
        ((Set)raftLeaderProviderImpl.A.apply(a2.replicationGroup())).forEach(a4 -> {
            RaftLeaderProviderImpl a5;
            a5.G.publishEvent((Object)new ClusterEvents.BecomeContextLeader(a4, a2.replicationGroup(), a2.unappliedEntriesSupplier(), l2));
        });
        RaftLeaderProviderImpl raftLeaderProviderImpl2 = a3;
        raftLeaderProviderImpl2.G.publishEvent((Object)new ClusterEvents.LeaderNotification(a2.replicationGroup(), a3.e, l2));
        raftLeaderProviderImpl2.M(a2.replicationGroup());
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated a2) {
        RaftLeaderProviderImpl a3;
        if (a3.l.containsKey(a2.replicationGroup())) {
            long l2 = a3.c.currentTerm(a2.replicationGroup()).orElse(-1L);
            ((Set)a3.A.apply(a2.replicationGroup())).forEach(a4 -> {
                RaftLeaderProviderImpl a5;
                a5.G.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a4, a2.replicationGroup(), (String)a5.l.get(a2.replicationGroup()), l2));
            });
        }
    }
}

