/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.admin;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.access.application.AdminApplicationController;
import io.axoniq.axonserver.admin.user.requestprocessor.UserController;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.component.processor.balancing.strategy.AdminProcessorLoadBalancingService;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminContext;
import io.axoniq.axonserver.configuration.admin.AdminContexts;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroups;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.grpc.internal.Context;
import io.axoniq.axonserver.grpc.internal.ContextConfiguration;
import io.axoniq.axonserver.grpc.internal.NodeInfoWithLabel;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupConfiguration;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupContexts;
import io.axoniq.axonserver.logging.PluginEventsLogger;
import io.axoniq.axonserver.plugin.AdminPluginContextManager;
import io.axoniq.axonserver.rest.svg.jsfunction.ShowDetail;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AdminReplicationGroupController {
    private final AdminContexts j;
    private final AdminConfigurationFactory h;
    private final AdminPluginContextManager l;
    private final ApplicationEventPublisher G;
    private final AdminProcessorLoadBalancingService B;
    private final AdminApplicationController A;
    private final AdminReplicationGroups E;
    private final UserController C;
    private final ClusterController c;
    private final Logger e;

    private static /* synthetic */ AdminContext M(AdminReplicationGroup a2, ContextConfiguration a3) {
        return a2.addContext(a3.getContext());
    }

    @Transactional
    public void unregisterAllAdminData() {
        AdminReplicationGroupController a2;
        AdminReplicationGroupController adminReplicationGroupController = a2;
        adminReplicationGroupController.e.debug(PluginEventsLogger.M((Object)"sHUEBM^C\u0010ETIYJ\u0010VUT\\MSEDM_J\u0010CBKET\u0010@UBYJYPYK^W"));
        adminReplicationGroupController.E.deleteAll();
        adminReplicationGroupController.C.deleteAll();
        adminReplicationGroupController.A.clearApplications();
        adminReplicationGroupController.j.deleteAll();
        adminReplicationGroupController.l.deleteAll();
        adminReplicationGroupController.B.deleteAll();
    }

    public int count() {
        AdminReplicationGroupController a2;
        return (int)a2.E.count();
    }

    @Transactional
    public void unregisterContext(String a3, String a4) {
        AdminReplicationGroupController a5;
        a5.j.findById(a4).ifPresent(a2 -> a2.getReplicationGroup().removeContext(a2));
        AdminReplicationGroupController adminReplicationGroupController = a5;
        adminReplicationGroupController.A.removeRolesForContext(a4);
        adminReplicationGroupController.C.removeRolesForContext(a4);
        adminReplicationGroupController.B.deleteByContext(a4);
        adminReplicationGroupController.l.delete(a4);
        adminReplicationGroupController.G.publishEvent((Object)new ClusterEvents.ReplicationGroupUpdated(a3));
        adminReplicationGroupController.G.publishEvent((Object)new ContextEvents.ContextUnregisteredInAdmin(a4));
    }

    public Set<String> contextsPerReplicationGroup(String a3) {
        AdminReplicationGroupController a4;
        return a4.E.findByName(a3).map(a2 -> a2.getContexts().stream().map(AdminContext::getName).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    @Transactional
    public void unregisterAllContexts() {
        AdminReplicationGroupController a2;
        a2.j.deleteAll();
    }

    @Transactional
    public void registerContext(String a2, String a3, Map<String, String> a4) {
        AdminReplicationGroupController a6;
        a6.E.findByName(a2).ifPresent(a5 -> {
            AdminReplicationGroupController a6;
            if (!a6.M(a5, a3)) {
                AdminReplicationGroupController adminReplicationGroupController = a6;
                AdminContext adminContext = adminReplicationGroupController.h.adminContext(a3);
                AdminReplicationGroup adminReplicationGroup = a5;
                adminContext.setMetaDataMap(a4);
                adminContext.setReplicationGroup(adminReplicationGroup);
                adminReplicationGroup.addContext(adminContext);
                adminReplicationGroupController.G.publishEvent((Object)new ClusterEvents.ReplicationGroupUpdated(a2));
                adminReplicationGroupController.G.publishEvent((Object)new ContextEvents.ContextRegisteredInAdmin(a3));
            }
        });
    }

    private /* synthetic */ void M(Map a2, ReplicationGroupConfiguration a3, Map a4, AdminReplicationGroup a5, String a6, NodeInfoWithLabel a7) {
        if (!a2.containsKey(a6)) {
            AdminReplicationGroupController a8;
            a8.e.debug(ShowDetail.M((Object)"\u001e!_|+3\u00019E2\n(E5\u000b|\u0006)\u0017.\u00002\u0011|\u00063\u000b:\f;\u0010.\u0004(\f3\u000b|\u001e!"), (Object)a3.getReplicationGroupName(), (Object)a6);
            ((ClusterNode)a4.get(a6)).addReplicationGroup(a5, a7.getLabel(), a7.getRole());
        }
    }

    public Optional<AdminReplicationGroup> findByName(String a2) {
        AdminReplicationGroupController a3;
        return a3.E.findByName(a2);
    }

    @Transactional
    public void updateContext(String a2, Map<String, String> a3) {
        AdminReplicationGroupController a5;
        a5.j.findById(a2).ifPresent(a4 -> {
            AdminReplicationGroupController a5;
            a4.setMetaDataMap(a3);
            a5.j.save(a4);
            a5.G.publishEvent((Object)new ContextEvents.ContextUpdatedInAdmin(a2));
        });
    }

    @Transactional
    public void updateReplicationGroup(ContextConfiguration a2) {
        AdminReplicationGroupController a3;
        ReplicationGroupConfiguration replicationGroupConfiguration = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName(a2.getContext()).addAllNodes((Iterable)a2.getNodesList()).build();
        AdminReplicationGroupController adminReplicationGroupController = a3;
        replicationGroupConfiguration = adminReplicationGroupController.updateReplicationGroup(replicationGroupConfiguration);
        adminReplicationGroupController.j.findById(a2.getContext()).orElseGet(() -> AdminReplicationGroupController.M((AdminReplicationGroup)replicationGroupConfiguration, a2)).setMetaDataMap(a2.getMetaDataMap());
    }

    private /* synthetic */ void M(Map a2, ReplicationGroupConfiguration a3, AdminReplicationGroup a4, String a5, ClusterNode a6) {
        if (!a2.containsKey(a5)) {
            AdminReplicationGroupController a7;
            a7.e.debug(PluginEventsLogger.M((Object)"KY\n\u0004~KTA\u0010J_P\u0010M^\u0004^AG\u0004SK^BYCEVQPYK^\u0004KY"), (Object)a3.getReplicationGroupName(), (Object)a5);
            a6.removeReplicationGroup(a4);
        }
    }

    private /* synthetic */ boolean M(AdminReplicationGroup a2, String a4) {
        return a2.getContexts().stream().anyMatch(a3 -> a3.getName().equals(a4));
    }

    @Transactional
    public void registerContexts(ReplicationGroupContexts a2) {
        Iterator iterator;
        Iterator iterator2 = iterator = a2.getContextList().iterator();
        while (iterator2.hasNext()) {
            AdminReplicationGroupController a3;
            Context context = (Context)iterator.next();
            iterator2 = iterator;
            a3.registerContext(a2.getReplicationGroupName(), context.getContextName(), context.getMetaDataMap());
        }
    }

    public Stream<AdminReplicationGroup> findAll() {
        AdminReplicationGroupController a2;
        return a2.E.findAll();
    }

    public int nrOfNodesInRole(Role a4, Set<String> a5) {
        AdminReplicationGroupController a6;
        return (int)a6.E.findAll().flatMap(a2 -> a2.getMembers().stream()).filter(a3 -> a4.equals((Object)a3.getRole())).map(a2 -> a2.getClusterNode().getName()).filter(a3 -> {
            if (!a5.contains(a3)) {
                return true;
            }
            return false;
        }).distinct().count();
    }

    public AdminReplicationGroupController(AdminReplicationGroups a2, AdminContexts a3, AdminApplicationController a4, UserController a5, ClusterController a6, AdminProcessorLoadBalancingService a7, AdminPluginContextManager a8, AdminConfigurationFactory a9, ApplicationEventPublisher a10) {
        AdminReplicationGroupController a11;
        AdminReplicationGroupController adminReplicationGroupController = a11;
        AdminReplicationGroupController adminReplicationGroupController2 = a11;
        AdminReplicationGroupController adminReplicationGroupController3 = a11;
        AdminReplicationGroupController adminReplicationGroupController4 = a11;
        AdminReplicationGroupController adminReplicationGroupController5 = a11;
        adminReplicationGroupController5.e = LoggerFactory.getLogger(AdminReplicationGroupController.class);
        adminReplicationGroupController5.E = a2;
        adminReplicationGroupController4.j = a3;
        adminReplicationGroupController4.A = a4;
        adminReplicationGroupController3.C = a5;
        adminReplicationGroupController3.c = a6;
        adminReplicationGroupController2.B = a7;
        adminReplicationGroupController2.l = a8;
        adminReplicationGroupController.h = a9;
        adminReplicationGroupController.G = a10;
    }

    @EventListener
    @Transactional
    public void on(ClusterEvents.DeleteNodeFromReplicationGroupRequested a2) {
        AdminReplicationGroupController a3;
        a3.E.findByName(a2.replicationGroup()).ifPresent(a4 -> {
            AdminReplicationGroupController a5;
            a4.getMember(a2.node()).ifPresent(a3 -> {
                AdminReplicationGroupController a4;
                a3.setPendingDelete(true);
                a4.E.save(a4);
            });
        });
    }

    public Collection<String> getNodeNames(String a2) {
        AdminReplicationGroupController a3;
        return a3.E.findByName(a2).map(AdminReplicationGroup::getMemberNames).orElse(Collections.emptyList());
    }

    @Transactional
    public void registerReplicationGroup(ReplicationGroupConfiguration a2) {
        Iterator iterator;
        AdminReplicationGroupController a3;
        AdminReplicationGroup adminReplicationGroup = a3.h.adminReplicationGroup(a2.getReplicationGroupName());
        Iterator iterator2 = iterator = a2.getNodesList().iterator();
        while (iterator2.hasNext()) {
            NodeInfoWithLabel nodeInfoWithLabel = (NodeInfoWithLabel)iterator.next();
            String string = nodeInfoWithLabel.getNode().getNodeName();
            iterator2 = iterator;
            a3.c.getNode(string).addReplicationGroup(adminReplicationGroup, nodeInfoWithLabel.getLabel(), nodeInfoWithLabel.getRole());
        }
        a3.E.save(adminReplicationGroup);
        a3.G.publishEvent((Object)new ClusterEvents.ReplicationGroupCreated(a2.getReplicationGroupName()));
    }

    @Transactional
    public AdminReplicationGroup updateReplicationGroup(ReplicationGroupConfiguration a2) {
        Iterator iterator;
        AdminReplicationGroupController a4;
        Optional optional = a4.E.findByName(a2.getReplicationGroupName());
        if (!a2.getPending() && a2.getNodesCount() == 0) {
            optional.ifPresent(a3 -> {
                AdminReplicationGroupController a4;
                HashSet hashSet = new HashSet(a3.getContexts());
                AdminReplicationGroupController adminReplicationGroupController = a4;
                adminReplicationGroupController.E.delete(a3);
                hashSet.forEach(a2 -> {
                    AdminReplicationGroupController a3;
                    AdminReplicationGroupController adminReplicationGroupController = a3;
                    adminReplicationGroupController.C.removeRolesForContext(a2.getName());
                    adminReplicationGroupController.A.removeRolesForContext(a2.getName());
                    adminReplicationGroupController.B.deleteByContext(a2.getName());
                    adminReplicationGroupController.l.delete(a2.getName());
                });
            });
            return null;
        }
        optional = optional.orElseGet(() -> {
            AdminReplicationGroupController a3;
            AdminReplicationGroupController adminReplicationGroupController = a3;
            a2 = adminReplicationGroupController.h.adminReplicationGroup(a2.getReplicationGroupName());
            return adminReplicationGroupController.E.save((AdminReplicationGroup)a2);
        });
        optional.setChangePending(a2.getPending());
        HashMap<String, ClusterNode> hashMap = new HashMap<String, ClusterNode>();
        optional.getMembers().forEach(a3 -> hashMap.put(a3.getClusterNode().getName(), a3.getClusterNode()));
        HashMap<String, NodeInfoWithLabel> hashMap2 = new HashMap<String, NodeInfoWithLabel>();
        a2.getNodesList().forEach(a3 -> hashMap2.put(a3.getNode().getNodeName(), (NodeInfoWithLabel)a3));
        HashMap<String, ClusterNode> hashMap3 = new HashMap<String, ClusterNode>();
        Iterator iterator2 = iterator = a2.getNodesList().iterator();
        while (iterator2.hasNext()) {
            NodeInfoWithLabel nodeInfoWithLabel = (NodeInfoWithLabel)iterator.next();
            String string = nodeInfoWithLabel.getNode().getNodeName();
            ClusterNode clusterNode = a4.c.getNode(string);
            if (clusterNode == null) {
                AdminReplicationGroupController adminReplicationGroupController = a4;
                adminReplicationGroupController.e.debug(ShowDetail.M((Object)"'\u0018fE\u001f\u00179\u0004(\f2\u0002|\u000b9\u0012|\u00063\u000b2\u0000?\u00115\n2E(\n|\u001e!"), (Object)a2.getReplicationGroupName(), (Object)nodeInfoWithLabel.getNode().getNodeName());
                clusterNode = adminReplicationGroupController.c.addConnection(nodeInfoWithLabel.getNode());
            }
            hashMap3.put(string, clusterNode);
            iterator2 = iterator;
        }
        hashMap.forEach((arg_0, arg_1) -> a4.M(hashMap2, a2, (AdminReplicationGroup)optional, arg_0, arg_1));
        hashMap2.forEach((arg_0, arg_1) -> a4.M(hashMap, a2, hashMap3, (AdminReplicationGroup)optional, arg_0, arg_1));
        a4.G.publishEvent((Object)new ClusterEvents.ReplicationGroupUpdated(optional.getName()));
        return optional;
    }

    @EventListener
    @Transactional
    public void on(ClusterEvents.ReplicationGroupDeleted a2) {
        if (RaftAdminGroup.M((String)a2.replicationGroup())) {
            AdminReplicationGroupController a3;
            a3.unregisterAllAdminData();
        }
    }
}

