/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.admin;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.replication.admin.LocalRaftConfigService;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigService;
import io.axoniq.axonserver.enterprise.replication.admin.RemoteRaftConfigService;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ChannelProvider;
import io.axoniq.axonserver.grpc.internal.RaftConfigServiceGrpc;
import io.axoniq.axonserver.replication.ReplicationLeaderProvider;
import io.grpc.Channel;
import org.springframework.stereotype.Component;

@Component
public class RaftConfigServiceFactory {
    private final ClusterController A;
    private final RaftConfigService E;
    private final ChannelProvider C;
    private final ReplicationLeaderProvider c;
    private final MessagingPlatformConfiguration e;

    public RaftConfigService getLocalRaftConfigService() {
        RaftConfigServiceFactory a2;
        return a2.E;
    }

    public RaftConfigService getRaftConfigService() {
        RaftConfigServiceFactory a2;
        if (a2.c.isLeader(RaftAdminGroup.M())) {
            return a2.E;
        }
        String string = a2.c.getLeader(RaftAdminGroup.M());
        if (string == null) {
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, "No leader for " + RaftAdminGroup.M());
        }
        ClusterNode clusterNode = a2.A.getNode(string);
        if (clusterNode == null) {
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, "Leader node " + string + " not found for " + RaftAdminGroup.M());
        }
        return new RemoteRaftConfigService(RaftConfigServiceGrpc.newStub((Channel)a2.C.get(clusterNode)));
    }

    public RaftConfigServiceGrpc.RaftConfigServiceBlockingStub getRaftConfigServiceStub(String a2, int a3) {
        RaftConfigServiceFactory a4;
        return RaftConfigServiceGrpc.newBlockingStub((Channel)a4.C.get(a2, a3));
    }

    public RaftConfigServiceFactory(MessagingPlatformConfiguration a2, ClusterController a3, LocalRaftConfigService a4, ReplicationLeaderProvider a5, ChannelProvider a6) {
        RaftConfigServiceFactory a7;
        RaftConfigServiceFactory raftConfigServiceFactory = a7;
        RaftConfigServiceFactory raftConfigServiceFactory2 = a7;
        a7.e = a2;
        raftConfigServiceFactory2.A = a3;
        raftConfigServiceFactory2.E = a4;
        raftConfigServiceFactory.c = a5;
        raftConfigServiceFactory.C = a6;
    }
}

