/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.group;

import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.replication.group.LocalRaftGroupService;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupService;
import io.axoniq.axonserver.enterprise.replication.group.RemoteRaftGroupService;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ChannelProvider;
import io.axoniq.axonserver.grpc.internal.RaftGroupServiceGrpc;
import io.axoniq.axonserver.replication.ReplicationLeaderProvider;
import io.grpc.Channel;
import org.springframework.stereotype.Component;

@Component
public class RaftGroupServiceFactory {
    private final ClusterController A;
    private final ChannelProvider E;
    private final MessagingPlatformConfiguration C;
    private final ReplicationLeaderProvider c;
    private final RaftGroupService e;

    public RaftGroupService getRaftGroupServiceForNode(String a2) {
        RaftGroupServiceFactory a3;
        if (a3.C.getName().equals(a2)) {
            return a3.e;
        }
        ClusterNode clusterNode = a3.A.getNode(a2);
        if (clusterNode == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, a2 + " not found");
        }
        return new RemoteRaftGroupService(RaftGroupServiceGrpc.newStub((Channel)a3.E.get(clusterNode)));
    }

    public RaftGroupService getRaftGroupServiceForNode(ClusterNode a2) {
        RaftGroupServiceFactory a3;
        if (a3.C.getName().equals(a2.getName())) {
            return a3.e;
        }
        return new RemoteRaftGroupService(RaftGroupServiceGrpc.newStub((Channel)a3.E.get(a2)));
    }

    public RaftGroupServiceFactory(MessagingPlatformConfiguration a2, ClusterController a3, LocalRaftGroupService a4, ReplicationLeaderProvider a5, ChannelProvider a6) {
        RaftGroupServiceFactory a7;
        RaftGroupServiceFactory raftGroupServiceFactory = a7;
        RaftGroupServiceFactory raftGroupServiceFactory2 = a7;
        a7.C = a2;
        raftGroupServiceFactory2.A = a3;
        raftGroupServiceFactory2.e = a4;
        raftGroupServiceFactory.c = a5;
        raftGroupServiceFactory.E = a6;
    }

    public String getLeader(String a2) {
        RaftGroupServiceFactory a3;
        return a3.c.getLeader(a2);
    }

    public RaftGroupService getRaftGroupService(String a2) {
        RaftGroupServiceFactory a3;
        if (a3.c.isLeader(a2)) {
            return a3.e;
        }
        String string = a3.c.getLeader(a2);
        if (string == null) {
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, "No leader for " + a2);
        }
        a2 = a3.A.getNode(string);
        return new RemoteRaftGroupService(RaftGroupServiceGrpc.newStub((Channel)a3.E.get((ClusterNode)a2)));
    }
}

