/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.component.version.ClientVersionsCache;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.internal.ManagedChannelHelper;
import io.axoniq.axonserver.enterprise.context.AdminContextController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ChannelExceptionHandler;
import io.axoniq.axonserver.grpc.ChannelManager;
import io.axoniq.axonserver.grpc.ChannelProvider;
import io.axoniq.axonserver.grpc.GrpcChannelProvider;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.TlsChannelCredentials;
import io.grpc.util.AdvancedTlsX509TrustManager;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.TrustManager;
import org.springframework.context.Lifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component
public class ChannelManager
implements ChannelProvider,
GrpcChannelProvider,
ChannelExceptionHandler,
Lifecycle {
    private final ExecutorService l;
    private ChannelCredentials G;
    private final Supplier<ScheduledExecutorService> B;
    private AdvancedTlsX509TrustManager.Closeable A;
    private final Map<ChannelKey, ManagedChannel> E;
    private final AdminNodes C;
    private final MessagingPlatformConfiguration c;
    private volatile boolean e;

    public Channel get(String a3, int a4) {
        ChannelManager a5;
        a3 = new ChannelKey(a3, a4);
        return (Channel)a5.E.computeIfAbsent(a3, a2 -> {
            ChannelManager a3;
            ChannelManager channelManager = a3;
            ChannelKey channelKey = a2;
            return ManagedChannelHelper.M((ExecutorService)channelManager.l, (MessagingPlatformConfiguration)channelManager.c, (String)channelKey.e, (int)channelKey.c, (ChannelCredentials)a3.G);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        ChannelManager channelManager;
        ChannelManager a2;
        if (a2.M()) {
            try {
                TlsChannelCredentials.Builder builder;
                TlsChannelCredentials.Builder builder2 = TlsChannelCredentials.newBuilder();
                AdvancedTlsX509TrustManager advancedTlsX509TrustManager = AdvancedTlsX509TrustManager.newBuilder().setVerification(a2.c.getSsl().getTrustManagerVerification()).build();
                if (a2.c.getSsl().getInternalTrustManagerFile() != null) {
                    a2.A = advancedTlsX509TrustManager.updateTrustCredentialsFromFile(new File(a2.c.getSsl().getInternalTrustManagerFile()), 1L, TimeUnit.MINUTES, (ScheduledExecutorService)a2.B.get());
                    builder = builder2;
                } else {
                    advancedTlsX509TrustManager.useSystemDefaultTrustCerts();
                    builder = builder2;
                }
                TrustManager[] trustManagerArray = new TrustManager[1];
                trustManagerArray[0] = advancedTlsX509TrustManager;
                builder.trustManager(trustManagerArray);
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray2[0] = advancedTlsX509TrustManager;
                a2.G = builder2.trustManager(trustManagerArray2).build();
                channelManager = a2;
            }
            catch (Exception exception) {
                throw new FailedToStartException(ClientVersionsCache.M((Object)"yoMc@d\fuC!OsI`Xd\fBD`BoIma`B`Kd^"), (Throwable)exception);
            }
        } else {
            channelManager = a2;
        }
        channelManager.e = true;
    }

    public Channel channelForNode(String a2) {
        ChannelManager a3;
        a2 = (ClusterNode)a3.C.findById(a2).orElseThrow(() -> new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, a2 + ": Node not found"));
        return a3.get(a2.getInternalHostName(), a2.getGrpcInternalPort().intValue());
    }

    public ChannelManager(MessagingPlatformConfiguration a2, AdminNodes a3, Supplier<ScheduledExecutorService> a4) {
        ChannelManager a5;
        ChannelManager channelManager = a5;
        ChannelManager channelManager2 = a5;
        ChannelManager channelManager3 = a5;
        channelManager3.E = new ConcurrentHashMap();
        channelManager2.c = a2;
        channelManager2.l = Executors.newFixedThreadPool(a2.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(AdminContextController.M((Object)"\u0007\u0010\u0011\u000f\u0010\u0019\u0016Q\u0016\u0019\u0015\t\u0001\u000f\u0010Q\u0001\u0004\u0001\u001f\u0011\b\u000b\u000eI")));
        channelManager.C = a3;
        channelManager.B = a4;
    }

    public boolean isRunning() {
        ChannelManager a2;
        return a2.e;
    }

    public void handleChannelException(String a22, int a3, Throwable a4) {
        if ((a4 = Status.fromThrowable((Throwable)a4).getCode()).equals(Status.Code.UNAVAILABLE) || a4.equals(Status.Code.INTERNAL)) {
            ChannelManager a5;
            a22 = new ChannelKey(a22, a3);
            if ((a22 = (ManagedChannel)a5.E.remove(a22)) != null) {
                try {
                    if (!a22.shutdown().awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                        a22.shutdownNow();
                        return;
                    }
                }
                catch (InterruptedException a22) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private /* synthetic */ boolean M() {
        ChannelManager a2;
        if (a2.c.getSsl() != null && a2.c.getSsl().isEnabled()) {
            return true;
        }
        return false;
    }

    public Channel channelForAddress(String a2, int a3) {
        ChannelManager a4;
        return a4.get(a2, a3);
    }

    public void stop() {
        ChannelManager a2;
        if (a2.A != null) {
            a2.A.close();
        }
        ChannelManager channelManager = a2;
        channelManager.l.shutdown();
        channelManager.E.forEach((a22, a3) -> {
            if (!a3.isShutdown()) {
                try {
                    ChannelManager a4;
                    a3.shutdown().awaitTermination(100L, TimeUnit.MILLISECONDS);
                    a4.E.remove(a22, a3);
                    return;
                }
                catch (InterruptedException a22) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        a2.e = false;
    }
}

