/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.CommandService;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcCommandDispatcherListener;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.grpc.SerializedCommandProviderInbound;
import io.axoniq.axonserver.grpc.SerializedCommandResponse;
import io.axoniq.axonserver.grpc.command.CommandProviderOutbound;
import io.axoniq.axonserver.grpc.command.CommandServiceGrpc;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.message.ByteStringMarshaller;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.transport.rest.v2.LoggingRestControllerV2;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service(value="CommandService")
public class CommandService
implements AxonServerClientService {
    private final Topology M;
    private static final MethodDescriptor<ByteString, SerializedCommandResponse> d = CommandServiceGrpc.getDispatchMethod().toBuilder((MethodDescriptor.Marshaller)ByteStringMarshaller.M(), ProtoUtils.marshaller((Message)SerializedCommandResponse.getDefaultInstance())).build();
    private final Logger a;
    private final AuthenticationProvider j;
    private final ClientIdRegistry h;
    private final ApplicationEventPublisher l;
    private static final MethodDescriptor<CommandProviderOutbound, SerializedCommandProviderInbound> G = CommandServiceGrpc.getOpenStreamMethod().toBuilder(ProtoUtils.marshaller((Message)CommandProviderOutbound.getDefaultInstance()), ProtoUtils.marshaller((Message)SerializedCommandProviderInbound.getDefaultInstance())).build();
    private final InstructionAckSource<SerializedCommandProviderInbound> B;
    private final MeterFactory A;
    private final CommandDispatcher E;
    private final Map<ClientStreamIdentification, GrpcCommandDispatcherListener> C;
    @Value(value="${axoniq.axonserver.command-threads:1}")
    private int c;
    private final ContextProvider e;

    private /* synthetic */ boolean M(InstructionAck a2) {
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }

    public void dispatch(ByteString a22, StreamObserver<SerializedCommandResponse> a3) {
        CommandService a5;
        a22 = new SerializedCommand(a22);
        String string = a22.wrapped().getClientId();
        if (a5.a.isTraceEnabled()) {
            a5.a.trace(HeartbeatMonitor.M((Object)"\u0016{W&?c\u000ec\u0004p\bbMe\u0002k\u0000g\u0003bW&\u0016{"), (Object)string, (Object)a22.wrapped().getName());
        }
        try {
            CommandService commandService = a5;
            commandService.E.dispatch(commandService.e.getContext(), (Authentication)a5.j.get(), (SerializedCommand)a22, a4 -> {
                CommandService a5;
                a5.M(string, a4, a3);
            });
            return;
        }
        catch (Exception a22) {
            Exception exception = a22;
            a5.a.warn(LoggingRestControllerV2.M((Object)"\u000ej9s+w)k#m-#,b#o/gjt#w\"#?m/{:f)w/gjf8q%q"), (Throwable)exception);
            a3.onError((Throwable)GrpcExceptionBuilder.build((Throwable)exception));
            return;
        }
    }

    public void completeStreamForInactivity(String a2, ClientStreamIdentification a3) {
        CommandService a4;
        if (a4.C.containsKey(a3)) {
            String string = "Command stream inactivity for " + a3.h();
            string = new ApplicationInactivityException(string);
            ((GrpcCommandDispatcherListener)a4.C.remove(a3)).cancelAndCompleteStreamExceptionally((Throwable)((Object)string));
            CommandService commandService = a4;
            commandService.a.debug(HeartbeatMonitor.M((Object)".i\u0000k\fh\t&>r\u001fc\fkMe\u0001i\u001ec\t&\u000bi\u001f&\u000ej\u0004c\u0003rW&\u0016{"), (Object)a3);
            commandService.l.publishEvent((Object)new TopologyEvents.CommandHandlerDisconnected(a3.B(), a2, a3.h()));
        }
    }

    public CommandService(Topology topology, CommandDispatcher commandDispatcher, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, MeterFactory meterFactory, ApplicationEventPublisher eventPublisher, @Qualifier(value="commandInstructionAckSource") InstructionAckSource<SerializedCommandProviderInbound> a2) {
        CommandService commandService = this;
        CommandService commandService2 = this;
        CommandService commandService3 = this;
        CommandService commandService4 = this;
        CommandService commandService5 = this;
        commandService5.a = LoggerFactory.getLogger(CommandService.class);
        CommandService commandService6 = this;
        commandService5.C = new ConcurrentHashMap();
        commandService5.c = 1;
        commandService4.M = topology;
        commandService4.E = commandDispatcher;
        commandService3.e = contextProvider;
        commandService3.j = authenticationProvider;
        commandService2.h = clientIdRegistry;
        commandService2.A = meterFactory;
        commandService.l = eventPublisher;
        commandService.B = a2;
    }

    public Set<GrpcCommandDispatcherListener> listeners() {
        CommandService a2;
        return new HashSet<GrpcCommandDispatcherListener>(a2.C.values());
    }

    private /* synthetic */ void M(String a2, SerializedCommandResponse a32, StreamObserver<SerializedCommandResponse> a4) {
        try {
            StreamObserver<SerializedCommandResponse> streamObserver = a4;
            streamObserver.onNext((Object)a32);
            streamObserver.onCompleted();
            return;
        }
        catch (RuntimeException a32) {
            CommandService a5;
            a5.a.debug(LoggingRestControllerV2.M((Object)"\u0018f9s%m9fjw%#)o#f$wjx7#,b#o/g"), (Object)a2, (Object)a32);
            return;
        }
    }

    public StreamObserver<CommandProviderOutbound> openStream(StreamObserver<SerializedCommandProviderInbound> a2) {
        CommandService a3;
        String string = a3.e.getContext();
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        1 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        CommandService commandService = a3;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public final ServerServiceDefinition bindService() {
        CommandService a2;
        return ServerServiceDefinition.builder((String)HeartbeatMonitor.M((Object)"\u0004iCg\u0015i\u0003o\u001c(\f~\u0002h\u001ec\u001fp\btCa\u001fv\u000e(\u000ei\u0000k\fh\t(.i\u0000k\fh\tU\bt\u001bo\u000ec")).addMethod(G, ServerCalls.asyncBidiStreamingCall(arg_0 -> a2.openStream(arg_0))).addMethod(d, ServerCalls.asyncUnaryCall((arg_0, arg_1) -> a2.dispatch(arg_0, arg_1))).build();
    }

    @PreDestroy
    public void cleanup() {
        CommandService a4;
        a4.C.forEach((a2, a3) -> a3.cancel());
        a4.C.clear();
    }
}

