/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.access.application.AdminApplicationController;
import io.axoniq.axonserver.applicationevents.SubscriptionEvents;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.serializer.Media;
import io.axoniq.axonserver.transport.rest.LoadBalancingManagementRestController;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
public class DefaultClientIdRegistry
implements ClientIdRegistry {
    private final Map<ClientIdRegistry.ConnectionType, Map<String, ClientContext>> c;
    private final Logger e = LoggerFactory.getLogger(DefaultClientIdRegistry.class);

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected a2) {
        DefaultClientIdRegistry a3;
        DefaultClientIdRegistry defaultClientIdRegistry = a3;
        defaultClientIdRegistry.e.info(AdminApplicationController.M((Object)"\u0002Y3A4Z XrF&G7T?\u00156\\!V=[<P1A7Qh\u0015)Hrn!A P3Xr\\6\u0015\u007f\u000brN/h"), (Object)a2.h(), (Object)a2.B());
        defaultClientIdRegistry.unregister(a2.B(), ClientIdRegistry.ConnectionType.C);
    }

    public ClientContext clientId(String a2) {
        int n;
        ClientIdRegistry.ConnectionType[] connectionTypeArray = ClientIdRegistry.ConnectionType.values();
        int n2 = connectionTypeArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            DefaultClientIdRegistry a3;
            ClientIdRegistry.ConnectionType connectionType = connectionTypeArray[n];
            if ((connectionType = (ClientContext)a3.c.getOrDefault(connectionType, Collections.emptyMap()).get(a2)) != null) {
                return connectionType;
            }
            n3 = ++n;
        }
        throw new IllegalStateException("Client " + a2 + " is not present in this registry.");
    }

    @EventListener
    public void on(TopologyEvents.QueryHandlerDisconnected a2) {
        DefaultClientIdRegistry a3;
        DefaultClientIdRegistry defaultClientIdRegistry = a3;
        defaultClientIdRegistry.e.info(LoadBalancingManagementRestController.M((Object)"WCcD\u007f\u0016uBtSg[&RoEeYhXcUrSb\f&M{\u0016]ErDcWk\u0016oR&\u001b8\u0016}K["), (Object)a2.B(), (Object)a2.h());
        defaultClientIdRegistry.unregister(a2.h(), ClientIdRegistry.ConnectionType.E);
    }

    @EventListener
    public void on(SubscriptionEvents.SubscribeQuery a2) {
        DefaultClientIdRegistry a3;
        SubscriptionEvents.SubscribeQuery subscribeQuery = a2;
        String string = subscribeQuery.M().B();
        String string2 = subscribeQuery.M().h();
        if (!a3.c.getOrDefault(ClientIdRegistry.ConnectionType.E, Collections.emptyMap()).containsKey(string2)) {
            a3.e.info(AdminApplicationController.M((Object)"\u0003@7G+\u0015!A P3XrV=[<P1A7Qh\u0015)Hrn!A P3Xr\\6\u0015\u007f\u000brN/h"), (Object)string, (Object)string2);
        }
        a3.register(string2, new ClientContext(string, a2.M()), ClientIdRegistry.ConnectionType.E);
    }

    public boolean unregister(String a2, ClientIdRegistry.ConnectionType a3) {
        DefaultClientIdRegistry a4;
        if ((ClientContext)a4.c.getOrDefault(a3, Collections.emptyMap()).remove(a2) != null) {
            return true;
        }
        return false;
    }

    @Order(value=0)
    @EventListener
    public void on(TopologyEvents.ApplicationConnected a2) {
        DefaultClientIdRegistry a3;
        DefaultClientIdRegistry defaultClientIdRegistry = a3;
        defaultClientIdRegistry.e.info(LoadBalancingManagementRestController.M((Object)"VZgB`Yt[&ErDcWk\u0016eYhXcUrSb\f&M{\u0016]ErDcWk\u0016oR&\u001b8\u0016}K["), (Object)a2.B(), (Object)a2.A());
        defaultClientIdRegistry.register(a2.A(), new ClientContext(a2.B(), a2.E()), ClientIdRegistry.ConnectionType.C);
    }

    public DefaultClientIdRegistry() {
        DefaultClientIdRegistry a2;
        DefaultClientIdRegistry defaultClientIdRegistry = a2;
        a2.c = new ConcurrentHashMap();
    }

    public boolean register(String a4, ClientContext a5, ClientIdRegistry.ConnectionType a6) {
        DefaultClientIdRegistry a7;
        Object object = a7.c.computeIfAbsent(a6, a2 -> new ConcurrentHashMap());
        a4 = object.put(a4, a5);
        if (a7.e.isInfoEnabled()) {
            object = object.entrySet().stream().filter(a3 -> ((ClientContext)a3.getValue()).equals((Object)a5)).map(Map.Entry::getKey).collect(Collectors.toSet());
            if (object.size() != 1) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a6;
                objectArray[1] = a5;
                objectArray[2] = object;
                a7.e.info(AdminApplicationController.M((Object)"x'Y&\\\"Y7\u0015?T\"E;[5FrS=GrN/\u0015!A P3XrS=GrV>\\7[&|6\u0015)Hh\u0015)H"), objectArray);
            }
        }
        if (a4 == null) {
            return true;
        }
        return false;
    }

    public void printOn(Media a2) {
        DefaultClientIdRegistry a5;
        a5.c.forEach((a3, a4) -> a2.with(a3.toString(), a5 -> a4.forEach((a3, a4) -> a5.with(a3, a4.toString()))));
    }

    public Set<String> streamIdsFor(ClientContext a2, ClientIdRegistry.ConnectionType a4) {
        DefaultClientIdRegistry a5;
        return Collections.unmodifiableSet(a5.c.getOrDefault(a4, Collections.emptyMap()).entrySet().stream().filter(a3 -> ((ClientContext)a3.getValue()).equals((Object)a2)).map(Map.Entry::getKey).collect(Collectors.toSet()));
    }

    @EventListener
    public void on(TopologyEvents.CommandHandlerDisconnected a2) {
        DefaultClientIdRegistry a3;
        DefaultClientIdRegistry defaultClientIdRegistry = a3;
        defaultClientIdRegistry.e.info(LoadBalancingManagementRestController.M((Object)"EYk[gXb\u0016uBtSg[&RoEeYhXcUrSb\f&M{\u0016]ErDcWk\u0016oR&\u001b8\u0016}K["), (Object)a2.M(), (Object)a2.h());
        defaultClientIdRegistry.unregister(a2.h(), ClientIdRegistry.ConnectionType.c);
    }

    @EventListener
    public void on(SubscriptionEvents.SubscribeCommand a2) {
        DefaultClientIdRegistry a3;
        SubscriptionEvents.SubscribeCommand subscribeCommand = a2;
        String string = subscribeCommand.M().h();
        String string2 = subscribeCommand.M().h();
        if (!a3.c.getOrDefault(ClientIdRegistry.ConnectionType.c, Collections.emptyMap()).containsKey(string2)) {
            a3.e.info(AdminApplicationController.M((Object)"\u0011Z?X3[6\u0015!A P3XrV=[<P1A7Qh\u0015)Hrn!A P3Xr\\6\u0015\u007f\u000brN/h"), (Object)string, (Object)string2);
        }
        a3.register(string2, new ClientContext(string, a2.M()), ClientIdRegistry.ConnectionType.c);
    }
}

