/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.processor.ClientsByEventProcessor;
import io.axoniq.axonserver.component.version.ClientVersionsCache;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.SendingStreamObserver;
import io.axoniq.axonserver.grpc.control.ClientIdentification;
import io.axoniq.axonserver.grpc.control.NodeInfo;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformInfo;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformServiceGrpc;
import io.axoniq.axonserver.grpc.control.RequestReconnect;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.topology.AxonServerNode;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.util.StreamObserverUtils;
import io.grpc.stub.StreamObserver;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service(value="PlatformService")
public class PlatformService
extends PlatformServiceGrpc.PlatformServiceImplBase
implements AxonServerClientService {
    private final ClientIdRegistry d;
    private final ContextProvider a;
    private final Topology j;
    private final Map<PlatformInboundInstruction.RequestCase, Deque<InstructionConsumer>> h;
    private final AuthenticationProvider l;
    private final Map<String, Gauge> G;
    private final MeterFactory B;
    private final InstructionAckSource<PlatformOutboundInstruction> A;
    private final ApplicationEventPublisher E;
    private final Map<ClientComponent, SendingStreamObserver<PlatformOutboundInstruction>> C;
    public static final String c = "component";
    private static final Logger e = LoggerFactory.getLogger(PlatformService.class);

    private /* synthetic */ boolean M(InstructionAck a2) {
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }

    public void requestReconnectForContext(String a2, String a4) {
        PlatformService a5;
        a5.C.keySet().stream().filter(a3 -> a3.E.equals(a2)).collect(Collectors.toSet()).forEach(a3 -> {
            PlatformService a4;
            a4.requestReconnect(a3, a4);
        });
    }

    public void getPlatformServer(ClientIdentification a2, StreamObserver<PlatformInfo> a3) {
        PlatformService a4;
        String string = a4.a.getContext();
        try {
            AxonServerNode axonServerNode = a4.j.findNodeForClient(a2.getClientId(), a2.getComponentName(), string, a2.getTagsMap());
            StreamObserver<PlatformInfo> streamObserver = a3;
            streamObserver.onNext((Object)PlatformInfo.newBuilder().setSameConnection(axonServerNode.getName().equals(a4.j.getName())).setPrimary(NodeInfo.newBuilder().setNodeName(axonServerNode.getName()).setHostName(axonServerNode.getHostName()).setGrpcPort(axonServerNode.getGrpcPort().intValue()).setHttpPort(axonServerNode.getHttpPort().intValue())).build());
            streamObserver.onCompleted();
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getClientId();
            objectArray[1] = string;
            objectArray[2] = messagingPlatformException.getMessage();
            e.info(ClientsByEventProcessor.M((Object)"%D\u0012Y\u0012\u0016\u0006_\u000eR\tX\u0007\u0016\u0014W\u0012Q\u0005B@P\u000fD@U\f_\u0005X\u0014\u0016\u001bKOM\u001d\f@M\u001d"), objectArray);
            a3.onError((Throwable)GrpcExceptionBuilder.build((Throwable)messagingPlatformException));
            return;
        }
        catch (RuntimeException runtimeException) {
            e.warn(ClientVersionsCache.M((Object)"D^sCs\fq^nOd_rEoK!OmEdBu\fsIpYd_u\fzQ"), (Object)a2, (Object)runtimeException);
            a3.onError((Throwable)GrpcExceptionBuilder.build((Throwable)runtimeException));
            return;
        }
    }

    public void onInboundInstruction(PlatformInboundInstruction.RequestCase a3, InstructionConsumer a4) {
        PlatformService a5;
        a5.h.computeIfAbsent(a3, a2 -> new ArrayDeque()).add(a4);
    }

    public boolean requestReconnect(String a2, String a4) {
        PlatformService a5;
        e.debug(ClientsByEventProcessor.M((Object)"2S\u0011C\u0005E\u0014\u0016\u0012S\u0003Y\u000eX\u0005U\u0014\f@M\u001d"), (Object)a2);
        return a5.C.keySet().stream().filter(a3 -> a3.c.equals(a2)).map(a3 -> {
            PlatformService a4;
            return a4.requestReconnect(a3, a4);
        }).findFirst().orElse(false);
    }

    private /* synthetic */ void M(ClientComponent a2, long a3, String a4) {
        e.debug(ClientVersionsCache.M((Object)"hd\u0001sIfErXd^dH!OmEdBu\f;\fzQ"), (Object)a2);
        if (a2 != null) {
            PlatformService a5;
            String[] stringArray = new String[4];
            stringArray[0] = "context";
            stringArray[1] = a2.getContext();
            stringArray[2] = c;
            stringArray[3] = a2.getComponent();
            Tags tags = Tags.of((String[])stringArray);
            a5.B.counter((MetricName)BaseMetricName.fa, tags).increment();
            if (a3 > 0L) {
                a5.B.timer((MetricName)BaseMetricName.N, tags).record(System.currentTimeMillis() - a3, TimeUnit.MILLISECONDS);
            }
            if ((tags = (SendingStreamObserver)a5.C.remove(a2)) != null) {
                StreamObserverUtils.M((StreamObserver)tags);
            }
            a5.d.unregister(a2.e, ClientIdRegistry.ConnectionType.C);
            ClientComponent clientComponent = a2;
            ClientComponent clientComponent2 = a2;
            a5.E.publishEvent((Object)new TopologyEvents.ApplicationDisconnected(clientComponent.E, clientComponent.C, clientComponent2.e, clientComponent2.c, null, a4));
        }
    }

    private /* synthetic */ void M(ClientComponent a2, Throwable a3) {
        PlatformService a4;
        SendingStreamObserver sendingStreamObserver = (SendingStreamObserver)a4.C.remove(a2);
        if (sendingStreamObserver != null) {
            StreamObserverUtils.M((StreamObserver)sendingStreamObserver, (Throwable)a3);
        }
        a4.M(a2, 0L, a3.getMessage());
    }

    private /* synthetic */ long M(String a2) {
        PlatformService a4;
        return a4.C.keySet().stream().filter(a3 -> a3.getContext().equals(a2)).count();
    }

    public PlatformService(Topology topology, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, ApplicationEventPublisher eventPublisher, MeterFactory meterFactory, @Qualifier(value="platformInstructionAckSource") InstructionAckSource<PlatformOutboundInstruction> a4) {
        PlatformService platformService = this;
        PlatformService platformService2 = this;
        PlatformService platformService3 = this;
        PlatformService platformService4 = this;
        platformService4.C = new ConcurrentHashMap();
        PlatformService platformService5 = this;
        platformService3.G = new ConcurrentHashMap();
        PlatformService platformService6 = this;
        platformService3.h = new EnumMap(PlatformInboundInstruction.RequestCase.class);
        platformService3.j = topology;
        platformService2.a = contextProvider;
        platformService2.l = authenticationProvider;
        platformService.d = clientIdRegistry;
        platformService.E = eventPublisher;
        this.B = meterFactory;
        this.A = a4;
        this.onInboundInstruction(PlatformInboundInstruction.RequestCase.ACK, (a2, a3) -> {
            PlatformService a4;
            if (a4.M((InstructionAck)(a3 = a3.getAck()))) {
                ClientComponent clientComponent = a2;
                e.warn(ClientVersionsCache.M((Object)"TBrYq\\n^uIe\fhBrXsYbXhCo\frIoX!Xn\fuDd\fb@hIoX!W|\fnJ!OnBuIyX!W|\u0002"), (Object)clientComponent.e, (Object)clientComponent.E);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.e;
            objectArray[1] = a2.E;
            objectArray[2] = a3;
            e.trace(ClientsByEventProcessor.M((Object)"2S\u0003S\t@\u0005R@_\u000eE\u0014D\u0015U\u0014_\u000fX@W\u0003]@P\u0012Y\r\u0016\u0014^\u0005\u0016\u0003Z\tS\u000eB@M\u001d\u0016\u000fP@U\u000fX\u0014S\u0018B@M\u001d\u0018@d\u0005E\u0015Z\u0014\u0016\u001bKN"), objectArray);
        });
    }

    public Set<ClientComponent> getConnectedClients() {
        PlatformService a2;
        return a2.C.keySet();
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected a2) {
        PlatformService a3;
        StreamObserver streamObserver = (StreamObserver)a3.C.remove(new ClientComponent(a2.B(), a2.h(), a2.E(), a2.l()));
        e.debug(ClientsByEventProcessor.M((Object)"W\u0010F\f_\u0003W\u0014_\u000fX@R\tE\u0003Y\u000eX\u0005U\u0014S\u0004\f@M\u001d\u001a@U\u000fX\u000eS\u0003B\tY\u000e\f@M\u001d"), (Object)a2.B(), (Object)streamObserver);
        if (streamObserver != null) {
            try {
                streamObserver.onCompleted();
                return;
            }
            catch (Exception exception) {
                e.debug(ClientVersionsCache.M((Object)"D^sCs\fvDh@d\fb@n_hBf\fu^`OjEoK!IwIoX!\\sCbIr_n^!OnBoIbXhCo\fg^nA!W|\f,\fzQ"), (Object)a2.B(), (Object)exception.getMessage());
            }
        }
    }

    private /* synthetic */ void M(ClientComponent a2, String a3, SendingStreamObserver<PlatformOutboundInstruction> a4) {
        PlatformService a5;
        e.debug(ClientsByEventProcessor.M((Object)"d\u0005Q\tE\u0014S\u0012S\u0004\u0016\u0003Z\tS\u000eB@\f@M\u001d"), (Object)a2);
        a5.C.put(a2, a4);
        ClientComponent clientComponent = a2;
        ClientComponent clientComponent2 = a2;
        a5.E.publishEvent((Object)new TopologyEvents.ApplicationConnected(clientComponent.E, clientComponent.C, clientComponent2.e, clientComponent2.c, a3, null));
    }

    public boolean requestReconnect(ClientComponent a2, String a3) {
        PlatformService a4;
        e.debug(ClientVersionsCache.M((Object)"SIpYd_u\fsIbCoBdOu\u0016!W|\f,\fzQ"), (Object)a2, (Object)a3);
        StreamObserver streamObserver = (StreamObserver)a4.C.get(a2);
        if (streamObserver != null) {
            ClientComponent clientComponent = a2;
            a4.E.publishEvent((Object)new TopologyEvents.ApplicationReconnectRequested(clientComponent.E, clientComponent.c, a2.C, a3));
            streamObserver.onNext((Object)PlatformOutboundInstruction.newBuilder().setRequestReconnect(RequestReconnect.newBuilder()).build());
            return true;
        }
        return false;
    }

    @EventListener
    public void on(TopologyEvents.RequestClientReconnect a2) {
        PlatformService a3;
        a3.requestReconnect(a2.M(), ClientsByEventProcessor.M((Object)"2S\u0011C\u0005E\u0014S\u0004\u0016\u0002O@C\u0013S\u0012"));
    }

    public void sendToClient(String a2, String a4, PlatformOutboundInstruction a5) {
        PlatformService a6;
        a6.C.entrySet().stream().filter(a3 -> ((ClientComponent)a3.getKey()).c.equals(a4)).filter(a3 -> ((ClientComponent)a3.getKey()).E.equals(a2)).map(Map.Entry::getValue).forEach(a3 -> a3.onNext((Object)a5));
    }

    public void sendToClientStreamId(String a2, PlatformOutboundInstruction a4) {
        PlatformService a5;
        a5.C.entrySet().stream().filter(a3 -> a2.equals(((ClientComponent)a3.getKey()).e)).map(Map.Entry::getValue).collect(Collectors.toList()).forEach(a3 -> a3.onNext((Object)a4));
    }

    public StreamObserver<PlatformInboundInstruction> openStream(StreamObserver<PlatformOutboundInstruction> a2) {
        PlatformService a3;
        PlatformService platformService = a3;
        String string = platformService.a.getContext();
        a2 = new SendingStreamObserver(a2);
        Authentication authentication = (Authentication)platformService.l.get();
        if (e.isInfoEnabled()) {
            e.info(ClientVersionsCache.M((Object)"BCoBdOuEnB!CqIoIe\fgCs\fzQ"), (Object)authentication.getName());
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @EventListener
    public void on(TopologyEvents.ApplicationInactivityTimeout a2) {
        PlatformService a3;
        Object object = a2.M();
        a2 = new ClientComponent(object.h(), a2.M().clientId(), a2.M(), a2.M().context());
        object = "Platform stream inactivity for " + object.h();
        object = new ApplicationInactivityException((String)object);
        a3.M((ClientComponent)a2, (Throwable)object);
    }
}

