/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc.heartbeat;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.enterprise.context.AdminContextController;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.Publisher;
import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatPublisher;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.rest.svg.jsfunction.ShowDetail;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.axonserver.heartbeat.enabled"})
public class HeartbeatMonitor {
    private final ApplicationEventPublisher G;
    private final long B;
    private final Publisher<PlatformOutboundInstruction> A;
    private final Clock E;
    private final Map<ClientStreamIdentification, ClientInformation> C;
    private final Logger c = LoggerFactory.getLogger(HeartbeatMonitor.class);
    private final Map<ClientStreamIdentification, Instant> e;

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-check-initial-delay:10000}", fixedRateString="${axoniq.axonserver.client-heartbeat-check-rate:1000}")
    public void checkClientsStillAlive() {
        HeartbeatMonitor a2;
        HeartbeatMonitor heartbeatMonitor = a2;
        heartbeatMonitor.c.debug(ShowDetail.M((Object)"\u001f\r9\u00067\f2\u0002|\u00063\u000b2\u0000?\u00119\u0001|\u00060\f9\u000b(\u0016|\u0004.\u0000|\u0016(\f0\t|\u00040\f*\u0000rKr"));
        HeartbeatMonitor heartbeatMonitor2 = a2;
        Instant instant = Instant.now(heartbeatMonitor.E).minus(heartbeatMonitor2.B, ChronoUnit.MILLIS);
        heartbeatMonitor2.e.forEach((a3, a4) -> {
            HeartbeatMonitor a5;
            if (a4.isBefore(instant) && a5.C.containsKey(a3)) {
                ClientInformation clientInformation = (ClientInformation)a5.C.get(a3);
                String string = clientInformation.c;
                String string2 = clientInformation.C;
                Object[] objectArray = new Object[4];
                objectArray[0] = a5.B;
                objectArray[1] = a3;
                objectArray[2] = a4;
                objectArray[3] = instant;
                a5.c.info(AdminContextController.M((Object)"'\u0010\r\u0019\n\bD\u0015\n\u001d\u0007\b\r\n\r\b\u001d\\\u0000\u0019\u0010\u0019\u0007\b\u0001\u0018D\u001a\u000b\u000eD\u0011\u000b\u000e\u0001\\\u0010\u0014\u0005\u0012D\u0007\u0019\\\t\u0015\b\u0010\r\u000f\u0001\u001f\u000b\u0012\u0000\u000fJ\\'\u0010\r\u0019\n\b^\\\u001f\u0001H\\\b\u001d\u0017\b%\u001f\u0010\u0015\u0012\u0015\u0010\u0005^\\\u001f\u0001H\\\u0010\u0015\t\u0019\u000b\t\u0010FD\u0007\u0019RD"), objectArray);
                a5.G.publishEvent((Object)new TopologyEvents.ApplicationInactivityTimeout(a3, string, new ClientContext(string2, clientInformation.e)));
            }
        });
    }

    public static String M(Object a2) {
        a2 = (String)a2;
        int n = ((String)a2).length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = (3 ^ 5) << 4 ^ (3 << 2 ^ 1);
        int cfr_ignored_0 = 4 << 3 ^ 3;
        int n4 = n2;
        int n5 = 3 ^ 5;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(((String)a2).charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(((String)a2).charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected a2) {
        HeartbeatMonitor a3;
        a2 = new ClientStreamIdentification(a2.l(), a2.B());
        a3.e.remove(a2);
        a3.C.remove(a2);
        a3.c.debug(AdminContextController.M((Object)"/\u0010\u0013\u0014\\\t\u0013\n\u0015\u0010\u0013\u0016\u0015\n\u001bD\u0014\u0001\u001d\u0016\b\u0006\u0019\u0005\bD\u001a\u000b\u000eD\u001f\b\u0015\u0001\u0012\u0010\\\u001f\u0001J"), (Object)a2);
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-initial-delay:5000}", fixedRateString="${axoniq.axonserver.client-heartbeat-frequency:500}")
    public void sendHeartbeat() {
        HeartbeatMonitor a2;
        a2.A.publish((Object)PlatformOutboundInstruction.newBuilder().setHeartbeat(Heartbeat.newBuilder()).build());
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected a2) {
        HeartbeatMonitor a3;
        ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a2.E(), a2.A());
        a3.C.put(clientStreamIdentification, new ClientInformation(a2.M(), a2.B(), a2.E()));
    }

    @Autowired
    public HeartbeatMonitor(PlatformService platformService, HeartbeatPublisher heartbeatPublisher, ApplicationEventPublisher eventPublisher, @Value(value="${axoniq.axonserver.client-heartbeat-timeout:5000}") long a2) {
        this(a5 -> platformService.onInboundInstruction(PlatformInboundInstruction.RequestCase.HEARTBEAT, (a3, a4) -> a5.accept(new ClientStreamIdentification(a3.getContext(), a3.getClientStreamId()), a4)), eventPublisher, (Publisher)heartbeatPublisher, a2, Clock.systemUTC());
    }

    public HeartbeatMonitor(Consumer<BiConsumer<ClientStreamIdentification, PlatformInboundInstruction>> a4, ApplicationEventPublisher a5, Publisher<PlatformOutboundInstruction> a6, long a7, Clock a8) {
        HeartbeatMonitor a9;
        HeartbeatMonitor heartbeatMonitor = a9;
        a9.C = new ConcurrentHashMap();
        HeartbeatMonitor heartbeatMonitor2 = a9;
        heartbeatMonitor.e = new ConcurrentHashMap();
        a4.accept((a2, a3) -> {
            HeartbeatMonitor a4;
            HeartbeatMonitor heartbeatMonitor = a4;
            heartbeatMonitor.c.trace(ShowDetail.M((Object)"-9\u0004.\u0011\u001e\u0000=\u0011|\u00179\u00069\f*\u00008E:\u00173\b|\u001e!"), a2);
            heartbeatMonitor.e.put(a2, Instant.now(a4.E));
        });
        HeartbeatMonitor heartbeatMonitor3 = a9;
        HeartbeatMonitor heartbeatMonitor4 = a9;
        heartbeatMonitor4.E = a8;
        heartbeatMonitor4.G = a5;
        heartbeatMonitor3.B = a7;
        heartbeatMonitor3.A = a6;
    }
}

