/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage;

import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.grpc.event.EventWithToken;
import io.axoniq.axonserver.interceptor.PluginRemovedEvent;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.QueryOptions;
import io.axoniq.axonserver.localstorage.Registration;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.localstorage.SerializedTransactionWithToken;
import io.axoniq.axonserver.plugin.PluginPackageProvider;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.data.util.CloseableIterator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface EventStorageEngine {
    public Flux<SerializedEvent> eventsPerAggregate(String var1, long var2, long var4, long var6);

    default public void init(boolean a2) {
        EventStorageEngine a3;
        a3.init(a2, 0L);
    }

    public CloseableIterator<SerializedEventWithToken> getGlobalIterator(long var1);

    default public Registration registerEventListener(BiConsumer<Long, List<Event>> a2) {
        return () -> {};
    }

    default public void validateTransaction(long a2, List<Event> a3) {
    }

    public Optional<SerializedEvent> getLastEvent(String var1, long var2, long var4);

    public void init(boolean var1, long var2);

    default public Optional<Long> getLastSequenceNumber(String a2, SearchHint a3, long a4) {
        EventStorageEngine a5;
        return a5.getLastSequenceNumber(a2, new SearchHint[0]);
    }

    public CloseableIterator<SerializedTransactionWithToken> transactionIterator(long var1, long var3);

    public Flux<Long> transformContents(int var1, Flux<EventWithToken> var2);

    default public long store(List<Event> a2) {
        EventStorageEngine a3;
        return a3.store(a2, 0);
    }

    public void query(QueryOptions var1, Predicate<EventWithToken> var2);

    public void processEventsPerAggregateHighestFirst(String var1, long var2, long var4, int var6, Predicate<SerializedEvent> var7, Consumer<SerializedEvent> var8);

    default public long getFirstCompletedSegment() {
        return -1L;
    }

    public EventTypeContext getType();

    default public long getLastToken() {
        return -1L;
    }

    default public Stream<String> getBackupFilenames(long a2, int a3, boolean a4) {
        throw new UnsupportedOperationException();
    }

    public void processEventsPerAggregate(String var1, long var2, long var4, long var6, Consumer<SerializedEvent> var8);

    public long size();

    public Registration registerCloseListener(Runnable var1);

    default public void close(boolean a2) {
    }

    default public boolean validateSnapshot(SerializedEvent a2) {
        return true;
    }

    public Optional<Long> getLastSequenceNumber(String var1, SearchHint ... var2);

    default public long store(List<Event> a2, int a3) {
        throw new UnsupportedOperationException(PluginPackageProvider.M((Object)"Z~fxl*fzlxh~`eg*ge}*z\u007fyzfx}om"));
    }

    default public byte transactionVersion() {
        return 0;
    }

    public long nextToken();

    default public Mono<Void> deleteOldVersions() {
        return Mono.error((Throwable)new UnsupportedOperationException(PluginRemovedEvent.M((Object)"t+|+d+C+w#u d=*n_>u<q:y!~n~!dnc;`>\u007f<d+tnr70:x'cnU8u d\u001dd!b/w+U w'~+")));
    }

    public long getFirstToken();

    public long getTokenAt(long var1);
}

