/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.AggregateSequence;
import io.axoniq.axonserver.localstorage.file.EventSource;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.StorageTier;
import io.axoniq.axonserver.logging.PluginEventsLogger;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.rest.json.CommandRequestJson;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractFileStorageTier
implements StorageTier {
    protected final Supplier<StorageProperties> D;
    protected static final int F = 1;
    private final AtomicBoolean k;
    protected final EventTypeContext f;
    protected final Counter I;
    protected static final int H = 5;
    protected final String g;
    protected static final int m = 7;
    protected final AtomicLong K;
    protected final String M;
    protected final Supplier<StorageTier> d;
    protected static final int a = 4;
    protected static final byte j = 2;
    protected static final int h = 0x7FFFFFF6;
    protected static final int l = 4;
    protected static final int G = 4;
    private static final int B = 2;
    private static final int A = 4;
    public static final byte E = 2;
    protected final NavigableMap<Long, Integer> C;
    protected final IndexManager c;
    protected static final Logger e = LoggerFactory.getLogger(AbstractFileStorageTier.class);

    private /* synthetic */ String M(File a2, File a3) {
        return "Could not rename " + a2.getAbsolutePath() + " to " + a3.getAbsolutePath();
    }

    protected <R> R M(Function<StorageTier, R> a2, R a3) {
        AbstractFileStorageTier a4;
        StorageTier storageTier = (StorageTier)a4.d.get();
        if (storageTier != null) {
            return a2.apply(storageTier);
        }
        return a3;
    }

    public SortedSet<Long> getSegments() {
        AbstractFileStorageTier a2;
        if (!a2.k.get()) {
            a2.initSegments(Long.MAX_VALUE);
        }
        return a2.C.navigableKeySet();
    }

    public Stream<Long> allSegments() {
        AbstractFileStorageTier a2;
        return Stream.concat(a2.getSegments().stream(), (Stream)a2.M(StorageTier::allSegments, Stream.empty()));
    }

    protected AbstractFileStorageTier(EventTypeContext a2, IndexManager a3, Supplier<StorageProperties> a4, Supplier<StorageTier> a5, MeterFactory a6, String a7) {
        AbstractFileStorageTier a8;
        AbstractFileStorageTier abstractFileStorageTier = a8;
        AbstractFileStorageTier abstractFileStorageTier2 = a8;
        AbstractFileStorageTier abstractFileStorageTier3 = a8;
        a8.C = new ConcurrentSkipListMap(Comparator.reverseOrder());
        AbstractFileStorageTier abstractFileStorageTier4 = a8;
        abstractFileStorageTier3.k = new AtomicBoolean(true);
        AbstractFileStorageTier abstractFileStorageTier5 = a8;
        a8.K = new AtomicLong();
        a8.f = a2;
        abstractFileStorageTier2.g = a8.f.M();
        abstractFileStorageTier2.c = a3;
        abstractFileStorageTier.D = a4;
        abstractFileStorageTier.d = a5;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a8.g;
        stringArray[2] = "type";
        stringArray[3] = a2.M().name();
        a2 = Tags.of((String[])stringArray);
        AbstractFileStorageTier abstractFileStorageTier6 = a8;
        abstractFileStorageTier6.I = a6.counter((MetricName)BaseMetricName.q, (Tags)a2);
        abstractFileStorageTier6.M = a7;
    }

    protected abstract Optional<EventSource> M(FileVersion var1);

    protected File h(FileVersion a2) {
        AbstractFileStorageTier a3;
        return ((StorageProperties)a3.D.get()).dataFile(a3.M, a2);
    }

    protected EventTypeContext M() {
        AbstractFileStorageTier a2;
        return a2.f;
    }

    public void initSegments(long a2) {
        AbstractFileStorageTier a4;
        AbstractFileStorageTier abstractFileStorageTier = a4;
        abstractFileStorageTier.M(a2);
        abstractFileStorageTier.M((T a3) -> {
            AbstractFileStorageTier a4;
            a3.initSegments(a4.C.isEmpty() ? a2 : (Long)a4.C.navigableKeySet().last());
        });
        a4.k.set(true);
    }

    protected Stream<AggregateSequence> M(FileVersion a2) {
        AbstractFileStorageTier a4;
        return a4.c.latestSequenceNumbers(a2).map(a3 -> {
            AbstractFileStorageTier a4;
            return a4.h(a2, a3);
        });
    }

    protected Set<Integer> M(long a2, int a3) {
        int n;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n2 = n = 0;
        while (n2 <= a3) {
            AbstractFileStorageTier a4;
            if (a4.h(new FileVersion(a2, n)).exists()) {
                hashSet.add(n);
            }
            n2 = ++n;
        }
        return hashSet;
    }

    protected void M(Consumer<StorageTier> a2) {
        AbstractFileStorageTier a3;
        StorageTier storageTier = (StorageTier)a3.d.get();
        if (storageTier != null) {
            a2.accept(storageTier);
        }
    }

    public Optional<EventSource> eventSource(FileVersion a2) {
        AbstractFileStorageTier a4;
        Optional optional = a4.M(a2);
        if (optional.isPresent()) {
            return optional;
        }
        return (Optional)a4.M((T a3) -> a3.eventSource(a2), Optional.empty());
    }

    protected AbstractFileStorageTier(EventTypeContext a2, IndexManager a3, Supplier<StorageProperties> a4, MeterFactory a5, String a6) {
        a7(a2, a3, a4, () -> null, a5, a6);
        AbstractFileStorageTier a7;
    }

    protected void M(long a2) {
        AbstractFileStorageTier a3;
        StorageProperties storageProperties = (StorageProperties)a3.D.get();
        File file = storageProperties.oldDataFile(a3.M, a2);
        FileVersion fileVersion = new FileVersion(a2, 0);
        if (file.exists()) {
            if (!file.renameTo(a3.h(fileVersion))) {
                AbstractFileStorageTier abstractFileStorageTier = a3;
                throw new MessagingPlatformException(ErrorCode.DATAFILE_READ_ERROR, abstractFileStorageTier.M(file, abstractFileStorageTier.h(fileVersion)));
            }
            file = storageProperties.oldIndex(a3.M, a2);
            if (file.exists() && !file.renameTo(storageProperties.index(a3.M, a2))) {
                AbstractFileStorageTier abstractFileStorageTier = a3;
                throw new MessagingPlatformException(ErrorCode.DATAFILE_READ_ERROR, abstractFileStorageTier.M(file, storageProperties.index(abstractFileStorageTier.M, a2)));
            }
            file = storageProperties.oldBloomFilter(a3.M, a2);
            if (file.exists() && !file.renameTo(storageProperties.bloomFilter(a3.M, a2))) {
                AbstractFileStorageTier abstractFileStorageTier = a3;
                throw new MessagingPlatformException(ErrorCode.DATAFILE_READ_ERROR, abstractFileStorageTier.M(file, storageProperties.bloomFilter(abstractFileStorageTier.M, a2)));
            }
        }
    }

    private /* synthetic */ AggregateSequence h(FileVersion a2, AggregateIndexEntries a4) {
        AbstractFileStorageTier a5;
        block3: {
            block2: {
                if (a5.f.M()) break block2;
                if (a4.M().size() != 1) break block3;
            }
            return new AggregateSequence(a4.M(), a4.M().lastSequenceNumber());
        }
        return a5.M(0L, Long.MAX_VALUE, new SegmentIndexEntries(a2, a4.M())).map(a3 -> new AggregateSequence(a4.M(), a3.B())).orElseThrow(() -> new RuntimeException(PluginEventsLogger.M((Object)"bQM\\AT\u0004DK\u0010VUET\u0004CJQTCL_P")));
    }

    public Optional<EventSource> eventSource(long a2) {
        AbstractFileStorageTier a4;
        Optional optional = a4.M(a2);
        if (optional.isPresent()) {
            return optional;
        }
        return (Optional)a4.M((T a3) -> a3.eventSource(a2), Optional.empty());
    }

    public void activateSegmentVersion(long a2, int a3) {
        AbstractFileStorageTier a5;
        if ((Integer)a5.C.get(a2) != null) {
            a5.C.put(a2, a3);
            return;
        }
        a5.M((T a4) -> a4.activateSegmentVersion(a2, a3));
    }

    protected Map<Long, Integer> M(long a4) {
        File file;
        AbstractFileStorageTier a5;
        StorageProperties storageProperties = (StorageProperties)a5.D.get();
        File file2 = file = new File(a5.M);
        FileUtils.M((File)file2);
        Arrays.stream(FileUtils.M((File)file2, (String)storageProperties.getEventsSuffix())).map(FileUtils::M).filter(a3 -> {
            if (a3.M() < a4) {
                return true;
            }
            return false;
        }).forEach(a2 -> {
            AbstractFileStorageTier a5;
            a5.C.compute(a2.M(), (a3, a4) -> {
                AbstractFileStorageTier a5;
                a5.K.addAndGet(a5.h(a2).length());
                if (a4 == null) {
                    return a2.M();
                }
                return Math.max(a4, a2.M());
            });
        });
        a5.C.forEach((a2, a3) -> {
            AbstractFileStorageTier a4;
            a4.M(a2.longValue());
        });
        return a5.C;
    }

    public long size() {
        AbstractFileStorageTier a2;
        return a2.K.get() + (Long)a2.M(StorageTier::size, (Object)0L);
    }

    public Stream<String> getBackupFilenames(long a2, int a3) {
        AbstractFileStorageTier a5;
        TreeSet treeSet = new TreeSet();
        a5.getSegments().stream().filter(a4 -> {
            AbstractFileStorageTier a5;
            if (a4 > a2 || a5.currentSegmentVersion(a4) > a3) {
                return true;
            }
            return false;
        }).forEach(a7 -> {
            AbstractFileStorageTier a8;
            AbstractFileStorageTier abstractFileStorageTier = a8;
            abstractFileStorageTier.M(a7.longValue(), abstractFileStorageTier.currentSegmentVersion(a7).intValue()).stream().filter(a5 -> {
                if (a7 > a2 || a5 > a3) {
                    return true;
                }
                return false;
            }).forEach(a4 -> {
                AbstractFileStorageTier a5;
                a7 = new FileVersion(a7.longValue(), a4.intValue());
                treeSet.add(a5.h((FileVersion)a7));
                treeSet.addAll(a5.c.indexFiles((FileVersion)a7));
            });
        });
        treeSet.addAll(a5.c.getBackupFilenames(a2, a3).collect(Collectors.toSet()));
        StorageTier storageTier = (StorageTier)a5.d.get();
        if (storageTier == null) {
            return treeSet.stream().map(File::getAbsolutePath);
        }
        return Stream.concat(treeSet.stream().map(File::getAbsolutePath), storageTier.getBackupFilenames(a2, a3));
    }

    public Optional<SerializedEvent> M(long a2, long a3, SegmentIndexEntries a4) {
        AbstractFileStorageTier a6;
        return a6.M(a4.M()).map(a5 -> a5.readLastInRange(a2, a3, a4.M().positions()));
    }

    public Integer currentSegmentVersion(Long a2) {
        AbstractFileStorageTier a4;
        Integer n = (Integer)a4.C.get(a2);
        if (n != null) {
            return n;
        }
        return (Integer)a4.M((T a3) -> a3.currentSegmentVersion(a2), (Object)0);
    }

    private /* synthetic */ Mono<Void> M(FileVersion a3, File a5) {
        AbstractFileStorageTier a6;
        return Mono.fromSupplier(() -> {
            AbstractFileStorageTier a3;
            return ((StorageProperties)a3.D.get()).dataFile(a3.M, a3);
        }).filter(a2 -> {
            if (!a2.exists()) {
                return true;
            }
            return false;
        }).flatMap(a4 -> Mono.fromSupplier(() -> a5).filter(File::exists).switchIfEmpty(Mono.error((Throwable)new RuntimeException(CommandRequestJson.M((Object)"+\u0015\u0001\u0019M\u0018\u0002\u0019\u001e\\\u0003\u0013\u0019\\\b\u0004\u0004\u000f\u0019R")))).flatMap(a3 -> FileUtils.M((File)a3, (File)a4)));
    }

    public Flux<FileVersion> fileVersions(String a2) {
        AbstractFileStorageTier a4;
        Publisher[] publisherArray = new Publisher[2];
        publisherArray[0] = Flux.fromArray((Object[])FileUtils.M((File)new File(a4.M), (String)a2)).map(FileUtils::M);
        publisherArray[1] = (Publisher)a4.M((T a3) -> a3.fileVersions(a2), (Object)Flux.empty());
        return Flux.concat((Publisher[])publisherArray);
    }

    public SortedSet<FileVersion> segmentsWithoutIndex() {
        AbstractFileStorageTier a3;
        long l2 = a3.C.entrySet().stream().filter(a2 -> {
            AbstractFileStorageTier a3;
            return a3.c.validIndex(new FileVersion(((Long)a2.getKey()).longValue(), ((Integer)a2.getValue()).intValue()));
        }).map(Map.Entry::getKey).findFirst().orElse(-1L);
        Object[] objectArray = new Object[3];
        objectArray[0] = a3.f;
        objectArray[1] = a3.M;
        objectArray[2] = l2;
        e.info(CommandRequestJson.M((Object)"\u0016\u0001W\\\u0016\u0001M:\u0004\u000e\u001e\bM\n\f\u0010\u0004\u0018M\u0015\u0003\u0018\b\u0004W\\\u0016\u0001"), objectArray);
        TreeSet treeSet = a3.C.headMap(l2).entrySet().stream().map(a2 -> new FileVersion(((Long)a2.getKey()).longValue(), ((Integer)a2.getValue()).intValue())).collect(Collectors.toCollection(TreeSet::new));
        if (l2 < 0L) {
            treeSet.addAll((Collection)a3.M(StorageTier::segmentsWithoutIndex, Collections.emptySortedSet()));
        }
        return treeSet;
    }

    public Mono<Void> renameTransformedSegmentIfNeeded(FileVersion a2, File a3) {
        AbstractFileStorageTier a4;
        return Mono.defer(() -> {
            AbstractFileStorageTier a5;
            if (a5.C.containsKey(a2.M())) {
                return a5.M(a2, a3);
            }
            return (Mono)a5.M((T a4) -> a4.renameTransformedSegmentIfNeeded(a2, a3), (Object)Mono.empty());
        });
    }

    protected abstract Optional<EventSource> M(long var1);
}

