/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.rest.json.CommandRequestJson;
import io.axoniq.axonserver.taskscheduler.task.AddContextToReplicationGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Schedulers;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class FileUtils {
    public static final Logger e = LoggerFactory.getLogger(FileUtils.class);

    public static Mono<Void> M(File a2, File a3) {
        return Mono.create(a4 -> {
            try {
                MonoSink monoSink;
                if (Files.getFileStore(a2.toPath()).equals(Files.getFileStore(a3.getParentFile().toPath()))) {
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.move(a2.toPath(), a3.toPath(), copyOptionArray);
                    monoSink = a4;
                } else {
                    File file = File.createTempFile(a3.getName(), AddContextToReplicationGroup.M((Object)"\u000e.M*"), a3.getParentFile());
                    file.deleteOnExit();
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.copy(a2.toPath(), file.toPath(), copyOptionArray);
                    Files.delete(a2.toPath());
                    CopyOption[] copyOptionArray2 = new CopyOption[1];
                    copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.move(file.toPath(), a3.toPath(), copyOptionArray2);
                    monoSink = a4;
                }
                monoSink.success();
                return;
            }
            catch (Exception exception) {
                a4.error((Throwable)exception);
                return;
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }

    public static void M(File a2) {
        if (a2.exists() && !a2.isDirectory()) {
            throw new MessagingPlatformException(ErrorCode.DIRECTORY_CREATION_FAILED, "Could not setup directory " + a2.getAbsolutePath());
        }
        if (!a2.exists() && !a2.mkdirs()) {
            throw new MessagingPlatformException(ErrorCode.DIRECTORY_CREATION_FAILED, "Could not setup directory " + a2.getAbsolutePath());
        }
    }

    private /* synthetic */ FileUtils() {
        FileUtils a2;
    }

    public static FileVersion M(String a2) {
        String string = a2;
        String string2 = string.substring(0, string.indexOf(46));
        int n = string2.indexOf(95);
        if (n < 0) {
            return new FileVersion(Long.parseLong(string2), 0);
        }
        return new FileVersion(Long.parseLong(string2.substring(0, n)), Integer.parseInt(string2.substring(n + 1)));
    }

    public static String M(File a2) {
        try {
            return a2.getCanonicalFile().getAbsolutePath();
        }
        catch (IOException iOException) {
            return a2.getAbsolutePath();
        }
    }

    public static String[] M(File a2, String a3) {
        if ((a3 = a2.list((arg_0, arg_1) -> FileUtils.M((String)a3, arg_0, arg_1))) == null) {
            throw new MessagingPlatformException(ErrorCode.DATAFILE_READ_ERROR, "Could not list files in " + a2.getAbsolutePath());
        }
        return a3;
    }

    private static /* synthetic */ boolean M(String a2, File a3, String a4) {
        return a4.endsWith(a2);
    }

    public static boolean M(File a2) {
        if (!a2.exists()) {
            return true;
        }
        e.debug(CommandRequestJson.M((Object)")\u0019\u0001\u0019\u0019\u0019M\u001a\u0004\u0010\b\\\u0016\u0001"), (Object)a2.getAbsolutePath());
        try {
            Files.delete(a2.toPath());
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
            e.info(AddContextToReplicationGroup.M((Object)"\u001cA3L?DzT5\u0000>E6E.EzD3R?C.O(Y`\u0000!]v\u00003TzI)\u00004O.\u0000?M*T#"), (Object)a2);
            return false;
        }
        catch (IOException iOException) {
            e.warn(CommandRequestJson.M((Object)"+\u001d\u0004\u0010\b\u0018M\b\u0002\\\t\u0019\u0001\u0019\u0019\u0019W\\\u0016\u0001"), (Object)a2, (Object)iOException);
            return false;
        }
        return true;
    }
}

