/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.enterprise.cluster.ClusterEvent;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.H;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.PersistedBloomFilter;
import io.axoniq.axonserver.localstorage.file.RemoteAggregateSequenceNumberResolver;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntriesSerializer;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class StandardIndexManager
implements IndexManager {
    private final ConcurrentNavigableMap<Long, Integer> f;
    private final RemoteAggregateSequenceNumberResolver I;
    private final MeterFactory.RateMeter H;
    private static final String g = "aggregateMap";
    private final Supplier<IndexManager> m;
    private final ConcurrentNavigableMap<Long, Map<String, IndexEntries>> K;
    private ScheduledFuture<?> M;
    private final ConcurrentNavigableMap<FileVersion, PersistedBloomFilter> d;
    private final EventType a;
    private final MeterFactory.RateMeter j;
    protected final Supplier<StorageProperties> h;
    private static final Logger l = LoggerFactory.getLogger(StandardIndexManager.class);
    private final ConcurrentSkipListMap<FileVersion, H> G;
    private final Counter B;
    private final Counter A;
    protected final String E;
    private final String C;
    private final AtomicLong c;
    private static final ScheduledExecutorService e = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(ClusterEvent.M((Object)"<\u00041\u000f-G8\u000b;\u000b2\u000f'G")));

    private /* synthetic */ boolean M(FileVersion a3, String a4) {
        StandardIndexManager a5;
        if ((a3 = a5.d.computeIfAbsent(a3, a2 -> {
            StandardIndexManager a3;
            l.debug(HeartbeatMonitor.M((Object)"\u0016{W&\u0002v\bhMd\u0001i\u0002kM`\u0004j\u0019c\u001f&\u000bi\u001f&\u0016{"), (Object)a3.E, (Object)a2.M());
            StorageProperties storageProperties = (StorageProperties)a3.h.get();
            a2 = new PersistedBloomFilter(storageProperties.bloomFilter(a3.C, a2).getAbsolutePath(), 0, 0.03f);
            if (!a2.M()) {
                return null;
            }
            a3.B.increment();
            FileVersion fileVersion = a2;
            fileVersion.B();
            return fileVersion;
        })) != null && !a3.M(a4)) {
            return true;
        }
        return false;
    }

    public StandardIndexManager(String a2, Supplier<StorageProperties> a3, String a4, EventType a5, MeterFactory a6, Supplier<IndexManager> a7) {
        a8(a2, a3, a4, a5, null, a6, a7);
        StandardIndexManager a8;
    }

    public Optional<Long> getLastSequenceNumber(String a2, EventStorageEngine.SearchHint a32, long a4) {
        StandardIndexManager a5;
        int a32 = a32.equals((Object)EventStorageEngine.SearchHint.c) ? ((StorageProperties)a5.h.get()).segmentsForSequenceNumberCheck() : Integer.MAX_VALUE;
        return a5.M(a2, a32, a4);
    }

    public StandardIndexManager(String a2, Supplier<StorageProperties> a3, String a4, EventType a5, RemoteAggregateSequenceNumberResolver a6, MeterFactory a7, Supplier<IndexManager> a8) {
        StandardIndexManager a9;
        StandardIndexManager standardIndexManager = a9;
        StandardIndexManager standardIndexManager2 = a9;
        StandardIndexManager standardIndexManager3 = a9;
        StandardIndexManager standardIndexManager4 = a9;
        a9.K = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager5 = a9;
        standardIndexManager4.d = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager6 = a9;
        a9.G = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager7 = a9;
        standardIndexManager3.f = new ConcurrentSkipListMap(Comparator.reverseOrder());
        StandardIndexManager standardIndexManager8 = a9;
        standardIndexManager3.c = new AtomicLong();
        standardIndexManager3.h = a3;
        standardIndexManager2.C = a4;
        standardIndexManager2.E = a2;
        standardIndexManager.a = a5;
        standardIndexManager.I = a6;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a2;
        stringArray[2] = "type";
        stringArray[3] = a5.name();
        a2 = Tags.of((String[])stringArray);
        StandardIndexManager standardIndexManager9 = a9;
        MeterFactory meterFactory = a7;
        a9.j = a7.rateMeter((MetricName)BaseMetricName.c, (Tags)a2);
        a9.H = meterFactory.rateMeter((MetricName)BaseMetricName.Ma, (Tags)a2);
        standardIndexManager9.B = meterFactory.counter((MetricName)BaseMetricName.w, (Tags)a2);
        standardIndexManager9.A = a7.counter((MetricName)BaseMetricName.ba, (Tags)a2);
        e.scheduleAtFixedRate(() -> {
            Map.Entry entry;
            StandardIndexManager a2;
            StorageProperties storageProperties = (StorageProperties)a2.h.get();
            StandardIndexManager standardIndexManager = a2;
            while (standardIndexManager.G.size() > storageProperties.getMaxIndexesInMemory()) {
                entry = a2.G.pollFirstEntry();
                l.debug(ClusterEvent.M((Object)".\u0017oJ\u0016\u0006:\u0019<\u00042J<\u00041\u000f-J.\u0017"), (Object)a2.E, entry.getKey());
                a2.M = e.schedule(() -> ((H)entry.getValue()).close(), 2L, TimeUnit.SECONDS);
                standardIndexManager = a2;
            }
            StandardIndexManager standardIndexManager2 = a2;
            while (standardIndexManager2.d.size() > storageProperties.getMaxBloomFiltersInMemory()) {
                StandardIndexManager standardIndexManager3 = a2;
                standardIndexManager2 = standardIndexManager3;
                entry = standardIndexManager3.d.pollFirstEntry();
                StandardIndexManager standardIndexManager4 = a2;
                l.debug(HeartbeatMonitor.M((Object)"}\u0010<MT\bk\u0002p\bbMd\u0001i\u0002kM`\u0004j\u0019c\u001f&\u000bi\u001f&\u0016{M`\u001fi\u0000&\u0000c\u0000i\u001f\u007f"), (Object)standardIndexManager4.E, entry.getKey());
                standardIndexManager4.A.increment();
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        a9.m = a8;
    }

    public Stream<File> getBackupFilenames(long a2, int a5) {
        StandardIndexManager a6;
        StorageProperties storageProperties = (StorageProperties)a6.h.get();
        return a6.f.entrySet().stream().filter(a4 -> {
            if ((Long)a4.getKey() > a2 || (Integer)a4.getValue() > a5) {
                return true;
            }
            return false;
        }).flatMap(a3 -> {
            StandardIndexManager a4;
            File[] fileArray = new File[2];
            fileArray[0] = storageProperties.index(a4.C, ((Long)a3.getKey()).longValue());
            fileArray[1] = storageProperties.bloomFilter(a4.C, ((Long)a3.getKey()).longValue());
            return Stream.of(fileArray);
        });
    }

    private /* synthetic */ Mono<Void> M(FileVersion a4, File a5) {
        StandardIndexManager a6;
        return Mono.fromSupplier(() -> {
            StandardIndexManager a3;
            return ((StorageProperties)a3.h.get()).index(a3.C, a4);
        }).filter(a2 -> {
            if (!a2.exists()) {
                return true;
            }
            return false;
        }).flatMap(a3 -> Mono.fromSupplier(() -> a5).filter(File::exists).switchIfEmpty(Mono.error((Throwable)new RuntimeException())).flatMap(a4 -> FileUtils.M((File)a5, (File)a3))).doOnSuccess(a3 -> {
            StandardIndexManager a4;
            a4.f.put(a4.M(), a4.M());
        });
    }

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion a2) {
        StandardIndexManager a3;
        return a3.M(a2).M();
    }

    public void addExistingIndex(FileVersion a2) {
        StandardIndexManager a3;
        a3.f.put(a2.M(), a2.M());
        a3.M();
    }

    public boolean removeAllVersions(long a2) {
        Integer n;
        StandardIndexManager a3;
        StorageProperties storageProperties = (StorageProperties)a3.h.get();
        if (a3.K.remove(a2) == null && (n = (Integer)a3.f.remove(a2)) != null) {
            FileVersion fileVersion;
            int n2;
            int n3 = n2 = 0;
            while (n3 < n) {
                fileVersion = new FileVersion(a2, n2);
                if (storageProperties.index(a3.C, fileVersion).exists()) {
                    a3.remove(fileVersion);
                }
                n3 = ++n2;
            }
            FileVersion fileVersion2 = new FileVersion(a2, n.intValue());
            fileVersion = (H)a3.G.remove(fileVersion2);
            if (fileVersion != null) {
                fileVersion.close();
            }
            a3.d.remove(fileVersion2);
        }
        if (FileUtils.M((File)storageProperties.index(a3.C, a2)) && FileUtils.M((File)storageProperties.bloomFilter(a3.C, a2))) {
            return true;
        }
        return false;
    }

    public SegmentIndexEntries lastIndexEntries(String a2, long a3) {
        StandardIndexManager a4;
        for (Long l2 : a4.K.descendingKeySet()) {
            IndexEntries indexEntries = (IndexEntries)((Map)a4.K.get(l2)).get(a2);
            if (indexEntries == null || indexEntries.firstSequenceNumber() >= a3) continue;
            IndexEntries indexEntries2 = indexEntries;
            return new SegmentIndexEntries(new FileVersion(l2.longValue(), 0), indexEntries2.range(indexEntries2.firstSequenceNumber(), a3, EventType.e.equals((Object)a4.a)));
        }
        if (!a4.f.isEmpty()) {
            return a4.lastIndexEntriesFromClosedSegments(a2, a3, ((Long)a4.f.keySet().first()).longValue());
        }
        return null;
    }

    private /* synthetic */ boolean M(FileVersion a2) {
        StandardIndexManager a3;
        return ((StorageProperties)a3.h.get()).dataFile(a3.C, a2).exists();
    }

    public void h(FileVersion a2, Map<String, IndexEntries> a3) {
        StandardIndexManager a4;
        if (a4.M(a2)) {
            a4.M(a2, a3);
            return;
        }
        StandardIndexManager standardIndexManager = (StandardIndexManager)a4.m.get();
        if (standardIndexManager != null) {
            standardIndexManager.h(a2, a3);
        }
    }

    public void complete(FileVersion a2) {
        StandardIndexManager a3;
        StandardIndexManager standardIndexManager = a3;
        standardIndexManager.M(a2, (Map)standardIndexManager.K.get(a2.M()));
        a3.K.remove(a2.M());
        a3.M();
    }

    public List<File> indexFiles(FileVersion a2) {
        StandardIndexManager a3;
        File[] fileArray = new File[2];
        fileArray[0] = ((StorageProperties)a3.h.get()).index(a3.C, a2);
        fileArray[1] = ((StorageProperties)a3.h.get()).bloomFilter(a3.C, a2);
        return Arrays.asList(fileArray);
    }

    private /* synthetic */ boolean M(long a2, long a3, IndexEntries a4) {
        if (!a4.isEmpty() && a2 >= a4.firstSequenceNumber() || a3 <= 0L) {
            return true;
        }
        return false;
    }

    public Mono<Void> activateVersion(FileVersion a2) {
        StandardIndexManager a3;
        return Mono.defer(() -> {
            StandardIndexManager a3;
            File file = ((StorageProperties)a3.h.get()).transformedIndex(a3.C, a2);
            return a3.activateVersion(a2, file);
        });
    }

    private /* synthetic */ void M(FileVersion a2, Map<String, IndexEntries> a3) {
        DBMaker.Maker maker;
        HTreeMap hTreeMap;
        File file;
        StorageProperties storageProperties;
        StandardIndexManager a4;
        block14: {
            DBMaker.Maker maker2;
            block9: {
                DBMaker.Maker maker3;
                block13: {
                    block12: {
                        block11: {
                            storageProperties = (StorageProperties)a4.h.get();
                            if (a3 == null) {
                                a3 = Collections.emptyMap();
                            }
                            if (!FileUtils.M((File)(file = storageProperties.indexTemp(a4.C, a2.M())))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + file);
                            }
                            maker2 = DBMaker.fileDB((File)file);
                            if (!storageProperties.isUseMmapIndex()) break block11;
                            maker2.fileMmapEnable();
                            if (!storageProperties.isForceCleanMmapIndex()) break block12;
                            DBMaker.Maker maker4 = maker2;
                            maker3 = maker4;
                            maker4.cleanerHackEnable();
                            break block13;
                        }
                        maker2.fileChannelEnable();
                    }
                    maker3 = maker2;
                }
                maker2 = maker3.make();
                hTreeMap = maker2.hashMap(g, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.M()).createOrOpen();
                try {
                    hTreeMap.putAll(a3);
                    if (hTreeMap == null) break block9;
                    maker = maker2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block10: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block10;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block14;
            }
            maker = maker2;
        }
        maker.close();
        try {
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(file.toPath(), storageProperties.index(a4.C, a2).toPath(), copyOptionArray);
        }
        catch (IOException iOException) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(a4.C, a2), (Throwable)iOException);
        }
        HTreeMap hTreeMap2 = hTreeMap = new PersistedBloomFilter(storageProperties.bloomFilter(a4.C, a2).getAbsolutePath(), a3.keySet().size(), storageProperties.getBloomIndexFpp());
        hTreeMap2.M();
        hTreeMap2.M(a3.keySet());
        hTreeMap2.h();
        a4.d.put(a2, hTreeMap);
        a4.f.put(a2.M(), a2.M());
        a4.M(a2);
    }

    public void createNewVersion(long a2, int a52, Map<String, List<IndexEntry>> a6) {
        DBMaker.Maker maker;
        HTreeMap hTreeMap;
        StandardIndexManager a7;
        FileVersion a52;
        block12: {
            DBMaker.Maker maker2;
            block7: {
                DBMaker.Maker maker3;
                block11: {
                    block10: {
                        block9: {
                            a52 = new FileVersion(a2, a52);
                            if (a6 == null) {
                                a6 = Collections.emptyMap();
                            }
                            if (!FileUtils.M((File)(a2 = ((StorageProperties)a7.h.get()).transformedIndex(a7.C, a52)))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + a2);
                            }
                            maker2 = DBMaker.fileDB((File)a2);
                            if (!((StorageProperties)a7.h.get()).isUseMmapIndex()) break block9;
                            maker2.fileMmapEnable();
                            if (!((StorageProperties)a7.h.get()).isForceCleanMmapIndex()) break block10;
                            DBMaker.Maker maker4 = maker2;
                            maker3 = maker4;
                            maker4.cleanerHackEnable();
                            break block11;
                        }
                        maker2.fileChannelEnable();
                    }
                    maker3 = maker2;
                }
                maker2 = maker3.make();
                hTreeMap = maker2.hashMap(g, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.M()).createOrOpen();
                try {
                    a6.forEach((a3, a4) -> {
                        int n;
                        IndexEntry indexEntry = (IndexEntry)a4.get(0);
                        Integer[] integerArray = new Integer[a4.size()];
                        int n2 = n = 0;
                        while (n2 < a4.size()) {
                            int n3 = n++;
                            integerArray[n3] = ((IndexEntry)a4.get(n3)).M();
                            n2 = n;
                        }
                        hTreeMap.put(a3, (Object)new StandardIndexEntries(indexEntry.h(), integerArray));
                    });
                    if (hTreeMap == null) break block7;
                    maker = maker2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block8: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block8;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block12;
            }
            maker = maker2;
        }
        maker.close();
        HTreeMap hTreeMap2 = hTreeMap = new PersistedBloomFilter(((StorageProperties)a7.h.get()).bloomFilter(a7.C, a52).getAbsolutePath(), a6.keySet().size(), ((StorageProperties)a7.h.get()).getBloomIndexFpp());
        hTreeMap2.M();
        hTreeMap2.M(a6.keySet());
        hTreeMap2.h();
    }

    public long size() {
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    public Optional<Long> M(String a2, int a3, long a4) {
        void var7_13;
        void var7_11;
        Map map;
        StandardIndexManager a5;
        int n = 0;
        for (Long optional2 : a5.K.descendingKeySet()) {
            if (n >= a3) {
                return Optional.empty();
            }
            if (optional2 > a4 || (map = (Map)a5.K.get(optional2)) == null) continue;
            IndexEntries indexEntries = (IndexEntries)map.get(a2);
            if (indexEntries != null) {
                return Optional.of(indexEntries.lastSequenceNumber());
            }
            ++n;
        }
        for (Map.Entry entry : a5.f.entrySet()) {
            if (n >= a3) {
                return Optional.empty();
            }
            if ((Long)entry.getKey() > a4) continue;
            map = a5.M(new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue()), a2);
            if (map != null) {
                return Optional.of(map.lastSequenceNumber());
            }
            ++n;
        }
        Iterator<Object> iterator = (StandardIndexManager)a5.m.get();
        Optional optional = Optional.empty();
        if (iterator != null) {
            Optional optional2 = iterator.M(a2, a3 - n, a4);
        }
        if (var7_11.isEmpty() && a5.I != null && n < a3 && !a5.f.isEmpty()) {
            StandardIndexManager standardIndexManager = a5;
            Optional optional3 = standardIndexManager.I.getLastSequenceNumber(standardIndexManager.E, a2, a3 - n, (Long)a5.f.keySet().last() - 1L);
        }
        return var7_13;
    }

    private /* synthetic */ H M(FileVersion a3) {
        StandardIndexManager a4;
        try {
            return a4.G.computeIfAbsent(a3, a2 -> {
                StandardIndexManager a3;
                return new H(a3, a2);
            }).M();
        }
        catch (IndexNotFoundException indexNotFoundException) {
            a3 = (H)a4.G.remove(a3);
            if (a3 != null) {
                a3.close();
            }
            throw indexNotFoundException;
        }
    }

    public Mono<Void> activateVersion(FileVersion a2, File a3) {
        StandardIndexManager a4;
        if (a4.f.containsKey(a2.M())) {
            return a4.M(a2, a3);
        }
        IndexManager indexManager = (IndexManager)a4.m.get();
        if (indexManager != null) {
            return indexManager.activateVersion(a2, a3);
        }
        return Mono.empty();
    }

    public void init() {
        int n;
        StandardIndexManager a2;
        StorageProperties storageProperties = (StorageProperties)a2.h.get();
        String[] stringArray = FileUtils.M((File)new File(a2.C), (String)storageProperties.getIndexSuffix());
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            FileVersion fileVersion = FileUtils.M((String)stringArray[n]);
            if (storageProperties.dataFile(a2.C, fileVersion).exists()) {
                a2.f.compute(fileVersion.M(), (a3, a4) -> a4 == null ? fileVersion.M() : Math.max(fileVersion.M(), a4));
            } else {
                a2.remove(fileVersion);
            }
            n3 = ++n;
        }
        a2.M();
    }

    private /* synthetic */ int M(long a2, long a3, SortedMap<FileVersion, IndexEntries> a4, FileVersion a5, IndexEntries a6) {
        StandardIndexManager a7;
        if (!(a6 = a6.range(a2, a3, EventType.e.equals((Object)a7.a))).isEmpty()) {
            a4.put(a5, a6);
        }
        return a6.size();
    }

    private /* synthetic */ IndexEntries M(FileVersion a2, String a3) {
        int n;
        StandardIndexManager a4;
        if (a4.M(a2, a3)) {
            return null;
        }
        RuntimeException runtimeException = new RuntimeException();
        int n2 = n = 0;
        while (true) {
            if (n2 >= 3) break;
            try {
                H h2 = a4.M(a2);
                return h2.M(a3);
            }
            catch (IndexNotFoundException indexNotFoundException) {
                return null;
            }
            catch (Exception exception) {
                runtimeException = new RuntimeException("Error happened while trying get positions for " + a2.M() + " segment.", exception);
                n2 = ++n;
                continue;
            }
            break;
        }
        throw runtimeException;
    }

    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String a2, long a3, long a4, long a5, long a6, long a7) {
        StandardIndexManager a8;
        IndexManager indexManager;
        TreeMap<FileVersion, IndexEntries> treeMap = new TreeMap<FileVersion, IndexEntries>();
        IndexManager indexManager2 = indexManager = a8.f.entrySet().iterator();
        while (indexManager2.hasNext()) {
            Map.Entry entry = indexManager.next();
            if (a7 < a6) {
                return treeMap;
            }
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            IndexEntries indexEntries = a8.M(fileVersion, a2);
            Object[] objectArray = new Object[4];
            objectArray[0] = a8.E;
            objectArray[1] = a2;
            objectArray[2] = entry;
            objectArray[3] = indexEntries;
            l.debug(HeartbeatMonitor.M((Object)"}\u0010<Mj\u0002i\u0006s\u001dG\na\u001fc\ng\u0019cM}\u0010&\u0004hMu\ba\u0000c\u0003rM}\u0010&\u000bi\u0018h\t&\u0016{"), objectArray);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager = a8;
                int n = standardIndexManager.M(a3, a4, treeMap, fileVersion, indexEntries);
                if (standardIndexManager.M(a3, a5 -= (long)n, indexEntries)) {
                    return treeMap;
                }
            }
            a7 = (Long)entry.getKey();
            indexManager2 = indexManager;
        }
        indexManager = (IndexManager)a8.m.get();
        if (indexManager != null) {
            treeMap.putAll(indexManager.lookupAggregateInClosedSegments(a2, a3, a4, a5, a6, a7));
        }
        return treeMap;
    }

    public boolean validIndex(FileVersion a2) {
        block3: {
            boolean bl;
            block4: {
                StandardIndexManager a3;
                if (!a3.f.containsKey(a2.M()) || ((Integer)a3.f.get(a2.M())).intValue() != a2.M()) break block3;
                if (a3.M(a2) == null || a3.M(a2) == null) break block4;
                return true;
            }
            try {
                bl = false;
            }
            catch (Exception exception) {
                l.warn(ClusterEvent.M((Object)"\u0013\u000b<\u00060\u000eu\u001e:J#\u000b9\u00031\u000b!\u000fu\u0003;\u000e0\u0012u\f:\u0018u\u00190\r8\u000f;\u001eoJ.\u0017"), (Object)a2, (Object)exception);
            }
            return bl;
        }
        return false;
    }

    private /* synthetic */ void M() {
        StandardIndexManager a2;
        StandardIndexManager standardIndexManager = a2;
        standardIndexManager.c.set(standardIndexManager.f.keySet().stream().skip(((StorageProperties)a2.h.get()).getMaxIndexesInMemory()).findFirst().orElse(-1L));
    }

    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String a2, long a3, long a4, long a5, long a6) {
        Iterator iterator;
        StandardIndexManager a7;
        TreeMap<FileVersion, IndexEntries> treeMap = new TreeMap<FileVersion, IndexEntries>();
        Object[] objectArray = new Object[4];
        objectArray[0] = a7.E;
        objectArray[1] = a2;
        objectArray[2] = a3;
        objectArray[3] = a4;
        l.debug(HeartbeatMonitor.M((Object)"\u0016{W&\u0001i\u0002m\u0018v,a\nt\ba\fr\b&\u0016{Mk\u0004h>c\u001cs\bh\u000ec#s\u0000d\btM}\u0010*Mj\fu\u0019U\bw\u0018c\u0003e\bH\u0018k\u000fc\u001f&\u0016{"), objectArray);
        long l2 = Long.MAX_VALUE;
        Iterator iterator2 = iterator = a7.K.descendingKeySet().iterator();
        while (iterator2.hasNext()) {
            Long l3 = (Long)iterator.next();
            if (l2 < a6) {
                return treeMap;
            }
            IndexEntries indexEntries = (IndexEntries)a7.K.getOrDefault(l3, Collections.emptyMap()).get(a2);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager = a7;
                int n = standardIndexManager.M(a3, a4, treeMap, new FileVersion(l3.longValue(), 0), indexEntries);
                if (standardIndexManager.M(a3, a5 -= (long)n, indexEntries)) {
                    return treeMap;
                }
            }
            l2 = l3;
            iterator2 = iterator;
        }
        TreeMap<FileVersion, IndexEntries> treeMap2 = treeMap;
        treeMap2.putAll(a7.lookupAggregateInClosedSegments(a2, a3, a4, a5, a6, l2));
        return treeMap2;
    }

    public void addToActiveSegment(long a4, String a5, IndexEntry a6) {
        StandardIndexManager a7;
        if (a7.f.containsKey(a4)) {
            throw new IndexNotFoundException(a4 + ": already completed");
        }
        a7.K.computeIfAbsent(a4, a2 -> new ConcurrentHashMap()).computeIfAbsent(a5, a3 -> new StandardIndexEntries(a6.h())).add(a6);
    }

    public StandardIndexManager(String a2, Supplier<StorageProperties> a3, String a4, EventType a5, MeterFactory a6) {
        a7(a2, a3, a4, a5, null, a6, () -> null);
        StandardIndexManager a7;
    }

    public void cleanup(boolean a4) {
        StandardIndexManager a5;
        StandardIndexManager standardIndexManager = a5;
        standardIndexManager.K.clear();
        standardIndexManager.d.clear();
        standardIndexManager.G.forEach((a2, a3) -> a3.close());
        StandardIndexManager standardIndexManager2 = a5;
        standardIndexManager2.G.clear();
        if (standardIndexManager2.M != null && !a5.M.isDone()) {
            a5.M.cancel(true);
        }
        if (a4) {
            a5.f.keySet().forEach(arg_0 -> a5.removeAllVersions(arg_0));
        }
        StandardIndexManager standardIndexManager3 = a5;
        standardIndexManager3.f.clear();
        IndexManager indexManager = (IndexManager)standardIndexManager3.m.get();
        if (indexManager != null) {
            indexManager.cleanup(a4);
        }
    }

    public void addToActiveSegment(Long a2, Map<String, List<IndexEntry>> a3) {
        StandardIndexManager a4;
        if (a4.f.containsKey(a2)) {
            throw new IndexNotFoundException(a2 + ": already completed");
        }
        a3.forEach((a5, a6) -> {
            StandardIndexManager a7;
            a7.K.computeIfAbsent(a2, a2 -> new ConcurrentHashMap()).computeIfAbsent(a5, a3 -> new StandardIndexEntries(((IndexEntry)a6.get(0)).h())).addAll(a6);
        });
    }

    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String a2, long a3, long a422) {
        StandardIndexManager a5;
        for (Map.Entry entry : a5.f.entrySet()) {
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            IndexEntries indexEntries = a5.M(fileVersion, a2);
            if (indexEntries == null || indexEntries.firstSequenceNumber() >= a3) continue;
            IndexEntries indexEntries2 = indexEntries;
            return new SegmentIndexEntries(fileVersion, indexEntries2.range(indexEntries2.firstSequenceNumber(), a3, EventType.e.equals((Object)a5.a)));
        }
        IndexManager a422 = (IndexManager)a5.m.get();
        if (a422 != null) {
            return a422.lastIndexEntriesFromClosedSegments(a2, a3, (Long)a5.f.keySet().last() - 1L);
        }
        return null;
    }

    public void createIndex(FileVersion a2, Map<String, List<IndexEntry>> a3) {
        StandardIndexManager a6;
        HashMap hashMap = new HashMap();
        a3.forEach((a4, a5) -> hashMap.computeIfAbsent(a4, a3 -> new StandardIndexEntries(((IndexEntry)a5.get(0)).h())).addAll(a5));
        a6.h(a2, hashMap);
    }

    public boolean remove(FileVersion a2) {
        StandardIndexManager a3;
        H h2 = (H)a3.G.remove(a2);
        if (h2 != null) {
            h2.close();
        }
        StandardIndexManager standardIndexManager = a3;
        standardIndexManager.d.remove(a2);
        if (FileUtils.M((File)((StorageProperties)standardIndexManager.h.get()).index(a3.C, a2)) && FileUtils.M((File)((StorageProperties)a3.h.get()).bloomFilter(a3.C, a2))) {
            return true;
        }
        return false;
    }
}

