/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.component.processor.ClientEventProcessorInfo;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.file.AbstractFileStorageTier;
import io.axoniq.axonserver.localstorage.file.ByteBufferEventSource;
import io.axoniq.axonserver.localstorage.file.EventInformation;
import io.axoniq.axonserver.localstorage.file.EventIterator;
import io.axoniq.axonserver.localstorage.file.EventSource;
import io.axoniq.axonserver.localstorage.file.FilePreparedTransaction;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.L;
import io.axoniq.axonserver.localstorage.file.Segment;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.StorageTier;
import io.axoniq.axonserver.localstorage.file.Synchronizer;
import io.axoniq.axonserver.localstorage.file.WritableEventSource;
import io.axoniq.axonserver.localstorage.file.WritePosition;
import io.axoniq.axonserver.localstorage.transformation.EventTransformer;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.localstorage.transformation.ProcessedEvent;
import io.axoniq.axonserver.localstorage.transformation.WrappedEvent;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.taskscheduler.task.AddContextToReplicationGroup;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WritableFileStorageTier
extends AbstractFileStorageTier {
    protected final AtomicLong l;
    private static final Logger e = LoggerFactory.getLogger(WritableFileStorageTier.class);
    protected final ConcurrentNavigableMap<Long, ByteBufferEventSource> G;
    private final MeterFactory B;
    private final EventTransformer A;
    private final FileSystemMonitor E;
    private final Synchronizer C;
    protected final AtomicReference<WritePosition> c;
    private final Gauge e;

    protected Optional<EventSource> M(FileVersion a2) {
        WritableFileStorageTier a3;
        return a3.M(a2.M());
    }

    private /* synthetic */ void B(long a2) {
        WritableFileStorageTier a4;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.G.remove(a2);
        int n = 0;
        if (byteBufferEventSource != null) {
            ByteBufferEventSource byteBufferEventSource2 = byteBufferEventSource;
            n = byteBufferEventSource2.M();
            byteBufferEventSource2.M(0L);
        }
        a4.M(a2, n).forEach(a3 -> {
            WritableFileStorageTier a4;
            a4.M(a2, a3.intValue());
        });
    }

    public Integer currentSegmentVersion(Long a2) {
        WritableFileStorageTier a4;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.G.get(a2);
        if (byteBufferEventSource != null) {
            return byteBufferEventSource.M();
        }
        return (Integer)a4.M((T a3) -> a3.currentSegmentVersion(a2), (Object)0);
    }

    public void M(long a2, long a3) {
        WritableFileStorageTier a4;
        StorageProperties storageProperties = (StorageProperties)a4.D.get();
        File file = new File(a4.M);
        FileUtils.M((File)file);
        WritableFileStorageTier writableFileStorageTier = a4;
        writableFileStorageTier.c.init();
        writableFileStorageTier.M(a2, file, a3, storageProperties);
        writableFileStorageTier.E.registerPath(a4.M(), file.toPath());
    }

    public long B() {
        WritableFileStorageTier a2;
        return a2.l.get();
    }

    public SortedSet<Long> getSegments() {
        WritableFileStorageTier a2;
        return a2.G.keySet();
    }

    private /* synthetic */ FilePreparedTransaction M(List<Event> a3, int a42) {
        WritableFileStorageTier a5;
        a3 = a3.stream().map(a2 -> {
            WritableFileStorageTier a3;
            return new WrappedEvent(a2, a3.A);
        }).collect(Collectors.toList());
        WritableFileStorageTier writableFileStorageTier = a5;
        int n = writableFileStorageTier.M(a3);
        WritePosition a42 = writableFileStorageTier.M(n, a3.size(), a42);
        return new FilePreparedTransaction(a42, n, a3);
    }

    private /* synthetic */ void M(long a3, File a4, long a52, StorageProperties a6) {
        WritableFileStorageTier writableFileStorageTier;
        int n;
        EventIterator eventIterator;
        HashMap<String, List> a52;
        WritableFileStorageTier a7;
        block10: {
            block8: {
                WritableFileStorageTier writableFileStorageTier2 = a7;
                a4 = writableFileStorageTier2.M(a3, a4, new FileVersion(a52, 0), a6);
                writableFileStorageTier2.M(a4.M());
                a4 = writableFileStorageTier2.M((FileVersion)a4, a6);
                writableFileStorageTier2.M(arg_0 -> WritableFileStorageTier.M((FileVersion)a4, arg_0));
                WritableFileStorageTier writableFileStorageTier3 = a7;
                writableFileStorageTier3.h();
                a6 = writableFileStorageTier3.M((FileVersion)a4, a6.getSegmentSize(), false);
                writableFileStorageTier3.c.remove((FileVersion)a4);
                a3 = a4.M();
                a52 = new HashMap<String, List>();
                eventIterator = a6.createEventIterator();
                try {
                    EventIterator eventIterator2 = eventIterator;
                    while (eventIterator2.hasNext()) {
                        EventInformation eventInformation = eventIterator.M();
                        if (eventInformation.M()) {
                            IndexEntry indexEntry = new IndexEntry(eventInformation.M().getAggregateSequenceNumber(), eventInformation.M(), a3);
                            a52.computeIfAbsent(eventInformation.M().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                        }
                        ++a3;
                        eventIterator2 = eventIterator;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (eventIterator != null) {
                            try {
                                eventIterator.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                n = eventIterator.M();
                a7.l.set(a3 - 1L);
                if (eventIterator == null) break block8;
                writableFileStorageTier = a7;
                eventIterator.close();
                break block10;
            }
            writableFileStorageTier = a7;
        }
        writableFileStorageTier.c.addToActiveSegment(Long.valueOf(a4.M()), a52);
        a6.M(n, 0);
        eventIterator = new WritePosition(a3, n, a4.M(), (WritableEventSource)a6, Long.valueOf(a4.M()), 0);
        WritableFileStorageTier writableFileStorageTier4 = a7;
        writableFileStorageTier4.c.set(eventIterator);
        writableFileStorageTier4.C.M((WritePosition)eventIterator);
    }

    public void initSegments(long a2) {
    }

    public Optional<EventSource> eventSource(long a2) {
        WritableFileStorageTier a4;
        Optional optional = a4.M(a2);
        if (optional.isPresent()) {
            return optional;
        }
        return (Optional)a4.M((T a3) -> a3.eventSource(a2), Optional.empty());
    }

    public long h() {
        WritableFileStorageTier a2;
        return ((WritePosition)a2.c.get()).E;
    }

    public WritableFileStorageTier(EventTypeContext a3, IndexManager a4, Supplier<StorageProperties> a5, Supplier<StorageTier> a6, MeterFactory a7, ScheduledExecutorService a8, String a9, EventTransformerFactory a10, FileSystemMonitor a11) {
        WritableFileStorageTier a12;
        WritableFileStorageTier writableFileStorageTier = a12;
        WritableFileStorageTier writableFileStorageTier2 = a12;
        super(a3, a4, a5, a6, a7, a9);
        WritableFileStorageTier writableFileStorageTier3 = a12;
        writableFileStorageTier3.c = new AtomicReference();
        WritableFileStorageTier writableFileStorageTier4 = a12;
        writableFileStorageTier2.l = new AtomicLong(-1L);
        WritableFileStorageTier writableFileStorageTier5 = a12;
        writableFileStorageTier2.G = new ConcurrentSkipListMap(Comparator.reverseOrder());
        writableFileStorageTier2.B = a7;
        writableFileStorageTier.E = a11;
        writableFileStorageTier.A = a10.get(a5.get().getFlags());
        WritableFileStorageTier writableFileStorageTier6 = a12;
        writableFileStorageTier6.C = new Synchronizer(a3, a5.get(), a7, a8, a2 -> {
            WritableFileStorageTier a4;
            WritableFileStorageTier writableFileStorageTier = a4;
            writableFileStorageTier.c.complete(new FileVersion(a2.c.longValue(), 0));
            writableFileStorageTier.M((T a3) -> {
                WritableFileStorageTier a4;
                a3.handover((Segment)new L(a4, a2), () -> {
                    WritableFileStorageTier a3;
                    ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a3.G.remove(a2.c);
                    e.debug(AddContextToReplicationGroup.M((Object)"h;N>E>\u00005V?Rz['\fzR?M;I4I4GzS?G7E4T)\u001az['"), (Object)a2.c, (Object)a3.getSegments());
                    if (byteBufferEventSource != null) {
                        byteBufferEventSource.M((long)((StorageProperties)a3.D.get()).getPrimaryCleanupDelay());
                    }
                });
            });
        });
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a3.M();
        stringArray[2] = "type";
        stringArray[3] = a3.M().name();
        a12.e = a7.gauge((MetricName)BaseMetricName.u, Tags.of((String[])stringArray), (Object)a12.C, a2 -> {
            WritableFileStorageTier a3;
            return (double)a3.l.get() - (double)a2.M();
        });
    }

    private /* synthetic */ WritePosition M(int a2, int a3, int a4) {
        int n = (int)Math.ceil((double)a3 / 32767.0);
        if ((n = a2 + n * 11) > 0x7FFFFFF6 || a2 <= 0) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a2;
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, String.format(AddContextToReplicationGroup.M((Object)"i6L?G;LzT(A4S;C.I5NzS3Z?\u001az\u0005>"), objectArray));
        }
        do {
            WritableFileStorageTier a6;
            if (!(a2 = (WritePosition)a6.c.getAndUpdate(a5 -> a5.M(a3, n, a4))).B(n) && !a2.h(a4)) continue;
            e.debug(ClientEventProcessorInfo.M((Object)"@p\u0001-x\u007f^lOdUj\u001bc^z\u001b~^jVhUy\u001bvF"), (Object)a6.f, (Object)a2.E);
            WritePosition writePosition = a2;
            writePosition.B.M(writePosition.e, -1);
            WritableEventSource writableEventSource = a6.M(new FileVersion(a2.E, a4), n + 5 + 4, true);
            a6.c.set(a2.M(writableEventSource, a4));
        } while (!a2.M(n) || a2.h(a4));
        return a2;
    }

    private /* synthetic */ void h() {
        WritableFileStorageTier a2;
        a2.segmentsWithoutIndex().forEach(a4 -> {
            HashMap<String, List> hashMap;
            WritableFileStorageTier a5;
            Optional optional = (Optional)a5.M((T a3) -> a3.eventSource(a4), Optional.empty());
            if (!optional.isPresent()) return;
            optional = ((EventSource)optional.get()).createEventIterator(a4.M());
            try {
                hashMap = new HashMap<String, List>();
                while (optional.hasNext()) {
                    EventInformation eventInformation = optional.M();
                    if (!eventInformation.M()) continue;
                    IndexEntry indexEntry = new IndexEntry(eventInformation.M().getAggregateSequenceNumber(), eventInformation.M(), eventInformation.M());
                    hashMap.computeIfAbsent(eventInformation.M().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (optional != null) {
                    try {
                        optional.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
            a5.c.createIndex(a4, hashMap);
            if (optional == null) return;
            optional.close();
        });
    }

    private /* synthetic */ boolean M(long a2, int a3) {
        WritableFileStorageTier a4;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.G.remove(a2);
        if (byteBufferEventSource != null) {
            byteBufferEventSource.M(0L);
        }
        if (a4.c.remove(a3 = new FileVersion(a2, a3)) && FileUtils.M((File)a4.h(a3))) {
            return true;
        }
        return false;
    }

    private /* synthetic */ FileVersion M(long a2, File a4, FileVersion a5, StorageProperties a6) {
        return Arrays.stream(FileUtils.M((File)a4, (String)a6.getEventsSuffix())).map(FileUtils::M).filter(a3 -> {
            if (a3.M() < a2) {
                return true;
            }
            return false;
        }).max(FileVersion::M).orElse(a5);
    }

    public int M() {
        WritableFileStorageTier a2;
        return a2.G.size();
    }

    private static /* synthetic */ void M(FileVersion a2, StorageTier a3) {
        a3.initSegments(a2.M());
    }

    public long size() {
        WritableFileStorageTier a3;
        return a3.G.values().stream().mapToLong(a2 -> a2.h.capacity()).sum() + (Long)a3.M(StorageTier::size, (Object)0L);
    }

    public Optional<EventSource> eventSource(FileVersion a2) {
        WritableFileStorageTier a4;
        Optional optional = a4.M(a2);
        if (optional.isPresent()) {
            return optional;
        }
        return (Optional)a4.M((T a3) -> a3.eventSource(a2), Optional.empty());
    }

    public void handover(Segment a2, Runnable a3) {
        a3.run();
    }

    private /* synthetic */ void M() {
        WritableFileStorageTier a2;
        WritableFileStorageTier writableFileStorageTier = a2;
        while (true) {
            if (writableFileStorageTier.G.size() == 1) break;
            try {
                Thread.sleep(10L);
                writableFileStorageTier = a2;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new MessagingPlatformException(ErrorCode.OTHER, a2.f + ": Interrupted while waiting for completion", (Throwable)interruptedException);
            }
        }
    }

    public Stream<String> M(long a3, int a5, boolean a6) {
        WritableFileStorageTier a7;
        if (a6) {
            return Stream.concat(a7.G.entrySet().stream().map(a2 -> {
                WritableFileStorageTier a3;
                return FileUtils.M((File)a3.h(new FileVersion(((Long)a2.getKey()).longValue(), ((ByteBufferEventSource)a2.getValue()).M())));
            }), (Stream)a7.M((T a4) -> a4.getBackupFilenames(a3, a5), Stream.empty()));
        }
        return (Stream)a7.M((T a4) -> a4.getBackupFilenames(a3, a5), Stream.empty());
    }

    public Flux<FileVersion> fileVersions(String a2) {
        WritableFileStorageTier a4;
        return (Flux)a4.M((T a3) -> a3.fileVersions(a2), (Object)Flux.empty());
    }

    public SortedSet<FileVersion> segmentsWithoutIndex() {
        WritableFileStorageTier a2;
        return (SortedSet)a2.M(StorageTier::segmentsWithoutIndex, Collections.emptySortedSet());
    }

    private /* synthetic */ void M(WritePosition a2, List<ProcessedEvent> a6, Map<String, List<IndexEntry>> a7) {
        WritableFileStorageTier a8;
        WritePosition writePosition = a2;
        a2.B.M(a6, writePosition.e, writePosition.E, (a3, a4, a5) -> {
            WritableFileStorageTier a6;
            a6.M(a3, a4, a5, a7);
        });
    }

    public void close(boolean a2) {
        WritableFileStorageTier a5;
        File file = new File(a5.M);
        WritableFileStorageTier writableFileStorageTier = a5;
        WritableFileStorageTier writableFileStorageTier2 = a5;
        writableFileStorageTier.E.unregisterPath(writableFileStorageTier2.M());
        writableFileStorageTier.B.remove((Meter)a5.e);
        writableFileStorageTier2.C.h();
        writableFileStorageTier.G.forEach((a3, a4) -> {
            a4.M(0L);
            if (a2) {
                WritableFileStorageTier a5;
                a5.B(a3.longValue());
            }
        });
        a5.M((T a3) -> a3.close(a2));
        boolean bl = a2;
        a5.c.cleanup(bl);
        if (bl) {
            FileUtils.M((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ FileVersion M(FileVersion a2, StorageProperties a3) {
        WritableFileStorageTier writableFileStorageTier;
        EventIterator eventIterator;
        WritableFileStorageTier a4;
        if (!a4.c.validIndex(a2)) {
            return a2;
        }
        a3 = a4.M(a2, a3.getSegmentSize(), false);
        long l2 = a2.M();
        try {
            eventIterator = a3.createEventIterator(a2.M());
            try {
                while (eventIterator.hasNext()) {
                    eventIterator.M();
                    ++l2;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (eventIterator != null) {
                    try {
                        eventIterator.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        catch (Throwable throwable) {
            a4.G.remove(a2.M());
            a3.M(0L);
            throw throwable;
        }
        if (eventIterator != null) {
            writableFileStorageTier = a4;
            eventIterator.close();
        } else {
            writableFileStorageTier = a4;
        }
        writableFileStorageTier.G.remove(a2.M());
        a3.M(0L);
        return new FileVersion(l2, 0);
    }

    public boolean removeSegment(long a2, int a3) {
        WritableFileStorageTier a5;
        if (a5.G.containsKey(a2)) {
            return a5.M(a2, a3);
        }
        return (Boolean)a5.M((T a4) -> a4.removeSegment(a2, a3), (Object)true);
    }

    public long M(List<Event> a2, int a32) {
        WritableFileStorageTier a4;
        HashMap hashMap = new HashMap();
        WritableFileStorageTier writableFileStorageTier = a4;
        a2 = writableFileStorageTier.M(a2, a32);
        WritePosition a32 = a2.M();
        writableFileStorageTier.M(a32, a2.M(), hashMap);
        writableFileStorageTier.c.addToActiveSegment(a32.c, hashMap);
        writableFileStorageTier.l.set(a32.E + (long)a2.M().size() - 1L);
        writableFileStorageTier.C.h(a32);
        return a32.E;
    }

    /*
     * Loose catch block
     */
    protected WritableEventSource M(FileVersion a2, int a32222, boolean a42222) {
        WritableEventSource a42222;
        FileChannel fileChannel;
        Object object;
        WritableFileStorageTier a5;
        block21: {
            StorageProperties storageProperties = (StorageProperties)a5.D.get();
            File file = storageProperties.dataFile(a5.M, a2);
            int n = Math.max(storageProperties.getSegmentSize(), a32222);
            if (file.exists()) {
                if (a42222 && file.length() < (long)a32222) {
                    object = (ByteBufferEventSource)a5.G.remove(a2.M());
                    if (object != null) {
                        object.M(0L);
                    }
                    FileUtils.M((File)file);
                } else {
                    n = (int)file.length();
                }
            } else if (a2.M() > 0) {
                object = storageProperties.dataFile(a5.M, new FileVersion(a2.M(), 0));
                if (((File)object).exists()) {
                    fileChannel = (ByteBufferEventSource)a5.G.remove(a2.M());
                    if (fileChannel != null) {
                        fileChannel.M(0L);
                    }
                    FileUtils.M((File)object);
                }
            }
            object = new RandomAccessFile(file, ClientEventProcessorInfo.M((Object)"\u007fL"));
            fileChannel = ((RandomAccessFile)object).getChannel();
            e.info(AddContextToReplicationGroup.M((Object)"!]`\u0000\u0015P?N3N=\u0000<I6Ez['"), (Object)a5.f, (Object)file);
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, n);
            mappedByteBuffer.put((byte)2);
            mappedByteBuffer.putInt(storageProperties.getFlags());
            WritableEventSource a32222 = new WritableEventSource(file.getAbsolutePath(), (ByteBuffer)mappedByteBuffer, a2.M(), a2.M(), a5.A, storageProperties);
            a5.G.put(a2.M(), a32222);
            a42222 = a32222;
            if (fileChannel == null) break block21;
            fileChannel.close();
        }
        ((RandomAccessFile)object).close();
        return a42222;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Throwable throwable2;
                        block22: {
                            if (fileChannel != null) {
                                try {
                                    fileChannel.close();
                                    throwable2 = throwable;
                                    break block22;
                                }
                                catch (Throwable a32222) {
                                    throwable.addSuppressed(a32222);
                                }
                            }
                            throwable2 = throwable;
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        Throwable throwable4;
                        try {
                            ((RandomAccessFile)object).close();
                            throwable4 = throwable3;
                        }
                        catch (Throwable throwable5) {
                            Throwable throwable6 = throwable3;
                            throwable4 = throwable6;
                            throwable6.addSuppressed(throwable5);
                        }
                        throw throwable4;
                    }
                }
                catch (Exception exception) {
                    throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, a5.f + ": Failed to create segment: " + a2, (Throwable)exception);
                }
            }
        }
    }

    public void activateSegmentVersion(long a2, int a3) {
        WritableFileStorageTier a5;
        a5.M((T a4) -> a4.activateSegmentVersion(a2, a3));
    }

    public void h(long a22) {
        WritableFileStorageTier a4;
        if (!a4.G.containsKey(a22)) {
            return;
        }
        if (a22 == (Long)a4.G.firstKey()) {
            e.info(ClientEventProcessorInfo.M((Object)"vF7\u001bKT\u007fXdUj\u001bc^uO-Hh\\`^cO-Ob\u001bo^-X\u007f^lOh_"), (Object)a4.f);
            StorageProperties a22 = (StorageProperties)a4.D.get();
            WritePosition writePosition = (WritePosition)a4.c.getAndUpdate(a3 -> a3.M(0, a22.getSegmentSize(), 0));
            if (writePosition.B(a22.getSegmentSize())) {
                e.debug(AddContextToReplicationGroup.M((Object)"!]`\u0000\u0019R?A.I4GzN?WzS?G7E4Tz['"), (Object)a4.f, (Object)writePosition.E);
                WritePosition writePosition2 = writePosition;
                writePosition2.B.M(writePosition2.e, -1);
                WritableFileStorageTier writableFileStorageTier = a4;
                WritableFileStorageTier writableFileStorageTier2 = a4;
                WritableEventSource writableEventSource = writableFileStorageTier.M(new FileVersion(writePosition.E, 0), a22.getSegmentSize(), false);
                a4.c.set(writePosition.M(writableEventSource, 0));
                writableFileStorageTier.C.h(new WritePosition(writePosition.E, 0, 0, writableEventSource, Long.valueOf(writePosition.E), writePosition.l));
            }
        }
        a4.M();
    }

    private /* synthetic */ String M() {
        WritableFileStorageTier a2;
        WritableFileStorageTier writableFileStorageTier = a2;
        return writableFileStorageTier.f + "-" + writableFileStorageTier.f.M().name().toLowerCase();
    }

    public long M() {
        WritableFileStorageTier a3;
        return (Long)a3.M((T a2) -> a2.allSegments().findFirst().orElse(-1L), (Object)-1L);
    }

    protected Optional<EventSource> M(long a2) {
        WritableFileStorageTier a3;
        if (a3.G.containsKey(a2)) {
            return Optional.of((EventSource)a3.G.get(a2));
        }
        return Optional.empty();
    }

    private /* synthetic */ int M(List<ProcessedEvent> a2) {
        long l2 = 0L;
        Object object = a2 = a2.iterator();
        while (object.hasNext()) {
            ProcessedEvent processedEvent = (ProcessedEvent)a2.next();
            l2 += (long)(4 + processedEvent.getSerializedSize());
            object = a2;
        }
        if (l2 > Integer.MAX_VALUE) {
            WritableFileStorageTier a3;
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, a3.f + ": Transaction size exceeds maximum size");
        }
        return (int)l2;
    }

    private /* synthetic */ void M(ProcessedEvent a3, long a4, int a5, Map<String, List<IndexEntry>> a6) {
        if (a3.isDomainEvent()) {
            a6.computeIfAbsent(a3.getAggregateIdentifier(), a2 -> new ArrayList()).add(new IndexEntry(a3.getAggregateSequenceNumber(), a5, a4));
        }
    }
}

