/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file.xref;

import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.EventStoreValidationException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.xref.GlobalIndex;
import io.axoniq.axonserver.localstorage.file.xref.JumpSkipIndexEntries;
import io.axoniq.axonserver.localstorage.file.xref.LastEventPositionInfo;
import io.axoniq.axonserver.localstorage.file.xref.ReadOnlyJumpSkipIndexManager;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.rest.svg.jsfunction.ShowDetail;
import io.axoniq.axonserver.taskscheduler.TransientException;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryJumpSkipIndexManager
extends ReadOnlyJumpSkipIndexManager {
    protected final ConcurrentNavigableMap<Long, Map<String, JumpSkipIndexEntries>> E;
    public static final int C = 2;
    protected final GlobalIndex c;
    private static final Logger e = LoggerFactory.getLogger(ReadOnlyJumpSkipIndexManager.class);

    public Stream<File> getBackupFilenames(long a2, int a3) {
        PrimaryJumpSkipIndexManager a4;
        return Stream.concat(super.getBackupFilenames(a2, a3), a4.c.M());
    }

    public List<File> indexFiles(FileVersion a2) {
        PrimaryJumpSkipIndexManager a3;
        return Collections.singletonList(((StorageProperties)a3.e.get()).newIndex(a3.m, a2));
    }

    public boolean limitedSegmentChecks() {
        PrimaryJumpSkipIndexManager a2;
        if (((StorageProperties)a2.e.get()).globalIndexSegmentsCheck() < Integer.MAX_VALUE) {
            return true;
        }
        return false;
    }

    public void complete(FileVersion a2) {
        PrimaryJumpSkipIndexManager a3;
        PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager = a3;
        primaryJumpSkipIndexManager.M(a2, (Map)primaryJumpSkipIndexManager.E.get(a2.M()));
        a3.C.put(a2.M(), a2.M());
        a3.E.remove(a2.M());
        a3.h();
    }

    public void addToActiveSegment(long a3, String a4, IndexEntry a5) {
        PrimaryJumpSkipIndexManager a6;
        if (a6.C.containsKey(a3)) {
            throw new IndexNotFoundException(a3 + ": already completed");
        }
        JumpSkipIndexEntries jumpSkipIndexEntries = (JumpSkipIndexEntries)a6.E.computeIfAbsent(a3, a2 -> new ConcurrentHashMap()).get(a4);
        if (jumpSkipIndexEntries == null) {
            if (a5.h() > 0L) {
                LastEventPositionInfo lastEventPositionInfo = a6.M(a4);
                if (lastEventPositionInfo != null) {
                    jumpSkipIndexEntries = new JumpSkipIndexEntries(lastEventPositionInfo.h(), a5.h());
                } else {
                    lastEventPositionInfo = a6.c.M(a4, Integer.MAX_VALUE, new LastEventPositionInfo(-1L, -1L));
                    jumpSkipIndexEntries = new JumpSkipIndexEntries(lastEventPositionInfo.h(), a5.h());
                }
            } else {
                jumpSkipIndexEntries = new JumpSkipIndexEntries(-1L, a5.h());
            }
            ((Map)a6.E.get(a3)).put(a4, jumpSkipIndexEntries);
        }
        jumpSkipIndexEntries.add(a5);
    }

    public void createIndex(FileVersion a2, Map<String, List<IndexEntry>> a5) {
        PrimaryJumpSkipIndexManager a6;
        HashMap hashMap = new HashMap();
        a5.forEach((a3, a4) -> {
            JumpSkipIndexEntries jumpSkipIndexEntries = (JumpSkipIndexEntries)hashMap.get(a3);
            if (jumpSkipIndexEntries == null) {
                PrimaryJumpSkipIndexManager a5;
                IndexEntry indexEntry = (IndexEntry)a4.get(0);
                jumpSkipIndexEntries = a5.M(a3, indexEntry);
                hashMap.put(a3, jumpSkipIndexEntries);
            }
            jumpSkipIndexEntries.addAll(a4);
        });
        PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager = a6;
        primaryJumpSkipIndexManager.h(a2, hashMap);
        primaryJumpSkipIndexManager.c.M(hashMap, a2.M());
    }

    protected void M(FileVersion a2, Map<String, JumpSkipIndexEntries> a3) {
        PrimaryJumpSkipIndexManager a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.g;
        objectArray[1] = a4.G;
        objectArray[2] = a2;
        e.debug(TransientException.M((Object)"\u0006\u0017GJ\u001e\u0018\u0018\u000b\t\u000f]\u0011\u0000J\u0014\u0004\u0019\u000f\u0005J\u001b\u0005\u000fJ\u0006\u0017"), objectArray);
        StorageProperties storageProperties = (StorageProperties)a4.e.get();
        a3 = a3 == null ? Collections.emptyMap() : a3;
        File file = a4.M(a2, a3);
        try {
            File file2 = storageProperties.newIndex(a4.m, a2);
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(file.toPath(), file2.toPath(), copyOptionArray);
            a4.K.addAndGet(file2.length());
            a4.c.M(a3, a2.M());
            return;
        }
        catch (IOException iOException) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(a4.m, a2), (Throwable)iOException);
        }
    }

    @Nonnull
    protected JumpSkipIndexEntries M(String a2, IndexEntry a3) {
        JumpSkipIndexEntries jumpSkipIndexEntries;
        if (a3.h() > 0L) {
            PrimaryJumpSkipIndexManager a4;
            LastEventPositionInfo lastEventPositionInfo = a4.M(a2);
            if (lastEventPositionInfo != null) {
                jumpSkipIndexEntries = new JumpSkipIndexEntries(lastEventPositionInfo.h(), a3.h());
            } else {
                a2 = a4.c.M(a2, Integer.MAX_VALUE, new LastEventPositionInfo(-1L, -1L));
                jumpSkipIndexEntries = new JumpSkipIndexEntries(a2.h(), a3.h());
            }
        } else {
            jumpSkipIndexEntries = new JumpSkipIndexEntries(-1L, a3.h());
        }
        return jumpSkipIndexEntries;
    }

    MeterFactory.RateMeter M() {
        PrimaryJumpSkipIndexManager a2;
        return a2.a;
    }

    public SegmentIndexEntries lastIndexEntries(String a2, long a3) {
        PrimaryJumpSkipIndexManager a4;
        for (Long l2 : a4.E.descendingKeySet()) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a4.g;
            objectArray[1] = a2;
            objectArray[2] = l2;
            objectArray[3] = a4.E.getOrDefault(l2, Collections.emptyMap()).size();
            e.debug(ShowDetail.M((Object)"\u001e!_|\t=\u0016( *\u00002\u0011|\u001e!E5\u000b|\u00169\u00021\u00002\u0011|\u001e!E1\u0004,E/\f&\u0000|\u001e!"), objectArray);
            IndexEntries indexEntries = (IndexEntries)a4.E.getOrDefault(l2, Collections.emptyMap()).get(a2);
            if (indexEntries == null || a3 != Long.MAX_VALUE && indexEntries.firstSequenceNumber() >= a3) continue;
            IndexEntries indexEntries2 = indexEntries;
            return new SegmentIndexEntries(new FileVersion(l2.longValue(), 0), indexEntries2.range(indexEntries2.firstSequenceNumber(), a3, EventType.e.equals((Object)a4.G)));
        }
        LastEventPositionInfo lastEventPositionInfo = a4.c.M(a2, Integer.MAX_VALUE);
        if (lastEventPositionInfo == null) {
            return null;
        }
        return a4.lastIndexEntriesFromClosedSegments(a2, a3, lastEventPositionInfo.h());
    }

    public PrimaryJumpSkipIndexManager(String a2, Supplier<StorageProperties> a3, String a4, EventType a5, MeterFactory a6, int a7, Supplier<IndexManager> a8) {
        PrimaryJumpSkipIndexManager a9;
        Supplier<StorageProperties> supplier = a3;
        super(a2, supplier, a4, a5, a6, a8);
        PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager = a9;
        primaryJumpSkipIndexManager.E = new ConcurrentSkipListMap();
        a2 = supplier.get();
        PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager2 = a9;
        primaryJumpSkipIndexManager2.c = new GlobalIndex(a4, (StorageProperties)a2, a7);
    }

    public void cleanup(boolean a2) {
        PrimaryJumpSkipIndexManager a3;
        PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager = a3;
        primaryJumpSkipIndexManager.E.clear();
        primaryJumpSkipIndexManager.c.M(a2);
        super.cleanup(a2);
    }

    public Optional<Long> getLastSequenceNumber(String a2, EventStorageEngine.SearchHint a3, long a42) {
        Long l22;
        PrimaryJumpSkipIndexManager a5;
        for (Long l22 : a5.E.descendingKeySet()) {
            IndexEntries indexEntries = (IndexEntries)a5.E.getOrDefault(l22, Collections.emptyMap()).get(a2);
            if (indexEntries == null) continue;
            return Optional.of(indexEntries.lastSequenceNumber());
        }
        int a42 = EventStorageEngine.SearchHint.c.equals((Object)a3) ? Math.max(((StorageProperties)a5.e.get()).globalIndexSegmentsCheck(), 2) : Integer.MAX_VALUE;
        l22 = a5.c.M(a2, a42);
        if (l22 == null) {
            return Optional.empty();
        }
        return Optional.of(l22.M());
    }

    public long size() {
        PrimaryJumpSkipIndexManager a2;
        return super.size() + a2.c.h();
    }

    public void addToActiveSegment(Long a2, Map<String, List<IndexEntry>> a3) {
        PrimaryJumpSkipIndexManager a6;
        if (a6.C.containsKey(a2)) {
            throw new IndexNotFoundException(a2 + ": already completed");
        }
        a3.forEach((a4, a5) -> {
            PrimaryJumpSkipIndexManager a6;
            JumpSkipIndexEntries jumpSkipIndexEntries = (JumpSkipIndexEntries)a6.E.computeIfAbsent(a2, a2 -> new ConcurrentHashMap()).get(a4);
            if (jumpSkipIndexEntries == null) {
                IndexEntry indexEntry = (IndexEntry)a5.get(0);
                PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager = a6;
                jumpSkipIndexEntries = primaryJumpSkipIndexManager.M(a4, indexEntry);
                ((Map)primaryJumpSkipIndexManager.E.get(a2)).put(a4, jumpSkipIndexEntries);
            }
            jumpSkipIndexEntries.addAll(a5);
        });
    }

    protected LastEventPositionInfo M(String a2) {
        PrimaryJumpSkipIndexManager a3;
        for (Long l2 : a3.E.descendingKeySet()) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a3.g;
            objectArray[1] = a2;
            objectArray[2] = l2;
            objectArray[3] = a3.E.getOrDefault(l2, Collections.emptyMap()).size();
            e.debug(TransientException.M((Object)"\u0011\u0000P]\u0006\u001c\u0019\t+\u001e\u001e\u0014\u001c\u0018#\u0013\u000e\u0018\u00128\u0004\t\u0018\u0004J\u0006\u0017]\u0003\u0013J\u000e\u000f\u001a\u0007\u0018\u0004\tJ\u0006\u0017]\u0007\u001c\u001a]\u0019\u0014\u0010\u0018J\u0006\u0017"), objectArray);
            if ((l2 = (JumpSkipIndexEntries)a3.E.getOrDefault(l2, Collections.emptyMap()).get(a2)) == null) continue;
            return l2.M();
        }
        return null;
    }

    protected FileVersion M(long a2) {
        PrimaryJumpSkipIndexManager a3;
        NavigableSet<Long> navigableSet = a3.E.headMap((Object)a2, true);
        if (!navigableSet.isEmpty()) {
            return new FileVersion(((Long)navigableSet.lastKey()).longValue(), ((Integer)a3.C.get(navigableSet.lastKey())).intValue());
        }
        navigableSet = a3.C.keySet().tailSet(a2, true);
        if (navigableSet.isEmpty()) {
            throw new IndexNotFoundException(a3.g + ": Index for token not found: " + a2);
        }
        return new FileVersion(((Long)navigableSet.first()).longValue(), ((Integer)a3.C.get(navigableSet.first())).intValue());
    }

    public void init() {
        PrimaryJumpSkipIndexManager a5;
        if (!a5.A.get()) {
            int n;
            long l2;
            a5.c.M();
            File[] fileArray = new File(a5.m).listFiles(a2 -> {
                PrimaryJumpSkipIndexManager a3;
                return a2.getName().endsWith(a3.d);
            });
            long l3 = l2 = a5.c.M() == 0L ? Long.MAX_VALUE : a5.c.M();
            if (fileArray == null) {
                return;
            }
            int n2 = fileArray.length;
            int n3 = n = 0;
            while (n3 < n2) {
                File file = fileArray[n];
                FileVersion fileVersion = FileUtils.M((String)file.getName());
                if (fileVersion.M() <= l2) {
                    PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager = a5;
                    if (((StorageProperties)a5.e.get()).dataFile(a5.m, fileVersion).exists()) {
                        primaryJumpSkipIndexManager.C.compute(fileVersion.M(), (a3, a4) -> a4 == null ? fileVersion.M() : Math.max(fileVersion.M(), a4));
                        a5.K.addAndGet(file.length());
                    } else {
                        primaryJumpSkipIndexManager.remove(fileVersion);
                    }
                } else {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a5.g;
                    objectArray[1] = a5.G;
                    objectArray[2] = file;
                    e.warn(ShowDetail.M((Object)"'\u0018fE\u001a\n)\u000b8E'\u0018|\f2\u00019\u001d|\u00169\u00021\u00002\u0011|\u000b3\u0011|\f2E;\t3\u0007=\t|\f2\u00019\u001dpE.\u00001\n*\f2\u0002|\u001e!"), objectArray);
                    a5.remove(fileVersion);
                }
                n3 = ++n;
            }
            if (a5.c.M() >= 0L && (a5.C.isEmpty() || a5.c.M() != ((Long)a5.C.keySet().first()).longValue())) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a5.g;
                objectArray[1] = a5.G;
                objectArray[2] = a5.c.M();
                throw new EventStoreValidationException(String.format(TransientException.M((Object)"O\u000eP]\u0003\u0013\u001c\u001c\u0006\u0014\u000e]\r\u0011\u0005\u001f\u000b\u0011J\u0014\u0004\u0019\u000f\u0005J\u001b\u0005\u000fJX\u0019QJ\u001a\u0006\u0012\b\u001c\u0006]\u0003\u0013\u000e\u0018\u0012]\u000f\u0005\u001a\u0018\t\t\u0019]\u0006\u001c\u0019\tJ\u000e\u000f\u001a\u0007\u0018\u0004\tJX\u000e"), objectArray));
            }
            PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager = a5;
            primaryJumpSkipIndexManager.h();
            primaryJumpSkipIndexManager.A.set(true);
        }
    }

    public PrimaryJumpSkipIndexManager(String a2, Supplier<StorageProperties> a3, String a4, EventType a5, MeterFactory a6, Supplier<IndexManager> a7) {
        a8(a2, a3, a4, a5, a6, 1000000, a7);
        PrimaryJumpSkipIndexManager a8;
    }

    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String a2, long a3, long a4, long a5, long a6) {
        LastEventPositionInfo lastEventPositionInfo;
        PrimaryJumpSkipIndexManager a7;
        TreeMap<FileVersion, IndexEntries> treeMap = new TreeMap<FileVersion, IndexEntries>();
        Object[] objectArray = new Object[4];
        objectArray[0] = a7.g;
        objectArray[1] = a2;
        objectArray[2] = a3;
        objectArray[3] = a4;
        e.debug(ShowDetail.M((Object)"\u001e!_|\t3\n7\u0010,$;\u0002.\u0000;\u0004(\u0000|\u001e!E1\f269\u0014)\u00002\u00069+)\b>\u0000.E'\u0018pE0\u0004/\u0011\u000f\u0000-\u00109\u000b?\u0000\u0012\u00101\u00079\u0017|\u001e!"), objectArray);
        long l2 = -1L;
        long l3 = Long.MAX_VALUE;
        LastEventPositionInfo lastEventPositionInfo2 = lastEventPositionInfo = a7.E.descendingKeySet().iterator();
        while (lastEventPositionInfo2.hasNext()) {
            Long l4 = (Long)lastEventPositionInfo.next();
            if (l3 < a6) {
                return treeMap;
            }
            JumpSkipIndexEntries jumpSkipIndexEntries = (JumpSkipIndexEntries)a7.E.getOrDefault(l4, Collections.emptyMap()).get(a2);
            Object[] objectArray2 = new Object[4];
            objectArray2[0] = a7.g;
            objectArray2[1] = a2;
            objectArray2[2] = l4;
            objectArray2[3] = jumpSkipIndexEntries;
            e.debug(TransientException.M((Object)"\u0011\u0000P]\u0006\u0012\u0005\u0016\u001f\r+\u001a\r\u000f\u000f\u001a\u000b\t\u000f]\u0011\u0000J\u0014\u0004]\u0019\u0018\r\u0010\u000f\u0013\u001e]\u0011\u0000J\u001b\u0005\b\u0004\u0019J\u0006\u0017"), objectArray2);
            if (jumpSkipIndexEntries != null) {
                if (jumpSkipIndexEntries.lastSequenceNumber() < a3) {
                    return treeMap;
                }
                IndexEntries indexEntries = jumpSkipIndexEntries.range(a3, a4, EventType.e.equals((Object)a7.G));
                if (!indexEntries.isEmpty()) {
                    treeMap.put(new FileVersion(l4.longValue(), 0), indexEntries);
                    if (a7.M(a3, a5 -= (long)indexEntries.size(), (IndexEntries)jumpSkipIndexEntries)) {
                        return treeMap;
                    }
                }
                l2 = jumpSkipIndexEntries.M();
            }
            l3 = l4;
            lastEventPositionInfo2 = lastEventPositionInfo;
        }
        if (l2 < 0L && (lastEventPositionInfo = a7.c.M(a2, Integer.MAX_VALUE)) != null) {
            LastEventPositionInfo lastEventPositionInfo3 = lastEventPositionInfo;
            l2 = lastEventPositionInfo3.h();
            if (lastEventPositionInfo3.M() < a3) {
                return treeMap;
            }
        }
        TreeMap<FileVersion, IndexEntries> treeMap2 = treeMap;
        treeMap2.putAll(a7.lookupAggregateInClosedSegments(a2, a3, a4, a5, a6, l2));
        return treeMap2;
    }

    /*
     * Exception decompiling
     */
    public boolean validIndex(FileVersion a) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

