/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.logging;

import io.axoniq.axonserver.applicationevents.UserEvents;
import io.axoniq.axonserver.localstorage.SerializedTransactionWithToken;
import io.axoniq.axonserver.logging.L;
import io.axoniq.axonserver.util.StringUtils;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class AuditLog {
    private static final Logger e = AuditLog.getLogger();

    @EventListener
    public void on(AbstractAuthenticationEvent a2) {
        if (a2 instanceof InteractiveAuthenticationSuccessEvent) {
            return;
        }
        Authentication authentication = a2.getAuthentication();
        if (e.isDebugEnabled()) {
            e.debug(a2.toString());
            return;
        }
        if (a2 instanceof AuthenticationSuccessEvent && authentication.isAuthenticated()) {
            e.info(SerializedTransactionWithToken.M((Object)"\n\u0001!\u0007(N1\u00072\u0006f\u001b5\u000b4\u0000'\u0003#Nd\u0015;Lh"), (Object)authentication.getName());
            return;
        }
        if (a2 instanceof AbstractAuthenticationFailureEvent) {
            a2 = (AbstractAuthenticationFailureEvent)a2;
            e.error(SerializedTransactionWithToken.M((Object)"\n\u0001!\u0007(N1\u00072\u0006f\u001b5\u000b4\u0000'\u0003#Nd\u0015;Lf(\u0007'\n+\u0002Tf\u0015;"), (Object)authentication.getName(), (Object)a2.getException().getMessage());
        }
    }

    @EventListener
    public void on(UserEvents.AdminUserDeleted a2) {
        if (e.isDebugEnabled()) {
            e.debug(a2.toString());
        }
    }

    public static String enablement(boolean a2) {
        if (a2) {
            return SerializedTransactionWithToken.M((Object)"\u0003 \u0007,\n+\u0002");
        }
        return SerializedTransactionWithToken.M((Object)"*\u000f=\u0007,\n+\u0002");
    }

    public static String username(String a2) {
        if (a2 == null) {
            return SerializedTransactionWithToken.M((Object)"z\u000f(\u0001(\u0017+\u00013\u001dx");
        }
        return StringUtils.sanitize((String)a2);
    }

    public AuditLog() {
        AuditLog a2;
    }

    public static String username(Principal a2) {
        if (a2 == null) {
            return SerializedTransactionWithToken.M((Object)"z\u000f(\u0001(\u0017+\u00013\u001dx");
        }
        return StringUtils.sanitize((String)a2.getName());
    }

    @EventListener
    public void on(UserEvents.AdminUserUpdated a2) {
        if (e.isDebugEnabled()) {
            e.debug(a2.toString());
        }
    }

    public static <T> Logger getLogger() {
        return LoggerFactory.getLogger((String)("AUDIT." + L.e.M()[2].getName()));
    }
}

