/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message;

import io.axoniq.axonserver.component.processor.ClientsByEventProcessor;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class ContextLimitedCache<CACHE extends NonReplacingConstraintCache<String, T>, T>
implements NonReplacingConstraintCache<String, T> {
    private final Function<String, Long> A;
    private final Map<String, Long> E;
    private final Map<String, AtomicLong> C;
    private final CACHE c;
    private final Function<T, String> e;

    public T remove(@Nonnull String a4) {
        if ((a4 = this.c.remove(a4)) != null) {
            ContextLimitedCache contextLimitedCache = this;
            contextLimitedCache.C.computeIfPresent((String)contextLimitedCache.e.apply(a4), (a2, a3) -> {
                AtomicLong atomicLong = a3;
                atomicLong.decrementAndGet();
                return atomicLong;
            });
        }
        return (T)a4;
    }

    public T get(String a2) {
        ContextLimitedCache a3;
        return (T)a3.c.get((Object)a2);
    }

    public Stream<T> getMessagesForContext(String a2) {
        ContextLimitedCache a4;
        return a4.c.entrySet().stream().filter(a3 -> {
            ContextLimitedCache a4;
            return a2.equals(a4.e.apply(a3.getValue()));
        }).map(Map.Entry::getValue);
    }

    public Collection<Map.Entry<String, T>> entrySet() {
        ContextLimitedCache a2;
        return a2.c.entrySet();
    }

    public T putIfAbsent(@Nonnull String key, @Nonnull T a4) {
        String string = (String)this.e.apply(a4);
        long l2 = this.E.computeIfAbsent(string, this.A::apply);
        if (l2 != -1L) {
            this.C.computeIfAbsent(string, a2 -> new AtomicLong()).getAndUpdate(a3 -> {
                if (a3 >= l2) {
                    throw new InsufficientBufferCapacityException(ClientsByEventProcessor.M((Object)"t\u0015P\u0006S\u0012\u0016\tE@P\u0015Z\f\u001a@E\fY\u0017\u0016\u0004Y\u0017XN"));
                }
                return a3 + 1L;
            });
        }
        try {
            return (T)this.c.putIfAbsent((Object)key, a4);
        }
        catch (InsufficientBufferCapacityException insufficientBufferCapacityException) {
            this.C.computeIfPresent(string, (a2, a3) -> {
                AtomicLong atomicLong = a3;
                atomicLong.decrementAndGet();
                return atomicLong;
            });
            throw insufficientBufferCapacityException;
        }
    }

    public long activeMessages(String a2) {
        ContextLimitedCache a3;
        return a3.C.getOrDefault(a2, new AtomicLong(0L)).get();
    }

    public void setMaxMessagesForContext(String a2, long a3) {
        ContextLimitedCache a4;
        a4.E.put(a2, a3);
    }

    protected ContextLimitedCache(Function<T, String> a2, Function<String, Long> a3, CACHE a4) {
        ContextLimitedCache a5;
        ContextLimitedCache contextLimitedCache = a5;
        ContextLimitedCache contextLimitedCache2 = a5;
        ContextLimitedCache contextLimitedCache3 = a5;
        contextLimitedCache2.C = new ConcurrentHashMap();
        ContextLimitedCache contextLimitedCache4 = a5;
        contextLimitedCache2.E = new ConcurrentHashMap();
        contextLimitedCache2.e = a2;
        contextLimitedCache.A = a3;
        contextLimitedCache.c = a4;
    }

    public int size() {
        ContextLimitedCache a2;
        return a2.c.size();
    }

    public Set<Map.Entry<String, T>> timedOut() {
        ContextLimitedCache a2;
        return a2.c.timedOut();
    }
}

