/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.command;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.grpc.SerializedCommandResponse;
import io.axoniq.axonserver.grpc.command.CommandResponse;
import io.axoniq.axonserver.interceptor.CommandInterceptors;
import io.axoniq.axonserver.interceptor.DefaultExecutionContext;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.DispatchQueueMetrics;
import io.axoniq.axonserver.message.FlowControlQueues;
import io.axoniq.axonserver.message.QueueMetrics;
import io.axoniq.axonserver.message.command.CommandHandler;
import io.axoniq.axonserver.message.command.CommandInformation;
import io.axoniq.axonserver.message.command.CommandMetricsRegistry;
import io.axoniq.axonserver.message.command.CommandRegistrationCache;
import io.axoniq.axonserver.message.command.WrappedCommand;
import io.axoniq.axonserver.message.query.subscription.metric.GlobalSubscriptionMetricRegistry;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.plugin.ExecutionContext;
import io.axoniq.axonserver.transport.rest.EventStoreTransformationRestController;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import io.micrometer.core.instrument.Tags;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="CommandDispatcher")
public class CommandDispatcher {
    private final CommandInterceptors l;
    private final CommandMetricsRegistry G;
    private final Map<String, AtomicInteger> B;
    private final FlowControlQueues<WrappedCommand> A;
    private final Map<String, MeterFactory.RateMeter> E;
    private final Logger C;
    private final CommandRegistrationCache c;
    private final NonReplacingConstraintCache<String, CommandInformation> e;

    public MeterFactory.RateMeter commandRate(String a3) {
        CommandDispatcher a4;
        return a4.E.computeIfAbsent(a3, a2 -> {
            CommandDispatcher a3;
            return a3.G.rateMeter(a2, (MetricName)BaseMetricName.y, (MetricName)BaseMetricName.ka);
        });
    }

    private /* synthetic */ void h(ClientStreamIdentification a2) {
        CommandDispatcher a3;
        a3.c.remove(a2);
    }

    public CommandDispatcher(CommandRegistrationCache registrations, NonReplacingConstraintCache<String, CommandInformation> commandCache, CommandMetricsRegistry metricRegistry, MeterFactory meterFactory, CommandInterceptors commandInterceptors, ClientIdRegistry clientIdRegistry, @Value(value="${axoniq.axonserver.command-queue-capacity-per-client:10000}") int a2) {
        CommandDispatcher commandDispatcher = this;
        CommandDispatcher commandDispatcher2 = this;
        this.C = LoggerFactory.getLogger(CommandDispatcher.class);
        CommandDispatcher commandDispatcher3 = this;
        this.E = new ConcurrentHashMap();
        CommandDispatcher commandDispatcher4 = this;
        commandDispatcher3.B = new ConcurrentHashMap();
        commandDispatcher2.c = registrations;
        commandDispatcher2.e = commandCache;
        commandDispatcher.G = metricRegistry;
        commandDispatcher.l = commandInterceptors;
        registrations = new DispatchQueueMetrics(meterFactory, (MetricName)BaseMetricName.ja, (MetricName)BaseMetricName.a, clientIdRegistry);
        CommandDispatcher commandDispatcher5 = this;
        commandDispatcher.A = new FlowControlQueues(Comparator.comparing(WrappedCommand::M).reversed(), a2, (QueueMetrics)registrations, ErrorCode.TOO_MANY_REQUESTS);
        metricRegistry.gauge((MetricName)BaseMetricName.Ga, commandCache, ConstraintCache::size);
    }

    private /* synthetic */ void M(ClientStreamIdentification a4) {
        CommandDispatcher a5;
        a5.e.entrySet().stream().filter(a3 -> ((CommandInformation)a3.getValue()).M(a4)).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(a2 -> {
            CommandDispatcher a3;
            CommandInformation commandInformation = (CommandInformation)a3.e.remove(a2);
            if (commandInformation != null) {
                commandInformation.M().accept(a3.M(a2, ErrorCode.CONNECTION_TO_HANDLER_LOST, "Connection lost while executing command on: " + commandInformation.E()));
            }
        });
    }

    public void dispatchProxied(String a2, SerializedCommand a3, Consumer<SerializedCommandResponse> a4) {
        CommandDispatcher a5;
        String string = a3.getClientStreamId();
        a2 = new ClientStreamIdentification(a2, string);
        CommandDispatcher commandDispatcher = a5;
        a2 = commandDispatcher.c.findByClientAndCommand((ClientStreamIdentification)a2, a3.getCommand());
        Object[] objectArray = new Object[2];
        objectArray[0] = string;
        objectArray[1] = a3.getCommand();
        commandDispatcher.M(a3, (CommandHandler)a2, a4, ErrorCode.CLIENT_DISCONNECTED, String.format(EventStoreTransformationRestController.M((Object)"*\f\u0000\u0005\u0007\u0014IE\u001a@\u0007\u000f\u001d@\u000f\u000f\u001c\u000e\r@\u001e\b\u0000\f\f@\u0019\u0012\u0006\u0003\f\u0013\u001a\t\u0007\u0007S@L\u0013"), objectArray));
    }

    @Nonnull
    private /* synthetic */ SerializedCommandResponse M(String a2, ErrorCode a3, String a4) {
        return new SerializedCommandResponse(CommandResponse.newBuilder().setMessageIdentifier(UUID.randomUUID().toString()).setRequestIdentifier(a2).setErrorCode(a3.getCode()).setErrorMessage(ErrorMessageFactory.M((String)a4)).build());
    }

    public int activeCommandCount() {
        CommandDispatcher a2;
        return a2.e.size();
    }

    private /* synthetic */ void M(DefaultExecutionContext a2, Consumer a3, SerializedCommandResponse a4) {
        CommandDispatcher a5;
        a5.M(a2, a4, a3);
    }

    private /* synthetic */ void M(DefaultExecutionContext a2, SerializedCommandResponse a3, Consumer<SerializedCommandResponse> a4) {
        CommandDispatcher a5;
        try {
            a4.accept(a5.l.commandResponse(a3, (ExecutionContext)a2));
            return;
        }
        catch (Exception exception) {
            CommandDispatcher commandDispatcher = a5;
            commandDispatcher.C.warn(EventStoreTransformationRestController.M((Object)"\u001b\u0014ZI%\u0011\u0003\f\u0010\u001d\t\u0006\u000eI\t\u0007@\u001b\u0005\u001a\u0010\u0006\u000e\u001a\u0005I\t\u0007\u0014\f\u0012\n\u0005\u0019\u0014\u0006\u0012"), (Object)a2.contextName(), (Object)exception);
            a4.accept(commandDispatcher.M(a3.getRequestIdentifier(), ErrorCode.fromException((Throwable)exception), exception.getMessage()));
            a2.compensate((Throwable)exception);
            return;
        }
    }

    public void dispatch(String a2, Authentication a4, SerializedCommand a6, Consumer<SerializedCommandResponse> a7) {
        CommandDispatcher a8;
        String string = a2;
        a8.B.computeIfAbsent(string, a3 -> {
            CommandDispatcher a4;
            a3 = new AtomicInteger();
            a4.G.gauge((MetricName)BaseMetricName.Ca, Tags.of((String)"context", (String)string), ((AtomicInteger)a3)::get);
            return a3;
        }).incrementAndGet();
        a7 = a5 -> {
            CommandDispatcher a6;
            SerializedCommandResponse serializedCommandResponse = a5;
            a7.accept(serializedCommandResponse);
            if (a6.M(serializedCommandResponse)) {
                a6.G.error(a6.getCommand(), a2, a5.getErrorCode());
            }
            ((AtomicInteger)a6.B.get(a2)).decrementAndGet();
        };
        CommandDispatcher commandDispatcher = a8;
        commandDispatcher.commandRate(a2).h();
        commandDispatcher.M(a2, a4, a6, a7);
    }

    private /* synthetic */ void M(SerializedCommand a2, CommandHandler a3, Consumer<SerializedCommandResponse> a4, ErrorCode a52, String a6) {
        block4: {
            CommandDispatcher a7;
            if (a3 == null) {
                CommandDispatcher commandDispatcher = a7;
                commandDispatcher.C.warn(GlobalSubscriptionMetricRegistry.M((Object)"\u0016exB9d<f=xxl7xxi7g5k6nb*#w"), (Object)a2.getName());
                a4.accept(commandDispatcher.M(a2.getMessageIdentifier(), a52, a6));
                return;
            }
            try {
                CommandDispatcher commandDispatcher = a7;
                commandDispatcher.C.debug(EventStoreTransformationRestController.M((Object)"-\t\u001a\u0010\b\u0014\n\bI\u001b\u0014@\u001d\u000fS@\u0012\u001d"), (Object)a2.getName(), (Object)a3.M());
                a52 = new CommandInformation(a2.getName(), a2.getMessageIdentifier(), a2.wrapped().getClientId(), a3, a4);
                if (commandDispatcher.e.putIfAbsent((Object)a2.getMessageIdentifier(), (Object)a52) == null) break block4;
                Object[] objectArray = new Object[1];
                objectArray[0] = a2.getMessageIdentifier();
                a4.accept(a7.M(a2.getMessageIdentifier(), ErrorCode.COMMAND_DUPLICATED, String.format(GlobalSubscriptionMetricRegistry.M((Object)";e5g9d<*1nx/+*<\u007f(f1i9~=n"), objectArray)));
                return;
            }
            catch (MessagingPlatformException a52) {
                a7.e.remove((Object)a2.getMessageIdentifier());
                a4.accept(a7.M(a2.getMessageIdentifier(), a52.getErrorCode(), a52.getMessage()));
                return;
            }
        }
        a3.M(a2);
    }

    @EventListener
    public void on(TopologyEvents.CommandHandlerDisconnected a2) {
        CommandDispatcher a3;
        a3.M(a2.M(), a2.M());
    }

    private /* synthetic */ boolean M(SerializedCommandResponse a2) {
        if (ErrorCode.NO_HANDLER_FOR_COMMAND.getCode().equals(a2.getErrorCode()) || ErrorCode.TOO_MANY_REQUESTS.getCode().equals(a2.getErrorCode()) || ErrorCode.OTHER.getCode().equals(a2.getErrorCode()) || ErrorCode.EXCEPTION_IN_INTERCEPTOR.getCode().equals(a2.getErrorCode()) || ErrorCode.CONNECTION_TO_HANDLER_LOST.getCode().equals(a2.getErrorCode()) || ErrorCode.COMMAND_DUPLICATED.getCode().equals(a2.getErrorCode())) {
            return true;
        }
        return false;
    }

    public FlowControlQueues<WrappedCommand> getCommandQueues() {
        CommandDispatcher a2;
        return a2.A;
    }

    private /* synthetic */ void M(String a2, Authentication a3, SerializedCommand a4, Consumer<SerializedCommandResponse> a5) {
        CommandDispatcher a6;
        long l2 = System.currentTimeMillis();
        a3 = new DefaultExecutionContext(a2, a3);
        a5 = arg_0 -> a6.M((DefaultExecutionContext)a3, a5, arg_0);
        try {
            CommandHandler commandHandler;
            CommandDispatcher commandDispatcher = a6;
            SerializedCommand serializedCommand = commandDispatcher.l.commandRequest(a4, (ExecutionContext)a3);
            CommandHandler commandHandler2 = commandHandler = commandDispatcher.c.getHandlerForCommand(a2, serializedCommand.wrapped(), serializedCommand.getRoutingKey());
            commandDispatcher.M(serializedCommand, commandHandler2, a7 -> {
                CommandDispatcher a8;
                SerializedCommandResponse serializedCommandResponse = a7;
                a5.accept(serializedCommandResponse);
                if (!a8.M(serializedCommandResponse) && commandHandler2 != null) {
                    a8.G.add(a4.getCommand(), a4.wrapped().getClientId(), commandHandler2.h(), a2, System.currentTimeMillis() - l2);
                }
            }, ErrorCode.NO_HANDLER_FOR_COMMAND, "No Handler for command: " + serializedCommand.getCommand());
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2;
            objectArray[1] = a4.getCommand();
            objectArray[2] = exception;
            a6.C.warn(EventStoreTransformationRestController.M((Object)"\u0012\u001dS@,\u0018\n\u0005\u0019\u0014\u0000\u000f\u0007@\r\t\u001a\u0010\b\u0014\n\b\u0000\u000e\u000e@\n\u000f\u0004\r\b\u000e\r@\u0012\u001d"), objectArray);
            a5.accept(a6.M(a4.getMessageIdentifier(), ErrorCode.fromException((Throwable)exception), exception.getMessage()));
            a3.compensate((Throwable)exception);
            return;
        }
    }

    private /* synthetic */ void M(ClientStreamIdentification a3, boolean a4) {
        CommandDispatcher a5;
        a5.h(a3);
        if (!a4) {
            a5.getCommandQueues().M(a3.toString(), (T a2) -> {
                CommandDispatcher a3;
                SerializedCommand serializedCommand = a2.M();
                CommandInformation commandInformation = (CommandInformation)a3.e.remove((Object)serializedCommand.getMessageIdentifier());
                if (commandInformation == null) {
                    return null;
                }
                if ((a2 = a3.c.getHandlerForCommand(a2.M().B(), serializedCommand.wrapped(), serializedCommand.getRoutingKey())) == null) {
                    commandInformation.M().accept(a3.M(serializedCommand.getMessageIdentifier(), ErrorCode.NO_HANDLER_FOR_COMMAND, "No Handler for command: " + serializedCommand.getName()));
                    return null;
                }
                CommandDispatcher commandDispatcher = a3;
                commandDispatcher.C.debug(GlobalSubscriptionMetricRegistry.M((Object)"\u001cc+z9~;bxq%*,eb*#w"), (Object)serializedCommand.getName(), (Object)a2.M());
                commandDispatcher.e.putIfAbsent((Object)serializedCommand.getMessageIdentifier(), (Object)new CommandInformation(serializedCommand.getName(), serializedCommand.getMessageIdentifier(), serializedCommand.wrapped().getClientId(), (CommandHandler)a2, commandInformation.M()));
                return a2.c.toString();
            });
        }
        a5.M(a3);
    }

    public void handleResponse(SerializedCommandResponse a2) {
        CommandDispatcher a3;
        CommandInformation commandInformation = (CommandInformation)a3.e.remove((Object)a2.getRequestIdentifier());
        if (commandInformation != null) {
            CommandInformation commandInformation2 = commandInformation;
            a3.C.debug(GlobalSubscriptionMetricRegistry.M((Object)"Y=d<c6mxx=y(e6y=*,eb*#w"), (Object)commandInformation2);
            commandInformation2.M().accept(a2);
            return;
        }
        a3.C.info(EventStoreTransformationRestController.M((Object)"*\u000f\u001c\f\r@\u0007\u000f\u001d@\u000f\t\u0007\u0004I\u0003\u0006\r\u0004\u0001\u0007\u0004I\u0012\f\u0011\u001c\u0005\u001a\u0014S@\u0012\u001d"), (Object)a2.getRequestIdentifier());
    }

    public void deleteMetrics(String a2) {
        CommandDispatcher a3;
        MeterFactory.RateMeter rateMeter = (MeterFactory.RateMeter)a3.E.remove(a2);
        if (rateMeter != null) {
            rateMeter.M();
        }
        a3.B.remove(a2);
        CommandDispatcher commandDispatcher = a3;
        commandDispatcher.G.remove((MetricName)BaseMetricName.Ca, a2);
        commandDispatcher.G.removeForContext(a2);
    }
}

