/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.event;

import io.axoniq.axonserver.config.AxonServerStandardConfiguration;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.grpc.event.GetAggregateEventsRequest;
import io.axoniq.axonserver.grpc.event.GetAggregateSnapshotsRequest;
import io.axoniq.axonserver.grpc.event.GetEventsRequest;
import io.axoniq.axonserver.grpc.event.QueryEventsRequest;
import io.axoniq.axonserver.grpc.event.QueryEventsResponse;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.event.B;
import io.axoniq.axonserver.message.event.EventStore;
import io.axoniq.axonserver.message.event.SequenceValidationStrategy;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.taskscheduler.task.AddNodeToReplicationGroup;
import io.axoniq.axonserver.topology.EventStoreLocator;
import io.micrometer.core.instrument.Tags;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

@Component
public class EventDispatcher {
    private final Map<String, MeterFactory.RateMeter> f;
    private final MeterFactory I;
    private final Map<String, MeterFactory.RateMeter> H;
    @Value(value="${axoniq.axonserver.read-sequence-validation-strategy:LOG}")
    private SequenceValidationStrategy g;
    private static final Logger m = AuditLog.getLogger();
    private final Logger K;
    private final Map<String, AtomicInteger> M;
    private final Map<String, AtomicInteger> d;
    private final Map<String, MeterFactory.RateMeter> a;
    private final long j;
    static final String h = "{}:  Error on connection from event store: {}";
    private final Map<ClientStreamIdentification, List<B>> l;
    private final Map<String, AtomicInteger> G;
    private final Map<String, MeterFactory.RateMeter> B;
    private final EventStoreLocator A;
    private final RetryBackoffSpec E;
    private final Map<String, AtomicInteger> C;
    private final boolean c;
    private final int e;

    public Mono<Long> firstEventToken(String a2) {
        EventDispatcher a4;
        return a4.A.eventStore(a2, false).flatMap(a3 -> a3.firstEventToken(a2));
    }

    public Mono<Void> appendSnapshot(String a2, Event a3, Authentication a4) {
        EventDispatcher a5;
        if (m.isDebugEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a4);
            objectArray[1] = a2;
            objectArray[2] = a3.getAggregateIdentifier();
            m.debug(AddNodeToReplicationGroup.M((Object)"\u00019'\u0002!?\u0007b\b'+7?1.b.-z.31.b?4?,.1z$50z9'l"), objectArray);
        }
        long l2 = System.currentTimeMillis();
        return a5.A.eventStore(a2).flatMap(a8 -> {
            EventDispatcher a9;
            return a8.appendSnapshot(a2, a3, a4).doFirst(() -> {
                EventDispatcher a4;
                AtomicInteger atomicInteger = a4.C.computeIfAbsent(a2, a2 -> new AtomicInteger());
                atomicInteger.incrementAndGet();
                a4.I.gauge((MetricName)BaseMetricName.za, Tags.of((String)"context", (String)a2), atomicInteger::get);
            }).doOnSuccess(a4 -> {
                EventDispatcher a5;
                EventDispatcher eventDispatcher = a5;
                eventDispatcher.M(a2, eventDispatcher.f, BaseMetricName.A, BaseMetricName.ha).h();
                eventDispatcher.I.timer((MetricName)BaseMetricName.Ta, Tags.of((String)"context", (String)a2)).record(System.currentTimeMillis() - l2, TimeUnit.MILLISECONDS);
            }).doOnError(a3 -> {
                EventDispatcher a4;
                EventDispatcher eventDispatcher = a4;
                eventDispatcher.K.warn(h, (Object)AxonServerStandardConfiguration.M((Object)"\u00194\b!\u0016 +*\u00194\u000b,\u00170"), (Object)a3.getMessage());
                String[] stringArray = new String[4];
                stringArray[0] = "context";
                stringArray[1] = a2;
                stringArray[2] = "error";
                stringArray[3] = ErrorCode.fromException((Throwable)a3).getCode();
                eventDispatcher.I.counter((MetricName)BaseMetricName.o, Tags.of((String[])stringArray)).increment();
            }).doOnTerminate(() -> {
                EventDispatcher a3;
                ((AtomicInteger)a3.C.get(a2)).decrementAndGet();
            });
        });
    }

    public Mono<Long> lastEventToken(String a2) {
        EventDispatcher a4;
        return a4.A.eventStore(a2).flatMap(a3 -> a3.lastEventToken(a2));
    }

    private /* synthetic */ void M(Tags a2, long a3) {
        EventDispatcher a4;
        a4.I.timer((MetricName)BaseMetricName.d, a2).record(System.currentTimeMillis() - a3, TimeUnit.MILLISECONDS);
    }

    public MeterFactory.RateMeter snapshotRate(String a2) {
        EventDispatcher a3;
        EventDispatcher eventDispatcher = a3;
        return eventDispatcher.M(a2, eventDispatcher.f, BaseMetricName.A, BaseMetricName.ha);
    }

    public Flux<SerializedEventWithToken> events(String a2, Authentication a3, Flux<GetEventsRequest> a4) {
        EventDispatcher a5;
        return a4.switchOnFirst((a7, a8) -> {
            if (a7.isOnNext()) {
                EventDispatcher a9;
                B b2;
                GetEventsRequest getEventsRequest = (GetEventsRequest)a7.get();
                B b3 = b2 = new B(getEventsRequest.getClientId(), a2, getEventsRequest.getTrackingToken() - 1L);
                ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(b3.c, b3.e);
                a9.l.computeIfAbsent(clientStreamIdentification, a2 -> new CopyOnWriteArrayList()).add(b2);
                Object[] objectArray = new Object[3];
                objectArray[0] = getEventsRequest.getClientId();
                objectArray[1] = getEventsRequest.getComponentName();
                objectArray[2] = getEventsRequest.getTrackingToken();
                a9.K.info(AddNodeToReplicationGroup.M((Object)"\t6;0.+4%z6(#9)3,=b?4?,.b*05!?1)-(b<-(b!?`9'bwb!?"), objectArray);
                return a9.A.eventStore(a2, getEventsRequest.getForceReadFromLeader()).flatMapMany(a5 -> a5.events(a2, a3, a8)).doOnNext(a3 -> b2.M()).doFinally(a3 -> {
                    EventDispatcher a4;
                    a4.M(b2);
                });
            }
            if (a7.isOnError()) {
                return Flux.error((Throwable)a7.getThrowable());
            }
            return Flux.empty();
        });
    }

    public Map<String, Iterable<Long>> eventTrackerStatus(String a2) {
        EventDispatcher a3;
        HashMap<String, Iterable<Long>> hashMap = new HashMap<String, Iterable<Long>>();
        a3.l.forEach((a4, a5) -> {
            if (a4.B().equals(a2)) {
                a5 = a5.stream().map(B::M).collect(Collectors.toList());
                hashMap.put(a4.toString(), (Iterable<Long>)a5);
            }
        });
        return hashMap;
    }

    public void deleteMetrics(String a2) {
        EventDispatcher a3;
        MeterFactory.RateMeter rateMeter = (MeterFactory.RateMeter)a3.H.remove(a2);
        if (rateMeter != null) {
            rateMeter.M();
        }
        if ((rateMeter = (MeterFactory.RateMeter)a3.f.remove(a2)) != null) {
            rateMeter.M();
        }
        if ((rateMeter = (MeterFactory.RateMeter)a3.a.remove(a2)) != null) {
            rateMeter.M();
        }
        if ((rateMeter = (MeterFactory.RateMeter)a3.B.remove(a2)) != null) {
            rateMeter.M();
        }
        EventDispatcher eventDispatcher = a3;
        eventDispatcher.I.remove((MetricName)BaseMetricName.K, "context", a2);
        eventDispatcher.I.remove((MetricName)BaseMetricName.I, "context", a2);
        eventDispatcher.I.remove((MetricName)BaseMetricName.Ta, "context", a2);
        eventDispatcher.I.remove((MetricName)BaseMetricName.o, "context", a2);
        eventDispatcher.I.remove((MetricName)BaseMetricName.pa, "context", a2);
        eventDispatcher.I.remove((MetricName)BaseMetricName.d, "context", a2);
        eventDispatcher.I.remove((MetricName)BaseMetricName.j, "context", a2);
        eventDispatcher.I.remove((MetricName)BaseMetricName.n, "context", a2);
        eventDispatcher.I.remove((MetricName)BaseMetricName.k, "context", a2);
        eventDispatcher.I.remove((MetricName)BaseMetricName.za, "context", a2);
        eventDispatcher.I.remove((MetricName)BaseMetricName.p, "context", a2);
        eventDispatcher.I.remove((MetricName)BaseMetricName.x, "context", a2);
        eventDispatcher.G.remove(a2);
        a3.M.remove(a2);
        a3.C.remove(a2);
        a3.d.remove(a2);
    }

    public Flux<SerializedEvent> aggregateSnapshots(String a2, Authentication a4, GetAggregateSnapshotsRequest a6) {
        EventDispatcher a7;
        long l2 = System.currentTimeMillis();
        Tags tags = Tags.of((String)"context", (String)a2);
        return a7.A.eventStore(a2).flatMapMany(a5 -> a5.aggregateSnapshots(a2, a4, a6)).doFirst(() -> {
            EventDispatcher a6;
            AtomicInteger atomicInteger = a6.G.computeIfAbsent(a2, a2 -> new AtomicInteger());
            atomicInteger.incrementAndGet();
            a6.I.gauge((MetricName)BaseMetricName.x, tags, atomicInteger::get);
            a6.B.computeIfAbsent(a2, a3 -> {
                EventDispatcher a4;
                return a4.I.rateMeter((MetricName)BaseMetricName.Z, tags);
            }).h();
        }).doOnError(a3 -> {
            EventDispatcher a4;
            String[] stringArray = new String[4];
            stringArray[0] = "context";
            stringArray[1] = a2;
            stringArray[2] = "error";
            stringArray[3] = ErrorCode.fromException((Throwable)a3).getCode();
            a4.I.counter((MetricName)BaseMetricName.pa, Tags.of((String[])stringArray)).increment();
        }).doOnComplete(() -> {
            EventDispatcher a4;
            a4.I.timer((MetricName)BaseMetricName.j, tags).record(System.currentTimeMillis() - l2, TimeUnit.MILLISECONDS);
        }).doOnTerminate(() -> {
            EventDispatcher a3;
            ((AtomicInteger)a3.G.get(a2)).decrementAndGet();
        });
    }

    public Mono<Long> highestSequenceNumber(String a2, String a3) {
        EventDispatcher a5;
        return a5.A.eventStore(a2).flatMap(a4 -> a4.highestSequenceNumber(a2, a3));
    }

    public Mono<Void> appendEvent(String a2, Authentication a3, Flux<SerializedEvent> a4) {
        EventDispatcher a5;
        if (m.isDebugEnabled()) {
            m.debug(AddNodeToReplicationGroup.M((Object)"\u0019!?\u001a9'\u001fz\u0010?3/')6z65b;2*'4&z','46)l"), (Object)AuditLog.username((Principal)a3), (Object)a2);
        }
        long l2 = System.currentTimeMillis();
        return a5.A.eventStore(a2).flatMap(a8 -> {
            EventDispatcher a9;
            a4 = a4.doOnNext(a3 -> {
                EventDispatcher a4;
                EventDispatcher eventDispatcher = a4;
                eventDispatcher.M(a2, eventDispatcher.H, BaseMetricName.E, BaseMetricName.ca).h();
            });
            return a8.appendEvents(a2, a4, a3).doFirst(() -> {
                EventDispatcher a4;
                AtomicInteger atomicInteger = a4.d.computeIfAbsent(a2, a2 -> new AtomicInteger());
                atomicInteger.incrementAndGet();
                a4.I.gauge((MetricName)BaseMetricName.k, Tags.of((String)"context", (String)a2), atomicInteger::get);
            }).doOnSuccess(a4 -> {
                EventDispatcher a5;
                a5.I.timer((MetricName)BaseMetricName.K, Tags.of((String)"context", (String)a2)).record(System.currentTimeMillis() - l2, TimeUnit.MILLISECONDS);
            }).doOnError(a3 -> {
                EventDispatcher a4;
                String[] stringArray = new String[4];
                stringArray[0] = "context";
                stringArray[1] = a2;
                stringArray[2] = "error";
                stringArray[3] = ErrorCode.fromException((Throwable)a3).getCode();
                a4.I.counter((MetricName)BaseMetricName.I, Tags.of((String[])stringArray)).increment();
            }).doOnTerminate(() -> {
                EventDispatcher a3;
                ((AtomicInteger)a3.d.get(a2)).decrementAndGet();
            });
        });
    }

    public Mono<Long> eventTokenAt(String a2, Instant a3) {
        EventDispatcher a5;
        return a5.A.eventStore(a2, false).flatMap(a4 -> a4.eventTokenAt(a2, a3));
    }

    private /* synthetic */ MeterFactory.RateMeter M(String a2, Map<String, MeterFactory.RateMeter> a3, BaseMetricName a4, BaseMetricName a6) {
        EventDispatcher a7;
        return a3.computeIfAbsent(a2, a5 -> {
            EventDispatcher a6;
            return a6.I.rateMeter((MetricName)a4, (MetricName)(a6.c ? a6 : null), Tags.of((String)"context", (String)a2));
        });
    }

    public Flux<QueryEventsResponse> queryEvents(String a2, Authentication a3, Flux<QueryEventsRequest> a5) {
        EventDispatcher a7;
        return a5.switchOnFirst((a4, a6) -> {
            if (a4.isOnNext()) {
                EventDispatcher a7;
                QueryEventsRequest queryEventsRequest = (QueryEventsRequest)a4.get();
                return a7.A.eventStore(a2, queryEventsRequest.getForceReadFromLeader()).flatMapMany(a5 -> a5.queryEvents(a2, a6, a3));
            }
            if (a4.isOnError()) {
                return Flux.error((Throwable)a4.getThrowable());
            }
            return Flux.empty();
        });
    }

    public EventDispatcher(EventStoreLocator eventStoreLocator, MeterFactory meterFactory, @Value(value="${axoniq.axonserver.event.aggregate.retry.attempts:3}") int maxRetryAttempts, @Value(value="${axoniq.axonserver.event.aggregate.retry.delay:100}") long retryDelayMillis, @Value(value="${axoniq.axonserver.event.aggregate.prefetch:5}") int aggregateEventsPrefetch, @Value(value="${axoniq.axonserver.event.aggregate.timeout:30000}") long a2, @Value(value="${axoniq.axonserver.legacy-metrics-enabled:true}") boolean a3) {
        EventDispatcher eventDispatcher = this;
        EventDispatcher eventDispatcher2 = this;
        EventDispatcher eventDispatcher3 = this;
        EventDispatcher eventDispatcher4 = this;
        this.K = LoggerFactory.getLogger(EventDispatcher.class);
        EventDispatcher eventDispatcher5 = this;
        eventDispatcher4.l = new ConcurrentHashMap();
        EventDispatcher eventDispatcher6 = this;
        eventDispatcher5.H = new ConcurrentHashMap();
        EventDispatcher eventDispatcher7 = this;
        eventDispatcher4.f = new ConcurrentHashMap();
        EventDispatcher eventDispatcher8 = this;
        eventDispatcher4.a = new ConcurrentHashMap();
        EventDispatcher eventDispatcher9 = this;
        eventDispatcher4.B = new ConcurrentHashMap();
        eventDispatcher4.g = SequenceValidationStrategy.C;
        EventDispatcher eventDispatcher10 = this;
        eventDispatcher4.d = new ConcurrentHashMap();
        EventDispatcher eventDispatcher11 = this;
        eventDispatcher4.C = new ConcurrentHashMap();
        EventDispatcher eventDispatcher12 = this;
        eventDispatcher4.M = new ConcurrentHashMap();
        EventDispatcher eventDispatcher13 = this;
        eventDispatcher4.G = new ConcurrentHashMap();
        eventDispatcher3.A = eventStoreLocator;
        eventDispatcher3.I = meterFactory;
        eventDispatcher2.c = a3;
        eventDispatcher2.E = Retry.backoff((long)maxRetryAttempts, (Duration)Duration.ofMillis(retryDelayMillis));
        eventDispatcher.e = aggregateEventsPrefetch;
        eventDispatcher.j = a2;
    }

    private static /* synthetic */ Mono h(String a2, EventStore a3) {
        return a3.lastEventToken(a2);
    }

    private /* synthetic */ void M(String a4, Tags a5) {
        EventDispatcher a6;
        AtomicInteger atomicInteger = a6.M.computeIfAbsent(a4, a2 -> new AtomicInteger());
        atomicInteger.incrementAndGet();
        a6.I.gauge((MetricName)BaseMetricName.p, a5, atomicInteger::get);
        a6.a.computeIfAbsent(a4, a3 -> {
            EventDispatcher a4;
            return a4.I.rateMeter((MetricName)BaseMetricName.Y, a5);
        }).h();
    }

    public long getNrOfEvents(String a2) {
        EventDispatcher a3;
        if ((a2 = (Long)a3.A.eventStore((String)a2).flatMap(arg_0 -> EventDispatcher.h((String)a2, arg_0)).switchIfEmpty(Mono.just((Object)-1L)).block()) != null) {
            return (Long)a2;
        }
        return -1L;
    }

    public MeterFactory.RateMeter eventRate(String a2) {
        EventDispatcher a3;
        EventDispatcher eventDispatcher = a3;
        return eventDispatcher.M(a2, eventDispatcher.H, BaseMetricName.E, BaseMetricName.ca);
    }

    private /* synthetic */ void M(@Nonnull B a2) {
        EventDispatcher eventDispatcher = this;
        eventDispatcher.K.info(AxonServerStandardConfiguration.M((Object)"\u0016\u001d)\u00172\u001d X0\n%\u001b/\u001d6X-\u0016\"\u0017d\u00039"), (Object)a2);
        B b2 = a2;
        eventDispatcher.l.computeIfPresent(new ClientStreamIdentification(b2.c, b2.e), (a3, a4) -> {
            EventDispatcher a5;
            List list = a4;
            a5.K.debug(AxonServerStandardConfiguration.M((Object)"\u00039Bd\u00039X7\f6\u001d%\u00157"), (Object)a2.e, (Object)a4.size());
            list.remove(a2);
            if (list.isEmpty()) {
                return null;
            }
            return a4;
        });
    }

    public Flux<SerializedEvent> aggregateEvents(String a2, Authentication a3, GetAggregateEventsRequest a4) {
        EventDispatcher a5;
        if (m.isDebugEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a3);
            objectArray[1] = a2;
            objectArray[2] = a4.getAggregateId();
            m.debug(AxonServerStandardConfiguration.M((Object)"#?\u0005\u0004\u00039%d*!\t1\u001d7\fd\f+X(\u00117\fd\u001d2\u001d*\f7X\"\u00176X?\u0005j"), objectArray);
        }
        long l2 = System.currentTimeMillis();
        return a5.A.eventStore(a2).flatMapMany(a9 -> {
            EventDispatcher a10;
            String string = AxonServerStandardConfiguration.M((Object)"'\u001b4\u0005+\u0010'\u0017=\u0015");
            string = Tags.of((String)"context", (String)a2);
            return Flux.deferContextual(a6 -> {
                EventDispatcher a7;
                a6 = (AtomicLong)a6.get((Object)AddNodeToReplicationGroup.M((Object)"\u0005\u001d\u0016\u0003\t\u0016\u0005\u0011\u001f\u0013"));
                boolean bl = a4.getAllowSnapshots() && ((AtomicLong)a6).get() == -1L;
                GetAggregateEventsRequest getAggregateEventsRequest = a4.toBuilder().setAllowSnapshots(bl).setInitialSequence(((AtomicLong)a6).get() + 1L).build();
                a7.K.debug(AxonServerStandardConfiguration.M((Object)"\u0016\u001d%\u001c-\u0016#X!\u000e!\u00160\u000bd\u001e6\u0017)X7\u001d5[?\u0005d\u001e+\nd\u0019#\u001f6\u001d#\u00190\u001dd\u00039"), (Object)(((AtomicLong)a6).get() + 1L), (Object)a4.getAggregateId());
                return a9.aggregateEvents(a2, a3, getAggregateEventsRequest);
            }).doFirst(() -> a10.M(a2, (Tags)string)).limitRate(a10.e * 5, a10.e).doOnEach(a2 -> {
                if (a2.hasValue()) {
                    ((AtomicLong)a2.getContextView().get((Object)AxonServerStandardConfiguration.M((Object)"'\u001b4\u0005+\u0010'\u0017=\u0015"))).set(((SerializedEvent)a2.get()).B());
                }
            }).timeout(Duration.ofMillis(a10.j)).onErrorMap(TimeoutException.class, a2 -> {
                EventDispatcher a3;
                return new MessagingPlatformException(ErrorCode.LIST_AGGREGATE_EVENTS_TIMEOUT, "Timeout exception: No events were emitted from event store in last " + a3.j + "ms. Check the logs for virtual machine errors like OutOfMemoryError.");
            }).retryWhen((Retry)a10.E.doBeforeRetry(a3 -> {
                EventDispatcher a4;
                Object[] objectArray = new Object[3];
                objectArray[0] = a3.failure().getClass().getName();
                objectArray[1] = a3.failure().getMessage();
                objectArray[2] = a4.getAggregateId();
                a4.K.warn(AxonServerStandardConfiguration.M((Object)"*!\f6\u0001-\u0016#X0\u0017d\n!\u0019 X!\u000e!\u00160\u000bd\u0019#\u001f6\u001d#\u00190\u001dd\u000b0\n!\u0019)X \r!X0\u0017d\u00039B?\u0005hX\"\u00176X%\u001f#\n!\u001f%\f!Bd\u00039"), objectArray);
            })).onErrorMap(a2 -> {
                if (Exceptions.isRetryExhausted((Throwable)a2)) {
                    return a2.getCause();
                }
                return a2;
            }).doOnError(a3 -> {
                EventDispatcher a4;
                EventDispatcher eventDispatcher = a4;
                eventDispatcher.K.error(AddNodeToReplicationGroup.M((Object)"\u0007(050z&/03,=b(';&3,=b;%=0?%;6?b?4?,.1tb"), a3);
                String[] stringArray = new String[4];
                stringArray[0] = "context";
                stringArray[1] = a2;
                stringArray[2] = "error";
                stringArray[3] = ErrorCode.fromException((Throwable)a3).getCode();
                eventDispatcher.I.counter((MetricName)BaseMetricName.pa, Tags.of((String[])stringArray)).increment();
            }).doOnNext(a3 -> {
                EventDispatcher a4;
                a4.K.trace(AddNodeToReplicationGroup.M((Object)"','46z9'b<-(b;%=0?%;6?b!?"), a3, (Object)a4.getAggregateId());
            }).doOnComplete(() -> a10.M((Tags)string, l2)).doOnTerminate(() -> {
                EventDispatcher a3;
                ((AtomicInteger)a3.M.get(a2)).decrementAndGet();
            }).contextWrite(a3 -> a3.put((Object)AddNodeToReplicationGroup.M((Object)"\u0005\u001d\u0016\u0003\t\u0016\u0005\u0011\u001f\u0013"), (Object)new AtomicLong(a4.getInitialSequence() - 1L))).name(AddNodeToReplicationGroup.M((Object)"?4?,.\u001d)6(';/")).tag("context", a2).tag("stream", AxonServerStandardConfiguration.M((Object)"\u0019#\u001f6\u001d#\u00190\u001d\u001b\u001d2\u001d*\f7")).tag("origin", AddNodeToReplicationGroup.M((Object)"9.3'46\u00050?3/')6")).metrics();
        }).onErrorResume(Flux::error);
    }
}

