/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.ProcessingInstructionHelper;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.SerializedQuery;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.interceptor.DefaultExecutionContext;
import io.axoniq.axonserver.interceptor.PluginRemovedEvent;
import io.axoniq.axonserver.interceptor.QueryInterceptors;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.DispatchQueueMetrics;
import io.axoniq.axonserver.message.FlowControlQueues;
import io.axoniq.axonserver.message.QueueMetrics;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.message.query.QueryDefinition;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.message.query.QueryInstruction;
import io.axoniq.axonserver.message.query.QueryMetricsRegistry;
import io.axoniq.axonserver.message.query.QueryRegistrationCache;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.plugin.ExecutionContext;
import io.axoniq.axonserver.plugin.PluginPackageProvider;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import io.axoniq.axonserver.util.StringUtils;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="QueryDispatcher")
public class QueryDispatcher {
    private final QueryRegistrationCache l;
    private final Logger G;
    private final Map<String, AtomicInteger> B;
    private final QueryMetricsRegistry A;
    private final NonReplacingConstraintCache<String, ActiveQuery> E;
    private final DispatchQueueMetrics C;
    private final QueryInterceptors c;
    private final FlowControlQueues<QueryInstruction> e;

    public void flowControl(String a2, long a3) {
        QueryDispatcher a4;
        if ((a2 = (ActiveQuery)a4.E.get((Object)a2)) != null) {
            a2.h().forEach(arg_0 -> a4.M((ActiveQuery)a2, a3, arg_0));
        }
    }

    public void completeWithError(String a2, String a3, ErrorCode a4, String a5) {
        QueryDispatcher a6;
        Object[] objectArray = new Object[4];
        objectArray[0] = a3;
        objectArray[1] = a2;
        objectArray[2] = a4.getCode();
        objectArray[3] = a5;
        a6.G.debug(PluginPackageProvider.M((Object)"Jedzeo}cgm)}`~a*lx{e{*}bl*jedg|d`ih~`eg*~c}b)k)yyojcocj*akgneo{*Riecld}Y}xlkdCm7rwT&)lfx)~ao){|o{s)Q`n4qtW'*Lx{e{*jemo3*rw'*Lx{e{Glyzkno3*rw'"), objectArray);
        ActiveQuery activeQuery = (ActiveQuery)a6.E.get((Object)a2);
        if (activeQuery != null && activeQuery.M(a3, a4, a5)) {
            a6.E.remove((Object)a2);
        }
    }

    private /* synthetic */ boolean M(QueryResponse a2) {
        if (ErrorCode.NO_HANDLER_FOR_QUERY.getCode().equals(a2.getErrorCode()) || ErrorCode.TOO_MANY_REQUESTS.getCode().equals(a2.getErrorCode()) || ErrorCode.OTHER.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_REJECTED_BY_INTERCEPTOR.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_TIMEOUT.getCode().equals(a2.getErrorCode()) || ErrorCode.CONNECTION_TO_HANDLER_LOST.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_DUPLICATED.getCode().equals(a2.getErrorCode())) {
            return true;
        }
        return false;
    }

    private /* synthetic */ boolean M(QueryRequest a2) {
        return ProcessingInstructionHelper.M((List)a2.getProcessingInstructionsList());
    }

    private /* synthetic */ void M(ActiveQuery a2, long a3, QueryHandler a4) {
        QueryDispatcher a5;
        a5.h(a4, a2.h(), a2.M(), a3);
    }

    public void dispatchProxied(SerializedQuery a22, Consumer<QueryResponse> a3, Consumer<String> a4, boolean a52) {
        QueryDispatcher a6;
        SerializedQuery serializedQuery = a22;
        QueryRequest queryRequest = serializedQuery.query();
        String string = serializedQuery.context();
        String string2 = serializedQuery.clientStreamId();
        if ((string = a6.l.find(string, queryRequest, string2)) == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = string2;
            objectArray[1] = queryRequest.getQuery();
            a3.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.CLIENT_DISCONNECTED.getCode()).setRequestIdentifier(queryRequest.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.M((String)String.format(PluginRemovedEvent.M((Object)"S\"y+~:0kcn~!dnv!e tng&y\"un`<\u007f-u=c'~)*n5="), objectArray))).build());
            a4.accept(string2);
            return;
        }
        string2 = a6.M(queryRequest.getMessageIdentifier(), a22.clientStreamId());
        ActiveQuery a52 = new ActiveQuery(string2, a22, false, a3, a4, Collections.singleton(string), a52 && a6.M(queryRequest));
        try {
            if (a6.E.putIfAbsent((Object)string2, (Object)a52) != null) {
                a3.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a22.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.M((String)PluginPackageProvider.M((Object)"[|o{s)}`~a*z\u007fyzecln)CM*hf{ohnp*yxlyld}"))).build());
                a4.accept(PluginRemovedEvent.M((Object)"\ne>|'s/d+Y*"));
                return;
            }
            a6.M(string2, a52);
            return;
        }
        catch (InsufficientBufferCapacityException a22) {
            a52.M(string.h(), ErrorCode.QUERY_DISPATCH_ERROR, a22.getMessage());
            return;
        }
    }

    private /* synthetic */ void M(DefaultExecutionContext a2, QueryResponse a3, Consumer<QueryResponse> a4) {
        QueryDispatcher a5;
        try {
            a4.accept(a5.c.queryResponse(a3, (ExecutionContext)a2));
            return;
        }
        catch (Exception exception) {
            a5.G.warn(PluginPackageProvider.M((Object)"rw3*Lrjoy~`eg*`d)xlyyegyl*`d}o{ilz}e{"), (Object)a2.contextName(), (Object)exception);
            Exception exception2 = exception;
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.EXCEPTION_IN_INTERCEPTOR.getCode()).setRequestIdentifier(a3.getRequestIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.M((String)exception2.getMessage())).build());
            a2.compensate((Throwable)exception2);
            return;
        }
    }

    private /* synthetic */ void M(String a2, String a3, String a4, Consumer<QueryHandler> a5) {
        QueryDispatcher a6;
        a2 = new QueryDefinition(a2, a3);
        if ((a2 = a6.l.find((QueryDefinition)a2, a4)) != null) {
            a5.accept((QueryHandler)a2);
        }
    }

    private /* synthetic */ void M(DefaultExecutionContext a2, Consumer a3, QueryResponse a4) {
        QueryDispatcher a5;
        a5.M(a2, a4, a3);
    }

    private /* synthetic */ void h(QueryHandler a2, String a3, String a4, long a5) {
        QueryDispatcher a6;
        String string = a3;
        a6.M(string, a2.h(), () -> a2.M(string, a4, a5));
    }

    public void handleComplete(String a2, String a3, String a4) {
        QueryDispatcher a5;
        ActiveQuery activeQuery = a5.M(a3, a2);
        if (activeQuery != null) {
            if (activeQuery.B(a3)) {
                a5.E.remove((Object)activeQuery.h());
            }
            long l2 = System.currentTimeMillis() - activeQuery.M();
            if (activeQuery.h()) {
                a5.A.addHandlerResponseTime(activeQuery.M(), activeQuery.B(), a4, activeQuery.l(), l2);
                return;
            }
        } else {
            a5.G.debug(PluginRemovedEvent.M((Object)"\u0000\u007fn8#\u007f<ug0'~(\u007f<}/d'\u007f 0(\u007f<05mn\u007f 0-\u007f#`\"u:u*"), (Object)a2);
        }
    }

    public void handleResponse(QueryResponse a2, String a3, String a4) {
        QueryDispatcher a5;
        String string = a2.getRequestIdentifier();
        if ((string = a5.M(a3, string)) != null) {
            ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(string.l(), a3);
            long l2 = System.currentTimeMillis() - string.M();
            if (string.h()) {
                a5.A.addEndToEndResponseTime(string.M(), string.B(), a4, clientStreamIdentification.B(), string.M(), l2);
            }
            if (string.M(a2, a3) && string.M()) {
                string.M(a3);
                return;
            }
        } else {
            a5.G.debug(PluginPackageProvider.M((Object)"Df*!gfxl#)cglfxdk}cfd)lfx)qt"), (Object)a2.getRequestIdentifier());
        }
    }

    public void flowControlProxied(String a2, String a3, long a4, String a6, String a7) {
        QueryDispatcher a8;
        a8.M(a6, a3, a7, a5 -> {
            QueryDispatcher a6;
            a6.h(a5, a2, a3, a4);
        });
    }

    public FlowControlQueues<QueryInstruction> getQueryQueue() {
        QueryDispatcher a2;
        return a2.e;
    }

    private /* synthetic */ void M(String a2, String a3, Runnable a42) {
        try {
            a42.run();
            return;
        }
        catch (MessagingPlatformException a42) {
            QueryDispatcher a5;
            QueryDispatcher queryDispatcher = a5;
            queryDispatcher.G.debug(PluginRemovedEvent.M((Object)"U<b!bnt'c>q:s&y wnv\"\u007f90?e+b70'~=d<e-d'\u007f 0:\u007fnd/b)u:0-|'u dnk3"), (Object)a3);
            queryDispatcher.completeWithError(a2, a3, a42.getErrorCode(), a42.getMessage());
            return;
        }
    }

    public QueryDispatcher(QueryRegistrationCache registrationCache, NonReplacingConstraintCache<String, ActiveQuery> queryCache, QueryMetricsRegistry queryMetricsRegistry, QueryInterceptors queryInterceptors, MeterFactory meterFactory, ClientIdRegistry clientIdRegistry, @Value(value="${axoniq.axonserver.query-queue-capacity-per-client:10000}") int a2) {
        QueryDispatcher queryDispatcher = this;
        QueryDispatcher queryDispatcher2 = this;
        this.G = LoggerFactory.getLogger(QueryDispatcher.class);
        QueryDispatcher queryDispatcher3 = this;
        this.B = new ConcurrentHashMap();
        queryDispatcher2.l = registrationCache;
        queryDispatcher2.A = queryMetricsRegistry;
        queryDispatcher.E = queryCache;
        queryDispatcher.c = queryInterceptors;
        QueryDispatcher queryDispatcher4 = this;
        queryDispatcher.C = new DispatchQueueMetrics(meterFactory, (MetricName)BaseMetricName.e, (MetricName)BaseMetricName.la, clientIdRegistry);
        QueryDispatcher queryDispatcher5 = this;
        queryDispatcher4.e = new FlowControlQueues(Comparator.comparing(QueryInstruction::M).reversed(), a2, (QueueMetrics)this.C, ErrorCode.TOO_MANY_REQUESTS);
        queryMetricsRegistry.gauge((MetricName)BaseMetricName.ea, queryCache, ConstraintCache::size);
    }

    private /* synthetic */ ActiveQuery M(String a2, String a3) {
        QueryDispatcher a4;
        ActiveQuery activeQuery = (ActiveQuery)a4.E.get(a3);
        if (activeQuery == null) {
            a3 = (String)a3 + "/" + a2;
            activeQuery = (ActiveQuery)a4.E.get(a3);
        }
        return activeQuery;
    }

    public void cancel(String a2) {
        QueryDispatcher a3;
        if ((a2 = (ActiveQuery)a3.E.remove((Object)a2)) != null) {
            a2.h();
        }
    }

    public void deleteMetrics(String a2) {
        QueryDispatcher a3;
        a3.B.remove(a2);
        QueryDispatcher queryDispatcher = a3;
        queryDispatcher.A.remove((MetricName)BaseMetricName.M, a2);
        queryDispatcher.A.removeForContext(a2);
    }

    public void dispatchProxied(SerializedQuery a2, Consumer<QueryResponse> a3, Consumer<String> a4) {
        QueryDispatcher a5;
        a5.dispatchProxied(a2, a3, a4, true);
    }

    public void query(SerializedQuery a3, Authentication a6, Consumer<QueryResponse> a7, Consumer<String> a8) {
        QueryDispatcher a9;
        String string = a3.context();
        a7 = a5 -> {
            QueryDispatcher a6;
            QueryResponse queryResponse = a5;
            a7.accept(queryResponse);
            if (a6.M(queryResponse)) {
                a6.A.error(a3.query().getQuery(), string, a5.getErrorCode());
            }
        };
        a8 = a4 -> {
            QueryDispatcher a5;
            a8.accept((String)a4);
            ((AtomicInteger)a5.B.get(string)).decrementAndGet();
        };
        QueryDispatcher queryDispatcher = a9;
        queryDispatcher.queryRate(string).h();
        queryDispatcher.B.computeIfAbsent(string, a2 -> {
            QueryDispatcher a3;
            AtomicInteger atomicInteger = new AtomicInteger();
            a3.A.gauge((MetricName)BaseMetricName.M, Tags.of((String)"context", (String)a2), atomicInteger::get);
            return atomicInteger;
        }).incrementAndGet();
        a9.M(a3, string, a6, a7, a8);
    }

    private /* synthetic */ String M(String a2, String a3) {
        return a2 + "/" + a3;
    }

    public MeterFactory.RateMeter queryRate(String a2) {
        QueryDispatcher a3;
        return a3.A.rateMeter(a2);
    }

    private /* synthetic */ void M(String a2, ActiveQuery a3) {
        QueryDispatcher a4;
        try {
            a4.G.trace(PluginPackageProvider.M((Object)"Mczzh~jb`dn*x\u007flxp*rw'$'"), (Object)a3.h());
            a3.M();
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            QueryDispatcher queryDispatcher = a4;
            queryDispatcher.G.debug(PluginRemovedEvent.M((Object)"U<b!bnt;b'~)0*y=`/d-x'~)0!vna;u<ink3>nS/~-u\"|'~)09y:xnu<b!b`"), (Object)a3.h(), (Object)messagingPlatformException);
            a3.M(messagingPlatformException.getErrorCode(), messagingPlatformException.getMessage());
            queryDispatcher.E.remove((Object)a2);
            return;
        }
    }

    public void cancelProxied(String a2, String a3) {
        QueryDispatcher a4;
        QueryDispatcher queryDispatcher = a4;
        queryDispatcher.cancel(queryDispatcher.M(a2, a3));
    }

    private /* synthetic */ void M(SerializedQuery a2, String a3, Authentication a4, Consumer<QueryResponse> a5, Consumer<String> a6) {
        Set set;
        QueryRequest queryRequest;
        QueryDispatcher a7;
        block5: {
            SerializedQuery serializedQuery;
            Consumer<QueryResponse> consumer;
            block4: {
                a4 = new DefaultExecutionContext(a3, a4);
                consumer = arg_0 -> a7.M((DefaultExecutionContext)a4, a5, arg_0);
                try {
                    QueryDispatcher queryDispatcher = a7;
                    serializedQuery = queryDispatcher.c.queryRequest(a2, (ExecutionContext)a4);
                    queryRequest = serializedQuery.query();
                    set = queryDispatcher.l.find(a3, queryRequest);
                    if (!set.isEmpty()) break block4;
                    consumer.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.NO_HANDLER_FOR_QUERY.getCode()).setRequestIdentifier(queryRequest.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.M((String)("No handler for query: " + queryRequest.getQuery()))).build());
                    a6.accept(PluginPackageProvider.M((Object)"DfIecld}"));
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a3;
                    objectArray[1] = a2.query().getQuery();
                    objectArray[2] = exception;
                    a7.G.warn(PluginRemovedEvent.M((Object)"5mt0(q'|+tnd!0*y=`/d-xna;u<ink3"), objectArray);
                    queryRequest = ErrorCode.fromException((Throwable)exception);
                    consumer.accept(QueryResponse.newBuilder().setErrorCode(queryRequest.getCode()).setRequestIdentifier(a2.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.M((String)StringUtils.getOrDefault((String)queryRequest.getCode(), (String)exception.getClass().getName()))).build());
                    a6.accept(PluginPackageProvider.M((Object)"Lhceom"));
                    a4.compensate((Throwable)exception);
                    return;
                }
            }
            set = new ActiveQuery(queryRequest.getMessageIdentifier(), serializedQuery, true, consumer, a6, set, a7.M(queryRequest));
            if (a7.E.putIfAbsent((Object)queryRequest.getMessageIdentifier(), (Object)set) == null) break block5;
            a5.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a2.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.M((String)PluginRemovedEvent.M((Object)"A;u<ing'd&0=e>`\"y+tnY\n0/|<u/t70>b+c+~:"))).build());
            a6.accept(PluginPackageProvider.M((Object)"M\u007fyf`ih~lCm"));
            return;
        }
        a7.M(queryRequest.getMessageIdentifier(), (ActiveQuery)set);
    }
}

