/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.plugin;

import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.configuration.common.PluginPackage;
import io.axoniq.axonserver.configuration.common.PluginPackages;
import io.axoniq.axonserver.configuration.runtime.ContextPlugin;
import io.axoniq.axonserver.configuration.runtime.ContextPlugins;
import io.axoniq.axonserver.configuration.runtime.RuntimeConfigurationFactory;
import io.axoniq.axonserver.enterprise.cluster.internal.LicenseMetrics;
import io.axoniq.axonserver.interceptor.PluginEnabledEvent;
import io.axoniq.axonserver.interceptor.PluginRemovedEvent;
import io.axoniq.axonserver.plugin.OsgiController;
import io.axoniq.axonserver.plugin.PluginConfigurationManager;
import io.axoniq.axonserver.plugin.PluginConfigurationSerializer;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.PluginNotFoundException;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class PluginContextManager {
    private final PluginConfigurationSerializer G;
    private final RuntimeConfigurationFactory B;
    private final ContextPlugins A;
    private final PluginPackages E;
    private final Logger C;
    private final OsgiController c;
    private final ApplicationEventPublisher e;

    @Transactional
    public ContextPlugin updateStatus(String a2, String a4, String a5, boolean a6) {
        PluginContextManager a7;
        PluginPackage pluginPackage = (PluginPackage)a7.E.findByNameAndVersion(a4, a5).orElseThrow(() -> new PluginNotFoundException(a4, a5));
        pluginPackage = a7.A.findByContextAndPlugin(a2, pluginPackage).orElse(a7.B.contextPlugin(a2, pluginPackage));
        if (a6 && !pluginPackage.isActive()) {
            a7.A.findByContextAndPluginNameAndActive(a2, a4, true).ifPresent(a3 -> {
                PluginContextManager a4;
                a3.setActive(false);
                a4.A.save(a3);
                a4.e.publishEvent((Object)new PluginEnabledEvent(a2, a3.getPluginKey(), a4.G.deserialize(a3.getConfiguration()), false));
            });
        }
        pluginPackage.setActive(a6);
        a7.A.save((ContextPlugin)pluginPackage);
        a7.e.publishEvent((Object)new PluginEnabledEvent(a2, (PluginKey)new SimplePluginKey(a4, a5), a7.G.deserialize(pluginPackage.getConfiguration()), a6));
        return pluginPackage;
    }

    @Transactional
    public void uninstallForContexts(List<String> a3) {
        PluginContextManager a4;
        a4.A.findAllByContextIn(a3).forEach(a2 -> {
            PluginContextManager a3;
            PluginContextManager pluginContextManager = a3;
            pluginContextManager.A.delete(a2);
            pluginContextManager.e.publishEvent((Object)new PluginEnabledEvent(a2.getContext(), a2.getPluginKey(), null, false));
        });
    }

    public List<ContextPlugin> findAll(PluginKey a2) {
        PluginContextManager a3;
        return a3.E.findByNameAndVersion(a2.getSymbolicName(), a2.getVersion()).map(arg_0 -> ((ContextPlugins)a3.A).findAllByPlugin(arg_0)).orElse(Collections.emptyList());
    }

    public Optional<ContextPlugin> getStatus(String a2, String a3, String a4) {
        PluginContextManager a5;
        a3 = (PluginPackage)a5.E.findByNameAndVersion(a3, a4).orElseThrow(() -> new PluginNotFoundException(a3, a4));
        return a5.A.findByContextAndPlugin(a2, (PluginPackage)a3);
    }

    public PluginContextManager(ContextPlugins pluginStatusRepository, PluginPackages packageRepository, PluginConfigurationSerializer pluginConfigurationSerializer, RuntimeConfigurationFactory runtimeConfigurationFactory, OsgiController osgiController, @Qualifier(value="localEventPublisher") ApplicationEventPublisher a2) {
        PluginContextManager pluginContextManager = this;
        PluginContextManager pluginContextManager2 = this;
        PluginContextManager pluginContextManager3 = this;
        this.C = LoggerFactory.getLogger(PluginContextManager.class);
        pluginContextManager3.A = pluginStatusRepository;
        pluginContextManager3.E = packageRepository;
        pluginContextManager2.G = pluginConfigurationSerializer;
        pluginContextManager2.B = runtimeConfigurationFactory;
        pluginContextManager.c = osgiController;
        pluginContextManager.e = a2;
    }

    public Iterable<PluginInfo> listPlugins() {
        PluginContextManager a2;
        HashMap hashMap = new HashMap();
        a2.E.findAll().forEach(a3 -> {
            PluginContextManager a4;
            hashMap.put(a3.getKey(), new PluginInfo(a3.getName(), a3.getVersion(), a3.getFilename(), a4.c.getStatus(a3.getKey())));
        });
        a2.A.findAll().forEach(a3 -> ((PluginInfo)hashMap.get(a3.getPluginKey())).addContextInfo(a3.getContext(), a3.isActive()));
        return hashMap.values();
    }

    @Transactional
    public void remove(ContextPlugin a2) {
        PluginContextManager a3;
        PluginContextManager pluginContextManager = a3;
        pluginContextManager.A.delete(a2);
        pluginContextManager.e.publishEvent((Object)new PluginRemovedEvent(a2.getContext(), a2.getPluginKey()));
    }

    @Transactional
    public void updateConfiguration(String a2, String a3, String a4, Map<String, Map<String, Object>> a5) {
        PluginContextManager a6;
        PluginPackage pluginPackage = (PluginPackage)a6.E.findByNameAndVersion(a3, a4).orElseThrow(() -> new PluginNotFoundException(a3, a4));
        pluginPackage = a6.A.findByContextAndPlugin(a2, pluginPackage).orElse(a6.B.contextPlugin(a2, pluginPackage));
        PluginContextManager pluginContextManager = a6;
        pluginPackage.setConfiguration(pluginContextManager.G.serialize(a5));
        pluginContextManager.A.save((ContextPlugin)pluginPackage);
        a6.e.publishEvent((Object)new PluginEnabledEvent(a2, (PluginKey)new SimplePluginKey(a3, a4), a5, pluginPackage.isActive()));
    }

    @Transactional
    public void uninstall(PluginKey a4) {
        PluginContextManager a5;
        Object object = a5.E.findByNameAndVersion(a4.getSymbolicName(), a4.getVersion());
        if (((Optional)object).isPresent()) {
            object = a5.A.findAllByPlugin((PluginPackage)((Optional)object).get());
            object.forEach(a3 -> {
                PluginContextManager a4;
                a4.e.publishEvent((Object)new PluginEnabledEvent(a3.getContext(), a4, null, false));
            });
            object.forEach(a2 -> {
                PluginContextManager a3;
                a3.A.delete(a2);
            });
        }
    }

    public void publishConfiguration(PluginPackage a2) {
        PluginContextManager a4;
        a4.A.findAllByPlugin(a2).forEach(a3 -> {
            PluginContextManager a4;
            a4.e.publishEvent((Object)new PluginEnabledEvent(a3.getContext(), a2.getKey(), a4.G.deserialize(a3.getConfiguration()), a3.isActive()));
        });
    }

    @Transactional
    public void update(ContextPlugin a2) {
        PluginContextManager a3;
        a3.A.save(a2);
        a3.e.publishEvent((Object)new PluginEnabledEvent(a2.getContext(), a2.getPluginKey(), a3.G.deserialize(a2.getConfiguration()), a2.isActive()));
    }

    public void start() {
        PluginContextManager a3;
        a3.A.findAll().forEach(a2 -> {
            PluginContextManager a3;
            if (a2.isActive()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a2.getContext();
                objectArray[1] = a2.getPlugin().getName();
                objectArray[2] = a2.getPlugin().getVersion();
                a3.C.info(LicenseMetrics.M((Object)"w\u001f6BM\u0001x\u000bz\u0003x\u0007,\u0019qMw\u001f"), objectArray);
                a3.e.publishEvent((Object)new PluginEnabledEvent(a2.getContext(), a2.getPluginKey(), a3.G.deserialize(a2.getConfiguration()), true));
                return;
            }
            a3.C.info(PluginConfigurationManager.M((Object)"~\u0019?DU\bp\u0003l\n%\u001fxDk\u000bqDd\u0007q\rs\u0001"), (Object)a2.getContext(), (Object)a2.getPluginKey());
        });
    }

    public List<ContextPlugin> findAllByContextIn(List<String> a2) {
        PluginContextManager a3;
        return a3.A.findAllByContextIn(a2);
    }

    @Transactional
    public void removeForContext(PluginKey a2, String a4) {
        PluginContextManager a5;
        Optional optional = a5.E.findByNameAndVersion(a2.getSymbolicName(), a2.getVersion());
        if (!optional.isPresent()) {
            return;
        }
        a5.A.findByContextAndPlugin(a4, (PluginPackage)optional.get()).ifPresent(a3 -> {
            PluginContextManager a4;
            PluginContextManager pluginContextManager = a4;
            pluginContextManager.e.publishEvent((Object)new PluginEnabledEvent(a3.getContext(), a2, null, false));
            pluginContextManager.A.delete(a3);
        });
    }
}

