/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.plugin;

import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.common.CommonConfigurationFactory;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.configuration.common.PluginPackage;
import io.axoniq.axonserver.configuration.common.PluginPackages;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.transaction.PreparedTransaction;
import io.axoniq.axonserver.plugin.OsgiController;
import io.axoniq.axonserver.plugin.PluginContextManager;
import io.axoniq.axonserver.plugin.PluginEvent;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.rest.svg.jsfunction.ShowDetail;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Component;

@Component
public class PluginPackageManager
implements SmartLifecycle {
    private final CommonConfigurationFactory l;
    private final String G;
    private boolean B;
    private final ApplicationEventPublisher A;
    private final PluginPackages E;
    private final OsgiController C;
    private final Logger c;
    private final PluginContextManager e;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void uninstallPlugin(PluginKey a3) {
        PluginPackageManager a4;
        PluginPackageManager pluginPackageManager = a4;
        pluginPackageManager.e.uninstall(a3);
        pluginPackageManager.C.uninstallPlugin(a3);
        PluginPackages pluginPackages = pluginPackageManager.E;
        synchronized (pluginPackages) {
            a4.E.findByNameAndVersion(a3.getSymbolicName(), a3.getVersion()).ifPresent(a2 -> {
                PluginPackageManager a3;
                a3.E.delete(a2);
                FileUtils.M((File)new File(a3.G + File.separatorChar + a2.getFilename()));
            });
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void M(InputStream a2, File a3) {
        FileOutputStream fileOutputStream = new FileOutputStream(a3);
        byte[] byArray = new byte[5000];
        int n = a2.read(byArray);
        while (n > 0) {
            fileOutputStream.write(byArray, 0, n);
            n = a2.read(byArray);
        }
        fileOutputStream.close();
        return;
        {
            catch (IOException iOException) {
                throw new MessagingPlatformException(ErrorCode.OTHER, a3 + ": Writing plugin stream to file failed", (Throwable)iOException);
            }
        }
        {
            catch (Throwable throwable) {
                Throwable throwable2;
                try {
                    fileOutputStream.close();
                    throwable2 = throwable;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable;
                    throwable2 = throwable4;
                    throwable4.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
    }

    public boolean isRunning() {
        PluginPackageManager a2;
        return a2.B;
    }

    public PluginPackageManager(PluginPackages a4, OsgiController a5, PluginContextManager a6, ApplicationEventPublisher a7, MessagingPlatformConfiguration a8, CommonConfigurationFactory a9) {
        PluginPackageManager a10;
        PluginPackageManager pluginPackageManager = a10;
        PluginPackageManager pluginPackageManager2 = a10;
        a10.c = LoggerFactory.getLogger(PluginPackageManager.class);
        pluginPackageManager2.E = a4;
        pluginPackageManager2.C = a5;
        pluginPackageManager.e = a6;
        pluginPackageManager.A = a7;
        a10.G = a8.getPluginPackageDirectory();
        a10.l = a9;
        a10.C.registerPluginListener((a2, a3) -> {
            PluginPackageManager a4;
            a4.A.publishEvent((Object)new PluginEvent(a2, a3));
        });
    }

    public Iterable<PluginInfo> listPlugins() {
        PluginPackageManager a2;
        return a2.e.listPlugins();
    }

    public Optional<PluginPackage> getPluginPackage(String a2, String a4, String a5) {
        PluginPackageManager a6;
        return a6.E.findByNameAndVersion(a2, a4).map(a3 -> {
            if (a3.getFilename().equals(a5)) {
                return a3;
            }
            return null;
        });
    }

    public void stop() {
        PluginPackageManager a2;
        a2.C.stop();
        a2.B = false;
    }

    public File getLocation(PluginKey a3) {
        PluginPackageManager a4;
        return a4.E.findByNameAndVersion(a3.getSymbolicName(), a3.getVersion()).map(a2 -> new File(a2.getFilename())).orElse(null);
    }

    public void start() {
        PluginPackageManager pluginPackageManager;
        PluginPackageManager a3;
        a3.C.start();
        try {
            Files.createDirectories(new File(a3.G).toPath(), new FileAttribute[0]);
            a3.E.findAll().forEach(a2 -> {
                PluginPackageManager a3;
                block3: {
                    try {
                        if (!a2.isDeleted()) break block3;
                        a3.h(a2);
                        return;
                    }
                    catch (Exception exception) {
                        a3.c.error(ShowDetail.M((Object)"\u001a\u00045\t9\u0001|\u00113E/\u0011=\u0017(E,\t)\u00025\u000b|\u001e!"), (Object)a2.getKey(), (Object)exception);
                        return;
                    }
                }
                PluginPackageManager pluginPackageManager = a3;
                pluginPackageManager.C.startPlugin(pluginPackageManager.G + File.separatorChar + a2.getFilename());
                a3.M(a2.getKey(), PreparedTransaction.M((Object)"}7O1Z&J"));
            });
            a3.e.start();
            pluginPackageManager = a3;
        }
        catch (Exception exception) {
            PluginPackageManager pluginPackageManager2 = a3;
            pluginPackageManager = pluginPackageManager2;
            pluginPackageManager2.c.error(PreparedTransaction.M((Object)"\u0005O*B&JcZ,\u000e0Z\"\\7\u000e3B6I*@"), (Throwable)exception);
        }
        pluginPackageManager.B = true;
    }

    public File getFullPath(String a3, String a4) {
        PluginPackageManager a5;
        return a5.E.findByNameAndVersion(a3, a4).map(a2 -> {
            PluginPackageManager a3;
            return new File(a3.G + File.separatorChar + a2.getFilename());
        }).orElseThrow(() -> new MessagingPlatformException(ErrorCode.OTHER, ShowDetail.M((Object)"50\u0010;\f2E2\n(E:\n)\u000b8")));
    }

    public int getPhase() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional
    public PluginPackage addPlugin(String a2, InputStream a32) {
        PluginPackageManager a4;
        File file = new File(a4.G + File.separatorChar + a2);
        a4.M(a32, file);
        try {
            PluginPackageManager pluginPackageManager;
            PluginPackage pluginPackage;
            block5: {
                block4: {
                    block3: {
                        PluginPackageManager pluginPackageManager2 = a4;
                        a32 = pluginPackageManager2.C.addPlugin(file);
                        Optional optional = pluginPackageManager2.E.findByNameAndVersion(a32.getSymbolicName(), a32.getVersion());
                        if (!optional.isPresent()) break block3;
                        pluginPackage = (PluginPackage)optional.get();
                        if (a2.equals(pluginPackage.getFilename())) break block4;
                        FileUtils.M((File)new File(a4.G + File.separatorChar + pluginPackage.getFilename()));
                        pluginPackage.setFilename(a2);
                        a4.E.save(pluginPackage);
                        pluginPackageManager = a4;
                        break block5;
                    }
                    PluginPackageManager pluginPackageManager3 = a4;
                    pluginPackage = pluginPackageManager3.l.pluginPackage(a32.getSymbolicName(), a32.getVersion(), a2);
                    pluginPackage = pluginPackageManager3.E.save(pluginPackage);
                }
                pluginPackageManager = a4;
            }
            pluginPackageManager.e.publishConfiguration(pluginPackage);
            return pluginPackage;
        }
        catch (RuntimeException a32) {
            FileUtils.M((File)file);
            throw a32;
        }
    }
}

