/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.enterprise.replication.BackupInfoController;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.transaction.PreparedTransaction;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.logging.PluginEventsLogger;
import io.axoniq.axonserver.rest.BackupInfoRestController;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Principal;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/backup"})
public class ClusterBackupInfoRestController {
    private static final Logger E = AuditLog.getLogger();
    private final BackupInfoController C;
    private final BackupInfoRestController c;
    private final GrpcRaftController e;

    @PostMapping(value={"/createControlDbBackup"})
    public String M(@Parameter(hidden=true) Principal a3) throws SQLException {
        E.info(PreparedTransaction.M((Object)"\u0018U>sc|&_6K0ZcZ,\u000e \\&O7KcM,@7\\,B'LcL\"M([3\u0000"), (Object)AuditLog.username((Principal)a3));
        this.e.getRaftGroups().forEach(a2 -> {
            ClusterBackupInfoRestController a3;
            ClusterBackupInfoRestController clusterBackupInfoRestController = a3;
            String string = a2;
            clusterBackupInfoRestController.C.registerControlDbBackup(string, clusterBackupInfoRestController.e.getRaftGroup(string).logEntryProcessor().M(), System.currentTimeMillis());
        });
        return this.c.M();
    }

    @GetMapping(value={"/log/filenames"})
    public List<String> M(@RequestParam(value="context", defaultValue="default") String replicationGroup, @Parameter(hidden=true) Principal a2) {
        if (E.isInfoEnabled()) {
            E.info(PluginEventsLogger.M((Object)"\u007fKYm\u0004bAAQUWD\u0004DK\u0010HYWD\u0004RESOET\u0010BYHUW\u0010B_V\u0010VUT\\MSEDM_J\u0010CBKET\u0010_M\n"), (Object)AuditLog.username((Principal)a2), (Object)StringUtils.sanitize((String)replicationGroup));
        }
        if ((a2 = this.e.getRaftGroup(replicationGroup)) == null) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, replicationGroup + ": replication group not found");
        }
        return a2.localLogEntryStore().getBackupFilenames().collect(Collectors.toList());
    }

    public ClusterBackupInfoRestController(BackupInfoRestController a2, GrpcRaftController a3, BackupInfoController a4) {
        ClusterBackupInfoRestController a5;
        ClusterBackupInfoRestController clusterBackupInfoRestController = a5;
        a5.c = a2;
        clusterBackupInfoRestController.e = a3;
        clusterBackupInfoRestController.C = a4;
    }
}

