/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.AdminContextController;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.rest.svg.jsfunction.ShowDetail;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private final FeatureChecker a;
    private final ClusterTemplateController j;
    private static final Logger h = AuditLog.getLogger();
    private static final Logger l = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ClusterTopology G;
    private final ApplicationEventPublisher B;
    private final Predicate<String> A;
    public static final String E = "_none";
    private final DistributeLicenseService C;
    private final RaftConfigServiceFactory c;
    private final ClusterController e;

    public ClusterRestController(ClusterController a2, RaftConfigServiceFactory a3, FeatureChecker a4, DistributeLicenseService a5, ApplicationEventPublisher a6, ClusterTopology a7, ClusterTemplateController a8) {
        ClusterRestController a9;
        ClusterRestController clusterRestController = a9;
        ClusterRestController clusterRestController2 = a9;
        ClusterRestController clusterRestController3 = a9;
        ClusterRestController clusterRestController4 = a9;
        a9.A = new ContextNameValidation();
        a9.e = a2;
        clusterRestController3.c = a3;
        clusterRestController3.a = a4;
        clusterRestController2.C = a5;
        clusterRestController2.B = a6;
        clusterRestController.G = a7;
        clusterRestController.j = a8;
    }

    @GetMapping(path={"{name}"})
    public JsonClusterNode M(@PathVariable(value="name") String name, @Parameter(hidden=true) Principal a2) {
        h.info(ShowDetail.M((Object)"\u0007\u001e!8|79\u0014)\u0000/\u0011|\u000b3\u00019E8\u0000(\u00045\t/E:\n.E'\u0018r"), (Object)AuditLog.username((Principal)a2), (Object)name);
        a2 = this.e.getNode(name);
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + name + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a2, (boolean)this.e.isActive(name));
    }

    @DeleteMapping(path={"{name}"})
    public void M(@PathVariable(value="name") String name, @Parameter(hidden=true) Principal a2) {
        h.info(AdminContextController.M((Object)"?\u0007\u0019!D.\u0001\r\u0011\u0019\u0017\bD\b\u000b\\\u0000\u0019\b\u0019\u0010\u0019D\u0012\u000b\u0018\u0001\\\u001f\u0001J"), (Object)AuditLog.username((Principal)a2), (Object)name);
        this.c.getRaftConfigService().deleteNode(name);
    }

    @PostMapping
    public ResponseEntity<RestResponse> M(@Valid @RequestBody ClusterJoinRequest jsonClusterNode2, @Parameter(hidden=true) Principal a2) {
        ClusterRestController clusterRestController;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = jsonClusterNode2.getInternalHostName();
        objectArray[2] = jsonClusterNode2.internalGrpcPort;
        h.info(ShowDetail.M((Object)">'\u0018\u0001E\u000e\u0000-\u00109\u0016(E(\n|\u000f3\f2E?\t)\u0016(\u0000.E=\u0011|\u001e!_'\u0018r"), objectArray);
        a2 = NodeInfo.newBuilder((NodeInfo)this.e.getMe().toNodeInfo());
        String string = jsonClusterNode2.getContext();
        if (string != null && !string.isEmpty()) {
            if (jsonClusterNode2.getNoContexts() != null && jsonClusterNode2.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, AdminContextController.M((Object)"'\u001d\n\u0012\u000b\bD\u001f\u000b\u0011\u0006\u0015\n\u0019D\u0016\u000b\u0015\n\u0015\n\u001bD\u001f\u000b\u0012\u0010\u0019\u001c\bD\u000b\r\b\f\\\n\u0013'\u0013\n\b\u0001\u0004\u0010\u000fJ"));
            }
            if (!RaftAdminGroup.M((String)string) && !this.A.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            l.debug(ShowDetail.M((Object)"\u00048\u0001tLfE\u000e\u0000;\f/\u00119\u00175\u000b;E1\u001c/\u00000\u0003|\u00042\u0001|\u00048\u00015\u000b;E1\u0000|\u00113E?\n2\u00119\u001d(E~\u001e!Gr"), (Object)string);
            clusterRestController = this;
            a2.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (jsonClusterNode2.getNoContexts() != null && jsonClusterNode2.getNoContexts().booleanValue()) {
            l.debug(AdminContextController.M((Object)"\u0005\u0018\u0000TMFD.\u0001\u001b\r\u000f\u0010\u0019\u0016\u0015\n\u001bD\u0011\u001d\u000f\u0001\u0010\u0002\\\u0005\u0012\u0000\\\u0005\u0018\u0000\u0015\n\u001bD\u0011\u0001\\\u0010\u0013D\u0012\u000b\\\u0007\u0013\n\b\u0001\u0004\u0010\u000fJ"));
            clusterRestController = this;
            a2.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            l.debug(ShowDetail.M((Object)"\u00048\u0001tLfE\u000e\u0000;\f/\u00119\u00175\u000b;E1\u001c/\u00000\u0003|\u00042\u0001|\u00048\u00015\u000b;E1\u0000|\u00113E=\t0E?\n2\u00119\u001d(\u0016r"));
            clusterRestController = this;
        }
        if (clusterRestController.e.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body((Object)new RestResponse(false, AdminContextController.M((Object)"2\u000b\u0018\u0001\\\u0005\u0010\u0016\u0019\u0005\u0018\u001d\\\u0016\u0019\u0003\u0015\u0017\b\u0001\u000e\u0001\u0018D\u0015\n\\\u0005\\\u0007\u0010\u0011\u000f\u0010\u0019\u0016")));
        }
        try {
            ClusterRestController clusterRestController2 = this;
            ClusterJoinRequest clusterJoinRequest = jsonClusterNode2;
            jsonClusterNode2 = clusterRestController2.c.getRaftConfigServiceStub(clusterJoinRequest.internalHostName, clusterJoinRequest.internalGrpcPort.intValue()).joinCluster(a2.build());
            clusterRestController2.B.publishEvent((Object)new ClusterEvents.LicenseUpdated(jsonClusterNode2.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, ShowDetail.M((Object)"$?\u00069\u0015(\u00008E6\n5\u000b|\u00179\u0014)\u0000/\u0011pE1\u0004%E(\u00047\u0000|\u0004|\u00124\f0\u0000|\u00113E,\u00173\u00069\u0016/")));
        }
        catch (Exception jsonClusterNode2) {
            return new RestResponse(false, jsonClusterNode2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)jsonClusterNode2));
        }
    }

    @PostMapping(value={"/upload-license"})
    public void M(@RequestParam(value="licenseFile") MultipartFile licenseFile, @Parameter(hidden=true) Principal a2) throws IOException {
        h.info(AdminContextController.M((Object)"'\u001f\u00019\\6\u0019\u0015\t\u0001\u000f\u0010\\\b\u0015\u0007\u0019\n\u000f\u0001\\\u0011\f\u0000\u001d\u0010\u0019J"), (Object)AuditLog.username((Principal)a2));
        l.info(ShowDetail.M((Object)"+9\u0012|\t5\u00069\u000b/\u0000|\u0010,\t3\u00048\u00008I|\u00159\u0017:\n.\b5\u000b;E0\f?\u00002\u00169E)\u00158\u0004(\u0000rKr"));
        try {
            this.C.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, AdminContextController.M((Object)"*\u0013D\u0010\u0001\u001d\u0000\u0019\u0016\\\u0002\u0013\u0016\\;\u001d\u0000\u0011\r\u0012J\\!\u0012\u0017\t\u0016\u0019D\b\f\u001d\u0010\\\u0010\u0014\u0001\\;\u001d\u0000\u0011\r\u0012D\u000e\u0001\f\b\u0015\u0007\u001d\u0010\u0015\u000b\u0012D\u001b\u0016\u0013\u0011\fD\u0015\u0017\\\u0007\u000e\u0001\u001d\u0010\u0019\u0000\\\u0006\u0019\u0002\u0013\u0016\u0019D\t\u0014\u0010\u000b\u001d\u0000\u0015\n\u001bD\u001dD\u0010\r\u001f\u0001\u0012\u0017\u0019J"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException licenseException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, licenseException.getMessage());
        }
    }

    @GetMapping
    public List<JsonClusterNode> M(@Parameter(hidden=true) Principal a3) {
        h.info(ShowDetail.M((Object)"\u0007\u001e!8|79\u0014)\u0000/\u0011|\u00113E0\f/\u0011|\u000b3\u00019\u0016r"), (Object)AuditLog.username((Principal)a3));
        return this.e.nodes().map(a2 -> {
            ClusterRestController a3;
            ClusterNode clusterNode = a2;
            return JsonClusterNode.from((ClusterNode)clusterNode, (boolean)a3.e.isActive(clusterNode.getName()));
        }).collect(Collectors.toList());
    }

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void M(HttpServletResponse resp, @Parameter(hidden=true) Principal a2) throws IOException {
        h.info(AdminContextController.M((Object)"?\u0007\u0019!D.\u0001\r\u0011\u0019\u0017\bD\u001f\b\t\u0017\b\u0001\u000eD\b\u0001\u0011\u0014\u0010\u0005\b\u0001\\\u0000\u0013\u0013\u0012\b\u0013\u0005\u0018J"), (Object)AuditLog.username((Principal)a2));
        if (this.G.isAdminNode()) {
            a2 = ShowDetail.M((Object)"\u00060\u0010/\u00119\u0017q\u00119\b,\t=\u00119K%\b0");
            String string = this.j.buildYamlTemplate();
            HttpServletResponse httpServletResponse = resp;
            resp = httpServletResponse.getOutputStream();
            httpServletResponse.setContentType(AdminContextController.M((Object)"\u0010\u0019\u001c\bK\f\b\u001d\r\u0012_\\\u0007\u0014\u0005\u000e\u0017\u0019\u0010A\u0011\b\u0002Q\\"));
            httpServletResponse.addHeader(ShowDetail.M((Object)"\u001f\n2\u00119\u000b(H\u0018\f/\u00153\u00165\u00115\n2"), "attachment; filename=\"" + (String)a2 + "\"");
            HttpServletResponse httpServletResponse2 = resp;
            httpServletResponse2.write(string.getBytes(StandardCharsets.UTF_8));
            httpServletResponse2.flush();
            httpServletResponse2.close();
            return;
        }
        throw new RuntimeException(AdminContextController.M((Object)"=\u0013\u0011\\\u0007\u001d\n\\\u0011\u000f\u0001\\\u0010\u0014\r\u000fD\u001a\u0011\u0012\u0007\b\r\u0013\n\u001d\b\u0015\u0010\u0005D\u0013\n\u0010\u001d\\\u0002\u000e\u000b\u0011D\u001d\u0000\u0011\r\u0012D\u0012\u000b\u0018\u0001"));
    }
}

