/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.component.ComponentItems;
import io.axoniq.axonserver.component.command.ComponentCommand;
import io.axoniq.axonserver.component.command.DefaultCommands;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.enterprise.cluster.MetricsEvents;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.message.command.CommandRegistrationCache;
import io.axoniq.axonserver.rest.CommandRestController;
import io.axoniq.axonserver.rest.F;
import io.axoniq.axonserver.rest.json.CommandRequestJson;
import io.axoniq.axonserver.rest.json.CommandResponseJson;
import io.axoniq.axonserver.rest.svg.mapping.AxonServers;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.security.Principal;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="CommandRestController")
@RequestMapping(value={"/v1"})
public class CommandRestController {
    private final CommandRegistrationCache C;
    private static final Logger c = AuditLog.getLogger();
    private final CommandDispatcher e;

    @GetMapping(value={"commands/count"})
    public int M(@Parameter(hidden=true) Principal a2) {
        if (c.isDebugEnabled()) {
            c.debug(AxonServers.M((Object)"irOT\u0012[WxGlA}\u0012o]{\u0012}Zl\u0012hQ}[\u007fW)Qf_dSgV)QfGgF'"), (Object)AuditLog.username((Principal)a2));
        }
        return this.e.activeCommandCount();
    }

    public CommandRestController(CommandDispatcher a2, CommandRegistrationCache a3) {
        CommandRestController a4;
        CommandRestController commandRestController = a4;
        commandRestController.e = a2;
        commandRestController.C = a3;
    }

    @GetMapping(value={"commands"})
    public List<JsonClientMapping> h(@Parameter(hidden=true) Principal a2) {
        c.info(MetricsEvents.M((Object)"\u007fCYe\u0004jAIQ]WL\u0004LK\u0018HQWL\u0004YHT\u0004{KUIYJ\\W\u0018SPM[L\u0018LYR]\u0004Y\u0004JA_MKP]V]@\u0018LYJ\\H]V\u0016"), (Object)AuditLog.username((Principal)a2));
        return this.C.getAll().entrySet().stream().map(JsonClientMapping::M).collect(Collectors.toList());
    }

    @GetMapping(value={"commands/queues"})
    public List<F> M(@Parameter(hidden=true) Principal a2) {
        c.info(AxonServers.M((Object)"RIto)`lC|WzF)Ff\u0012e[zF)Se^)qf_dSgVXGlGlA'"), (Object)AuditLog.username((Principal)a2));
        return this.e.getCommandQueues().M().entrySet().stream().map(F::M).collect(Collectors.toList());
    }

    @GetMapping(value={"/components/{component}/commands"})
    public Iterable<ComponentCommand> M(@PathVariable(value="component") String component, @RequestParam(value="context") String context, @Parameter(hidden=true) Principal a2) {
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = component;
        objectArray[2] = StringUtils.sanitize((String)context);
        c.info(MetricsEvents.M((Object)"\u007fCYe\u0004jAIQ]WL\u0004LK\u0018HQWL\u0004YHT\u0004{KUIYJ\\W\u0018BWV\u0018SPM[L\u0018GWIHKVAVP\u0018\u0006CY\u001a\u0004QJ\u0018GWJLA@P\u0018\u0006CY\u001a\u0004PEK\u0004Y\u0004JA_MKP]V]@\u0018LYJ\\H]V\u0016"), objectArray);
        return new ComponentItems(component, context, (Iterable)new DefaultCommands(this.C));
    }

    @PostMapping(value={"commands/run"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public Future<CommandResponseJson> M(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @RequestBody @Valid CommandRequestJson command, @Parameter(hidden=true) Authentication a2) {
        c.info(AxonServers.M((Object)"irOT\u0012[WxGlA}\u0012}])V`AyS}Qa\u0012h\u0012+It\u0010)qf_dSgV'"), (Object)AuditLog.username((Principal)a2), (Object)command.getName());
        CompletableFuture<CommandResponseJson> completableFuture = new CompletableFuture<CommandResponseJson>();
        this.e.dispatch(context, (Authentication)ObjectUtils.M((Object)a2, (Object)GrpcContextAuthenticationProvider.e), new SerializedCommand(command.asCommand()), a3 -> completableFuture.complete(new CommandResponseJson(a3.wrapped())));
        return completableFuture;
    }
}

