/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.grpc.event.GetAggregateEventsRequest;
import io.axoniq.axonserver.grpc.event.GetAggregateSnapshotsRequest;
import io.axoniq.axonserver.grpc.event.GetEventsRequest;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.logging.PluginEventsLogger;
import io.axoniq.axonserver.message.event.EventDispatcher;
import io.axoniq.axonserver.rest.EventsRestController;
import io.axoniq.axonserver.rest.json.QueryRequestJson;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.security.Principal;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

@RestController(value="EventsRestController")
@RequestMapping(value={"/v1"})
public class EventsRestController {
    private final Logger C;
    private final EventDispatcher c;
    private static final Logger e = AuditLog.getLogger();

    private /* synthetic */ void M(SseEmitter a22, ObjectMapper a3, SerializedEvent a4) {
        try {
            a22.send(SseEmitter.event().data((Object)a3.writeValueAsString((Object)new JsonEvent(a4.M()))));
            return;
        }
        catch (Exception a22) {
            EventsRestController a5;
            a5.C.debug(QueryRequestJson.M((Object)"lEJXYI@RG\u001dFS\tNLSMTGZ\tX_XGI\t\u0010\tFT"), (Object)a22.getMessage(), (Object)a22);
            return;
        }
    }

    public EventsRestController(EventDispatcher a2) {
        EventsRestController a3;
        EventsRestController eventsRestController = a3;
        eventsRestController.C = LoggerFactory.getLogger(EventsRestController.class);
        eventsRestController.c = a2;
    }

    @GetMapping(path={"events"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public SseEmitter M(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @RequestParam(value="aggregateId", required=false) String aggregateId, @RequestParam(value="initialSequence", defaultValue="0", required=false) long initialSequence, @RequestParam(value="allowSnapshots", defaultValue="true", required=false) boolean allowSnapshots, @RequestParam(value="trackingToken", defaultValue="0", required=false) long trackingToken, @RequestParam(value="timeout", defaultValue="3600", required=false) long a22, @RequestParam(value="maxEvents", defaultValue="10000", required=false) long a5, @Parameter(hidden=true) Authentication a6) {
        Object[] objectArray = new Object[5];
        objectArray[0] = AuditLog.username((Principal)a6);
        objectArray[1] = context;
        objectArray[2] = aggregateId;
        objectArray[3] = initialSequence;
        objectArray[4] = trackingToken;
        e.info(PluginEventsLogger.M((Object)"\u007fKYp_My\u0010vUUEACP\u0010B_V\u0010E^\u0004URUJD\tCPBAQI\u0010KV\u0004QCWVUCQPU\u0004\u0012_M\u0006\u001c\u0004CPQVDM^C\u0010ED\u0004CAAQUJSA\u0010_M\b\u0010P_OUJ\u0010_M\n"), objectArray);
        SseEmitter a22 = new SseEmitter(Long.valueOf(TimeUnit.SECONDS.toMillis(a22)));
        if (aggregateId != null) {
            GetAggregateEventsRequest getAggregateEventsRequest = GetAggregateEventsRequest.newBuilder().setAggregateId(aggregateId).setAllowSnapshots(allowSnapshots).setInitialSequence(initialSequence).build();
            ObjectMapper objectMapper = new ObjectMapper();
            aggregateId = this.c.aggregateEvents(context, (Authentication)ObjectUtils.M((Object)a6, (Object)GrpcContextAuthenticationProvider.e), getAggregateEventsRequest).subscribe(a4 -> {
                EventsRestController a5;
                a5.M(a22, objectMapper, a4);
            }, arg_0 -> ((SseEmitter)a22).completeWithError(arg_0), () -> {
                EventsRestController a3;
                a3.M(a22);
            });
            this.M(a22, () -> ((Disposable)aggregateId).dispose());
            return a22;
        }
        GetEventsRequest getEventsRequest = GetEventsRequest.newBuilder().setTrackingToken(trackingToken).setNumberOfPermits(a5).setClientId(QueryRequestJson.M((Object)"oln}")).build();
        Sinks.Many many = Sinks.many().unicast().onBackpressureBuffer();
        this.c.events(context, (Authentication)ObjectUtils.M((Object)a6, (Object)GrpcContextAuthenticationProvider.e), many.asFlux()).subscribe(a3 -> {
            EventsRestController a4;
            a4.M(a22, a3);
        }, arg_0 -> ((SseEmitter)a22).completeWithError(arg_0), () -> {
            EventsRestController a3;
            a3.M(a22);
        });
        many.emitNext((Object)getEventsRequest, Sinks.EmitFailureHandler.FAIL_FAST);
        this.M(a22, () -> many.emitComplete(Sinks.EmitFailureHandler.FAIL_FAST));
        return a22;
    }

    @PostMapping(value={"events"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public Mono<Void> M(@RequestHeader(value="AxonIQ-Context", required=false, defaultValue="default") String context, @Valid @RequestBody JsonEventList jsonEvents, @Parameter(hidden=true) Authentication a3) {
        if (jsonEvents.messages.isEmpty()) {
            throw new IllegalArgumentException(PluginEventsLogger.M((Object)"}MCWYJW\u0004]ACWQCUW"));
        }
        jsonEvents = Flux.fromStream(jsonEvents.messages.stream().map(a2 -> new SerializedEvent(a2.asEvent())));
        return this.c.appendEvent(context, a3, (Flux)jsonEvents);
    }

    private /* synthetic */ void M(SseEmitter a2, Runnable a4) {
        a2.onError(a3 -> a4.run());
        a2.onCompletion(a4::run);
        a2.onTimeout(a4::run);
    }

    @PostMapping(value={"snapshot"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    @Deprecated
    public Mono<Void> h(@RequestHeader(value="AxonIQ-Context", required=false, defaultValue="default") String context, @RequestBody @Valid JsonEvent jsonEvent, @Parameter(hidden=true) Authentication a2) {
        e.warn(PluginEventsLogger.M((Object)"\u007fKYp_My\u0010vUUEACP\u0010P_\u0004QT@A^@\u0010AFA^P\u0018W\u0019\u0004EWYJW\u0004TA@VUGQPU@\u0010e`m"), (Object)AuditLog.username((Principal)a2), (Object)context);
        return this.M(context, jsonEvent, a2);
    }

    @GetMapping(path={"snapshots"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public SseEmitter M(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @RequestParam(value="aggregateId", required=true) String aggregateId, @RequestParam(value="maxSequence", defaultValue="-1", required=false) long maxSequence, @RequestParam(value="initialSequence", defaultValue="0", required=false) long a2, @Parameter(hidden=true) Authentication a4) {
        Object[] objectArray = new Object[5];
        objectArray[0] = AuditLog.username((Principal)a4);
        objectArray[1] = context;
        objectArray[2] = aggregateId;
        objectArray[3] = a2;
        objectArray[4] = maxSequence;
        e.info(QueryRequestJson.M((Object)"fR@iFT`\toLL\\XZI\t[FO\tQ@N]\u001dF[\tNG\\YNAR]N\tRO\u001dHZNOLZHIL\u001d\u000bFT\u001f\u0005\u001drFT\u0010R@t"), objectArray);
        SseEmitter sseEmitter = new SseEmitter();
        aggregateId = GetAggregateSnapshotsRequest.newBuilder().setAggregateId(aggregateId).setInitialSequence(a2).setMaxSequence(maxSequence >= 0L ? maxSequence : Long.MAX_VALUE).build();
        this.c.aggregateSnapshots(StringUtils.getOrDefault((String)context, (String)"default"), (Authentication)ObjectUtils.M((Object)a4, (Object)GrpcContextAuthenticationProvider.e), (GetAggregateSnapshotsRequest)aggregateId).doOnError(arg_0 -> ((SseEmitter)sseEmitter).completeWithError(arg_0)).doOnComplete(() -> {
            EventsRestController a3;
            a3.M(sseEmitter);
        }).subscribe(a3 -> {
            try {
                sseEmitter.send(SseEmitter.event().data((Object)new JsonEvent(a3.M())));
                return;
            }
            catch (Exception a22) {
                EventsRestController a4;
                a4.C.debug(QueryRequestJson.M((Object)"lEJXYI@RG\u001dFS\tNLSMTGZ\tX_XGI\t\u0010\tFT"), (Object)a22.getMessage(), (Object)a22);
                return;
            }
        });
        return sseEmitter;
    }

    @PostMapping(value={"snapshots"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public Mono<Void> M(@RequestHeader(value="AxonIQ-Context", required=false, defaultValue="default") String context, @RequestBody @Valid JsonEvent jsonEvent, @Parameter(hidden=true) Authentication a2) {
        e.info(PluginEventsLogger.M((Object)"k_MdKYm\u0004bAAQUWD\u0004DK\u0010E@TUJT\u0004URUJD\fC\r"), (Object)AuditLog.username((Principal)a2), (Object)context);
        return this.c.appendSnapshot(StringUtils.getOrDefault((String)context, (String)"default"), jsonEvent.asEvent(), (Authentication)ObjectUtils.M((Object)a2, (Object)GrpcContextAuthenticationProvider.e));
    }

    private /* synthetic */ void M(SseEmitter a2) {
        try {
            a2.send(SseEmitter.event().comment(QueryRequestJson.M((Object)"lSM\u001dF[\tN]OL\\D")));
            return;
        }
        catch (Exception exception) {
            EventsRestController a3;
            a3.C.debug(PluginEventsLogger.M((Object)"uVBKB\u0004_J\u0010WUJTM^C\u0010G_I@HUPU@"), (Throwable)exception);
            return;
        }
        finally {
            a2.complete();
        }
    }

    private /* synthetic */ void M(SseEmitter a2, SerializedEventWithToken a32) {
        try {
            a2.send(SseEmitter.event().id(String.valueOf(a32.M() + 1L)).data((Object)new JsonEvent(a32.M())));
            return;
        }
        catch (Exception a32) {
            EventsRestController a4;
            Exception exception = a32;
            a4.C.debug(QueryRequestJson.M((Object)"lEJXYI@RG\u001dFS\tNLSMTGZ\tX_XGI\t\u0010\tFT"), (Object)exception.getMessage(), (Object)a32);
            a2.completeWithError((Throwable)exception);
            return;
        }
    }
}

