/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.command.CommandMetricsWebSocket;
import io.axoniq.axonserver.plugin.PluginController;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import io.axoniq.axonserver.rest.PluginConfigurationJSON;
import io.axoniq.axonserver.rest.PluginPropertyGroup;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/plugins"})
@CrossOrigin
public class PluginsRestController {
    private final PluginController B;
    private final Logger A;
    private final FeatureChecker E;
    public static final String C = "Plugins disabled";
    private final boolean c;
    private static final Logger e = AuditLog.getLogger();

    @PostMapping(consumes={"multipart/form-data"})
    public PluginKey M(@RequestPart(value="bundle") MultipartFile pluginBundle22, @Parameter(hidden=true) Principal a2) throws IOException {
        MultipartFile pluginBundle22;
        block6: {
            if (!this.c || !this.E.plugins()) {
                throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, C);
            }
            e.info(TaskPublisher.M((Object)"G(a\u000e<\u0001y\"i6o'<'ssu=o'}?psl?i4u=<(a}<"), (Object)AuditLog.username((Principal)a2), (Object)StringUtils.sanitize((String)pluginBundle22.getOriginalFilename()));
            a2 = pluginBundle22.getInputStream();
            try {
                PluginsRestController pluginsRestController = this;
                String string = pluginsRestController.M(pluginBundle22.getOriginalFilename());
                pluginBundle22 = pluginsRestController.B.addPlugin(string, (InputStream)a2);
                if (a2 == null) break block6;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block7: {
                    if (a2 != null) {
                        try {
                            ((InputStream)a2).close();
                            throwable2 = throwable;
                            break block7;
                        }
                        catch (Throwable pluginBundle22) {
                            throwable.addSuppressed(pluginBundle22);
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            ((InputStream)a2).close();
        }
        return pluginBundle22;
    }

    @PostMapping(value={"configuration"})
    public void M(@RequestBody PluginConfigurationJSON configurationJSON, @Parameter(hidden=true) Principal a2) {
        if (!this.c || !this.E.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, C);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)configurationJSON.getName());
        objectArray[2] = StringUtils.sanitize((String)configurationJSON.getVersion());
        e.info(CommandMetricsWebSocket.M((Object)"ixO^\u0012QWrGfAw\u0012w]#GsVbFf\u0012`]mTjUv@bFj]m\u0012lT#I~\u001dxO-\u0012"), objectArray);
        this.B.updateConfiguration((PluginKey)new SimplePluginKey(configurationJSON.getName(), configurationJSON.getVersion()), configurationJSON.getContext(), configurationJSON.getProperties());
    }

    @GetMapping
    public Iterable<PluginInfo> M(@Parameter(hidden=true) Principal a2) {
        e.info(TaskPublisher.M((Object)"\bg.AsN6m&y hsh<<?u hs\u007f&n!y=hsl?i4u=o}<"), (Object)AuditLog.username((Principal)a2));
        return this.B.listPlugins();
    }

    @PostMapping(value={"status"})
    public void M(@RequestParam(value="name") String name, @RequestParam(value="version") String version, @RequestParam(required=false, name="targetContext") String context, @RequestParam boolean active, @Parameter(hidden=true) Principal a2) {
        if (!this.c || !this.E.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, C);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = active ? TaskPublisher.M((Object)"o'}!h") : CommandMetricsWebSocket.M((Object)"pFlB");
        objectArray[2] = StringUtils.sanitize((String)name);
        objectArray[3] = StringUtils.sanitize((String)version);
        e.info(CommandMetricsWebSocket.M((Object)"ixO^\u0012QWrGfAw\u0012w]#I~\u0012s^vUj\\#I~\u001dxO-\u0012"), objectArray);
        this.B.updatePluginStatus((PluginKey)new SimplePluginKey(name, version), context, active);
    }

    @DeleteMapping(value={"context"})
    public void M(@RequestParam(value="name") String name, @RequestParam(value="version") String version, @RequestParam(required=false, name="targetContext") String context, @Parameter(hidden=true) Principal a2) {
        if (!this.c || !this.E.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, C);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        objectArray[3] = StringUtils.sanitize((String)context);
        e.info(TaskPublisher.M((Object)"G(a\u000e<\u0001y\"i6o'<'ssi=n6{:o'y!<#p&{:rsg.3(asz<ns\u007f<r'y+hsg.2"), objectArray);
        this.B.unregisterPluginForContext((PluginKey)new SimplePluginKey(name, version), context);
    }

    @DeleteMapping
    public void M(@RequestParam(value="name") String name, @RequestParam(value="version") String version, @Parameter(hidden=true) Principal a2) {
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        e.info(CommandMetricsWebSocket.M((Object)"XI~o#`fCvWpF#Fl\u0012v\\j\\pFb^o\u0012s^vUj\\#I~\u001dxO-\u0012"), objectArray);
        this.B.uninstallPlugin((PluginKey)new SimplePluginKey(name, version));
    }

    public PluginsRestController(PluginController a2, MessagingPlatformConfiguration a3, FeatureChecker a4) {
        PluginsRestController a5;
        PluginsRestController pluginsRestController = a5;
        PluginsRestController pluginsRestController2 = a5;
        pluginsRestController2.A = LoggerFactory.getLogger(PluginsRestController.class);
        pluginsRestController2.c = a3.isPluginsEnabled();
        pluginsRestController.B = a2;
        pluginsRestController.E = a4;
    }

    private /* synthetic */ String M(String a2) {
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.OTHER, TaskPublisher.M((Object)"\u001dssl?i4u=<#}0w2{6<#n<j:x6x"));
        }
        if (a2.contains(File.separator)) {
            throw new MessagingPlatformException(ErrorCode.OTHER, CommandMetricsWebSocket.M((Object)"tj^f\\b_f\u0012pZlGoV#\\lF#Ql\\wSj\\#Vj@fQw]qK#AfBb@bFl@"));
        }
        int n = a2.lastIndexOf(46);
        if (n > 0) {
            return a2.substring(0, n) + "-" + System.currentTimeMillis() + a2.substring(n);
        }
        return a2 + "-" + System.currentTimeMillis();
    }

    @GetMapping(value={"configuration"})
    public Iterable<PluginPropertyGroup> M(@RequestParam(value="name") String name, @RequestParam(value="version") String version, @RequestParam(required=false, name="targetContext") String context, @Parameter(hidden=true) Principal a2) {
        if (!this.c || !this.E.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, C);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        e.info(TaskPublisher.M((Object)"G(a\u000e<\u0001y\"i6o'<5s!<0s=z:{&n2h:s=<<zsg.3(a}<"), objectArray);
        try {
            return this.B.listProperties((PluginKey)new SimplePluginKey(name, version), context);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = name;
            objectArray2[1] = version;
            objectArray2[2] = runtimeException;
            this.A.warn(CommandMetricsWebSocket.M((Object)"tb[oWg\u0012w]#@fFq[fDf\u0012s@lBf@w[fA#Tl@#I~\bxO"), objectArray2);
            throw runtimeException;
        }
    }
}

