/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.message.event.EventDispatcher;
import io.axoniq.axonserver.message.query.QueryDispatcher;
import io.axoniq.axonserver.message.query.subscription.metric.HubSubscriptionMetrics;
import io.axoniq.axonserver.message.query.subscription.metric.SubscriptionQueryMetricRegistry;
import io.axoniq.axonserver.rest.LicenseInfo;
import io.axoniq.axonserver.rest.PublicRestController;
import io.axoniq.axonserver.rest.json.NodeConfiguration;
import io.axoniq.axonserver.rest.json.StatusInfo;
import io.axoniq.axonserver.rest.json.UserInfo;
import io.axoniq.axonserver.rest.svg.mapping.AxonServer;
import io.axoniq.axonserver.taskscheduler.task.NodeContext;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.version.VersionInfo;
import io.axoniq.axonserver.version.VersionInfoProvider;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@CrossOrigin
@RestController(value="PublicRestController")
@RequestMapping(value={"/v1/public"})
public class PublicRestController {
    private final SslConfiguration M;
    private final VersionInfoProvider d;
    private final Function<Predicate<String>, Stream<AxonServer>> a;
    private final EventDispatcher j;
    private final FeatureChecker h;
    @Value(value="${axoniq.axonserver.devmode.enabled:false}")
    private boolean l;
    private final AccessControlConfiguration G;
    private final Map<String, Boolean> B;
    private final Topology A;
    private final boolean E;
    private final CommandDispatcher C;
    private final QueryDispatcher c;
    private final SubscriptionQueryMetricRegistry e;

    public PublicRestController(Function<Predicate<String>, Stream<AxonServer>> a2, Topology a3, CommandDispatcher a4, QueryDispatcher a5, EventDispatcher a6, FeatureChecker a7, MessagingPlatformConfiguration a8, VersionInfoProvider a9, SubscriptionQueryMetricRegistry a10) {
        PublicRestController a11;
        PublicRestController publicRestController = a11;
        PublicRestController publicRestController2 = a11;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a8;
        PublicRestController publicRestController3 = a11;
        PublicRestController publicRestController4 = a11;
        PublicRestController publicRestController5 = a11;
        a11.a = a2;
        publicRestController5.A = a3;
        publicRestController5.C = a4;
        publicRestController4.c = a5;
        publicRestController4.j = a6;
        publicRestController3.h = a7;
        publicRestController3.M = a8.getSsl();
        a11.G = messagingPlatformConfiguration.getAccesscontrol();
        publicRestController2.E = messagingPlatformConfiguration.isPluginsEnabled();
        publicRestController2.d = a9;
        publicRestController.e = a10;
        publicRestController.B = a8.getPreview();
    }

    @GetMapping(path={"user"})
    @Operation(summary="Retrieves information on the user logged in in the current Http Session")
    public UserInfo M(HttpServletRequest a2) {
        if (a2.getUserPrincipal() instanceof Authentication) {
            a2 = (Authentication)a2.getUserPrincipal();
            return new UserInfo(a2.getName(), a2.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet()));
        }
        return null;
    }

    @GetMapping(path={"mycontexts"})
    @Operation(summary="Retrieves names for all storage (non admin) contexts for the current node")
    public Iterable<String> M() {
        PublicRestController a2;
        return a2.A.getMyStorageContextNames();
    }

    @GetMapping
    @Operation(summary="Retrieves all nodes in the cluster that the current node knows about.", description="For _admin nodes the result contains all nodes, for non _admin nodes theresult only contains nodes from contexts available on this node and the _admin nodes.")
    public List<JsonServerNode> M() {
        PublicRestController a2;
        return ((Stream)a2.a.apply(null)).map(JsonServerNode::new).sorted(Comparator.comparing(JsonServerNode::getName)).collect(Collectors.toList());
    }

    @GetMapping(path={"me"})
    @Operation(summary="Retrieves general information on the configuration of the current node, including hostnames and ports for the gRPC and HTTP connections and contexts")
    public NodeConfiguration M() {
        PublicRestController a2;
        NodeConfiguration nodeConfiguration;
        NodeConfiguration nodeConfiguration2 = nodeConfiguration = new NodeConfiguration(a2.A.getMe());
        PublicRestController publicRestController = a2;
        NodeConfiguration nodeConfiguration3 = nodeConfiguration;
        PublicRestController publicRestController2 = a2;
        nodeConfiguration.setAuthentication(a2.G.isEnabled());
        nodeConfiguration.setSsl(publicRestController2.M.isEnabled());
        nodeConfiguration3.setAdminNode(publicRestController2.A.isAdminNode());
        nodeConfiguration3.setDevelopmentMode(a2.l);
        nodeConfiguration.setContextNames(publicRestController.A.getMyContextNames());
        nodeConfiguration2.setStorageContextNames(publicRestController.A.getMyStorageContextNames());
        nodeConfiguration2.setPluginsEnabled(a2.E && a2.h.plugins());
        NodeConfiguration nodeConfiguration4 = nodeConfiguration;
        PublicRestController publicRestController3 = a2;
        nodeConfiguration.setInitialized(a2.A.initialized());
        nodeConfiguration.setMaxApplications(publicRestController3.h.getMaxApplications());
        nodeConfiguration4.setMaxConnections(publicRestController3.h.maxConnections());
        nodeConfiguration4.setMaxContexts(a2.h.getMaxContexts().orElse(Integer.MAX_VALUE).intValue());
        nodeConfiguration.setMaxReplicationGroups(a2.h.getMaxReplicationGroups().orElse(Integer.MAX_VALUE).intValue());
        NodeConfiguration nodeConfiguration5 = nodeConfiguration;
        nodeConfiguration5.setMaxUsers(a2.h.getMaxUsers());
        return nodeConfiguration5;
    }

    @GetMapping(path={"version"})
    @Operation(summary="Retrieves version information of the product")
    public VersionInfo M() {
        PublicRestController a2;
        return a2.d.get();
    }

    @GetMapping(path={"status"})
    @Operation(summary="Retrieves status information, used by UI")
    public StatusInfo M(@RequestParam(value="context", defaultValue="default", required=false) String a2) {
        StatusInfo statusInfo;
        HubSubscriptionMetrics hubSubscriptionMetrics = this.e.get(a2);
        StatusInfo statusInfo2 = statusInfo = new StatusInfo();
        statusInfo2.setCommandRate(this.C.commandRate(a2));
        statusInfo2.setQueryRate(this.c.queryRate(a2));
        if (!a2.startsWith(NodeContext.M((Object)"T"))) {
            StatusInfo statusInfo3 = statusInfo;
            PublicRestController publicRestController = this;
            statusInfo.setEventRate(this.j.eventRate(a2));
            statusInfo.setSnapshotRate(publicRestController.j.snapshotRate(a2));
            statusInfo3.setNrOfEvents(publicRestController.j.getNrOfEvents(a2));
            statusInfo3.setEventTrackers(this.j.eventTrackerStatus(a2));
        }
        StatusInfo statusInfo4 = statusInfo;
        HubSubscriptionMetrics hubSubscriptionMetrics2 = hubSubscriptionMetrics;
        statusInfo.setNrOfActiveSubscriptionQueries(hubSubscriptionMetrics2.activesCount().longValue());
        statusInfo4.setNrOfSubscriptionQueries(hubSubscriptionMetrics2.totalCount().longValue());
        statusInfo4.setNrOfSubscriptionQueriesUpdates(hubSubscriptionMetrics.updatesCount().longValue());
        return statusInfo;
    }

    @GetMapping(path={"license"})
    @Operation(summary="Retrieves license information")
    public LicenseInfo M() {
        PublicRestController a2;
        LicenseInfo licenseInfo;
        LicenseInfo licenseInfo2 = licenseInfo = new LicenseInfo();
        PublicRestController publicRestController = a2;
        licenseInfo.setExpiryDate(a2.h.getExpiryDate());
        licenseInfo.setEdition(publicRestController.h.getEdition());
        licenseInfo2.setLicensee(publicRestController.h.getLicensee());
        licenseInfo2.setFeatureList(a2.h.getFeatureList());
        return licenseInfo2;
    }
}

