/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.runtime.ReplicationGroupMembers;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.file.multitier.LowerTierEventStoreFactory;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.RaftGroupInfoService;
import io.swagger.v3.oas.annotations.Operation;
import java.security.Principal;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"internal/raft"})
public class RaftGroupInfoService {
    private static final Logger C = AuditLog.getLogger();
    private final MessagingPlatformConfiguration c;
    private final ReplicationGroupMembers e;

    public RaftGroupInfoService(ReplicationGroupMembers a2, MessagingPlatformConfiguration a3) {
        RaftGroupInfoService a4;
        RaftGroupInfoService raftGroupInfoService = a4;
        raftGroupInfoService.e = a2;
        raftGroupInfoService.c = a3;
    }

    @GetMapping(value={"groups"})
    @Operation(hidden=true)
    public Set<ReplicationGroupMemberJson> M(Principal a3) {
        RaftGroupInfoService a4;
        if (C.isInfoEnabled()) {
            C.info(SerializedEvent.M((Object)"\u0014)2\u000fo\u0000*#:7<&o& r#;<&o *\"#;,3;; <o5==:\"<r <o&';<r!=+7a"), (Object)AuditLog.username((Principal)a3));
        }
        RaftGroupInfoService raftGroupInfoService = a4;
        return raftGroupInfoService.e.findByNodeName(raftGroupInfoService.c.getName()).stream().map(a2 -> new ReplicationGroupMemberJson(a2)).collect(Collectors.toSet());
    }

    @GetMapping(value={"members/{group}"})
    @Operation(hidden=true)
    public Set<ReplicationGroupMemberJson> M(@PathVariable(value="group") String group, Principal a3) {
        if (C.isInfoEnabled()) {
            C.info(LowerTierEventStoreFactory.M((Object)">v\u0018PE_\u0000|\u0010h\u0016yEy\n-\td\u0016yE\u007f\u0000}\td\u0006l\u0011d\ncEj\u0017b\u0010}E`\u0000`\u0007h\u0017~Ek\n\u007fEv\u0018-\ncEy\rd\u0016-\u000bb\u0001hK"), (Object)AuditLog.username((Principal)a3), (Object)group);
        }
        return this.e.findByGroupId(group).stream().map(a2 -> new ReplicationGroupMemberJson(a2)).collect(Collectors.toSet());
    }
}

