/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.taskscheduler.task;

import io.axoniq.axonserver.config.ClusterTemplate;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.Application;
import io.axoniq.axonserver.grpc.internal.ApplicationContextRole;
import io.axoniq.axonserver.taskscheduler.ScheduledTask;
import io.axoniq.axonserver.taskscheduler.StandaloneTaskManager;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.axoniq.axonserver.taskscheduler.task.RegisterApplicationTask;
import io.axoniq.axonserver.transport.rest.LoadBalancingManagementRestController;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RegisterApplicationTask
implements ScheduledTask {
    private final StandaloneTaskManager C;
    private final RaftConfigServiceFactory c;
    private final Logger e;

    public ApplicationContextRole buildApplicationContextRole(ClusterTemplate.ApplicationRole a2) {
        return ApplicationContextRole.newBuilder().setContext(a2.getContext()).addAllRoles((Iterable)a2.getRoles()).build();
    }

    public void execute(String a22, Object a3) {
        RegisterApplicationTask a4;
        try {
            a22 = (RegisterApplicationPayload)a3;
            a3 = a22.getApplication();
            a4.c.getRaftConfigService().updateApplication(a4.buildApplication((ClusterTemplate.Application)a3));
            return;
        }
        catch (MessagingPlatformException a22) {
            a4.e.debug(LoadBalancingManagementRestController.M((Object)"TSa_uBcD&WvFj_eWr_iX&Pg_jSb\u0018&aoZj\u0016rD\u007f\u0016gQg_h"), (Throwable)a22);
            if (ErrorCode.CONTEXT_NOT_FOUND.equals((Object)a22.getErrorCode()) || ErrorCode.REPLICATION_GROUP_NOT_FOUND.equals((Object)a22.getErrorCode()) || ErrorCode.NO_LEADER_AVAILABLE.equals((Object)a22.getErrorCode()) || ErrorCode.REPLICATION_GROUP_UPDATE_IN_PROGRESS.equals((Object)a22.getErrorCode())) {
                throw new TransientException(a22.getMessage(), (Throwable)a22);
            }
            throw a22;
        }
    }

    public void schedule(ClusterTemplate.Application a2) {
        RegisterApplicationTask a3;
        a3.C.createTask(RegisterApplicationTask.class.getName(), (Object)new RegisterApplicationPayload(a2), Duration.ZERO);
    }

    public RegisterApplicationTask(StandaloneTaskManager a2, RaftConfigServiceFactory a3) {
        RegisterApplicationTask a4;
        RegisterApplicationTask registerApplicationTask = a4;
        a4.e = LoggerFactory.getLogger(RegisterApplicationTask.class);
        registerApplicationTask.C = a2;
        registerApplicationTask.c = a3;
    }

    public Application buildApplication(ClusterTemplate.Application a2) {
        RegisterApplicationTask a3;
        Application.Builder builder = Application.newBuilder().setName(a2.getName()).setDescription(a2.getDescription());
        ClusterTemplate.Application application = a2;
        builder.setToken(application.getToken());
        if (application.getMetaData() != null) {
            builder.putAllMetaData(a2.getMetaData());
        }
        a2.getRoles().stream().map(arg_0 -> a3.buildApplicationContextRole(arg_0)).forEach(arg_0 -> ((Application.Builder)builder).addRolesPerContext(arg_0));
        return builder.build();
    }
}

