/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.topology;

import io.axoniq.axonserver.accesscontrol.VisibleContexts;
import io.axoniq.axonserver.admin.context.api.ContextAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.cluster.util.RoleUtils;
import io.axoniq.axonserver.configuration.admin.AdminContext;
import io.axoniq.axonserver.configuration.admin.AdminContexts;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.configuration.runtime.Context;
import io.axoniq.axonserver.configuration.runtime.Contexts;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.NodeSelector;
import io.axoniq.axonserver.enterprise.replication.ContextLeaderProvider;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftController;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.topology.AxonServerNode;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.axoniq.axonserver.topology.L;
import io.axoniq.axonserver.topology.Topology;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class ClusterTopology
implements Topology,
VisibleContexts {
    private final Contexts G;
    private final ContextAdminService B;
    private final AdminContexts A;
    private final NodeSelector E;
    private final GrpcRaftController C;
    private final ClusterController c;
    private final ContextLeaderProvider e;

    public boolean isAdminNode() {
        ClusterTopology a2;
        return a2.c.isAdminNode();
    }

    public boolean isActive(AxonServerNode a2) {
        ClusterTopology a3;
        return a3.c.isActive(a2.getName());
    }

    public AxonServerNode getMe() {
        ClusterTopology a2;
        return new DefaultAxonServerNode(a2.c.getMe());
    }

    public Set<String> visibleContexts(boolean a2, Authentication a3) {
        ClusterTopology a4;
        return (Set)a4.B.getVisibleContexts(a2, a3).collect(Collectors.toSet()).block();
    }

    public boolean isMultiContext() {
        return true;
    }

    public Stream<? extends AxonServerNode> nodes() {
        ClusterTopology a2;
        if (a2.c.isAdminNode()) {
            return a2.c.nodes().map(DefaultAxonServerNode::new);
        }
        return a2.nodesFromRaftGroups();
    }

    public boolean validContext(String a2) {
        ClusterTopology a3;
        if (a3.isAdminNode()) {
            return true;
        }
        if (a3.C.getRaftNodeForContext(a2) != null) {
            return true;
        }
        return false;
    }

    public Iterable<String> getMyContextNames() {
        ClusterTopology a2;
        return a2.C.getAllNonAdminContexts();
    }

    public boolean isLeader(String a2, String a3) {
        ClusterTopology a4;
        return a2.equals(a4.e.getLeaderOrWait(a3, false));
    }

    public Iterable<String> knownContexts() {
        ClusterTopology a2;
        if (a2.c.isAdminNode()) {
            return a2.A.findAll().stream().map(AdminContext::getName).collect(Collectors.toSet());
        }
        return a2.G.findAll().stream().map(Context::getName).collect(Collectors.toSet());
    }

    public boolean initialized() {
        ClusterTopology a2;
        if (!a2.c.getRemoteConnections().isEmpty() || !a2.C.getRaftGroups().isEmpty()) {
            return true;
        }
        return false;
    }

    public Iterable<String> getMyStorageContextNames() {
        ClusterTopology a2;
        return a2.C.getAllNonAdminContexts();
    }

    public Stream<AxonServerNode> nodesFromRaftGroups() {
        ClusterTopology a2;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        a2.c.nodes().forEach(a3 -> hashMap.put(a3, new HashSet()));
        a2.C.getRaftGroups().forEach(a4 -> {
            ClusterTopology a5;
            Iterator iterator;
            Iterator iterator2 = iterator = a5.C.getRaftGroup(a4).raftConfiguration().groupMembers().iterator();
            while (iterator2.hasNext()) {
                Node node = (Node)iterator.next();
                ClusterTopology clusterTopology = a5;
                ClusterNode clusterNode = clusterTopology.c.getNode(node.getNodeName());
                clusterTopology.G.findByReplicationGroupName(a4).forEach(a7 -> {
                    hashMap.computeIfAbsent(clusterNode, a2 -> new HashSet()).add(a7.getName());
                    if (RoleUtils.B((Role)node.getRole())) {
                        hashMap2.computeIfAbsent(clusterNode, a2 -> new HashSet()).add(a7.getName());
                    }
                });
                iterator2 = iterator;
            }
        });
        return hashMap.entrySet().stream().map(a3 -> {
            ClusterTopology a4;
            return new L(a4, a3, hashMap2);
        });
    }

    public String getName() {
        ClusterTopology a2;
        return a2.c.getName();
    }

    public AxonServerNode findNodeForClient(String a2, String a3, String a4, Map<String, String> a5) {
        ClusterTopology a6;
        return new DefaultAxonServerNode(a6.E.findNodeForClient(a2, a3, a4, a5));
    }

    public ClusterTopology(ClusterController a2, GrpcRaftController a3, ContextAdminService a4, NodeSelector a5, ContextLeaderProvider a6, Contexts a7, AdminContexts a8) {
        ClusterTopology a9;
        ClusterTopology clusterTopology = a9;
        ClusterTopology clusterTopology2 = a9;
        ClusterTopology clusterTopology3 = a9;
        a9.c = a2;
        clusterTopology3.C = a3;
        clusterTopology3.B = a4;
        clusterTopology2.E = a5;
        clusterTopology2.e = a6;
        clusterTopology.G = a7;
        clusterTopology.A = a8;
    }
}

