/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.grpc;

import io.axoniq.axonserver.AxonServerAccessController;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.UpdateReplicationGroupPayload;
import io.axoniq.axonserver.admin.user.requestprocessor.UserController;
import io.axoniq.axonserver.configuration.admin.AdminUser;
import io.axoniq.axonserver.configuration.admin.AdminUserRole;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.admin.ApplicationRoles;
import io.axoniq.axonserver.grpc.admin.AuthenticateUserRequest;
import io.axoniq.axonserver.grpc.admin.AuthenticationServiceGrpc;
import io.axoniq.axonserver.grpc.admin.ContextRole;
import io.axoniq.axonserver.grpc.admin.Token;
import io.axoniq.axonserver.grpc.admin.UserRoles;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.grpc.stub.StreamObserver;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Controller;

@Controller
public class AuthenticationGrpcController
extends AuthenticationServiceGrpc.AuthenticationServiceImplBase
implements AxonServerClientService {
    private final AxonServerAccessController C;
    private final UserController c;
    private final PasswordEncoder e;

    private /* synthetic */ ContextRole M(GrantedAuthority a2) {
        AuthenticationGrpcController a3;
        a2 = a2.getAuthority().split(UpdateReplicationGroupPayload.M((Object)"j"), 2);
        if (a2.length == 2) {
            return a3.M(a2[0], a2[1]);
        }
        return a3.M(a2[0], a3.C.defaultContextForRest());
    }

    public void authenticateToken(Token a22, StreamObserver<ApplicationRoles> a4) {
        try {
            AuthenticationGrpcController a5;
            a22 = a5.C.authenticate(a22.getToken());
            ApplicationRoles.Builder builder = ApplicationRoles.newBuilder().setApplicationName(a22.getName());
            a22.getAuthorities().forEach(a3 -> {
                AuthenticationGrpcController a4;
                builder.addApplicationRole(a4.M(a3));
            });
            StreamObserver<ApplicationRoles> streamObserver = a4;
            streamObserver.onNext((Object)builder.build());
            streamObserver.onCompleted();
            return;
        }
        catch (Exception a22) {
            a4.onError((Throwable)GrpcExceptionBuilder.build((Throwable)a22));
            return;
        }
    }

    private /* synthetic */ void M(UserRoles.Builder a2, AdminUserRole a3) {
        AuthenticationGrpcController a4;
        a2.addUserRoles(a4.M(a3.getRole(), a3.getContext()));
    }

    public AuthenticationGrpcController(UserController a2, AxonServerAccessController a3, PasswordEncoder a4) {
        AuthenticationGrpcController a5;
        AuthenticationGrpcController authenticationGrpcController = a5;
        a5.c = a2;
        authenticationGrpcController.C = a3;
        authenticationGrpcController.e = a4;
    }

    private /* synthetic */ ContextRole M(String a2, String a3) {
        return ContextRole.newBuilder().setRole(a2).setContext(a3).build();
    }

    public void authenticateUser(AuthenticateUserRequest a2, StreamObserver<UserRoles> a3) {
        AuthenticationGrpcController a4;
        AdminUser adminUser = a4.c.findUser(a2.getUserName());
        if (adminUser == null) {
            a3.onError((Throwable)GrpcExceptionBuilder.build((Throwable)new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, HeartbeatMonitor.M((Object)"O\u0003p\fj\u0004bMj\u0002a\u0004h"))));
            return;
        }
        if (!a4.e.matches((CharSequence)a2.getPassword(), adminUser.getPassword())) {
            a3.onError((Throwable)GrpcExceptionBuilder.build((Throwable)new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, UpdateReplicationGroupPayload.M((Object)"cP\\_FWN\u001eFQMWD"))));
            return;
        }
        a2 = UserRoles.newBuilder().setUserName(adminUser.getUserName());
        adminUser.getRoles().forEach(arg_0 -> a4.M((UserRoles.Builder)a2, arg_0));
        StreamObserver<UserRoles> streamObserver = a3;
        streamObserver.onNext((Object)a2.build());
        streamObserver.onCompleted();
    }
}

