/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.admin.context.api.ContextAdminService;
import io.axoniq.axonserver.admin.context.api.ContextOverview;
import io.axoniq.axonserver.admin.context.api.ContextPropertiesUpdate;
import io.axoniq.axonserver.admin.context.api.RemoveContext;
import io.axoniq.axonserver.admin.context.api.ReplicationGroupContext;
import io.axoniq.axonserver.admin.context.requestprocessor.DefaultContextPropertiesUpdate;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.enterprise.replication.ContextLeaderProvider;
import io.axoniq.axonserver.enterprise.replication.admin.AdminReplicationGroupController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.interceptor.PluginRemovedEvent;
import io.axoniq.axonserver.localstorage.ContextPropertyDefinition;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.managed.ManagedAxonServerEventStoreStatusService;
import io.axoniq.axonserver.replication.ReplicationLeaderProvider;
import io.axoniq.axonserver.rest.ContextJSON;
import io.axoniq.axonserver.rest.NodeAndRole;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.transport.rest.E;
import io.axoniq.axonserver.transport.rest.F;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import io.axoniq.axonserver.transport.rest.h;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Principal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Deprecated
@RestController
@CrossOrigin
@RequestMapping(value={"/v1"})
public class ContextRestController {
    private final Logger G;
    private final ReplicationLeaderProvider B;
    private static final Logger A = AuditLog.getLogger();
    private final ContextAdminService E;
    private final AdminReplicationGroupController C;
    private final ContextLeaderProvider c;
    private final ReplicationGroupAdminService e;

    public Mono<Void> h(String a3) {
        ContextRestController a4;
        return a4.M(a3).repeatWhenEmpty(100, a2 -> a2.delayElements(Duration.ofMillis(100L))).onErrorMap(IllegalStateException.class, a2 -> new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, ManagedAxonServerEventStoreStatusService.M((Object)"\u0007\u00143\u0018>\u001fr\u000e=Z4\u0013<\u001er\u00167\u001b6\u001f Z4\u0015 Z&\u00127Z<\u001f%\u0016+Z1\b7\u001b&\u001f6Z \u001f\"\u0016;\u00193\u000e;\u0015<Z5\b=\u000f\"Z%\u0013&\u0012;\u0014r\u000e:\u001fr\b7\u000b'\u0013 \u001f6Z&\u0013?\u001f"))).then();
    }

    @GetMapping(path={"public/visiblecontexts"})
    public Mono<List<String>> M(@RequestParam(name="includeAdmin", required=false, defaultValue="false") boolean includeAdmin, @Parameter(hidden=true) Principal a2) {
        return this.E.getVisibleContexts(includeAdmin, (Authentication)new PrincipalAuthentication(a2)).collectList();
    }

    public Mono<String> M(String a2) {
        ContextRestController a3;
        return Mono.fromCallable(() -> {
            ContextRestController a3;
            return a3.B.getLeader(a2);
        }).subscribeOn(Schedulers.boundedElastic());
    }

    @DeleteMapping(path={"context/{name}"})
    public Mono<ResponseEntity<RestResponse>> h(@PathVariable(value="name") String name, @RequestParam(name="preserveEventStore", required=false, defaultValue="false") boolean preserveEventStore, @Parameter(hidden=true) Principal a3) {
        return this.M(name, preserveEventStore, a3).thenReturn((Object)this.M(PluginRemovedEvent.M((Object)"\u000fs-u>d+tnt+|+d+0-\u007f d+h:0<u?e+c:"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
    }

    @GetMapping(path={"public/context/updates"}, produces={"text/event-stream"})
    public Flux<ServerSentEvent<String>> h(@Parameter(hidden=true) Principal a3) {
        a3 = this.E.subscribeContextUpdates((Authentication)new PrincipalAuthentication(a3)).doOnSubscribe(a2 -> {
            ContextRestController a3;
            a3.G.info(PluginRemovedEvent.M((Object)"\u001de,c-b'r+tnd!0-\u007f d+h:0;`*q:u="));
        }).doOnError(a2 -> {
            ContextRestController a3;
            a3.G.warn(ManagedAxonServerEventStoreStatusService.M((Object)"\u0017\b \u0015 Z=\u00191\u000f \b7\u001er\r:\u0013>\u001fr\u0016;\t&\u0013<\u001dr\u001c=\br\u0019=\u0014&\u001f*\u000er\u000f\"\u001e3\u000e7\thZ)\u0007"), (Object)a2.getMessage());
        }).onErrorResume(a2 -> Mono.empty()).map(a2 -> ServerSentEvent.builder().data((Object)a2.name()).event(a2.state().name()).build());
        Flux flux = Flux.interval((Duration)Duration.ofSeconds(2L)).map(a2 -> ServerSentEvent.builder().event(PluginRemovedEvent.M((Object)"{+u>=/|'f+")).build());
        Publisher[] publisherArray = new Publisher[2];
        publisherArray[0] = a3;
        publisherArray[1] = flux;
        return Flux.merge((Publisher[])publisherArray);
    }

    private /* synthetic */ Mono<Void> M(ContextJSON a2, String a3, Authentication a4) {
        ContextRestController a5;
        return a5.e.createReplicationGroup((ReplicationGroup)new E(a5, a3, a2), a4);
    }

    @GetMapping(path={"public/context"})
    public Flux<ContextJSON> M(@Parameter(hidden=true) Principal a3) {
        return this.E.getContexts((Authentication)new PrincipalAuthentication(a3)).map(a2 -> {
            ContextRestController a3;
            ContextJSON contextJSON = new ContextJSON(a2.name());
            ContextOverview contextOverview = a2;
            contextJSON.setChangePending(contextOverview.replicationGroup().changePending());
            if (contextOverview.pendingSince() != null) {
                contextJSON.setPendingSince(Objects.requireNonNull(a2.pendingSince()).getTime());
            }
            ContextJSON contextJSON2 = contextJSON;
            ContextOverview contextOverview2 = a2;
            contextJSON.setLeader(a3.c.getLeader(a2.name()));
            contextJSON2.setReplicationGroup(contextOverview2.replicationGroup().name());
            contextJSON2.setRoles(contextOverview2.replicationGroup().members().stream().map(NodeAndRole::new).sorted().collect(Collectors.toList()));
            if (a2.replicationGroup().members().stream().anyMatch(AdminReplicationGroupMember::isPendingDelete)) {
                contextJSON.setChangePending(true);
            }
            ContextJSON contextJSON3 = contextJSON;
            contextJSON3.setMetaData(a2.metaData());
            return contextJSON3;
        }).sort(Comparator.comparing(ContextJSON::getContext));
    }

    @PostMapping(path={"context"})
    public Mono<ResponseEntity<RestResponse>> M(@RequestBody @Valid ContextJSON contextJson, @Parameter(hidden=true) Principal a3) {
        return Mono.defer(() -> {
            ContextRestController a4;
            String string;
            Mono mono = Mono.empty();
            String string2 = string = StringUtils.isEmpty((String)contextJson.getReplicationGroup()) ? contextJson.getContext() : contextJson.getReplicationGroup();
            if ((AdminReplicationGroup)a4.C.findByName(string).orElse(null) == null) {
                if (contextJson.getRoles() == null || contextJson.getRoles().isEmpty()) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, ManagedAxonServerEventStoreStatusService.M((Object)"7;\t!\u0013<\u001dr\b7\n>\u00131\u001b&\u0013=\u0014r\u001d \u0015'\nr\u0014=\u001e7\t"));
                }
                mono = a4.M(contextJson, string, (Authentication)new PrincipalAuthentication(a3)).then(a4.h(string));
            }
            mono = mono.then(a4.M(contextJson, string, a3).timeout(Duration.ofSeconds(45L)));
            return mono;
        }).thenReturn((Object)this.M(ManagedAxonServerEventStoreStatusService.M((Object)"\u0013\u00191\u001f\"\u000e7\u001er\u001b6\u001er\u0019=\u0014&\u001f*\u000er\b7\u000b'\u001f!\u000e"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
    }

    @GetMapping(value={"public/context-properties"})
    public ContextPropertyDefinition[] M(@Parameter(hidden=true) Principal a2) {
        A.info(ManagedAxonServerEventStoreStatusService.M((Object)"!)\u0007\u000fZ\u0000\u001f#\u000f7\t&Z&\u0015r\u001d7\u000er\u0019=\u0014&\u001f*\u000er\n \u0015\"\u001f \u000e;\u001f!T"), (Object)AuditLog.username((Principal)a2));
        return ContextPropertyDefinition.values();
    }

    @PostMapping(path={"context/init"})
    public Mono<ResponseEntity<RestResponse>> M(@RequestParam(name="context", required=false) String context, @Parameter(hidden=true) Principal a3) {
        return Mono.defer(() -> {
            ContextRestController contextRestController;
            ContextRestController a4;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (StringUtils.isEmpty((String)context)) {
                contextRestController = a4;
                arrayList.add("default");
            } else {
                arrayList.add(context);
                contextRestController = a4;
            }
            return contextRestController.E.initCluster(arrayList, (Authentication)new PrincipalAuthentication(a3));
        }).thenReturn((Object)this.M(PluginRemovedEvent.M((Object)"\u000fs-u>d+tny y:0-|;c:u<0<u?e+c:"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
    }

    private /* synthetic */ Mono<Void> M(ContextJSON a2, String a3, Principal a4) {
        ContextRestController a5;
        return a5.E.createContext((ReplicationGroupContext)new F(a5, a2, a3), (Authentication)new PrincipalAuthentication(a4));
    }

    private /* synthetic */ Mono<Void> M(String a2, boolean a3, Principal a4) {
        ContextRestController a5;
        return a5.E.deleteContext((RemoveContext)new h(a5, a2, a3), (Authentication)new PrincipalAuthentication(a4));
    }

    @PatchMapping(path={"context/{name}"})
    public Mono<ResponseEntity<RestResponse>> M(@PathVariable(name="name") String name, @RequestBody @Valid Map<String, String> metaData, @Parameter(hidden=true) Principal a3) {
        return this.E.updateContext((ContextPropertiesUpdate)new DefaultContextPropertiesUpdate(name, metaData), (Authentication)new PrincipalAuthentication(a3)).thenReturn((Object)this.M(PluginRemovedEvent.M((Object)"\u000fs-u>d+tne>t/d+0-\u007f d+h:0<u?e+c:"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
    }

    public ContextRestController(ContextAdminService a2, ReplicationGroupAdminService a3, ContextLeaderProvider a4, ReplicationLeaderProvider a5, AdminReplicationGroupController a6) {
        ContextRestController a7;
        ContextRestController contextRestController = a7;
        ContextRestController contextRestController2 = a7;
        ContextRestController contextRestController3 = a7;
        contextRestController3.G = LoggerFactory.getLogger(ContextRestController.class);
        contextRestController3.E = a2;
        contextRestController2.e = a3;
        contextRestController2.c = a4;
        contextRestController.B = a5;
        contextRestController.C = a6;
    }

    private /* synthetic */ ResponseEntity<RestResponse> M(String a2) {
        return ResponseEntity.accepted().body((Object)new RestResponse(true, a2));
    }
}

