/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.admin.eventprocessor.api.EventProcessorAdminService;
import io.axoniq.axonserver.admin.eventprocessor.api.EventProcessorId;
import io.axoniq.axonserver.admin.eventprocessor.api.Result;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.component.processor.EventProcessorIdentifier;
import io.axoniq.axonserver.config.TransformationConfiguration;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.serializer.Printable;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import io.axoniq.axonserver.transport.rest.ResponseEntityFactory;
import io.axoniq.axonserver.transport.rest.json.GenericProcessor;
import io.axoniq.axonserver.transport.rest.json.StreamingProcessor;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Principal;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"v1"})
@CrossOrigin
public class EventProcessorRestController {
    private final EventProcessorAdminService e;

    @PatchMapping(value={"components/{component}/processors/{processor}/segments/merge"})
    public Mono<ResponseEntity<RestResponse>> l(@PathVariable(value="processor") String processor, @RequestParam(value="context") String context, @RequestParam(value="tokenStoreIdentifier") String tokenStoreIdentifier, @Parameter(hidden=true) Principal a2) {
        return this.e.merge((EventProcessorId)new EventProcessorIdentifier(processor, context, tokenStoreIdentifier), (Authentication)new PrincipalAuthentication(a2)).map(a3 -> {
            EventProcessorRestController a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = processor;
            return a4.M(a3, String.format(TransformationConfiguration.M((Object)"QbNsDcR\u007fS0\u0004c\u0001}DbFuE"), objectArray));
        }).onErrorResume(ResponseEntityFactory::M);
    }

    private /* synthetic */ boolean M(String a2) {
        if (StringUtils.isEmpty((String)a2) || ErrorMessageFactory.M((Object)"^<\\%").equals(a2)) {
            return true;
        }
        return false;
    }

    @PatchMapping(value={"components/{component}/processors/{processor}/start"})
    public Mono<ResponseEntity<RestResponse>> B(@PathVariable(value="processor") String processor, @RequestParam(value="context") String context, @RequestParam(value="tokenStoreIdentifier") String tokenStoreIdentifier, @Parameter(hidden=true) Principal a2) {
        return this.e.start((EventProcessorId)new EventProcessorIdentifier(processor, context, tokenStoreIdentifier), (Authentication)new PrincipalAuthentication(a2)).map(a3 -> {
            EventProcessorRestController a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = processor;
            return a4.M(a3, String.format(ErrorMessageFactory.M((Object)"@;_*U:C&Bi\u0015:\u0010:D(B=U-"), objectArray));
        }).onErrorResume(ResponseEntityFactory::M);
    }

    public EventProcessorRestController(EventProcessorAdminService a2) {
        EventProcessorRestController a3;
        a3.e = a2;
    }

    @PatchMapping(value={"components/{component}/processors/{processor}/pause"})
    public Mono<ResponseEntity<RestResponse>> h(@PathVariable(value="processor") String processor, @RequestParam(value="context") String context, @RequestParam(value="tokenStoreIdentifier") String tokenStoreIdentifier, @Parameter(hidden=true) Principal a2) {
        return this.e.pause((EventProcessorId)new EventProcessorIdentifier(processor, context, tokenStoreIdentifier), (Authentication)new PrincipalAuthentication(a2)).map(a3 -> {
            EventProcessorRestController a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = processor;
            return a4.M(a3, String.format(TransformationConfiguration.M((Object)"QbNsDcR\u007fS0\u0004c\u0001`@eRuE"), objectArray));
        }).onErrorResume(ResponseEntityFactory::M);
    }

    @GetMapping(value={"/processors/{processor}/clients"})
    public Flux<String> M(@PathVariable(value="processor") String processor, @RequestParam(value="context") String context, @RequestParam(value="tokenStoreIdentifier") String tokenStoreIdentifier, @Parameter(hidden=true) Principal a2) {
        return this.e.clientsBy((EventProcessorId)new EventProcessorIdentifier(processor, context, tokenStoreIdentifier), (Authentication)new PrincipalAuthentication(a2));
    }

    private /* synthetic */ ResponseEntity<RestResponse> M(Result a2, String a3) {
        if (a2.isSuccess()) {
            return ResponseEntityFactory.h((String)a3);
        }
        return ResponseEntityFactory.M((String)a3);
    }

    @PatchMapping(value={"components/{component}/processors/{processor}/segments/split"})
    public Mono<ResponseEntity<RestResponse>> M(@PathVariable(value="processor") String processor, @RequestParam(value="context") String context, @RequestParam(value="tokenStoreIdentifier") String tokenStoreIdentifier, @Parameter(hidden=true) Principal a2) {
        return this.e.split((EventProcessorId)new EventProcessorIdentifier(processor, context, tokenStoreIdentifier), (Authentication)new PrincipalAuthentication(a2)).map(a3 -> {
            EventProcessorRestController a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = processor;
            return a4.M(a3, String.format(TransformationConfiguration.M((Object)"`S\u007fBuRcNb\u00015R0R`MyU"), objectArray));
        }).onErrorResume(ResponseEntityFactory::M);
    }

    @GetMapping(value={"components/{component}/processors"})
    public Flux<Printable> M(@PathVariable(value="component") String component, @RequestParam(value="context") String context, @Parameter(hidden=true) Principal a4) {
        return this.e.eventProcessorsByComponent(component, (Authentication)new PrincipalAuthentication(a4)).filter(a3 -> {
            EventProcessorRestController a4;
            if (a4.M(context) || a3.id().context().equals(context)) {
                return true;
            }
            return false;
        }).map(a2 -> {
            if (a2.isStreaming()) {
                return new StreamingProcessor(a2);
            }
            return new GenericProcessor(a2);
        });
    }

    @PatchMapping(value={"components/{component}/processors/{processor}/segments/{segment}/move"})
    public Mono<ResponseEntity<RestResponse>> M(@PathVariable(value="processor") String processor, @PathVariable(value="segment") int segment, @RequestParam(value="target") String target, @RequestParam(value="context") String context, @RequestParam(value="tokenStoreIdentifier") String tokenStoreIdentifier, @Parameter(hidden=true) Principal a2) {
        return this.e.move((EventProcessorId)new EventProcessorIdentifier(processor, context, tokenStoreIdentifier), segment, target, (Authentication)new PrincipalAuthentication(a2)).map(a4 -> {
            EventProcessorRestController a5;
            Object[] objectArray = new Object[2];
            objectArray[0] = processor;
            objectArray[1] = segment;
            return a5.M(a4, String.format(ErrorMessageFactory.M((Object)"9B&S,C:_;\u0010lCiC,W$U'Di\u0015-\u0010$_?U-"), objectArray));
        }).onErrorResume(ResponseEntityFactory::M);
    }
}

